
; Listing19j2.s
; Deep-Trainer
;
; (WinUAE 5.3.0 A500 configuration)
; Console-Debugger
;
; D[idxzs <[max diff]>] Deep trainer. i=new value must be larger, d=smaller,
;                       x = must be same, z = must be different, s = restart.

;---------------------------------------------------------------

D is used when you don't know the value. A health bar might not be an obvious
value so you could use D to find it. It works by eliminating addresses that
have or haven't changed. The commands are
Ds (start/reset deep trainer),
D  (find any addresses that have changed since last D command),
Dx (find any addresses that haven't changed since last D command).

D		; Deep trainer
Di		; i=new value must be larger	(value must increase)
Dd		; d=new value must be smaller
Dx		; x=must be same
Dz		; z=must be different
Ds		; s=restart

Dd = decrease, abs(new value minus old value) must be smaller than "max diff".
		s = 1 = byte, 2 = word. long words not supported. (defaults to byte)

D  <[max diff]>
Di <[max diff]>	; must be smaller than "max diff"
Dd <[max diff]>
Dx <[max diff]>
Dz <[max diff]>
Ds <[max diff]>


Yo! Joe!

; The game is running (first level - health is lost by contacting with the enemies)
;------------------------------------------------------------------------------
>Ds
Scanning.. 00000000 - 00200000 (Chip memory)
Scanning.. 00c00000 - 00c80000 (Slow memory)
Deep trainer first pass complete.
;------------------------------------------------------------------------------
>g																				; play a little bit and lost
VPOS: 210 ($0d2) HPOS: 003 ($003) COP: $000051dc								; some health
  D0 00000000   D1 00000000   D2 0000001E   D3 000005E0
  D4 00036006   D5 0001FAA0   D6 0000FFFF   D7 000171EC
  A0 00C67C4E   A1 00C3A08E   A2 0007D48C   A3 00C496D1
  A4 00C3A08E   A5 00DFF000   A6 00C030FE   A7 00C7FFEE
USP  00C7FBFC ISP  00C7FFEE
SR=2004 T=00 S=1 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 0c2e (CMP) 0045 (OR) Chip latch 00000DDF
00c09524 0c2e 0045 0276           cmp.b #$45,(a6,$0276) == $00c03374 [60]
Next PC: 00c0952a																; Shift+F12
;------------------------------------------------------------------------------
>Dd																				; any smaller vlaue found?
Scanning.. 00000000 - 00200000 (Chip memory)
Scanning.. 00c00000 - 00c80000 (Slow memory)
103118 addresses found
Now continue with 'g' and use 'D' again after you have lost another life
;------------------------------------------------------------------------------
>g																				; play a little bit and lost
Cycles: 4194303 Chip, 8388607 CPU. (V=210 H=3 -> V=210 H=0)						; some health
VPOS: 210 ($0d2) HPOS: 005 ($005) COP: $000051de
  D0 00000000   D1 00000000   D2 0000001E   D3 000005E0
  D4 00036006   D5 0001FAA0   D6 0000FFFF   D7 000171EC
  A0 00005D38   A1 00C3A08E   A2 00007038   A3 00C496D1
  A4 00C3A08E   A5 00DFF000   A6 00C030FE   A7 00C7FF9C
USP  00C7FBFC ISP  00C7FF9C
SR=2104 T=00 S=1 M=0 X=0 N=0 Z=1 V=0 C=0 IM=1 STP=0
Prefetch d0fc (ADDA) 0a21 (EOR) Chip latch 0000D2DF
00c13306 d0fc 0a21                adda.w #$0a21,a0
Next PC: 00c1330a																; Shift+F12
;------------------------------------------------------------------------------
>Dd																				; any smaller vlaue found?
Scanning.. 00000000 - 00200000 (Chip memory)
Scanning.. 00c00000 - 00c80000 (Slow memory)
2282 addresses found
Now continue with 'g' and use 'D' again after you have lost another life
;------------------------------------------------------------------------------
>g																				; play a little bit and lost
Cycles: 4194303 Chip, 8388607 CPU. (V=210 H=5 -> V=210 H=0)						; some health
VPOS: 210 ($0d2) HPOS: 004 ($004) COP: $000051dc
  D0 00000000   D1 00000000   D2 0000001E   D3 000005E0
  D4 00036006   D5 0001FAA0   D6 0000FFFF   D7 000171EC
  A0 00C67C4E   A1 00C3A08E   A2 0007D48C   A3 00C496D1
  A4 00C3A08E   A5 00DFF000   A6 00C030FE   A7 00C7FFEA
USP  00C7FBFC ISP  00C7FFEA
SR=2004 T=00 S=1 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch b06e (CMP) 0206 (AND) Chip latch 00000CCF
00c0ac3a b06e 0206                cmp.w (a6,$0206) == $00c03304 [0000],d0
Next PC: 00c0ac3e																; Shift+F12
;------------------------------------------------------------------------------
>Dd
Scanning.. 00000000 - 00200000 (Chip memory)
Scanning.. 00c00000 - 00c80000 (Slow memory)
82 addresses found
Scanning.. 00000000 - 00200000 (Chip memory)
Scanning.. 00c00000 - 00c80000 (Slow memory)

000100E5=00E0 00010137=0082 00010139=00B0 000101B5=0080 00010235=00F0, addresses...
;------------------------------------------------------------------------------
Cycles: 4194303 Chip, 8388607 CPU. (V=210 H=4 -> V=105 H=0)
VPOS: 105 ($069) HPOS: 001 ($001) COP: $00004886
  D0 00000010   D1 00004000   D2 00000022   D3 000007FD
  D4 00000000   D5 00000006   D6 00000001   D7 00000001
  A0 00C4AC52   A1 00C3FD5C   A2 00C03326   A3 00C0BBF8
  A4 00C0E428   A5 00C0C62A   A6 00C030FE   A7 00C7FFA0
USP  00C7FBFC ISP  00C7FFA0
SR=2300 T=00 S=1 M=0 X=0 N=0 Z=0 V=0 C=0 IM=3 STP=0
Prefetch d0c0 (ADDA) d0c1 (ADDA) Chip latch 0000175F
00c0f0ba d0c0                     adda.w d0,a0
Next PC: 00c0f0bc																; Shift+F12
;------------------------------------------------------------------------------
>Dd
Scanning.. 00000000 - 00200000 (Chip memory)
Scanning.. 00c00000 - 00c80000 (Slow memory)
2 addresses found
Scanning.. 00000000 - 00200000 (Chip memory)
Scanning.. 00c00000 - 00c80000 (Slow memory)

00C0316B=0008 00C0316C=0008 >													; first adress looks interesting
																				; because health bar has only 5 segments now
;------------------------------------------------------------------------------
>W C0316B F																				
Wrote F (15) at 00C0316B.B														; full health bar
;------------------------------------------------------------------------------
>g
;------------------------------------------------------------------------------
																				; when you've found values you can freeze them with the watchpoint command:
																				; w <watchpoint number> <memory start address> <length in bytes> <flags>
																				; To freeze your 1E7E6 address in Crazy Cars 3 you would do:
																				; >w 0 1E7E6 2 frw
																				; This sets freeze watchpoint 0 on the contents of that address and the following one.

																				; or in Yo! Joe!
;------------------------------------------------------------------------------
>w 0 C0316B 1 frw																; yeah! endless energy!
Memwatch breakpoints enabled
 0: 00C0316B - 00C0316B (1) RW  F CPU