
; Listing19i2.s
; Scanline
; 
; (WinUAE 5.3.0 A500 configuration)
; Console-Debugger
 
; fs <lines to wait> | <vpos> <hpos> Wait n scanlines/position.

; 1. fs <lines to wait>
; 2. fs <vpos> <hpos>

;------------------------------------------------------------------------------

start:
	move.w #$4000,$dff09a		; Interrupts disable
loop: 
	move.l $dff004,d0
	and.l #$000fff00,d0
	cmp.l #$00013700,d0

; auf Ende des-Rasterdurchlaufs warten
	bne.s loop
	bsr somethingtodo
	btst #6,$bfe001
	bne loop
	move.w #$C000,$dff09a		; Interrupts enable	
	rts

somethingtodo:					; that are 227cycles
	
	lea	Table,a0				; 12 cycles
	movem.l	(a0)+,d3-d7/a3-a6	; 84(21/0)		; 42 cycles 5*42=210
	movem.l	(a0)+,d3-d7/a3-a6
	movem.l	(a0)+,d3-d7/a3-a6
	movem.l	(a0)+,d3-d7/a3-a6

	move.b	#0,d0
	move.l	#0,d0
	rts

Table:
	blk.w 1200,$FFFF


	end

;------------------------------------------------------------------------------
>r
Filename:Listing19i2.s
>a
Pass1
Pass2
No Errors
>j
																				; start the programm
;------------------------------------------------------------------------------
																				; open the Debugger with Shift+F12
																				; we need no breakpoint, program runs in a loop
>d pc
00024d62 66ec                     bne.b #$ec == $00024d50 (T)
00024d64 6100 0018                bsr.w #$0018 == $00024d7e
00024d68 0839 0006 00bf e001      btst.b #$0006,$00bfe001
00024d70 6600 ffde                bne.w #$ffde == $00024d50 (T)
00024d74 33fc c000 00df f09a      move.w #$c000,$00dff09a
00024d7c 4e75                     rts  == $00c4f748
00024d7e 41f9 0002 4da0           lea.l $00024da0,a0
00024d84 4cd8 78f8                movem.l (a0)+,d3-d7/a3-a6
00024d88 4cd8 78f8                movem.l (a0)+,d3-d7/a3-a6
00024d8c 4cd8 78f8                movem.l (a0)+,d3-d7/a3-a6
;------------------------------------------------------------------------------
>t
Cycles: 5 Chip, 10 CPU. (V=105 H=1 -> V=105 H=6)
VPOS: 105 ($069) HPOS: 006 ($006) COP: $0001ede4
  D0 00006800   D1 00000000   D2 00000000   D3 FFFFFFFF
  D4 FFFFFFFF   D5 FFFFFFFF   D6 FFFFFFFF   D7 FFFFFFFF
  A0 00024E30   A1 00000000   A2 00000000   A3 FFFFFFFF
  A4 FFFFFFFF   A5 FFFFFFFF   A6 FFFFFFFF   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0009 T=00 S=0 M=0 X=0 N=1 Z=0 V=0 C=1 IM=0 STP=0
Prefetch 2039 (MOVE) 00df (ILLEGAL) Chip latch 00000000
00024d50 2039 00df f004           move.l $00dff004,d0
Next PC: 00024d56
;------------------------------------------------------------------------------
>fs 10
Cycles: 2270 Chip, 4540 CPU. (V=105 H=6 -> V=115 H=6)
VPOS: 115 ($073) HPOS: 011 ($00b) COP: $0001ede4
  D0 00007200   D1 00000000   D2 00000000   D3 FFFFFFFF
  D4 FFFFFFFF   D5 FFFFFFFF   D6 FFFFFFFF   D7 FFFFFFFF
  A0 00024E30   A1 00000000   A2 00000000   A3 FFFFFFFF
  A4 FFFFFFFF   A5 FFFFFFFF   A6 FFFFFFFF   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0009 T=00 S=0 M=0 X=0 N=1 Z=0 V=0 C=1 IM=0 STP=0
Prefetch 66ec (Bcc) 6100 (BSR) Chip latch 00000000
00024d62 66ec                     bne.b #$ec == $00024d50 (T)
Next PC: 00024d64
;------------------------------------------------------------------------------
>c
A: CRA 00 CRB 08 ICR e8 IM 0a TA ffff (ffff) TB 0863 (0863)
   PRA c0 PRB 00 DDRA 03 DDRB 00
   TOD 007330 (0072fe) ALARM 000000 -- CYC=000000FD1501A200
B: CRA 00 CRB 80 ICR 04 IM 00 TA ffff (ffff) TB ffff (ffff)
   PRA ff PRB ff DDRA c0 DDRB ff
   TOD 003d95 (00ffff) ALARM 0000ac --
DEBUG: drive 0 motor off cylinder  1 sel no ro mfmpos 0/101344
side 0 dma 0 off 1 word 0000 pt 00000000 len 4000 bytr 8000 adk 1100 sync 0000
DMACON: $23f0 INTENA: $202c ($202c) INTREQ: $1068 ($1068) VPOS: 115 ($073) HPOS: 011 ($00b)
INT: $0028 IPL: 0
COP1LC: $00000420, COP2LC: $0001ed50 COPPTR: $0001ede4
DIWSTRT: $0581 DIWSTOP: $40c1 DDFSTRT: $003c DDFSTOP: $00d0
BPLCON 0: $a200 1: $0000 2: $0024 3: $0c00 4: $0011 LOF=1/1 HDIW=1 VDIW=1
Average frame time: 5469398.03 ms [frames: 27070 time: 2033185936]				; frames: 27070
;------------------------------------------------------------------------------
>fs 125
Cycles: 28375 Chip, 56750 CPU. (V=115 H=11 -> V=240 H=11)
VPOS: 240 ($0f0) HPOS: 016 ($010) COP: $0001ede4
  D0 0000EF00   D1 00000000   D2 00000000   D3 FFFFFFFF
  D4 FFFFFFFF   D5 FFFFFFFF   D6 FFFFFFFF   D7 FFFFFFFF
  A0 00024E30   A1 00000000   A2 00000000   A3 FFFFFFFF
  A4 FFFFFFFF   A5 FFFFFFFF   A6 FFFFFFFF   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0009 T=00 S=0 M=0 X=0 N=1 Z=0 V=0 C=1 IM=0 STP=0
Prefetch 66ec (Bcc) 6100 (BSR) Chip latch 00000000
00024d62 66ec                     bne.b #$ec == $00024d50 (T)
Next PC: 00024d64
;------------------------------------------------------------------------------
>c
A: CRA 00 CRB 08 ICR e8 IM 0a TA ffff (ffff) TB 0863 (0863)
   PRA c0 PRB 00 DDRA 03 DDRB 00
   TOD 007330 (0072fe) ALARM 000000 -- CYC=000000FD15DF5A00
B: CRA 00 CRB 80 ICR 04 IM 00 TA ffff (ffff) TB ffff (ffff)
   PRA ff PRB ff DDRA c0 DDRB ff
   TOD 003e12 (00ffff) ALARM 0000ac --
DEBUG: drive 0 motor off cylinder  1 sel no ro mfmpos 0/101344
side 0 dma 0 off 1 word 0000 pt 00000000 len 4000 bytr 8000 adk 1100 sync 0000
DMACON: $23f0 INTENA: $202c ($202c) INTREQ: $1068 ($1068) VPOS: 240 ($0f0) HPOS: 016 ($010)
INT: $0028 IPL: 0
COP1LC: $00000420, COP2LC: $0001ed50 COPPTR: $0001ede4
DIWSTRT: $0581 DIWSTOP: $40c1 DDFSTRT: $003c DDFSTOP: $00d0
BPLCON 0: $a200 1: $0000 2: $0024 3: $0c00 4: $0011 LOF=1/1 HDIW=0 VDIW=1
Average frame time: 5469398.03 ms [frames: 27070 time: 2033185936]				; frames: 27070
>
;------------------------------------------------------------------------------
>fs 200
Cycles: 45400 Chip, 90800 CPU. (V=240 H=16 -> V=127 H=16)
VPOS: 127 ($07f) HPOS: 016 ($010) COP: $0001ede4
  D0 00007E00   D1 00000000   D2 00000000   D3 FFFFFFFF
  D4 FFFFFFFF   D5 FFFFFFFF   D6 FFFFFFFF   D7 FFFFFFFF
  A0 00024E30   A1 00000000   A2 00000000   A3 FFFFFFFF
  A4 FFFFFFFF   A5 FFFFFFFF   A6 FFFFFFFF   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0009 T=00 S=0 M=0 X=0 N=1 Z=0 V=0 C=1 IM=0 STP=0
Prefetch 66ec (Bcc) 6100 (BSR) Chip latch 00000000
00024d62 66ec                     bne.b #$ec == $00024d50 (T)
Next PC: 00024d64
;------------------------------------------------------------------------------
>c
A: CRA 00 CRB 08 ICR e8 IM 0a TA ffff (ffff) TB 0863 (0863)
   PRA c0 PRB 00 DDRA 03 DDRB 00
   TOD 007331 (0072fe) ALARM 000000 -- CYC=000000FD17420A00
B: CRA 00 CRB 80 ICR 04 IM 00 TA ffff (ffff) TB ffff (ffff)
   PRA ff PRB ff DDRA c0 DDRB ff
   TOD 003eda (00ffff) ALARM 0000ac --
DEBUG: drive 0 motor off cylinder  1 sel no ro mfmpos 0/101344
side 0 dma 0 off 1 word 0000 pt 00000000 len 4000 bytr 8000 adk 1100 sync 0000
DMACON: $23f0 INTENA: $202c ($202c) INTREQ: $1068 ($1068) VPOS: 127 ($07f) HPOS: 016 ($010)
INT: $0028 IPL: 0
COP1LC: $00000420, COP2LC: $0001ed50 COPPTR: $0001ede4
DIWSTRT: $0581 DIWSTOP: $40c1 DDFSTRT: $003c DDFSTOP: $00d0
BPLCON 0: $a200 1: $0000 2: $0024 3: $0c00 4: $0011 LOF=1/1 HDIW=0 VDIW=1
Average frame time: 5786983.48 ms [frames: 27071 time: 2046394136]				; frames: 27071
>
										

;******************************************************************************	; 1b test
>fs 313																			; + 1 frame forward (313 lines)
Cycles: 71051 Chip, 142102 CPU. (V=127 H=16 -> V=127 H=16)
VPOS: 127 ($07f) HPOS: 020 ($014) COP: $0001ede4
  D0 00007E00   D1 00000000   D2 00000000   D3 FFFFFFFF
  D4 FFFFFFFF   D5 FFFFFFFF   D6 FFFFFFFF   D7 FFFFFFFF
  A0 00024E30   A1 00000000   A2 00000000   A3 FFFFFFFF
  A4 FFFFFFFF   A5 FFFFFFFF   A6 FFFFFFFF   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0009 T=00 S=0 M=0 X=0 N=1 Z=0 V=0 C=1 IM=0 STP=0
Prefetch 2039 (MOVE) 00df (ILLEGAL) Chip latch 00000000
00024d50 2039 00df f004           move.l $00dff004,d0
Next PC: 00024d56
;------------------------------------------------------------------------------
>c
A: CRA 00 CRB 08 ICR e8 IM 0a TA ffff (ffff) TB 0863 (0863)
   PRA c0 PRB 00 DDRA 03 DDRB 00
   TOD 007332 (0072fe) ALARM 000000 -- CYC=000000FD196D2800
B: CRA 00 CRB 80 ICR 04 IM 00 TA ffff (ffff) TB ffff (ffff)
   PRA ff PRB ff DDRA c0 DDRB ff
   TOD 004013 (00ffff) ALARM 0000ac --
DEBUG: drive 0 motor off cylinder  1 sel no ro mfmpos 0/101344
side 0 dma 0 off 1 word 0000 pt 00000000 len 4000 bytr 8000 adk 1100 sync 0000
DMACON: $23f0 INTENA: $202c ($202c) INTREQ: $1068 ($1068) VPOS: 127 ($07f) HPOS: 020 ($014)
INT: $0028 IPL: 0
COP1LC: $00000420, COP2LC: $0001ed50 COPPTR: $0001ede4
DIWSTRT: $0581 DIWSTOP: $40c1 DDFSTRT: $003c DDFSTOP: $00d0
BPLCON 0: $a200 1: $0000 2: $0024 3: $0c00 4: $0011 LOF=1/1 HDIW=0 VDIW=1
Average frame time: 5823911.67 ms [frames: 27072 time: -1243029276]				; frames: 27072
>									

;******************************************************************************	; 2 test
>fs 115 20
Cycles: 68327 Chip, 136654 CPU. (V=127 H=20 -> V=115 H=20)
VPOS: 115 ($073) HPOS: 023 ($017) COP: $0001ede4
  D0 8000730E   D1 00000000   D2 00000000   D3 FFFFFFFF
  D4 FFFFFFFF   D5 FFFFFFFF   D6 FFFFFFFF   D7 FFFFFFFF
  A0 00024E30   A1 00000000   A2 00000000   A3 FFFFFFFF
  A4 FFFFFFFF   A5 FFFFFFFF   A6 FFFFFFFF   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0008 T=00 S=0 M=0 X=0 N=1 Z=0 V=0 C=0 IM=0 STP=0
Prefetch 0280 (AND) 000f (ILLEGAL) Chip latch 00000000
00024d56 0280 000f ff00           and.l #$000fff00,d0
Next PC: 00024d5c
;------------------------------------------------------------------------------
>fs 0 0
Cycles: 44923 Chip, 89846 CPU. (V=115 H=23 -> V=0 H=0)
VPOS: 000 ($000) HPOS: 005 ($005) COP: $00000420
  D0 00013800   D1 00000000   D2 00000000   D3 FFFFFFFF
  D4 FFFFFFFF   D5 FFFFFFFF   D6 FFFFFFFF   D7 FFFFFFFF
  A0 00024E30   A1 00000000   A2 00000000   A3 FFFFFFFF
  A4 FFFFFFFF   A5 FFFFFFFF   A6 FFFFFFFF   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0000 T=00 S=0 M=0 X=0 N=0 Z=0 V=0 C=0 IM=0 STP=0
Prefetch 0c80 (CMP) 0001 (OR) Chip latch 0000FFFE
00024d5c 0c80 0001 3700           cmp.l #$00013700,d0
Next PC: 00024d62
>

;------------------------------------------------------------------------------
from EAB:
run n cyclesvblslines

I'd like to analyze (and measure execution time for some procedures) a few demos and games for educational purposes.
I tried two methods - set a breakpoint for VERTB; use Copper breakpoint, but in both cases without success.
In the first case, VERTB was masked in INTENA or was disturbed by Copper interrupt.
In the second case, COP1LH/COP2LH were very often modified (different copper lists I guess).
Therefore, would be cool to have another breakpoint method, e.g. break after n VBLs/cycles or break on n scan-line etc.
Or break on defined Vpos/Hpos

Note that debugger always needs to wait until current CPU instruction has finished execution which
means above breakpoints can't be 100% exact.

Debugger can't enter debugger when CPU instruction is mid-execution.
It always needs to wait for current instruction to finish first.
(which might take dozens or even hundreds of cycles in worst case
if for example blitter steals all cycles)

many thanks.
agree, a user should takes into account that a long instructions like div/mul could delay a breakpoint.

what about adding a breakpoint (bitfield mask) for INTREQR interrupts?
That would allow to track a masked breakpoints and also it would make easier to distinguish interrupts with the same level.
