
; Listing19d4.s
; debugging an assembler program with a memory watchpoint from asmone  
; 1. channel watchpoint  'BLT' 
; 2. channel watchpoint  'COP'
; 3. hints - how to find the copper instruction, what causes the break?
; (WinUAE 5.3.0 A500 configuration)
; Console-Debugger
;
; w <num> <address> <length> [<R/W/I>] [<F/C/L/N>] [V<value>[.x]][<channel>]
;						(read/write/opcode) (freeze/mustchange/logonly/nobreak).
;                       Add/remove memory watchpoints.
;
;------------------------------------------------------------------------------
; 1. channel watchpoint  'BLT' 
;------------------------------------------------------------------------------
>r
Filename:Listing19k4.s
>a
Pass1
Pass2
No Errors
>j
																				; start the programm				   
																				; Shift+F12 open the Debugger
;------------------------------------------------------------------------------
>d pc
00026f44 2039 00df f004           move.l $00dff004,d0
00026f4a 0280 000f ff00           and.l #$000fff00,d0
00026f50 0c80 0000 5000           cmp.l #$00005000,d0
00026f56 66ec                     bne.b #$ec == $00026f44 (T)
00026f58 0839 0006 00df f002      btst.b #$0006,$00dff002
00026f60 0839 0006 00df f002      btst.b #$0006,$00dff002
00026f68 66f6                     bne.b #$f6 == $00026f60 (T)
00026f6a 33fc 0100 00df f040      move.w #$0100,$00dff040
00026f72 33fc 0000 00df f042      move.w #$0000,$00dff042
00026f7a 23fc 0001 0508 00df f054 move.l #$00010508,$00dff054
;------------------------------------------------------------------------------
>m 10508 2
00010508 0000 0000 0000 0000 0000 0000 0000 0000  ................
00010518 0000 0000 0000 0000 0000 0000 0000 0000  ................
;------------------------------------------------------------------------------
>w 1 $10508 10 BLT																; This command with 'BLT' requires 'cycle exact' otherwise it will not work!
Memwatch breakpoints enabled
 1: 00010508 - 00010517 (16) RWI BLT
;------------------------------------------------------------------------------
>g
Memwatch 1: break at 00010508.W  W  00000000 PC=00026F94 BLTDN (000)
Blitter registers at start:
PT A=00019BC0 B=00001004 C=0000E348 D=00010508
CON0=0100 CON1=0000 DAT A=0000 B=FFFF C=8000
AFWM=FFFF ALWM=FFFF MOD A=0000 B=FFF8 C=004C D=0000
COP=0 PC=00026F8C
Blitter registers now:
PT A=00019BC0 B=00001004 C=0000E348 D=0001050A
CON0=0100 CON1=0000 DAT A=0000 B=FFFF C=8000
AFWM=FFFF ALWM=FFFF MOD A=0000 B=FFF8 C=004C D=0000
PC=00026F9C DMA=1
Cycles: 41663 Chip, 83326 CPU. (V=210 H=0 -> V=80 H=122)
VPOS: 080 ($050) HPOS: 125 ($07d) COP: $0001ede4
  D0 00005000   D1 00010540   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00C028F6   A1 00010540   A2 00000000   A3 00000000
  A4 00000000   A5 00000000   A6 00C028F6   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0010 T=00 S=0 M=0 X=1 N=0 Z=0 V=0 C=0 IM=0 STP=0
Prefetch 66a6 (Bcc) 4eae (JSR) Chip latch 00004EAE
00026f94 0839 0002 00df f016      btst.b #$0002,$00dff016
00026f9c 66a6                     bne.b #$a6 == $00026f44 (T)
Next PC: 00026f9e
;------------------------------------------------------------------------------
>w1
Memwatch 1 removed

;------------------------------------------------------------------------------
; 2. channel watchpoint  'COP' 
;------------------------------------------------------------------------------
																				; only asmone is active				   
																				; Shift+F12 open the Debugger
>w 1 dff100 2 COP
 1: 00DFF100 - 00DFF101 (2) RWI COP
;------------------------------------------------------------------------------
;																				; it breaks immediately
; Memwatch 1: break at ...														; info message is missed
VPOS: 300 ($12c) HPOS: 011 ($00b) COP: $0001edee								; actual Copperpointer	
  D0 00000000   D1 00000000   D2 00000000   D3 0000FFFF
  D4 00000000   D5 0000FFFF   D6 00000000   D7 00000000
  A0 00C0040C   A1 00C22270   A2 00C1B214   A3 00C00410
  A4 00FC0FE2   A5 00C23272   A6 00C00276   A7 00C80000
USP  00C232B4 ISP  00C80000
SR=2000 T=00 S=1 M=0 X=0 N=0 Z=0 V=0 C=0 IM=0 STP=1
Prefetch 4e72 (STOP) 2000 (MOVE) Chip latch 0000FFFF
00fc0f90 4e72 2000                stop #$2000
Next PC: 00fc0f94
;------------------------------------------------------------------------------
>o 1edee-6																		; But how to find the copper instruction, what causes the break?
 0001ede8: 0100 0200            ;  BPLCON0 := 0x0200
*0001edec: ffff fffe            ;  Wait for vpos >= 0xff and hpos >= 0xfe
                                ;  VP ff, VE 7f; HP fe, HE fe; BFD 1
                                ;  End of Copperlist
;------------------------------------------------------------------------------
>w1
Memwatch 1 removed
;------------------------------------------------------------------------------
>x


;------------------------------------------------------------------------------
; 3. hints
;------------------------------------------------------------------------------

But how to find the copper instruction, what causes the break?
with a search and find method, unfortenately not direct:

>w 0 dff09c 2 all
 0: 00DFF09C - 00DFF09D (2) RWI ALL

Memwatch 0: break at 00DFF09C.W  W  00008010 PC=000459FE COP (08c)
Cycles: 10671 Chip, 21342 CPU. (V=210 H=7 -> V=257 H=9)
VPOS: 257 ($101) HPOS: 019 ($013) COP: $0004bc6c

>o 4bc6c						;  actual copper pointer
*0004bc6c: 0108 002e            ;  BPL1MOD := 0x002e

>o 4bc6c-8						;  backwards with search and find method (multiple of 4)
 0004bc64: 009c 8010            ;  INTREQ := 0x8010
 0004bc68: 1101 ff00            ;  Wait for vpos >= 0x11, , ignore horizontal
                                ;  VP 11, VE 7f; HP 00, HE 00; BFD 1
*0004bc6c: 0108 002e            ;  BPL1MOD := 0x002e

better would be the information about the copperaddress directly in first line, like:
Memwatch 0: break at 00DFF09C.W  W  00008010 PC=000459FE COP (08c) COP=$0004bc64


; from EAB
The watch points are better to use in my opinion because you can filter on the
types of operation and the source of it (CPU, BLITTER channel, COPPER etc).
I use a write then a memwatch in $DFF180. Or any other color register that are
usually only written by the copper. Or read the register and use a read breakpoint.

;------------------------------------------------------------------------------
; open point: and what makes a memwatch DMA validator?
>wl
Memwatch DMA validator enabled
>wlo
Memwatch DMA validator disabled