
; Listing19d3.s
; debugging an assembler program with a memory watchpoint from asmone  
; freeze a word value	   
; (WinUAE 5.3.0 A500 configuration)
; Console-Debugger
;
; w <num> <address> <length> [<R/W/I>] [<F/C/L/N>] [V<value>[.x]][<channel>]
;						(read/write/opcode) (freeze/mustchange/logonly/nobreak).
;                       Add/remove memory watchpoints.
;----------------------------------------------------------
; 
	ORG $20000
	LOAD $20000
	JUMPPTR start

start:
waitmouse:  
	btst	#6,$bfe001			; left mousebutton?
	bne.s	Waitmouse


	move.b	#$AA,$22000			; mit >w 0 22000 2 fw	memory content stays unchangend
	move.w	#$0123,$22002		; mit >w 1 22002 2 fr
	move.l  $22000,d0
	rts

	org $22000
daten:
	blk.b 100,$FF

	org $23000
Sinustab:
	DC.W	$18C6,$191A,$1944,$1998,$19EC,$1A16,$1A6A,$1A94,$1AE8,$1B12
	DC.W	$1B3C,$1B66,$1B90,$1BBA,$1BBA,$1BE4,$1BE4,$1BE4,$1BE4,$1BE4
	DC.W	$1BBA,$1BBA,$1B90,$1B66,$1B3C,$1B12,$1AE8,$1A94,$1A6A,$1A16
	DC.W	$19EC,$1998,$1944,$191A,$18C6,$1872,$181E,$17F4,$17A0,$174C
	DC.W	$1722,$16CE,$16A4,$1650,$1626,$15FC,$15D2,$15A8,$157E,$157E
	DC.W	$1554,$1554,$1554,$1554,$1554,$157E,$157E,$15A8,$15D2,$15FC
	DC.W	$1626,$1650,$16A4,$16CE,$1722,$174C,$17A0,$17F4,$181E,$1872
EndSinustab:

	end

;------------------------------------------------------------------------------
>r
Filename:Listing19d3.s
>a
Pass1
Pass2
No Errors
>j																				; start the programm																				
																				; the program is waiting for the left mouse button
;------------------------------------------------------------------------------
																				; open the Debugger with Shift+F12
>d pc																			; step 1 - watch actual programlines
00020000 0839 0006 00bf e001      btst.b #$0006,$00bfe001
00020008 66f6                     bne.b #$f6 == $00020000 (T)
0002000a 13fc 00aa 0002 2000      move.b #$aa,$00022000 [ff]
00020012 33fc 0123 0002 2002      move.w #$0123,$00022002 [ffff]
0002001a 2039 0002 2000           move.l $00022000 [ffffffff],d0
00020020 4e75                     rts  == $00c4f748
00020022 2e4c                     movea.l a4,a7
...
;------------------------------------------------------------------------------
>m 22000 2																		; view memory
00022000 FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF  ................
00022010 FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF  ................
;------------------------------------------------------------------------------
>f 2000a																		; step 2 - set breakpoint
Breakpoint added.
>w 0 22000 2 fw																	; step 3 - set memwatchpoint with freeze write
 0: 00022000 - 00022001 (2)  W  F CPU
>w																				; list breakpoints seperatly
 0: 00022000 - 00022001 (2)  W  F CPU											; there is no command for all breakpoints		
>fl
0: PC == 0002000a [ffffffff 00000000]
>g																				; don't exit the debugger, run the program
;------------------------------------------------------------------------------
																				; now click left mousebutton and the Debugger reopens
Breakpoint 0 triggered.
VPOS: 105 ($069) HPOS: 036 ($024) COP: $0001ede4
  D0 AAFF0123   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00021000   A1 00021000   A2 12345678   A3 00000000
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=000C T=00 S=0 M=0 X=0 N=1 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 13fc (MOVE) 00aa (OR) Chip latch 00000000
0002000a 13fc 00aa 0002 2000      move.b #$aa,$00022000 [ff]
Next PC: 00020012																; actual pc=2000A (our breakpoint 0)
;------------------------------------------------------------------------------
>m 22000 2																		; view memory
00022000 FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF  ................
00022010 FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF  ................
;------------------------------------------------------------------------------
>fi																				; step 3 - run to the next rts
VPOS: 105 ($069) HPOS: 066 ($042) COP: $0001ede4
  D0 FFFF0123   D1 00000000   D2 00000000   D3 00000000
  D4 00000000   D5 00000000   D6 00000000   D7 00000000
  A0 00021000   A1 00021000   A2 12345678   A3 00000000
  A4 00000000   A5 00000000   A6 00000000   A7 00C5FE68
USP  00C5FE68 ISP  00C60E68
SR=0008 T=00 S=0 M=0 X=0 N=1 Z=0 V=0 C=0 IM=0 STP=0
Prefetch 4e75 (RTS) 2e4c (MOVEA) Chip latch 00000000
00020020 4e75                     rts  == $00c4f748
Next PC: 00020022
;------------------------------------------------------------------------------
>m 22000 2
00022000 FFFF 0123 FFFF FFFF FFFF FFFF FFFF FFFF  ...#............				; value on adress 22000 unchanged
00022010 FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF  ................				; because is freezed (w 0 22000 2 fw)
>
