
; Listing19c4.s
; debugging an assembler program with a programm breakpoint
; start and run from shell	
; (WinUAE 5.3.0 A500 configuration)
; Console-Debugger

;  fp "<name>"/<addr>    Step forward until process <name> or <addr> is active.
;  fl                    List breakpoints.
;  fd                    Remove all breakpoints.
;  d <address> [<lines>] Disassembly starting at <address>.
;  t [instructions]      Step one or more instructions.
;  fi                    Step forward until PC points to RTS, RTD or RTE.
;------------------------------------------------------------------------------

start:

;waitmouse:  
;	btst	#6,$bfe001	; left mousebutton?
;	bne.s	Waitmouse	

	lea	dog,a0
	move.L	#dog,a1
	move.L	dog,a2
	move.l	#$AA,cat1
	move.l	a1,cat2
	move.l	a2,cat3
	move.l	#$BB,cat1
	move.l	a1,cat2
	move.l	a2,cat3
	rts

dog:
	dc.l	$12345678
cat1:
	dc.l	0
cat2:
	dc.l	0
cat3:
	dc.l	0

	end
;------------------------------------------------------------------------------
																				; make an exe-file
>r 
Listing19c4.s
>a
Pass1
Pass2
No Errors
>wo
filename:L19c4
																				; change to shell by multitasking
																				; and to the directory with the file 'L19c4'
																				; or leave asmone with >!
																				; >list ; show the files in shell
;------------------------------------------------------------------------------
																				; open the Debugger with Shift+F12

>fp "L19c4"																		; Step forward until process <name> is active.
																				; with ""
																				; the x-command is not possible now
;------------------------------------------------------------------------------
																				; in the shell
>L19c4																			; insert (Listing19c4) and start the program with enter
																				; we don't need to wait for the left mousebutton
;------------------------------------------------------------------------------
>fp "L19c4"																		; the debugger leaves open !
Cycles: 4194303 Chip, 8388607 CPU. (V=210 H=1 -> V=135 H=52)			
VPOS: 135 ($087) HPOS: 052 ($034) COP: $0006a56c
  D0 00000001   D1 00C21B10   D2 00000FA0   D3 00000FA8
  D4 00000001   D5 0000003E   D6 0030866B   D7 00308678
  A0 00C21B10   A1 00C21C20   A2 00C063D8   A3 00C2354C
  A4 00C248E8   A5 00FF4134   A6 00FF4128   A7 00C248E4
USP  00C248E4 ISP  00C80000
SR=0000 T=00 S=0 M=0 X=0 N=0 Z=0 V=0 C=0 IM=0 STP=0
Prefetch 41f9 (LEA) 00c2 (ILLEGAL) Chip latch 00000003
00c23550 41f9 00c2 3590           lea.l $00c23590,a0
Next PC: 00c23556
>
;------------------------------------------------------------------------------
>fl
No breakpoints.
;------------------------------------------------------------------------------
>d pc
00c23550 41f9 00c2 3590           lea.l $00c23590,a0
00c23556 227c 00c2 3590           movea.l #$00c23590,a1
00c2355c 2479 00c2 3590           movea.l $00c23590 [12345678],a2
00c23562 23fc 0000 00aa 00c2 3594 move.l #$000000aa,$00c23594 [00000000]
00c2356c 23c9 00c2 3598           move.l a1,$00c23598 [00000000]
00c23572 23ca 00c2 359c           move.l a2,$00c2359c [00000000]
00c23578 23fc 0000 00bb 00c2 3594 move.l #$000000bb,$00c23594 [00000000]
00c23582 23c9 00c2 3598           move.l a1,$00c23598 [00000000]
00c23588 23ca 00c2 359c           move.l a2,$00c2359c [00000000]
00c2358e 4e75                     rts  == $00ff492e
;------------------------------------------------------------------------------
>t
Cycles: 6 Chip, 12 CPU. (V=135 H=52 -> V=135 H=58)
VPOS: 135 ($087) HPOS: 058 ($03a) COP: $0006a56c
  D0 00000001   D1 00C21B10   D2 00000FA0   D3 00000FA8
  D4 00000001   D5 0000003E   D6 0030866B   D7 00308678
  A0 00C23590   A1 00C21C20   A2 00C063D8   A3 00C2354C
  A4 00C248E8   A5 00FF4134   A6 00FF4128   A7 00C248E4
USP  00C248E4 ISP  00C80000
SR=0000 T=00 S=0 M=0 X=0 N=0 Z=0 V=0 C=0 IM=0 STP=0
Prefetch 227c (MOVEA) 00c2 (ILLEGAL) Chip latch 00000003
00c23556 227c 00c2 3590           movea.l #$00c23590,a1
Next PC: 00c2355c
;------------------------------------------------------------------------------
>t 3																			; three steps (doesn't work)
Cycles: 6 Chip, 12 CPU. (V=135 H=58 -> V=135 H=64)								; with fp 'only singlesteps'	
VPOS: 135 ($087) HPOS: 064 ($040) COP: $0006a56c
  D0 00000001   D1 00C21B10   D2 00000FA0   D3 00000FA8
  D4 00000001   D5 0000003E   D6 0030866B   D7 00308678
  A0 00C23590   A1 00C23590   A2 00C063D8   A3 00C2354C
  A4 00C248E8   A5 00FF4134   A6 00FF4128   A7 00C248E4
USP  00C248E4 ISP  00C80000
SR=0000 T=00 S=0 M=0 X=0 N=0 Z=0 V=0 C=0 IM=0 STP=0
Prefetch 2479 (MOVEA) 00c2 (ILLEGAL) Chip latch 00000003
00c2355c 2479 00c2 3590           movea.l $00c23590 [12345678],a2
Next PC: 00c23562
>
;------------------------------------------------------------------------------
>fi																				; run to next rts, doesn't work
Cycles: 10 Chip, 20 CPU. (V=135 H=64 -> V=135 H=74)								; with fp 'only singlesteps'
VPOS: 135 ($087) HPOS: 074 ($04a) COP: $0006a56c
  D0 00000001   D1 00C21B10   D2 00000FA0   D3 00000FA8
  D4 00000001   D5 0000003E   D6 0030866B   D7 00308678
  A0 00C23590   A1 00C23590   A2 12345678   A3 00C2354C
  A4 00C248E8   A5 00FF4134   A6 00FF4128   A7 00C248E4
USP  00C248E4 ISP  00C80000
SR=0000 T=00 S=0 M=0 X=0 N=0 Z=0 V=0 C=0 IM=0 STP=0
Prefetch 23fc (MOVE) 0000 (OR) Chip latch 00000003
00c23562 23fc 0000 00aa 00c2 3594 move.l #$000000aa,$00c23594 [00000000]
Next PC: 00c2356c
;------------------------------------------------------------------------------
>x																				; leave the debugger

;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
; 2nd try - the solution

Toni Wilen
It works as designed (which probably isn't what you wanted).
fp stays active after it has broken to debugger which means it will keep breaking
to debugger immediately after leaving as long as process is active. Disable fp 
("fp" without parameters) first and then use other commands.

It is not possible to combine "fp" with other breakpoints and expect them to work
nicely :)

I'd recommend using uaedbg mode instead of "fp" command which in my opinion does 
not really fit with other debugger features. (fp is not purely "hardware" breakpoint)

;------------------------------------------------------------------------------
>fp "L19c4"
Cycles: 4194303 Chip, 8388607 CPU. (V=210 H=3 -> V=65 H=179)
VPOS: 065 ($041) HPOS: 179 ($0b3) COP: $0006a56c
  D0 00000001   D1 00C21B10   D2 00000FA0   D3 00000FA8
  D4 00000001   D5 0000003E   D6 0030866B   D7 00308678
  A0 00C21B10   A1 00C21C20   A2 00C063D8   A3 00C2354C
  A4 00C248E8   A5 00FF4134   A6 00FF4128   A7 00C248E4
USP  00C248E4 ISP  00C80000
SR=0000 T=00 S=0 M=0 X=0 N=0 Z=0 V=0 C=0 IM=0 STP=0
Prefetch 41f9 (LEA) 00c2 (ILLEGAL) Chip latch 00000003
00c23550 41f9 00c2 3590           lea.l $00c23590,a0
Next PC: 00c23556
;------------------------------------------------------------------------------
>fp																				; step 1 - disable the fp
;------------------------------------------------------------------------------
>d pc																			; step 2 - look current programlines
00c23550 41f9 00c2 3590           lea.l $00c23590,a0
00c23556 227c 00c2 3590           movea.l #$00c23590,a1
00c2355c 2479 00c2 3590           movea.l $00c23590 [12345678],a2
00c23562 23fc 0000 00aa 00c2 3594 move.l #$000000aa,$00c23594 [00000000]
00c2356c 23c9 00c2 3598           move.l a1,$00c23598 [00000000]
00c23572 23ca 00c2 359c           move.l a2,$00c2359c [00000000]
00c23578 23fc 0000 00bb 00c2 3594 move.l #$000000bb,$00c23594 [00000000]
00c23582 23c9 00c2 3598           move.l a1,$00c23598 [00000000]
00c23588 23ca 00c2 359c           move.l a2,$00c2359c [00000000]
00c2358e 4e75                     rts  == $00ff492e
;------------------------------------------------------------------------------
>t																				; step 3 - trace (one step)
Cycles: 6 Chip, 12 CPU. (V=65 H=179 -> V=65 H=185)
VPOS: 065 ($041) HPOS: 185 ($0b9) COP: $0006a56c
  D0 00000001   D1 00C21B10   D2 00000FA0   D3 00000FA8
  D4 00000001   D5 0000003E   D6 0030866B   D7 00308678
  A0 00C23590   A1 00C21C20   A2 00C063D8   A3 00C2354C
  A4 00C248E8   A5 00FF4134   A6 00FF4128   A7 00C248E4
USP  00C248E4 ISP  00C80000
SR=0000 T=00 S=0 M=0 X=0 N=0 Z=0 V=0 C=0 IM=0 STP=0
Prefetch 227c (MOVEA) 00c2 (ILLEGAL) Chip latch 00000003
00c23556 227c 00c2 3590           movea.l #$00c23590,a1
Next PC: 00c2355c
;------------------------------------------------------------------------------
>t 3																			; step 4 - trace (multiple steps)
Cycles: 30 Chip, 60 CPU. (V=65 H=185 -> V=65 H=215)
VPOS: 065 ($041) HPOS: 215 ($0d7) COP: $0006a56c
  D0 00000001   D1 00C21B10   D2 00000FA0   D3 00000FA8
  D4 00000001   D5 0000003E   D6 0030866B   D7 00308678
  A0 00C23590   A1 00C23590   A2 12345678   A3 00C2354C
  A4 00C248E8   A5 00FF4134   A6 00FF4128   A7 00C248E4
USP  00C248E4 ISP  00C80000
SR=0000 T=00 S=0 M=0 X=0 N=0 Z=0 V=0 C=0 IM=0 STP=0
Prefetch 23c9 (MOVE) 00c2 (ILLEGAL) Chip latch 00000003
00c2356c 23c9 00c2 3598           move.l a1,$00c23598 [00000000]
Next PC: 00c23572
;------------------------------------------------------------------------------
>fi																				; step 5 - run to rts
Cycles: 54 Chip, 108 CPU. (V=65 H=215 -> V=66 H=42)
VPOS: 066 ($042) HPOS: 042 ($02a) COP: $0006a56c
  D0 00000001   D1 00C21B10   D2 00000FA0   D3 00000FA8
  D4 00000001   D5 0000003E   D6 0030866B   D7 00308678
  A0 00C23590   A1 00C23590   A2 12345678   A3 00C2354C
  A4 00C248E8   A5 00FF4134   A6 00FF4128   A7 00C248E4
USP  00C248E4 ISP  00C80000
SR=0000 T=00 S=0 M=0 X=0 N=0 Z=0 V=0 C=0 IM=0 STP=0
Prefetch 4e75 (RTS) 1234 (MOVE) Chip latch 00000003
00c2358e 4e75                     rts  == $00ff492e
Next PC: 00c23590
;------------------------------------------------------------------------------
>fl
No breakpoints.
;------------------------------------------------------------------------------
>fd
All breakpoints removed.
;------------------------------------------------------------------------------
>x																				; leave the debugger	

