
; Listing19c2.s
; debugging an assembler program with a programm breakpoint
; start and run from asmone	
; (WinUAE 5.3.0 A500 configuration)
; Console-Debugger

; change to Console Debugger with xx and restart WinUAE

;  f <address>           Add/remove breakpoint.
;  fl                    List breakpoints.
;  fd                    Remove all breakpoints.
;  d <address> [<lines>] Disassembly starting at <address>.
;  t [instructions]      Step one or more instructions.
;  fi                    Step forward until PC points to RTS, RTD or RTE.
;  z    Step through one instruction - useful for JSR, DBRA etc.
;------------------------------------------------------------------------------

start: 
 
waitmouse:  
	btst	#6,$bfe001	; left mousebutton?
	bne.s	Waitmouse	

	move.w	#0,d0		; Set i do 0
	
.loop:	
	cmp.w	#31,d0		; is i = 31?
	beq	.done			; yes, take branch
	add.w	#1,d0		; no, add 1 to i
; do something
	bra	.loop			; continue loop

.done:
	nop
	
.exit:  moveq	#0,d0
	rts
	end

;------------------------------------------------------------------------------
>r
Filename:Listing19c2.s
>a
Pass1
Pass2
No Errors
>j
																				; start the programm
																				; the program is waiting for the left mouse button
;------------------------------------------------------------------------------
																				; open the Debugger with Shift+F12
																				; task 1 - look current programlines
>d pc
00022d1c 0839 0006 00bf e001      btst.b #$0006,$00bfe001
00022d24 66f6                     bne.b #$f6 == $00022d1c (T)
00022d26 303c 0000                move.w #$0000,d0								; set a breakpoint on this line
00022d2a 0c40 001f                cmp.w #$001f,d0
00022d2e 6700 000a                beq.w #$000a == $00022d3a (F)
00022d32 0640 0001                add.w #$0001,d0
00022d36 6000 fff2                bra.w #$fff2 == $00022d2a (T)
00022d3a 4e71                     nop
00022d3c 7000                     moveq #$00,d0
00022d3e 4e75                     rts  == $00c4f6e8
>f 22d26																		; step 2 - set a breakpoint
Breakpoint added.
>x																				; leave the debugger
	
;------------------------------------------------------------------------------
																				; the program is waiting for the left mouse button
																				; now click left mousebutton and the debugger reopens
																				; and wait on this line

>r																				; step 3 - the actual state of the register
VPOS: 105 ($069) HPOS: 033 ($021) COP: $0001ede4
  D0 00000000   D1 01401A30   D2 01FE0000   D3 0000FFFF
  D4 0000FFFF   D5 00000000   D6 00000000   D7 00000000
  A0 0002248A   A1 0002248A   A2 12345678   A3 00000000
  A4 00000000   A5 00000000   A6 00C00276   A7 00C5FE08
USP  00C5FE08 ISP  00C60E08
SR=0014 T=00 S=0 M=0 X=1 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 303c (MOVE) 0000 (OR) Chip latch 00000000
00022d26 303c 0000                move.w #$0000,d0								; we waiting on this line	
Next PC: 00022d2a
>
;------------------------------------------------------------------------------
>d pc																			; disassembled programm
00022d26 303c 0000                move.w #$0000,d0								; we waiting on this line
00022d2a 0c40 001f                cmp.w #$001f,d0
00022d2e 6700 000a                beq.w #$000a == $00022d3a (T)
00022d32 0640 0001                add.w #$0001,d0
00022d36 6000 fff2                bra.w #$fff2 == $00022d2a (T)
00022d3a 4e71                     nop
00022d3c 7000                     moveq #$00,d0
00022d3e 4e75                     rts  == $00c4f6e8
00022d40 1234 5678                move.b (a4,d5.w[*8],$78) == $00000078 (68020+) [00],d1
00022d44 0000 0000                or.b #$00,d0
;------------------------------------------------------------------------------
>t																				; step 4 - try several times the t command								
Cycles: 4 Chip, 8 CPU. (V=105 H=33 -> V=105 H=37)								; and observe the registers
VPOS: 105 ($069) HPOS: 037 ($025) COP: $0001ede4
  D0 00000000   D1 01401A30   D2 01FE0000   D3 0000FFFF
  D4 0000FFFF   D5 00000000   D6 00000000   D7 00000000
  A0 0002248A   A1 0002248A   A2 12345678   A3 00000000
  A4 00000000   A5 00000000   A6 00C00276   A7 00C5FE08
USP  00C5FE08 ISP  00C60E08
SR=0014 T=00 S=0 M=0 X=1 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 0c40 (CMP) 001f (OR) Chip latch 00000000
00022d2a 0c40 001f                cmp.w #$001f,d0
Next PC: 00022d2e
;------------------------------------------------------------------------------
>t	
Cycles: 4 Chip, 8 CPU. (V=105 H=37 -> V=105 H=41)
VPOS: 105 ($069) HPOS: 041 ($029) COP: $0001ede4
  D0 00000000   D1 01401A30   D2 01FE0000   D3 0000FFFF
  D4 0000FFFF   D5 00000000   D6 00000000   D7 00000000
  A0 0002248A   A1 0002248A   A2 12345678   A3 00000000
  A4 00000000   A5 00000000   A6 00C00276   A7 00C5FE08
USP  00C5FE08 ISP  00C60E08
SR=0019 T=00 S=0 M=0 X=1 N=1 Z=0 V=0 C=1 IM=0 STP=0
Prefetch 6700 (Bcc) 000a (ILLEGAL) Chip latch 00000000
00022d2e 6700 000a                beq.w #$000a == $00022d3a (F)
Next PC: 00022d32
;------------------------------------------------------------------------------																		
>t 20																			; step 5 - more then one step
Cycles: 95 Chip, 190 CPU. (V=105 H=41 -> V=105 H=136)
VPOS: 105 ($069) HPOS: 136 ($088) COP: $0001ede4
  D0 00000005   D1 01401A30   D2 01FE0000   D3 0000FFFF							; watch register d0
  D4 0000FFFF   D5 00000000   D6 00000000   D7 00000000
  A0 0002248A   A1 0002248A   A2 12345678   A3 00000000
  A4 00000000   A5 00000000   A6 00C00276   A7 00C5FE08
USP  00C5FE08 ISP  00C60E08
SR=0009 T=00 S=0 M=0 X=0 N=1 Z=0 V=0 C=1 IM=0 STP=0
Prefetch 6700 (Bcc) 000a (ILLEGAL) Chip latch 00000000
00022d2e 6700 000a                beq.w #$000a == $00022d3a (F)
Next PC: 00022d32
;------------------------------------------------------------------------------
>d pc
00022d2e 6700 000a                beq.w #$000a == $00022d3a (F)
00022d32 0640 0001                add.w #$0001,d0
00022d36 6000 fff2                bra.w #$fff2 == $00022d2a (T)
00022d3a 4e71                     nop
00022d3c 7000                     moveq #$00,d0
00022d3e 4e75                     rts  == $00c4f6e8
;------------------------------------------------------------------------------
>z																				; step 6 - z works if bra .loop is the next command 
Cycles: 6 Chip, 12 CPU. (V=105 H=136 -> V=105 H=142)
VPOS: 105 ($069) HPOS: 142 ($08e) COP: $0001ede4
  D0 00000005   D1 01401A30   D2 01FE0000   D3 0000FFFF
  D4 0000FFFF   D5 00000000   D6 00000000   D7 00000000
  A0 0002248A   A1 0002248A   A2 12345678   A3 00000000
  A4 00000000   A5 00000000   A6 00C00276   A7 00C5FE08
USP  00C5FE08 ISP  00C60E08
SR=0009 T=00 S=0 M=0 X=0 N=1 Z=0 V=0 C=1 IM=0 STP=0
Prefetch 0640 (ADD) 0001 (OR) Chip latch 00000000
00022d32 0640 0001                add.w #$0001,d0
Next PC: 00022d36
;------------------------------------------------------------------------------
>z																				; step 7 - z works if bra .loop is the next command 
Cycles: 4 Chip, 8 CPU. (V=105 H=142 -> V=105 H=146)
VPOS: 105 ($069) HPOS: 146 ($092) COP: $0001ede4
  D0 00000006   D1 01401A30   D2 01FE0000   D3 0000FFFF
  D4 0000FFFF   D5 00000000   D6 00000000   D7 00000000
  A0 0002248A   A1 0002248A   A2 12345678   A3 00000000
  A4 00000000   A5 00000000   A6 00C00276   A7 00C5FE08
USP  00C5FE08 ISP  00C60E08
SR=0000 T=00 S=0 M=0 X=0 N=0 Z=0 V=0 C=0 IM=0 STP=0
Prefetch 6000 (Bcc) fff2 (ILLEGAL) Chip latch 00000000
00022d36 6000 fff2                bra.w #$fff2 == $00022d2a (T)
Next PC: 00022d3az
;------------------------------------------------------------------------------
>z																				; step 8 - z now !
Cycles: 489 Chip, 978 CPU. (V=105 H=146 -> V=107 H=181)
VPOS: 107 ($06b) HPOS: 181 ($0b5) COP: $0001ede4
  D0 0000001F   D1 01401A30   D2 01FE0000   D3 0000FFFF
  D4 0000FFFF   D5 00000000   D6 00000000   D7 00000000
  A0 0002248A   A1 0002248A   A2 12345678   A3 00000000
  A4 00000000   A5 00000000   A6 00C00276   A7 00C5FE08
USP  00C5FE08 ISP  00C60E08
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 4e71 (NOP) 7000 (MOVE) Chip latch 00000000
00022d3a 4e71                     nop
Next PC: 00022d3c
;------------------------------------------------------------------------------
>fi																				; step 9 - go to rts (Step forward until PC
Cycles: 4 Chip, 8 CPU. (V=107 H=181 -> V=107 H=185)								; points to RTS, RTD or RTE.)
VPOS: 107 ($06b) HPOS: 185 ($0b9) COP: $0001ede4
  D0 00000000   D1 01401A30   D2 01FE0000   D3 0000FFFF
  D4 0000FFFF   D5 00000000   D6 00000000   D7 00000000
  A0 0002248A   A1 0002248A   A2 12345678   A3 00000000
  A4 00000000   A5 00000000   A6 00C00276   A7 00C5FE08
USP  00C5FE08 ISP  00C60E08
SR=0004 T=00 S=0 M=0 X=0 N=0 Z=1 V=0 C=0 IM=0 STP=0
Prefetch 4e75 (RTS) 1234 (MOVE) Chip latch 00000000
00022d3e 4e75                     rts  == $00c4f6e8								; rts
Next PC: 00022d40
;------------------------------------------------------------------------------
>d pc 3
00022d3e 4e75                     rts  == $00c4f6e8								; return address
00022d40 1234 5678                move.b (a4,d5.w[*8],$78) == $00000078 (68020+) [00],d1
00022d44 0000 0000                or.b #$00,d0
>fd
All breakpoints removed.
>x																				; leave the debugger

Note:
The z-command steps through the part of code if bra is the next command,
else the z works like the t command. Also you can see information on how
many clock cycles or which raster time has elapsed.

With the z-command you can step over subroutines like jsr, bsr.