
; Listing18f.s = MaseDotCube.s

	section	bau,code_C

START:	MOVEM.L	D0-D7/A0-A6,-(A7)	; Put registers on stack
	MOVE.L	$4.W,A6					; Exec pointer to A6
	LEA.L	GfxName(PC),A1			; Set library pointer
	MOVEQ	#0,D0
	JSR	OldOpenLibrary(A6)			; Open graphics.library
	MOVE.L	D0,A1					; Use Base-pointer
	MOVE.L	$26(A1),OldCop1			; Store copper1 start addr
	MOVE.L	$32(A1),OldCop2			; Store copper1 start addr
	JSR	CloseLibrary(A6)			; Close graphics library
	LEA	$DFF000,A6
	MOVE.W	$1C(A6),INTENA			; Store old INTENA
	MOVE.W	$2(A6),DMACON			; Store old DMACON
	MOVE.W	$10(A6),ADKCON			; Store old ADKCON
	MOVE.W	#$7FFF,$9A(A6)			; Clear interrupt enable
	BSR.W	Wait_Vert_Blank
	MOVE.W	#$7FFF,$96(A6)			; Clear DMA channels
	MOVE.L	#COPLIST,$80(A6)		; Copper1 start address
	move.w	d0,$88(a6)
	move.w	#0,$1fc(a6)
	MOVE.W	#DMASET!$8200,$96(A6)	; DMA kontrol data
	MOVE.L	$6C.W,OldInter			; Store old inter pointer
	MOVE.L	#INTER,$6C.W			; Set interrupt pointer
	MOVE.W	#$7FFF,$9C(A6)			; Clear request
	MOVE.W	#$C020,$9A(A6)			; Interrupt enable

	BSR.W	CALCYTABELLA
	BSR.W	CALCXTABELLA
	BSR.W	CALCBITMASKX
	BSR.W	LOADSCREEN


LOOP:	BSR.W	LOADSCREEN
	BSR.W	SWAPSCREENS


	BSR.W	Wait_Vert_Blank
	move.w	#$370,$dff180
	BSR.W	CLS
	BSR.W	RUOTAXYZ
	LEA	$DFF000,A6
	BSR.W	PROIEZ_CENTRALE
	BSR.W	CALCOLA

	BSR.W	DRAWPOINTS

	move.w	#$008,$dff180
	BTST	#6,$BFE001
	BNE.S	LOOP


	LEA	$DFF000,A6
	MOVE.W	#$7FFF,$9A(A6)			; Disable interrupts
	BSR.S	Wait_Vert_Blank
	MOVE.W	#$7FFF,$96(A6)
	MOVE.L	OldCop1(PC),$80(A6)		; Restore old copper1
	MOVE.L	OldCop2(PC),$84(A6)		; Restore old copper1
	MOVE.L	OldInter(PC),$6C.W		; Restore inter pointer
	MOVE.W	DMACON,D0				; Restore old DMACON
	OR.W	#$8000,D0
	MOVE.W	D0,$96(A6)		
	MOVE.W	ADKCON,D0				; Restore old ADKCON
	OR.W	#$8000,D0
	MOVE.W	D0,$9E(A6)
	MOVE.W	INTENA,D0				; Restore inter data
	OR.W	#$C000,D0
	MOVE.W	#$7FFF,$9C(A6)
	MOVE.W	D0,$9A(A6)
	MOVEM.L	(A7)+,D0-D7/A0-A6		; Get registers from stack
	RTS

Wait_Vert_Blank:
	LEA	$DFF000,A6
	BTST	#0,$5(A6)
	BEQ.S	Wait_Vert_Blank
.loop	BTST	#0,$5(A6)
	BNE.S	.loop
	RTS


WAITOF:	move.l	$dff004,d2			; Wait the start of the vertirq
	and.l	#$0001ff00,d2			; and the start of the video scan
	cmp.l	#$0000F000,d2
	bne.b	WAITOF
	rts


OldOpenLibrary	= -408
CloseLibrary	= -414

DMASET=	%1000010111000000
;	 -----a-bcdefghij

;	a: Blitter Nasty
;	b: Bitplane DMA (if this isn't set, sprites disappear!)
;	c: Copper DMA
;	d: Blitter DMA
;	e: Sprite DMA
;	f: Disk DMA
;	g-j: Audio 3-0 DMA

GfxName		DC.B	'graphics.library',0
		even
DosBase		DC.L	0
OldInter	DC.L	0
OldCop1		DC.L	0
OldCop2		DC.L	0
INTENA		DC.W	0
DMACON		DC.W	0
ADKCON		DC.W	0

INTER:
	MOVEM.L	D0-D7/A0-A6,-(A7)
	LEA.L	$DFF000,A6


	MOVE.W	#$4020,$9C(A6)			; Clear interrupt request
	MOVEM.L	(A7)+,D0-D7/A0-A6
	RTE
	
LOADSCREEN:
	MOVE.L	SCRPTR,D0
	LEA.L	PLANES,A0
	MOVE.W	#320,D1
	MOVE.W	#256,D2
	MOVEQ	#3,D3
	BSR.B	LOADBITMAP
	RTS

SWAPSCREENS
	MOVE.W	SCRFLAG,D0
	TST.W	D0
	BNE.S	SCREENBUF
	MOVE.L	#SCREEN,SCRPTR
	MOVE.L	#FBUFFER,SCRPTR2
	MOVE.W	#1,SCRFLAG
	RTS

SCREENBUF:
	MOVE.L	#FBUFFER,SCRPTR
	MOVE.L	#SCREEN,SCRPTR2
	MOVE.W	#0,SCRFLAG
	RTS

	; D0 <- Ptr to Bitmap
	; A0 <- Ptr to Copper list (Assign Bitplanes Zone)
	; D1 <- N. pixel horizontal
	; D2 <- N. pixel vertical
	; D3 <- Number of Bitplanes

LOADBITMAP:
	LSR.W	#3,D1
	MULU.W	D2,D1
	SUBQ.W	#1,D3
LOADBITMAP_LOOP
	MOVE.W	D0,2(A0)
	SWAP	D0
	ADDQ.W	#4,A0
	MOVE.W	D0,2(A0)
	SWAP	D0
	ADDQ.W	#4,A0
	ADD.L	D1,D0
	DBRA	D3,LOADBITMAP_LOOP
	RTS

CALCYTABELLA
	LEA.L	YTABELLA,A0
	MOVEQ	#40,D0
	MOVEQ	#0,D1
	MOVE.W	#255,D2
CALCYTABELLA_LOOP
	MOVE.W	D1,D3
	MULU.W	D0,D3
	MOVE.W	D3,(A0)+
	ADDQ.W	#1,D1
	DBRA	D2,CALCYTABELLA_LOOP
	RTS

CALCXTABELLA
	LEA.L	XTABELLA,A0
	MOVEQ	#0,D1
	MOVE.W	#39,D2
CALCXTABELLA_LOOP
	MOVE.W	D1,(A0)+
	MOVE.W	D1,(A0)+
	MOVE.W	D1,(A0)+
	MOVE.W	D1,(A0)+
	MOVE.W	D1,(A0)+
	MOVE.W	D1,(A0)+
	MOVE.W	D1,(A0)+
	MOVE.W	D1,(A0)+

	ADD.W	#1,D1
	DBRA	D2,CALCXTABELLA_LOOP
	RTS

CALCBITMASKX
	LEA.L	BITMASKX,A0
	MOVE.W	#39,D2
CALCBITMASKX_LOOP
	LEA.L	PREDEF_MASX,A1
	MOVE.B	(A1)+,(A0)+
	MOVE.B	(A1)+,(A0)+
	MOVE.B	(A1)+,(A0)+
	MOVE.B	(A1)+,(A0)+
	MOVE.B	(A1)+,(A0)+
	MOVE.B	(A1)+,(A0)+
	MOVE.B	(A1)+,(A0)+
	MOVE.B	(A1)+,(A0)+

	DBRA	D2,CALCBITMASKX_LOOP
	RTS

PREDEF_MASX
	 DC.B	%10000000,%01000000,%00100000,%00010000
	 DC.B	%00001000,%00000100,%00000010,%00000001


;    ************************** PROJECTIONS ****************************

RUOTAXYZ:
	LEA.L	RT_AUXBUF(PC),A6

	MOVE.W	ax,D0
	MOVE.W	ay,D1
	MOVE.W	az,D2

	LEA.L	SENO(PC),A0
	LEA.L	SENO(PC),A1
	LEA.L	SENO(PC),A2
	ADD.W	D0,A0
	ADD.W	D1,A1
	ADD.W	D2,A2
	MOVE.W	(A0),(A6)				; SIN(RX)
	MOVE.W	(A1),$2(A6)				; SIN(RY)
	MOVE.W	(A2),$4(A6)				; SIN(RZ)

	LEA.L	COSENO(PC),A0
	LEA.L	COSENO(PC),A1
	LEA.L	COSENO(PC),A2
	ADD.W	D0,A0
	ADD.W	D1,A1
	ADD.W	D2,A2
	MOVE.W	(A0),$6(A6)				; COS(RX)
	MOVE.W	(A1),$8(A6)				; COS(RY)
	MOVE.W	(A2),$A(A6)				; COS(RZ)

	ADD.W	r1x,d0
	AND.W	#$03ff,d0
	MOVE.W	d0,ax
	ADD.W	r1y,d1
	AND.W	#$03ff,d1
	MOVE.W	d1,ay
	ADD.W	r1z,d2
	AND.W	#$03ff,d2
	MOVE.W	d2,az

	MOVEQ	#$C,D7
	LEA.L	X_COORD(pc),A0
	LEA.L	Y_COORD(pc),A1
	LEA.L	Z_COORD(pc),A2
	LEA.L	X_COORD2(pc),A3
	LEA.L	Y_COORD2(pc),A4
	LEA.L	Z_COORD2(pc),A5
	MOVE.W	#4,D0
;	MOVE.W	N_XYZCOORD(pc),D0
	SUBQ	#1,D0
RUOTAXYZ_LOOP:

	; rotate x-axis

	MOVE.W	(A0)+,D3				; save partial x

	MOVE.W	(A1),D1					; y <- d1
	MULS.W	$6(A6),D1				; y*cos(a)*1000 <- d1
	ASR.L	D7,D1					; y*cos(a)  <- d1
	MOVE.W	(A2),D2					; z <- d2
	MULS.W	(A6),D2					; z*sin(a)*1000 <- d2
	ASR.L	D7,D2					; z*sin(a)  <- d2
	SUB.W	D2,D1					; y*cos(a)-z*sin(a) <- d1
	MOVE.W	D1,d4					; save  partial y

	MOVE.W	(A1)+,D1				; y <- d1
	MULS.W	(A6),D1					; y*sin(a)*1000 <- d1
	ASR.L	D7,D1					; y*sin(a)  <- d1
	MOVE.W	(A2)+,D2				; z <- d2
	MULS.W	$6(A6),D2				; z*cos(a)*1000 <- d2
	ASR.L	D7,D2					; z*cos(a)  <- d2
	ADD.W	D2,D1					; y*sin(a)+z*cos(a) <- d1
	MOVE.W	D1,d5					; save partial z

	;  Rotate y-axis

	MOVE.W	d3,D1					; x <- d1
	MOVE.W	D1,D6					; save xpar value
	MULS.W	$8(A6),D1				; x*cos(b)*1000 <- d1
	ASR.L	D7,D1					; x*cos(b)  <- d1
	MOVE.W	d5,D2					; z <- d2
	MULS.W	$2(A6),D2				; z*sin(b)*1000 <- d2
	ASR.L	D7,D2					; z*sin(b)  <- d2
	SUB.W	D2,D1					; x*cos(b)+z*sin(b) <- d1
	MOVE.W	D1,d3					; save  partial x
	
	MOVE.W	d6,D1					; x <- d1
	MULS.W	$2(A6),D1				; x*sin(b)*1000 <- d1
	ASR.L	D7,D1					; x*sin(b)  <- d1
	MOVE.W	d5,D2					; z <- d2
	MULS.W	$8(A6),D2				; z*cos(b)*1000 <- d2
	ASR.L	D7,D2					; z*cos(b)  <- d2
	ADD.W	D2,D1					; -x*sin(b)+z*cos(b) <- d1
	MOVE.W	D1,d5					; save partial z

;	bra	conti

	;  Rotate z-axis

	MOVE.W	d3,D1					; x <- d1
	MOVE.W	D1,D6					; save xpar value
	MULS.W	$A(A6),D1				; x*cos(c)*1000 <- d1
	ASR.L	D7,D1					; x*cos(c)  <- d1
	MOVE.W	d4,D2					; z <- d2
	MULS.W	$4(A6),D2				; z*sin(c)*1000 <- d2
	ASR.L	D7,D2					; z*sin(c)  <- d2
	SUB.L	D2,D1					; x*cos(c)-y*sin(c) <- d1
	MOVE.W	D1,d3					; save  partial x
	
	MOVE.W	D6,D1					; x <- d1
	MULS.W	$4(A6),D1				; x*sin(c)*1000 <- d1
	ASR.L	D7,D1					; x*sin(c)  <- d1
	MOVE.W	d4,D2					; z <- d2
	MULS.W	$A(A6),D2				; z*cos(c)*1000 <- d2
	ASR.L	D7,D2					; z*cos(c)  <- d2
	ADD.L	D2,D1					; x*sin(c)+z*cos(c) <- d1
	MOVE.W	D1,d4					; save partial y

conti:	
	MOVE.W	D3,(A3)+
	NEG.W	D3
	MOVE.W	D3,6(A3)

	MOVE.W	D4,(A4)+
	NEG.W	D4
	MOVE.W	D4,6(A4)

	MOVE.W	D5,(A5)+
	NEG.W	D5
	MOVE.W	D5,6(A5)

	DBRA	D0,RUOTAXYZ_LOOP
	RTS	

RT_AUXBUF
	DS.W	6


PROIEZ_CENTRALE:
	LEA	X_COORD2(pc),A0
	LEA	Y_COORD2(pc),A1
	LEA	Z_COORD2(pc),A2
	LEA	X_SCR(pc),A3
	LEA	Y_SCR(pc),A4
	LEA	MXY(pc),A5
	MOVE.W	#$110,D4
	MOVE.W	ZOOMF(pc),D7
	MOVEQ	#8,D6
;	MOVE.W	N_XYZCOORD(pc),D6
	SUBQ	#1,D6
PROIEZ_LOOP:
	MOVE.W	(A0)+,D0
	MOVE.W	(A1)+,D1
	MOVE.W	(A2)+,D2
	SUB.W	D7,D2
	MOVE.W	d4,d5					; d4 -> d5

	Muls.w	d4,d0					; d0 = distance*x
	Muls.w	d4,d1					; d1 = distance*y
	SUB.W	d2,d5					; d5 = distance-z
	DIVS.W	d5,d0					; d0 = x(relative)
	DIVS.W	d5,d1					; d1 = y(relative)

	ADD.W	(A5),D0
	ADD.W	2(A5),D1

	move.w	d0,(a3)+				; d0 -> store X
	move.w	d1,(a4)+				; d1 -> store Y
	DBRA	D6,PROIEZ_LOOP
	RTS	



CALCOLA
	LEA.L	X_SCR+16(pc),A0
	LEA.L	Y_SCR+16(pc),A1
	LEA.L	X_SCR(pc),A4
	LEA.L	Y_SCR(pc),A5

	MOVE.W	(A4),D0					; 0 x
	MOVE.W	(A5),D1					; 0 y
	MOVE.W	2(A4),D2				; 1 x
	MOVE.W	2(A5),D3				; 1 y
	BSR.W	CHECKANDCALC

	MOVE.W	2(A4),D0				; 1 x
	MOVE.W	2(A5),D1				; 1 y
	MOVE.W	4(A4),D2				; 2 x
	MOVE.W	4(A5),D3				; 2 y
	BSR.W	CHECKANDCALC

	MOVE.W	4(A4),D0				; 2 x
	MOVE.W	4(A5),D1				; 2 y
	MOVE.W	6(A4),D2				; 3 x
	MOVE.W	6(A5),D3				; 3 y
	BSR.W	CHECKANDCALC

	MOVE.W	6(A4),D0				; 3 x
	MOVE.W	6(A5),D1				; 3 y
	MOVE.W	(A4),D2					; 0 x
	MOVE.W	(A5),D3					; 0 y
	BSR.W	CHECKANDCALC

	MOVE.W	8(A4),D0				; 4 x
	MOVE.W	8(A5),D1				; 4 y
	MOVE.W	10(A4),D2				; 5 x
	MOVE.W	10(A5),D3				; 5 y
	BSR.W	CHECKANDCALC

	MOVE.W	10(A4),D0				; 5 x
	MOVE.W	10(A5),D1				; 5 y
	MOVE.W	12(A4),D2				; 6 x
	MOVE.W	12(A5),D3				; 6 y
	BSR.W	CHECKANDCALC

	MOVE.W	12(A4),D0				; 6 x
	MOVE.W	12(A5),D1				; 6 y
	MOVE.W	14(A4),D2				; 7 x
	MOVE.W	14(A5),D3				; 7 y
	BSR.W	CHECKANDCALC

	MOVE.W	14(A4),D0				; 7 x
	MOVE.W	14(A5),D1				; 7 y
	MOVE.W	8(A4),D2				; 4 x
	MOVE.W	8(A5),D3				; 4 y
	BSR.W	CHECKANDCALC

	MOVE.W	(A4),D0					; 0 x
	MOVE.W	(A5),D1					; 0 y
	MOVE.W	12(A4),D2				; 6 x
	MOVE.W	12(A5),D3				; 6 y
	BSR.W	CHECKANDCALC

	MOVE.W	2(A4),D0				; 1 x
	MOVE.W	2(A5),D1				; 1 y
	MOVE.W	14(A4),D2				; 7 x
	MOVE.W	14(A5),D3				; 7 y
	BSR.W	CHECKANDCALC

	MOVE.W	4(A4),D0				; 2 x
	MOVE.W	4(A5),D1				; 2 y
	MOVE.W	8(A4),D2				; 4 x
	MOVE.W	8(A5),D3				; 4 y
	BSR.W	CHECKANDCALC

	MOVE.W	6(A4),D0				; 3 x
	MOVE.W	6(A5),D1				; 3 y
	MOVE.W	10(A4),D2				; 5 x
	MOVE.W	10(A5),D3				; 5 y
	BSR.W	CHECKANDCALC




	LEA.L	X_SCR+16(pc),A2
	LEA.L	Y_SCR+16(pc),A3
	LEA.L	X_SCR+62(pc),A4
	LEA.L	Y_SCR+62(pc),A5

	MOVEQ	#7,D5
FACE1_LOOP
	MOVE.W	(A2)+,D0
	MOVE.W	(A3)+,D1
	MOVE.W	-(A4),D2
	MOVE.W	-(A5),D3
	BSR.W	CHECKANDCALC
	DBRA	D5,FACE1_LOOP

	LEA.L	X_SCR+110(pc),A2
	LEA.L	Y_SCR+110(pc),A3
	LEA.L	X_SCR+96(pc),A4
	LEA.L	Y_SCR+96(pc),A5

	MOVEQ	#7,D5
FACE2_LOOP
	MOVE.W	(A2)+,D0
	MOVE.W	(A3)+,D1
	MOVE.W	-(A4),D2
	MOVE.W	-(A5),D3
	BSR.W	CHECKANDCALC
	DBRA	D5,FACE2_LOOP



	LEA.L	X_SCR+16(pc),A2
	LEA.L	Y_SCR+16(pc),A3
	LEA.L	X_SCR+112(pc),A4
	LEA.L	Y_SCR+112(pc),A5

	MOVEQ	#7,D5
FACE3_LOOP
	MOVE.W	(A2)+,D0
	MOVE.W	(A3)+,D1
	MOVE.W	(A4)+,D2
	MOVE.W	(A5)+,D3
	BSR.W	CHECKANDCALC
	DBRA	D5,FACE3_LOOP


	LEA.L	X_SCR+64(pc),A2
	LEA.L	Y_SCR+64(pc),A3
	LEA.L	X_SCR+96(pc),A4
	LEA.L	Y_SCR+96(pc),A5

	MOVEQ	#7,D5
FACE4_LOOP
	MOVE.W	-(A2),D0
	MOVE.W	-(A3),D1
	MOVE.W	-(A4),D2
	MOVE.W	-(A5),D3
	BSR.B	CHECKANDCALC
	DBRA	D5,FACE4_LOOP

	LEA.L	X_SCR+32(pc),A2
	LEA.L	Y_SCR+32(pc),A3
	LEA.L	X_SCR+128(pc),A4
	LEA.L	Y_SCR+128(pc),A5

	MOVEQ	#7,D5
FACE5_LOOP
	MOVE.W	(A2)+,D0
	MOVE.W	(A3)+,D1
	MOVE.W	(A4)+,D2
	MOVE.W	(A5)+,D3
	BSR.B	CHECKANDCALC
	DBRA	D5,FACE5_LOOP


	LEA.L	X_SCR+64(pc),A2
	LEA.L	Y_SCR+64(pc),A3
	LEA.L	X_SCR+96(pc),A4
	LEA.L	Y_SCR+96(pc),A5

	MOVEQ	#7,D5
FACE6_LOOP
	MOVE.W	(A2)+,D0
	MOVE.W	(A3)+,D1
	MOVE.W	(A4)+,D2
	MOVE.W	(A5)+,D3
	BSR.B	CHECKANDCALC
	DBRA	D5,FACE6_LOOP

	RTS



CHECKANDCALC
	MOVEQ	#0,D4

	CMP.W	D0,D2
	BGE.B	NOXNEGAT
	OR.B	#%01,D4
NOXNEGAT
	CMP.W	D1,D3
	BGE.B	NOYNEGAT
	OR.B	#%10,D4
NOYNEGAT
	LSL.W	#8,D0
	LSL.W	#8,D1
	LSL.W	#8,D2
	LSL.W	#8,D3

	CMP.B	#%00,D4
	BNE.S	NOXYPOS
	BSR.B	XNOINVERS
	BSR.B	YNOINVERS
	BRA.B	NOYNEG
NOXYPOS
	CMP.B	#%11,D4
	BNE.S	NOXYNEG
	BSR.B	XINVERS
	BSR.B	YINVERS
	BRA.B	NOYNEG
NOXYNEG
	CMP.B	#%01,D4
	BNE.S	NOXNEG
	BSR.B	XINVERS
	BSR.B	YNOINVERS
	BRA.B	NOYNEG
NOXNEG
	CMP.B	#%10,D4
	BNE.S	NOYNEG
	BSR.B	XNOINVERS
	BSR.B	YINVERS
NOYNEG
	RTS


XINVERS
	MOVE.W	D0,D7
	SUB.W	D2,D0
	LSR.W	#3,D0
	MOVEQ	#7,D6
LIP0	SUB.W	D0,D7
	MOVE.W	D7,D4
	LSR.W	#8,D4
	MOVE.W	D4,(A0)+
	DBRA	D6,LIP0
	RTS

XNOINVERS
	SUB.W	D0,D2
	LSR.W	#3,D2
	MOVEQ	#7,D6
LIP1	ADD.W	D2,D0
	MOVE.W	D0,D4
	LSR.W	#8,D4
	MOVE.W	D4,(A0)+
	DBRA	D6,LIP1
	RTS


YINVERS
	MOVE.W	D1,D7
	SUB.W	D3,D1
	LSR.W	#3,D1
	MOVEQ	#7,D6
LIP2	SUB.W	D1,D7
	MOVE.W	D7,D4
	LSR.W	#8,D4
	MOVE.W	D4,(A1)+
	DBRA	D6,LIP2
	RTS

YNOINVERS
	SUB.W	D1,D3
	LSR.W	#3,D3
	MOVEQ	#7,D6
LIP3	ADD.W	D3,D1
	MOVE.W	D1,D4
	LSR.W	#8,D4
	MOVE.W	D4,(A1)+
	DBRA	D6,LIP3
	RTS


************************* TRACCIA DOT-CUBE ***********************

N_XYZCOORD	DC.W	64+64+64+64+64+64+16+1	;+104

DRAWPOINTS:
	LEA.L	X_SCR+16(pc),A0
	LEA.L	Y_SCR+16(pc),A1
	LEA.L	X_SCR+976(pc),A2
	LEA.L	Y_SCR+976(pc),A3
	MOVEQ	#7,D0	
LITTLE_TONY_LOOP
	MOVE.W	(A0)+,(A2)+
	MOVE.W	(A1)+,(A3)+
	DBRA	D0,LITTLE_TONY_LOOP

	LEA.L	X_SCR+64(pc),A0
	LEA.L	Y_SCR+64(pc),A1
	LEA.L	X_SCR+992(pc),A2
	LEA.L	Y_SCR+992(pc),A3
	MOVEQ	#7,D0	
LITTLE_TONY_LOOP2
	MOVE.W	(A0)+,(A2)+
	MOVE.W	(A1)+,(A3)+
	DBRA	D0,LITTLE_TONY_LOOP2

	LEA.L	X_SCR+6(pc),A0
	LEA.L	Y_SCR+6(pc),A1
	LEA.L	X_SCR+1008(pc),A2
	LEA.L	Y_SCR+1008(pc),A3
	MOVE.W	(A0),(A2)
	MOVE.W	(A1),(A3)
		

	LEA.L	X_SCR+208(pc),A4
	LEA.L	Y_SCR+208(pc),A5
	MOVE.W	N_XYZCOORD(pc),d4
	LEA.L	BITMASKX(pc),A1
	LEA.L	YTABELLA(pc),A2
	LEA.L	XTABELLA(pc),A3

	MOVEQ	#0,D0
	MOVEQ	#0,D1
	SUBQ	#1,D4
	MOVE.L	SCRPTR,A0

DRAWLOOP:
	MOVE.W	(A4)+,D0
	MOVE.W	(A5)+,D1

PSET:	ADD.W	D1,D1
	MOVE.B	(A1,D0.W),D6			; PREC. BITS
	MOVE.W	(A2,D1.W),D1			; Y*40
	ADD.W	D0,D0
	ADD.W	(A3,D0.W),D1
	OR.B	D6,(A0,D1.W)

	DBRA	D4,DRAWLOOP
	RTS


CLS: 	BTST.B	#14,$02(A6)
	BNE.S	CLS
	MOVE.L	#0,$44(A6)
	MOVE.W	#10,$64(A6)
	MOVE.W	#10,$66(A6)
	MOVE.L	#$01000000,$40(A6)
	MOVE.L	SCRPTR,A0
	MOVE.L	A0,$54(A6)
	MOVE.W	#256*64+15,$58(A6)
	RTS


CLSB: 	BTST.B	#14,$02(A6)
	BNE.S	CLSB
;	CLR.L	$44(A6)
;	MOVE.W	#0,$60(A6)
;	MOVE.W	#0,$64(A6)
;	MOVE.L	#$01000000,$40(A6)
;	MOVE.L	SCRPTR,A0
	ADD.W	#40*256,A0
	MOVE.L	A0,$54(A6)
	MOVE.W	#256*64+20,$58(A6)
        RTS

* /-------------------/ *

* VARIABILI *

ax	dc.w	0
ay	dc.w	90
az	dc.w	0

r1x	dc.w 	4
r1y	dc.w 	2
r1z	dc.w 	2

MXY	dc.w	130,125

ZOOMF	dc.w	200

	;-------------------------------
X_COORD:
	dc.w	90,90,-90,-90
	dc.w	-90,-90,90,90
	
Y_COORD:
	dc.w	90,-90,-90,90
	dc.w	-90,90,90,-90
	
Z_COORD:
	dc.w	90,90,90,90
	dc.w	-90,-90,-90,-90

X_COORD2	DS.W	200
Y_COORD2	DS.W	200
Z_COORD2	DS.W	200

X_SCR	DS.W	1000
Y_SCR	DS.W	1000

COSENO	DC.W	$1000,$1000,$0FFF,$0FFD,$0FFB,$0FF8
	DC.W	$0FF5,$0FF1,$0FEC,$0FE7,$0FE1,$0FDB
	DC.W	$0FD4,$0FCC,$0FC4,$0FBB,$0FB1,$0FA7
	DC.W	$0F9C,$0F91,$0F85,$0F79,$0F6C,$0F5E
	DC.W	$0F50,$0F41,$0F31,$0F21,$0F11,$0EFF
	DC.W	$0EEE,$0EDB,$0EC8,$0EB5,$0EA1,$0E8C
	DC.W	$0E77,$0E61,$0E4B,$0E34,$0E1C,$0E04
	DC.W	$0DEC,$0DD3,$0DB9,$0D9F,$0D85,$0D69
	DC.W	$0D4E,$0D32,$0D15,$0CF8,$0CDA,$0CBC
	DC.W	$0C9D,$0C7E,$0C5E,$0C3E,$0C1E,$0BFC
	DC.W	$0BDB,$0BB9,$0B97,$0B74,$0B50,$0B2D
	DC.W	$0B08,$0AE4,$0ABF,$0A99,$0A73,$0A4D
	DC.W	$0A26,$09FF,$09D8,$09B0,$0988,$095F
	DC.W	$0937,$090D,$08E4,$08BA,$088F,$0865
	DC.W	$083A,$080E,$07E3,$07B7,$078B,$075E
	DC.W	$0732,$0705,$06D7,$06AA,$067C,$064E
	DC.W	$061F,$05F1,$05C2,$0593,$0564,$0534
	DC.W	$0505,$04D5,$04A5,$0475,$0444,$0414
	DC.W	$03E3,$03B2,$0381,$0350,$031F,$02EE
	DC.W	$02BC,$028B,$0259,$0227,$01F5,$01C3
	DC.W	$0191,$015F,$012D,$00FB,$00C9,$0097
	DC.W	$0065,$0032,$0000,$FFCF,$FF9C,$FF6A
	DC.W	$FF38,$FF06,$FED4,$FEA2,$FE70,$FE3E
	DC.W	$FE0C,$FDDA,$FDA8,$FD76,$FD45,$FD13
	DC.W	$FCE2,$FCB1,$FC80,$FC4F,$FC1E,$FBED
	DC.W	$FBBD,$FB8C,$FB5C,$FB2C,$FAFC,$FACD
	DC.W	$FA9D,$FA6E,$FA3F,$FA10,$F9E2,$F9B3
	DC.W	$F985,$F957,$F92A,$F8FC,$F8CF,$F8A3
	DC.W	$F876,$F84A,$F81E,$F7F2,$F7C7,$F79C
	DC.W	$F772,$F747,$F71D,$F6F4,$F6CA,$F6A2
	DC.W	$F679,$F651,$F629,$F602,$F5DB,$F5B4
	DC.W	$F58E,$F568,$F542,$F51D,$F4F9,$F4D4
	DC.W	$F4B1,$F48D,$F46A,$F448,$F426,$F405
	DC.W	$F3E3,$F3C3,$F3A3,$F383,$F364,$F345
	DC.W	$F327,$F309,$F2EC,$F2CF,$F2B3,$F298
	DC.W	$F27C,$F262,$F248,$F22E,$F215,$F1FD
	DC.W	$F1E5,$F1CD,$F1B6,$F1A0,$F18A,$F175
	DC.W	$F160,$F14C,$F139,$F126,$F113,$F102
	DC.W	$F0F0,$F0E0,$F0D0,$F0C0,$F0B1,$F0A3
	DC.W	$F095,$F088,$F07C,$F070,$F065,$F05A
	DC.W	$F050,$F046,$F03D,$F035,$F02D,$F026
	DC.W	$F020,$F01A,$F015,$F010,$F00C,$F009
	DC.W	$F006,$F004,$F002,$F001,$F001,$F001
	DC.W	$F002,$F004,$F006,$F009,$F00C,$F010
	DC.W	$F015,$F01A,$F020,$F026,$F02D,$F035
	DC.W	$F03D,$F046,$F050,$F05A,$F065,$F070
	DC.W	$F07C,$F088,$F095,$F0A3,$F0B1,$F0C0
	DC.W	$F0D0,$F0E0,$F0F0,$F102,$F113,$F126
	DC.W	$F139,$F14C,$F160,$F175,$F18A,$F1A0
	DC.W	$F1B6,$F1CD,$F1E5,$F1FD,$F215,$F22E
	DC.W	$F248,$F262,$F27D,$F298,$F2B3,$F2D0
	DC.W	$F2EC,$F309,$F327,$F345,$F364,$F383
	DC.W	$F3A3,$F3C3,$F3E4,$F405,$F426,$F448
	DC.W	$F46B,$F48D,$F4B1,$F4D4,$F4F9,$F51D
	DC.W	$F542,$F568,$F58E,$F5B4,$F5DB,$F602
	DC.W	$F629,$F651,$F679,$F6A2,$F6CB,$F6F4
	DC.W	$F71D,$F747,$F772,$F79C,$F7C7,$F7F3
	DC.W	$F81E,$F84A,$F876,$F8A3,$F8CF,$F8FC
	DC.W	$F92A,$F957,$F985,$F9B3,$F9E2,$FA10
	DC.W	$FA3F,$FA6E,$FA9D,$FACD,$FAFC,$FB2C
	DC.W	$FB5C,$FB8C,$FBBD,$FBED,$FC1E,$FC4F
	DC.W	$FC80,$FCB1,$FCE2,$FD13,$FD45,$FD76
	DC.W	$FDA8,$FDDA,$FE0C,$FE3E,$FE70,$FEA2
	DC.W	$FED4,$FF06,$FF38,$FF6A,$FF9D,$FFCF
	DC.W	$0000,$0032,$0065,$0097,$00C9,$00FB
	DC.W	$012D,$015F,$0192,$01C4,$01F5,$0227
	DC.W	$0259,$028B,$02BC,$02EE,$031F,$0350
	DC.W	$0382,$03B2,$03E3,$0414,$0445,$0475
	DC.W	$04A5,$04D5,$0505,$0535,$0564,$0593
	DC.W	$05C2,$05F1,$0620,$064E,$067C,$06AA
	DC.W	$06D7,$0705,$0732,$075E,$078B,$07B7
	DC.W	$07E3,$080F,$083A,$0865,$088F,$08BA
	DC.W	$08E4,$090D,$0937,$095F,$0988,$09B0
	DC.W	$09D8,$09FF,$0A27,$0A4D,$0A73,$0A99
	DC.W	$0ABF,$0AE4,$0B08,$0B2D,$0B50,$0B74
	DC.W	$0B97,$0BB9,$0BDB,$0BFD,$0C1E,$0C3E
	DC.W	$0C5E,$0C7E,$0C9D,$0CBC,$0CDA,$0CF8
	DC.W	$0D15,$0D32,$0D4E,$0D69,$0D85,$0D9F
	DC.W	$0DB9,$0DD3,$0DEC,$0E04,$0E1C,$0E34
	DC.W	$0E4B,$0E61,$0E77,$0E8C,$0EA1,$0EB5
	DC.W	$0EC8,$0EDB,$0EEE,$0EFF,$0F11,$0F21
	DC.W	$0F31,$0F41,$0F50,$0F5E,$0F6C,$0F79
	DC.W	$0F85,$0F91,$0F9C,$0FA7,$0FB1,$0FBB
	DC.W	$0FC4,$0FCC,$0FD4,$0FDB,$0FE1,$0FE7
	DC.W	$0FEC,$0FF1,$0FF5,$0FF8,$0FFB,$0FFD
	DC.W	$0FFF,$1000,$0000,$0000,$0000,$0000

SENO:
	DC.W	$0000,$0032,$0065,$0097,$00C9,$00FB
	DC.W	$012D,$015F,$0192,$01C4,$01F5,$0227
	DC.W	$0259,$028B,$02BC,$02EE,$031F,$0350
	DC.W	$0382,$03B2,$03E3,$0414,$0445,$0475
	DC.W	$04A5,$04D5,$0505,$0535,$0564,$0593
	DC.W	$05C2,$05F1,$0620,$064E,$067C,$06AA
	DC.W	$06D7,$0705,$0732,$075E,$078B,$07B7
	DC.W	$07E3,$080F,$083A,$0865,$088F,$08BA
	DC.W	$08E4,$090D,$0937,$095F,$0988,$09B0
	DC.W	$09D8,$09FF,$0A27,$0A4D,$0A73,$0A99
	DC.W	$0ABF,$0AE4,$0B08,$0B2D,$0B50,$0B74
	DC.W	$0B97,$0BB9,$0BDB,$0BFD,$0C1E,$0C3E
	DC.W	$0C5E,$0C7E,$0C9D,$0CBC,$0CDA,$0CF8
	DC.W	$0D15,$0D32,$0D4E,$0D69,$0D85,$0D9F
	DC.W	$0DB9,$0DD3,$0DEC,$0E04,$0E1C,$0E34
	DC.W	$0E4B,$0E61,$0E77,$0E8C,$0EA1,$0EB5
	DC.W	$0EC8,$0EDB,$0EEE,$0EFF,$0F11,$0F21
	DC.W	$0F31,$0F41,$0F50,$0F5E,$0F6C,$0F79
	DC.W	$0F85,$0F91,$0F9C,$0FA7,$0FB1,$0FBB
	DC.W	$0FC4,$0FCC,$0FD4,$0FDB,$0FE1,$0FE7
	DC.W	$0FEC,$0FF1,$0FF5,$0FF8,$0FFB,$0FFD
	DC.W	$0FFF,$1000,$1000,$1000,$0FFF,$0FFD
	DC.W	$0FFB,$0FF8,$0FF5,$0FF1,$0FEC,$0FE7
	DC.W	$0FE1,$0FDB,$0FD4,$0FCC,$0FC4,$0FBB
	DC.W	$0FB1,$0FA7,$0F9C,$0F91,$0F85,$0F79
	DC.W	$0F6C,$0F5E,$0F50,$0F41,$0F31,$0F21
	DC.W	$0F11,$0EFF,$0EEE,$0EDB,$0EC8,$0EB5
	DC.W	$0EA1,$0E8C,$0E77,$0E61,$0E4B,$0E34
	DC.W	$0E1C,$0E04,$0DEC,$0DD3,$0DB9,$0D9F
	DC.W	$0D85,$0D69,$0D4E,$0D32,$0D15,$0CF8
	DC.W	$0CDA,$0CBC,$0C9D,$0C7E,$0C5E,$0C3E
	DC.W	$0C1E,$0BFC,$0BDB,$0BB9,$0B97,$0B74
	DC.W	$0B50,$0B2D,$0B08,$0AE4,$0ABF,$0A99
	DC.W	$0A73,$0A4D,$0A26,$09FF,$09D8,$09B0
	DC.W	$0988,$095F,$0937,$090D,$08E4,$08BA
	DC.W	$088F,$0865,$083A,$080E,$07E3,$07B7
	DC.W	$078B,$075E,$0732,$0705,$06D7,$06AA
	DC.W	$067C,$064E,$061F,$05F1,$05C2,$0593
	DC.W	$0564,$0534,$0505,$04D5,$04A5,$0475
	DC.W	$0444,$0414,$03E3,$03B2,$0381,$0350
	DC.W	$031F,$02EE,$02BC,$028B,$0259,$0227
	DC.W	$01F5,$01C3,$0191,$015F,$012D,$00FB
	DC.W	$00C9,$0097,$0065,$0032,$0000,$FFCF
	DC.W	$FF9C,$FF6A,$FF38,$FF06,$FED4,$FEA2
	DC.W	$FE70,$FE3E,$FE0C,$FDDA,$FDA8,$FD76
	DC.W	$FD45,$FD13,$FCE2,$FCB1,$FC80,$FC4F
	DC.W	$FC1E,$FBED,$FBBD,$FB8C,$FB5C,$FB2C
	DC.W	$FAFC,$FACD,$FA9D,$FA6E,$FA3F,$FA10
	DC.W	$F9E2,$F9B3,$F985,$F957,$F92A,$F8FC
	DC.W	$F8CF,$F8A3,$F876,$F84A,$F81E,$F7F2
	DC.W	$F7C7,$F79C,$F772,$F747,$F71D,$F6F4
	DC.W	$F6CA,$F6A2,$F679,$F651,$F629,$F602
	DC.W	$F5DB,$F5B4,$F58E,$F568,$F542,$F51D
	DC.W	$F4F9,$F4D4,$F4B1,$F48D,$F46A,$F448
	DC.W	$F426,$F405,$F3E3,$F3C3,$F3A3,$F383
	DC.W	$F364,$F345,$F327,$F309,$F2EC,$F2CF
	DC.W	$F2B3,$F298,$F27C,$F262,$F248,$F22E
	DC.W	$F215,$F1FD,$F1E5,$F1CD,$F1B6,$F1A0
	DC.W	$F18A,$F175,$F160,$F14C,$F139,$F126
	DC.W	$F113,$F102,$F0F0,$F0E0,$F0D0,$F0C0
	DC.W	$F0B1,$F0A3,$F095,$F088,$F07C,$F070
	DC.W	$F065,$F05A,$F050,$F046,$F03D,$F035
	DC.W	$F02D,$F026,$F020,$F01A,$F015,$F010
	DC.W	$F00C,$F009,$F006,$F004,$F002,$F001
	DC.W	$F001,$F001,$F002,$F004,$F006,$F009
	DC.W	$F00C,$F010,$F015,$F01A,$F020,$F026
	DC.W	$F02D,$F035,$F03D,$F046,$F050,$F05A
	DC.W	$F065,$F070,$F07C,$F088,$F095,$F0A3
	DC.W	$F0B1,$F0C0,$F0D0,$F0E0,$F0F0,$F102
	DC.W	$F113,$F126,$F139,$F14C,$F160,$F175
	DC.W	$F18A,$F1A0,$F1B6,$F1CD,$F1E5,$F1FD
	DC.W	$F215,$F22E,$F248,$F262,$F27D,$F298
	DC.W	$F2B3,$F2D0,$F2EC,$F309,$F327,$F345
	DC.W	$F364,$F383,$F3A3,$F3C3,$F3E4,$F405
	DC.W	$F426,$F448,$F46B,$F48D,$F4B1,$F4D4
	DC.W	$F4F9,$F51D,$F542,$F568,$F58E,$F5B4
	DC.W	$F5DB,$F602,$F629,$F651,$F679,$F6A2
	DC.W	$F6CB,$F6F4,$F71D,$F747,$F772,$F79C
	DC.W	$F7C7,$F7F3,$F81E,$F84A,$F876,$F8A3
	DC.W	$F8CF,$F8FC,$F92A,$F957,$F985,$F9B3
	DC.W	$F9E2,$FA10,$FA3F,$FA6E,$FA9D,$FACD
	DC.W	$FAFC,$FB2C,$FB5C,$FB8C,$FBBD,$FBED
	DC.W	$FC1E,$FC4F,$FC80,$FCB1,$FCE2,$FD13
	DC.W	$FD45,$FD76,$FDA8,$FDDA,$FE0C,$FE3E
	DC.W	$FE70,$FEA2,$FED4,$FF06,$FF38,$FF6A
	DC.W	$FF9D,$FFCF,$0000,$0000,$0000,$0000

YTABELLA
	DS.W	256
XTABELLA
	DS.W	320
BITMASKX
	DS.W	320

COPLIST:
	DC.W	$0100,$0200,$0102,$0000,$0104,$0010
	DC.W	$0108,$0000,$010A,$0000
	DC.W	$008E,$2C81,$0090,$2CC1
	DC.W	$0092,$0038,$0094,$00D0
PLANES:	DC.W	$00E2,$0000,$00E0,$0000,$00E6,$0000,$00E4,$0000
	DC.W	$00EA,$0000,$00E8,$0000,$00EE,$0000,$00EC,$0000
	DC.W	$00F2,$0000,$00F0,$0000,$00F6,$0000,$00F4,$0000
COLS	DC.W	$0180,$0000,$0182,$0FFF
	DC.W	$0184,$0FFF,$0186,$0FFF
	DC.W	$0188,$004F,$018A,$005F
	DC.W	$018C,$006F,$018E,$007F
	DC.W	$0190,$008F,$0192,$009F
	DC.W	$0194,$00AF,$0196,$00BF
	DC.W	$0198,$00CF,$019A,$00DF
	DC.W	$019C,$00EF,$019E,$00FF
	DC.W	$01A0,$0F00,$01A2,$0F10
	DC.W	$01A4,$0F20,$01A6,$0F30
	DC.W	$01A8,$0F40,$01AA,$0F50
	DC.W	$01AC,$0F60,$01AE,$0F70
	DC.W	$01B0,$0F80,$01B2,$0F90
	DC.W	$01B4,$0FA0,$01B6,$0FB0
	DC.W	$01B8,$0FC0,$01BA,$0FD0
	DC.W	$01BC,$0FE0,$01BE,$0FF0
	DC.W	$2C01,$FFFE,$0100,$3200
	DC.L	$FFFFFFFE

SCRFLAG	DC.W	0

SCRPTR	DC.L	SCREEN
SCRPTR2	DC.L	FBUFFER

SCREEN	DS.B	40*256*3
FBUFFER DS.B	40*256*3

