
; Listing18c2.s = Lezione3d-4b.s
; Wireframe 

BLTCON0		equ	$DFF040
BLTCON1		equ	$DFF042
BLTAFWM		equ	$DFF044
BLTALWM		equ	$DFF046
BLTAPT		equ	$DFF050
BLTBPT		equ	$DFF04C
BLTCPT		equ	$DFF048
BLTDPT		equ	$DFF054
BLTSIZE		equ	$DFF058
BLTAMOD		equ	$DFF064
BLTBMOD		equ	$DFF062
BLTCMOD		equ	$DFF060
BLTDMOD		equ	$DFF066
BLTADAT		equ	$DFF074
BLTBDAT		equ	$DFF072
DMACONR		equ	$DFF002


	SECTION Boot_Menu,Code

Start:
	movem.l	d0-d7/a0-a6,-(a7)
	move.l	a7,InitialSP
	bsr.s	KillOS
	bsr.w	SetUp
	bsr.w	MainRoutine
	bsr.w	HelpOS
	move.l	InitialSP(pc),a7
	movem.l	(a7)+,d0-d7/a0-a6
	move.w	Selector(pc),d5
	rts

*************************************************************************
*	   Turn Off All Multi-Tasking & Operating System Tasks				*
*************************************************************************

KillOS:
	move.l	$4.w,a6
	moveq	#0,d0
	lea	GFXLib(pc),a1
	jsr	-552(a6)		_LVOOpenLibrary
	move.l	d0,GFXBase
	jsr	-132(a6)		_LVOForbid
	jsr	-150(a6)		_LVOSuperState
	move.l	d0,SYSStack
	move.w	$DFF01C,IntEnSave
	move.w	$DFF01E,IntRqSave
	move.w	$DFF002,DMASave
	move.w	$DFF010,ADKSave
	move.w	#%0111111111111111,$DFF096
	move.w	#%0111111111111111,$DFF09A
	move.l	#CopperList,$DFF080
	move.W	#0,$DFF088
	move.w	#0,$dff1fc
	move.l	#0,$dff108
	move.w	#$c00,$dff106
	move.w	#%1000001001000000,$DFF096
	rts

************************************************************************
*             Set Up - Clear BitPlanes Used For Display                *
************************************************************************

SetUp:
	move.w	#%1000011111100000,$DFF096
	rts

*************************************************************************
*	   Restore All Multi-Tasking & Operating System Tasks				*
*************************************************************************

HelpOS:
	move.w	#0,$DFF0A8
	move.w	#0,$DFF0B8
	move.w	#0,$DFF0C8
	move.w	#0,$DFF0D8
	move.w	IntEnSave,d7
	BSET	#$F,d7
	move.w	d7,$DFF09A
	move.w	IntRqSave,d7
	BSET	#$F,d7
	move.w	d7,$DFF09C
	move.w	DMASave,d7
	BSET	#$F,d7
	move.w	d7,$DFF096
	move.w	ADKSave,d7
	BSET	#$F,d7
	move.w	d7,$DFF09E
	move.l	GFXBase,a0
	move.l	$26(a0),$DFF080
	move.l	$4,a6
	jsr	-138(a6)		_LVOPermit
	move.l	SYSStack,d0		
	jsr	-156(a6)		_LVOUserState

	rts

*************************************************************************
*	  Main Program Routine - Selecting of Program to Load				*
*************************************************************************

MainRoutine:
	move.l	$DFF004,d0			; Check VPOSR For Screen Position
	and.l	#$1FF00,d0
	cmp.l	#$11000,d0
	bne.s	MainRoutine
	addq.w	#2,Xrot
	subq.w	#3,Yrot
	addq.w	#4,Zrot
	and.w	#$1FE,Xrot
	and.w	#$1FE,Yrot
	and.w	#$1FE,Zrot
	bsr.w	SpinLogo
	btst	#6,$BFE001			; Check Left Mouse Button
	bne.s	MainRoutine
	rts
		
	
*************************************************************************
*			      3D Line Routine										*
*************************************************************************

SpinLogo:
	move.l	Current(pc),d0
	lea	VectorPtrs,a0
	move.w	d0,6(a0)
	swap	d0
	move.w	d0,2(a0)
	move.w	DBuffer(pc),d1
	eor.w	#1,d1
	cmp.w	#1,d1
	bne.s	Screen1
Screen2:
	move.l	#VectorPlane1,d0
	bra.s	SkipScr
Screen1:
	move.l	#VectorPlane2,d0
SkipScr:
	move.l	d0,Current
	move.w	d1,DBuffer
	move.l	Current(pc),a0
	move.l	#$1f00000,BLTCON0
	move.l	a0,a4
;	add.w	#1408,a4
	move.l	a4,BLTDPT
	move.w	#0,BLTADAT
	move.w	#0,BLTDMOD
	move.w	#250*64+22,BLTSIZE

	move.w	#No_points-1,d7
	lea	Points(pc),a4	
	lea	Sintable+$40(pc),a1
	lea	Rotated_coords(pc),a2
	lea	Perspective(pc),a3

TD_loop:
	move.w	(a4)+,d0
	move.w	d0,d2
	move.w	(a4)+,d1
	move.w	d1,d3

	move.w	Zrot(pc),d6
	move.w	$40(a1,d6),d4
	move.w	-$40(a1,d6),d5
	muls.w	d4,d0
	muls.w	d5,d1
	sub.l	d1,d0
	add.l	d0,d0
	swap	d0					; d0 holds intermediate x coord
	muls.w	d5,d2
	muls.w	d4,d3
	add.l	d3,d2
	add.l	d2,d2
	swap	d2					; d2 holds intermediate y coord
	move.w	d2,d4

	move.w	(a4)+,d1			; z coord
	move.w	d1,d3
	move.w	Xrot(pc),d6
	move.w	$40(a1,d6),d5
	move.w	-$40(a1,d6),d6
	muls.w	d5,d2
	muls.w	d6,d1
	sub.l	d1,d2
	add.l	d2,d2
	swap	d2					; d2 holds the final y coord
	muls.w	d5,d3
	muls.w	d6,d4
	add.l	d4,d3
	add.l	d3,d3
	swap	d3					; d3 holds intermediate z coord

	move.w	d0,d1
	move.w	d3,d4
	move.w	Yrot(pc),d6
	move.w	$40(a1,d6),d5
	move.w	-$40(a1,d6),d6
	muls.w	d5,d3
	muls.w	d6,d0
	sub.l	d0,d3
	add.l	d3,d3
	swap	d3					; d3 holds the final z coord
	muls.w	d6,d4
	muls.w	d5,d1
	add.l	d4,d1
	add.l	d1,d1
	swap	d1					; d1 holds the final x coord

	add.w	Depth(pc),d3
	add.w	d3,d3
	move.w	(a3,d3),d5
	muls.w	d5,d1
	muls.w	d5,d2
	add.l	d1,d1
	swap	d1
	add.w	#160,d1				; Bildschirmmitte X
	add.l	d2,d2
	swap	d2
	add.w	#128,d2				; Bildschirmmitte Y
	
	move.w	d1,(a2)+
	move.w	d2,(a2)+
	dbra	d7,TD_loop

	move.w	#No_connects-1,d7
	lea	$dff000,a5
	lea	Connect(pc),a3
	lea	Rotated_coords(pc),a4
	moveq	#44,d0
	lea	Mul40(pc),a1
	lea	Bits(pc),a2
B_wait2:
	btst.b	#14,DMACONR
	bne.s	B_wait2

	move.w	#$ffff,BLTAFWM
	move.w	d0,BLTCMOD			; Bltcmod
	move.w	d0,BLTDMOD			; Bltdmod
	move.w	#$ffff,BLTBDAT		; Bltbdat
Draw_loop:
	move.w	(a3)+,d6
	move.w	(a4,d6),d0
	move.w	2(a4,d6),d1
	move.w	(a3)+,d6
	move.w	(a4,d6),d2
	move.w	2(a4,d6),d3
	cmp.w	d0,d2
	bne.s	Draw
	cmp.w	d1,d3
	beq.s	Nodraw	
Draw:
	bsr.w	Line
Nodraw:
	dbra	d7,Draw_loop
Bwit:
	btst.b	#14,DMACONR
	bne.s	Bwit
	rts

Sintable:
	incbin	"Sin"
	incbin	"Sin"
Perspective:
	incbin	"Perspective"
Octant_table:
	Dc.b	1,17,9,21,5,25,13,29

;----------- Line Draw ------------
Line:
	moveq	#0,d4
	move.w	d1,d4
	add.w	d4,d4
	move.w	(a1,d4),d4
	moveq	#-$10,d5
	and.w	d0,d5
	lsr.w	#3,d5
	add.w	d5,d4
	add.l	a0,d4

	moveq	#0,d5
	sub.w	d1,d3
	roxl.b	d5
	tst.w	d3
	bge.s	Y2gy1
	neg.w	d3
Y2gy1:
	sub.w	d0,d2
	roxl.b	d5
	tst.w	d2
	bge.s	X2gx1
	neg.w	d2
X2gx1:

	move.w	d3,d1
	Sub.w	d2,d1
	bge.s	Dygdx
	exg	d2,d3
Dygdx:
	roxl.b	d5
	move.b	Octant_table(pc,d5),d5
	add.w	d2,d2
Wblit:
	btst.b	#14,DMACONR
	bne.s	Wblit

	move.w	d2,BLTBMOD			; Bltbmod
	sub.w	d3,d2
	bge.s	Signn1
	Or.b	#$40,d5
Signn1:
	move.w	d2,BLTAPT+2			; Bltaptl
	Sub.w	d3,d2
	move.w	d2,BLTAMOD			; Bltamod

	move.w	#$8000,BLTADAT		; Bltadat
	add.w	d0,d0
	move.w	(a2,d0),BLTCON0		; Bltcon0
	move.w	d5,BLTCON1			; Bltcon1
	move.l	d4,BLTCPT			; Bltcpth
	move.l	d4,BLTDPT			; Bltdpth
	lsl.w	#6,d3
	Addq.w	#2,d3
	move.w	d3,BLTSIZE			; Bltsize
	rts


*************************************************************************
*	 Variables and Data Tables used throughout the program				*
*************************************************************************

SYSStack	dc.l	0
GFXBase		dc.l	0
InitialSP	dc.l	0
IntEnSave	dc.w	0	
IntRqSave	dc.w	0
DMASave		dc.w	0
ADKSave		dc.w	0
GFXLib		DC.B	"graphics.library",0,0
 even

Xrot		dc.w	$100
Yrot		dc.w	0
Zrot		dc.w	0
Depth		dc.w	200
Current:	dc.l	VectorPlane0			
Depthpt		dc.w	0
DBuffer		dc.w	1

LastYPos	dc.w	0
Selector	dc.w	0

Mul40
A set 0
	Rept	320
	Dc.w	A*44
A set A+1
	Endr

A set 0
Bits
	Rept	320
	Dc.w	((A&$f)*$1000)+$bca
A set A+1
	Endr

Size
A set 0
	Rept	320
	Dc.w	(A*64)+2
A set A+1
	Endr

No_points	=  8  
No_connects	=  12

Points:
	dc.w	-100,+100,-100	; P0 (X,Y,Z)
	dc.w	+100,+100,-100	; P1 (X,Y,Z)
	dc.w	+100,-100,-100	; P2 (X,Y,Z)
	dc.w	-100,-100,-100	; P3 (X,Y,Z)
	dc.w	-100,+100,+100	; P4 (X,Y,Z)
	dc.w	+100,+100,+100	; P5 (X,Y,Z)
	dc.w	+100,-100,+100	; P6 (X,Y,Z)
	dc.w	-100,-100,+100	; P7 (X,Y,Z)


Connect:		; (multipliziert mit * 4 durch das berspringen der Routine...)
	dc.w	0*4,1*4				; Flche vorn
	dc.w	1*4,2*4
	dc.w	2*4,3*4
	dc.w	3*4,0*4

	dc.w	4*4,5*4				; Flche hinten
	dc.w	5*4,6*4
	dc.w	6*4,7*4
	dc.w	7*4,4*4

	dc.w	0*4,4*4				; Seitenkanten
	dc.w	1*4,5*4
	dc.w	2*4,6*4
	dc.w	3*4,7*4

; -------------------

Rotated_coords:
	Dcb.w	No_points*2,0


	SECTION	grafic,DATA_C

*************************************************************************
*	  New Copper-List to Replace old WorkBench Copper-List				*
*************************************************************************

CopperList:
		dc.l	$008E2c81
		dc.l	$00902CC1
		dc.l	$00920030
		dc.l	$009400D8
		dc.l	$01001200
		dc.l	$01040000
		dc.l	$01020001
		dc.w	$108,0
		dc.w	$10a,0
SpritePtrs:
		dc.l	$01200000,$01220000,$01240000,$01260000
		dc.l	$01280000,$012A0000,$012C0000,$012E0000
		dc.l	$01300000,$01320000,$01340000,$01360000
		dc.l	$01380000,$013A0000,$013C0000,$013E0000
		dc.l	$01800002,$018200fa
VectorPtrs:
		dc.l	$00E00000,$00E20000
		dc.l	$fffffffe  

	SECTION	buffs,BSS_C

VectorPlane0:
	ds.b	$8000
VectorPlane1:
	ds.b	$4000
VectorPlane2:
	ds.b	$4000

	end

