
; Listings17k2.s = COPPER-GELLY.S

**	COPPER-GELLY
**	CODED BY CRADON/MATRIX
**	ASM-ONE FORMAT

*******************************************************************************

	SECTION	MAIN,CODE

START:
	MOVEM.L	D0-A6,-(A7)
	MOVE.W	$DFF01C,INTENA
	MOVE.W	$DFF002,DMACON
	MOVE.W	$DFF010,ADKCON
	MOVE.W	#%0111111111111111,$DFF096
	MOVE.W	#%0111111111111111,$DFF09A
	MOVE.W	#%0111111111111111,$DFF09C
	MOVE.L 	$6C.w,OLDIRQ
	MOVE.L 	#MYIRQ,$6C.w

	BSR.w	TABINIT		; PREPARE "COPPER-GELLY" RUTINE
	BSR.w	COPINIT		; ACTIVATE COPPERLIST

	MOVE.W	#%1000001111000000,$DFF096
	MOVE.W 	#%1100000000110000,$DFF09A
LOOP:
	BTST	#6,$BFE001
	BNE.B	LOOP

	MOVE.W	#%0111111111111111,$DFF096
	MOVE.W	#%0111111111111111,$DFF09A
	MOVE.W	#%0111111111111111,$DFF09C
	MOVE.L	OLDIRQ(PC),$6C.w
	MOVE.W	DMACON(PC),D0
	OR.W	#$8000,D0
	MOVE.W	D0,$DFF096
	MOVE.W	ADKCON(PC),D0
	OR.W	#$8000,D0
	MOVE.W	D0,$DFF09E
	MOVE.W	INTENA(PC),D0
	OR.W	#$C000,D0
	MOVE.W	D0,$DFF09A
	MOVE.W	d0,$DFF088
	MOVEM.L	(A7)+,D0-A6
	RTS

** COPPER-GELLY BY CRADON/MATRIX PRODUCTIONS 1993 *****************************

SIZE    = 27	; CHECKER HIGHT
CONVERT = 20	; COLOUR ADJUSTMENT
SPEED1	= 2	; SINE TABLE 1
SPEED2  = 12	; SINE TABLE 2

COLOUR1:
	DC.W	$00EE
COLOUR2:
	DC.W	$00FF

COPFILL:
	LEA	NTSC,A0
	LEA	SINUS,A1
	LEA	SINUS2,A2
	ADD.W	SINOFF(PC),A1
	ADD.W	SIN2OFF(PC),A2
	ADD.W	#SPEED1,SINOFF
	ADD.W	#SPEED2,SIN2OFF
	MOVE.W	#$2301,D1
	MOVE.W	#220,D2
	MOVE.W	COLOUR1(PC),COL1
	MOVE.W	COLOUR2(PC),COL2

	MOVE.W	#SIZE,CCOUNT
	MOVE.W	CCOFF(PC),D0
	EXT.L	D0
	MOVE.W	#SIZE,D3
	LSL.W	D3
	CMP.W	D3,D0
	BNE.B	NORESET
	CLR.W	CCOFF
NORESET	ADDQ.W	#2,CCOFF
	LEA.L	CCNEW(PC),A3
	ADD.W	CCOFF(PC),A3
	MOVE.W	(A3),D0
	SUB.W	D0,CCOUNT

	CMP.W	#SIZE,CCOUNT

	BNE.B	COPLOP1
	MOVE.W	COLOUR1(PC),D3
	MOVE.W	COLOUR2(PC),COLOUR1
	MOVE.W	D3,COLOUR2

COPLOP1:
	MOVE.L	#TERN,D0
	MOVE.W	(A1)+,D4
	CMP.W	#$FFFF,D4
	BNE.B	NOPROB1		; END OF SINE TABLE?
	LEA.L	SINUS,A1
	CLR.W	SINOFF
	MOVE.W	(A1)+,D4
NOPROB1:
	MOVE.W	(A2)+,D5
	CMP.W	#$FFFF,D5
	BNE.B	NOPROBA
	LEA	SINUS2,A2
	MOVE.W	#0,SIN2OFF
	ADD.W	SIN2OFF(PC),A2
	MOVE.W	(A2)+,D5
NOPROBA:
	ADD.W	D5,D4		; OFFSET IN GRAPHICS
	MOVE.W	D4,D5		; (FOR LATER USE IN COLOUR ADJUSTMENT)
	MULU	#44,D4
	ADD.L	D4,D0		; ADD OFFSET TO ADDRESS FOR BITPLANE POINTER
	MOVE.W	D1,(A0)+
	SUBQ.W	#1,CCOUNT
	TST.W	CCOUNT		; IS IT TIME TO CHANGE COLOURS? (MAKE CHECKERS)
	BNE.B	SETCOP1
	MOVE.W	COL1(PC),D3
	MOVE.W	COL2(PC),COL1
	MOVE.W	D3,COL2
	MOVE.W	#SIZE,CCOUNT
SETCOP1:
	EXT.L	D5
	DIVU	#CONVERT,D5	; ADJUST COLOURS
	MOVE.W	COL1(PC),D3
	MOVE.W	COL2(PC),D4
	SUB.W	D5,D3
	SUB.W	D5,D4
	MOVE.W	#$FFFE,(A0)+	; WRITE CHANGES TO COPPERLIST
	MOVE.W	#$0180,(A0)+
	MOVE.W	D3,(A0)+
	MOVE.W	#$0182,(A0)+
	MOVE.W	D4,(A0)+
	MOVE.W	#$00E0,(A0)+
	SWAP	D0
	MOVE.W	D0,(A0)+
	MOVE.W	#$00E2,(A0)+
	SWAP	D0
	MOVE.W	D0,(A0)+
	ADD.L	#$100,D1
	DBRA	D2,COPLOP1	
	LEA	PAL,A0
	MOVE.W	#$0001,D1
	MOVE.W	#51,D2

COPLOP2:
	MOVE.L	#TERN,D0
	MOVE.W	(A1)+,D4
	CMP.W	#$FFFF,D4
	BNE.B	NOPROB2
	LEA	SINUS,A1
	CLR.W	SINOFF
	MOVE.W	(A1)+,D4
NOPROB2:
	MOVE.W	(A2)+,D5
	CMP.W	#$FFFF,D5
	BNE.B	NOPROBB
	LEA	SINUS2,A2
	CLR.W	SIN2OFF
	ADD.W	SIN2OFF(PC),A2
	MOVE.W	(A2)+,D5
NOPROBB:
	ADD.W	D5,D4
	MOVE.W	D4,D5
	MULU	#44,D4
	ADD.L	D4,D0
	MOVE.W	D1,(A0)+
	SUBQ.W	#1,CCOUNT
	TST.W	CCOUNT
	BNE.B	SETCOP2
	MOVE.W	COL1(PC),D3
	MOVE.W	COL2(PC),COL1
	MOVE.W	D3,COL2
	MOVE.W	#SIZE,CCOUNT
SETCOP2:
	EXT.L	D5
	DIVU	#CONVERT,D5
	MOVE.W	COL1(PC),D3
	MOVE.W	COL2(PC),D4
	SUB.W	D5,D3
	SUB.W	D5,D4
	MOVE.W	#$FFFE,(A0)+
	MOVE.W	#$0180,(A0)+
	MOVE.W	D3,(A0)+
	MOVE.W	#$0182,(A0)+
	MOVE.W	D4,(A0)+
	MOVE.W	#$00E0,(A0)+
	SWAP	D0
	MOVE.W	D0,(A0)+
	MOVE.W	#$00E2,(A0)+
	SWAP	D0
	MOVE.W	D0,(A0)+
	ADD.L	#$100,D1
	DBRA	D2,COPLOP2	
	RTS

TABINIT:
	MOVE.W	#SIZE,D0
	LEA	CCNEW,A0
TABLOOP:
	MOVE.W	D0,(A0)+
	SUBQ.W	#1,D0
	BNE.S	TABLOOP
	RTS

** ACTIVATE COPPERLIST ********************************************************

COPINIT:
	MOVE.L	#COPPER,D0
	LEA	ADDRESS,A0
	MOVE.W	D0,6(A0)
	SWAP	D0
	MOVE.W	D0,2(A0)
	MOVE.L	#COPPER,$DFF084
	MOVE.w	d0,$DFF08A
	RTS
	
*******************************************************************************

MYIRQ:
	btst	#5,$dff01f
	beq.s	noint
	MOVEM.L	D0-A6,-(A7)
	BSR.W	COPFILL
	MOVE.B	$DFF006,D0
	MOVE.B	RASTTID(PC),D1
	CMP.B	D0,D1
	BGT.B	NOPE
	MOVE.B	D0,RASTTID
NOPE:
	MOVE.W	#$20,$DFF09C
	MOVEM.L	(A7)+,D0-A6 		
noint:
	RTE

** ABSOLUTES ******************************************************************

RASTTID:	DC.B	0
	EVEN

OLDIRQ:		DC.L	0
INTENA:		DC.W	0
DMACON:		DC.W	0
ADKCON:		DC.W	0

TCOUNT:		DC.W	0
CHECKER:	DC.W	0
CCOUNT:		DC.W	0
COL1:		DC.W	0
COL2:		DC.W	0
SINOFF:		DC.W	0
SIN2OFF:	DC.W	0
CCOFF:		DC.W	0
CCNEW:		BLK.W	50,0

** COPPERLIST *****************************************************************

	SECTION	B,DATA_C

COPPER:
	DC.W    $008E,115+(35*256)		; WINDOW START (115,35)
	DC.W	$0090,(467-256)+(305-256)*256	; WINDOW STOP (467,305)
	DC.W    $0092,(115/2-8)			; 8:LOWRES (4:HIGHRES)
	DC.W	$0094,(115/2-8)+(8*(22-1))	; 22:HORIZONTAL WORD COUNT
	DC.W    $0102,$0000			; HORIZONTAL SCROLL
	DC.W	$0104,$0000			; VIDIO PRIORITY
	DC.W	$0108,$0000			; MODULO FOR ODD PLANES
	DC.W	$010A,$0000			; MODULO FOR EVEN PLANES
	DC.W    $0100,$1200			; NUMBER OF BITPLANES

NTSC:
	BLK.W	[10*221],$0000
	DC.W	$FFE1,$FFFE			; JUMP TO PAL
PAL:
	BLK.W	[10*52],$0000

	DC.W	$0100,$0200

ADDRESS:
	DC.W	$0084,$0000,$0086,$0000 	; RESTART ADDRESS
	DC.W	$008A,$0000,$FFFF,$FFFE		; FORCE RESTART

** SCREEN *********************************************************************

TERN:
	INCBIN	"PATTERN4-352.BIT"	; c'e' l'iff

	SECTION	PURE_DATA,DATA

SINUS:		; 562 words
	dc.w	$55,$57,$5A,$5D,$60,$62,$65,$68,$6B,$6D,$70,$73
	dc.w	$75,$78,$7A,$7D,$7F,$82,$84,$86,$89,$8B,$8D,$8F
	dc.w	$91,$93,$95,$97,$98,$9A,$9C,$9D,$9F,$A0,$A1,$A2
	dc.w	$A3,$A4,$A5,$A6,$A7,$A8,$A8,$A9,$A9,$A9,$A9,$A9
	dc.w	$A9,$A9,$A9,$A9,$A9,$A8,$A8,$A7,$A6,$A5,$A4,$A3
	dc.w	$A2,$A1,$A0,$9F,$9D,$9C,$9A,$98,$97,$95,$93,$91
	dc.w	$8F,$8D,$8B,$89,$86,$84,$82,$7F,$7D,$7A,$78,$75
	dc.w	$73,$70,$6D,$6B,$68,$65,$62,$60,$5D,$5A,$57,$55
	dc.w	$52,$4F,$4C,$49,$47,$44,$41,$3E,$3C,$39,$36,$34
	dc.w	$31,$2F,$2C,$2A,$27,$25,$23,$20,$1E,$1C,$1A,$18
	dc.w	$16,$14,$12,$11,15,13,12,10,9,8,7,6,5,4,3,2,1,1,0
	dc.w	0,0,0,0,0,0,0,0,0,1,1,2,3,4,5,6,7,8,9,10,12,13,15
	dc.w	$11,$12,$14,$16,$18,$1A,$1C,$1E,$20,$23,$25,$27
	dc.w	$2A,$2C,$2F,$31,$34,$36,$39,$3C,$3E,$41,$44,$47
	dc.w	$49,$4C,$4F,$52,$54,$57,$5A,$5D,$60,$62,$65,$68
	dc.w	$6B,$6D,$70,$73,$75,$78,$7A,$7D,$7F,$82,$84,$86
	dc.w	$89,$8B,$8D,$8F,$91,$93,$95,$97,$98,$9A,$9C,$9D
	dc.w	$9F,$A0,$A1,$A2,$A3,$A4,$A5,$A6,$A7,$A8,$A8,$A9
	dc.w	$A9,$A9,$A9,$A9,$A9,$A9,$A9,$A9,$A9,$A8,$A8,$A7
	dc.w	$A6,$A5,$A4,$A3,$A2,$A1,$A0,$9F,$9D,$9C,$9A,$98
	dc.w	$97,$95,$93,$91,$8F,$8D,$8B,$89,$86,$84,$82,$7F
	dc.w	$7D,$7A,$78,$75,$73,$70,$6D,$6B,$68,$65,$62,$60
	dc.w	$5D,$5A,$57,$54,$52,$4F,$4C,$49,$47,$44,$41,$3E
	dc.w	$3C,$39,$36,$34,$31,$2F,$2C,$2A,$27,$25,$23,$20
	dc.w	$1E,$1C,$1A,$18,$16,$14,$12,$11,15,13,12,10,9,8,7
	dc.w	6,5,4,3,2,1,1,0,0,0,0,0,0,0,0,0,0,1,1,2,3,4,5,6,7
	dc.w	8,9,10,12,13,15,$11,$12,$14,$16,$18,$1A,$1C,$1E
	dc.w	$20,$23,$25,$27,$2A,$2C,$2F,$31,$34,$36,$39,$3C
	dc.w	$3E,$41,$44,$47,$49,$4C,$4F,$52,$54,$57,$5A,$5D
	dc.w	$60,$62,$65,$68,$6B,$6D,$70,$73,$75,$78,$7A,$7D
	dc.w	$7F,$82,$84,$86,$89,$8B,$8D,$8F,$91,$93,$95,$97
	dc.w	$98,$9A,$9C,$9D,$9F,$A0,$A1,$A2,$A3,$A4,$A5,$A6
	dc.w	$A7,$A8,$A8,$A9,$A9,$A9,$A9,$A9,$A9,$A9,$A9,$A9
	dc.w	$A9,$A8,$A8,$A7,$A6,$A5,$A4,$A3,$A2,$A1,$A0,$9F
	dc.w	$9D,$9C,$9A,$98,$97,$95,$93,$91,$8F,$8D,$8B,$89
	dc.w	$86,$84,$82,$7F,$7D,$FFFF,$7A,$78,$75,$73,$70,$6D
	dc.w	$6B,$68,$65,$62,$60,$5D,$5A,$57,$55,$52,$4F,$4C
	dc.w	$49,$47,$44,$41,$3E,$3C,$39,$36,$34,$31,$2F,$2C
	dc.w	$2A,$27,$25,$23,$20,$1E,$1C,$1A,$18,$16,$14,$12
	dc.w	$11,15,13,12,10,9,8,7,6,5,4,3,2,1,1,0,0,0,0,0,0,0
	dc.w	0,0,0,1,1,2,3,4,5,6,7,8,9,10,12,13,15,$11,$12,$14
	dc.w	$16,$18,$1A,$1C,$1E,$20,$23,$25,$27,$2A,$2C,$2F
	dc.w	$31,$34,$36,$39

SINUS2:		; 645 words
	dc.w	$2B,$2B,$2C,$2D,$2E,$2F,$30,$31,$32,$33,$33,$34
	dc.w	$35,$36,$37,$38,$39,$39,$3A,$3B,$3C,$3D,$3E,$3E
	dc.w	$3F,$40,$41,$42,$42,$43,$44,$44,$45,$46,$47,$47
	dc.w	$48,$49,$49,$4A,$4A,$4B,$4C,$4C,$4D,$4D,$4E,$4E
	dc.w	$4F,$4F,$50,$50,$51,$51,$51,$52,$52,$52,$53,$53
	dc.w	$53,$54,$54,$54,$54,$55,$55,$55,$55,$55,$55,$55
	dc.w	$55,$55,$55,$56,$55,$55,$55,$55,$55,$55,$55,$55
	dc.w	$55,$55,$54,$54,$54,$54,$53,$53,$53,$52,$52,$52
	dc.w	$51,$51,$51,$50,$50,$4F,$4F,$4E,$4E,$4D,$4D,$4C
	dc.w	$4C,$4B,$4A,$4A,$49,$49,$48,$47,$47,$46,$45,$44
	dc.w	$44,$43,$42,$42,$41,$40,$3F,$3E,$3E,$3D,$3C,$3B
	dc.w	$3A,$39,$39,$38,$37,$36,$35,$34,$33,$33,$32,$31
	dc.w	$30,$2F,$2E,$2D,$2C,$2B,$2B,$2A,$29,$28,$27,$26
	dc.w	$25,$24,$23,$22,$22,$21,$20,$1F,$1E,$1D,$1C,$1C
	dc.w	$1B,$1A,$19,$18,$17,$17,$16,$15,$14,$13,$13,$12
	dc.w	$11,$11,$10,15,14,14,13,12,12,11,11,10,9,9,8,8,7
	dc.w	7,6,6,5,5,4,4,4,3,3,3,2,2,2,1,1,1,1,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,3,3,3,4
	dc.w	4,4,5,5,6,6,7,7,8,8,9,9,10,11,11,12,12,13,14,14
	dc.w	15,$10,$11,$11,$12,$13,$13,$14,$15,$16,$17,$17
	dc.w	$18,$19,$1A,$1B,$1C,$1C,$1D,$1E,$1F,$20,$21,$22
	dc.w	$22,$23,$24,$25,$26,$27,$28,$29,$2A,$2B,$2B,$2C
	dc.w	$2D,$2E,$2F,$30,$31,$32,$33,$33,$34,$35,$36,$37
	dc.w	$38,$39,$39,$3A,$3B,$3C,$3D,$3E,$3E,$3F,$40,$41
	dc.w	$42,$42,$43,$44,$44,$45,$46,$47,$47,$48,$49,$49
	dc.w	$4A,$4A,$4B,$4C,$4C,$4D,$4D,$4E,$4E,$4F,$4F,$50
	dc.w	$50,$51,$51,$51,$52,$52,$52,$53,$53,$53,$54,$54
	dc.w	$54,$54,$55,$55,$55,$55,$55,$55,$55,$55,$55,$55
	dc.w	$56,$55,$55,$55,$55,$55,$55,$55,$55,$55,$55,$54
	dc.w	$54,$54,$54,$53,$53,$53,$52,$52,$52,$51,$51,$51
	dc.w	$50,$50,$4F,$4F,$4E,$4E,$4D,$4D,$4C,$4C,$4B,$4A
	dc.w	$4A,$49,$49,$48,$47,$47,$46,$45,$44,$44,$43,$42
	dc.w	$42,$41,$40,$3F,$3E,$3E,$3D,$3C,$3B,$3A,$39,$39
	dc.w	$38,$37,$36,$35,$34,$33,$33,$32,$31,$30,$2F,$2E
	dc.w	$2D,$2C,$2B,$2A,$2A,$29,$28,$27,$26,$25,$24,$23
	dc.w	$22,$22,$21,$20,$1F,$1E,$1D,$1C,$1C,$1B,$1A,$19
	dc.w	$18,$17,$17,$16,$15,$14,$13,$13,$12,$11,$11,$10
	dc.w	15,14,14,13,12,12,11,11,10,9,9,8,8,7,7,6,6,5,5,4
	dc.w	4,4,3,3,3,2,2,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,3,3,3,4,4,4,5,5,6,6
	dc.w	7,7,8,8,9,9,10,11,11,12,12,13,$FFFF,14,14,15,$10
	dc.w	$11,$11,$12,$13,$13,$14,$15,$16,$17,$17,$18,$19
	dc.w	$1A,$1B,$1C,$1C,$1D,$1E,$1F,$20,$21,$22,$22,$23
	dc.w	$24,$25,$26,$27,$28,$29,$2A,$2B,$2B,$2C,$2D,$2E
	dc.w	$2F,$30,$31,$32,$33,$33,$34,$35,$36,$37,$38,$39
	dc.w	$39,$3A,$3B,$3C,$3D,$3E,$3E,$3F,$40,$41,$42,$42
	dc.w	$43,$44,$45,$45,$46,$47,$47,$48,$49,$49,$4A,$4A
	dc.w	$4B,$4C,$4C

	end

