
; Listing17e.s = ANsprites
; Animation von Sprites.
; Original version: Autor unbekannt
; Fixed version: Randy/Ram Jam

	SECTION	SPRITEANIM,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	;incdir ""
	include	"/Sources/startup2.s"	; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001110100000	; Copper,Bitplane,Sprites

WaitDisk	equ	10

CopiedSprites	equ	20

Start:

; Zeiger auf leere Bitplane

	move.l	#Bitplane,d0
	lea	Bplpointers,a1
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

; Zeiger auf Sprites

	move.l	#SpriteBuffer,d0	; Adresse, an die die Sprites kopiert werden
	lea	SpritePointers,a1		; Adressezeiger in der copperliste.
	moveq	#8-1,d1				; 8 Sprites
Ploop:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	add.l	#68,d0
	addq.w	#8,a1
	dbra	d1,Ploop

	lea	SpriteBuffer,a1			; Ziel
	moveq	#CopiedSprites-1,d1	; Anzahl Kopien
	bsr.w	SpriteCopy			; Kopieren Sie das Sprite 21 Mal in den Puffer

	lea	$dff000,a5
	move.w	#DMASET,$96(a5)		; DMACON - aktivieren Bitplane, Copper
								; und Sprites.
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse:
	move.l	#$1ff00,d1			; Bits durch UND auswhlen
	move.l	#$12c00,d2			; warte auf Zeile $12c
WaitY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l	d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l	d2,d0				; warte auf Zeile $12c
	bne.s	WaitY1
WaitY2:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l	d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l	d2,d0				; warte auf Zeile $12c
	beq.s	WaitY2

	btst	#2,$16(a5)			; rechte Taste gedrckt?
	beq.s	NoSpri

	bsr.w	DoAnim

	lea	$dff000,a5				; Custom base $dff000 in a5

NoSpri:
	btst	#6,$bfe001			; linke Taste gedrckt?
	bne.s	Mouse
	rts

*****************************************************************************
; Routine, die die Sprites gem den Tabellen animiert
*****************************************************************************

DoAnim:
	subq.w	#1,Counter			; waitcounter -1
	tst.w	Counter				; sind wir bei 0 angekommen?
	bne.s	StessAnim			; Wenn noch nicht, ok... andernfalls...
	move.l	ActionPtr(pc),a0	; Nchste Animation von der Tabelle!
	cmp.w	#-1,(a0)			; sind wir am Ende der Tabelle?
	bne.s	NoStartAgain1			; Wenn noch nicht, ok
	move.l	#Action,ActionPtr	; ansonsten von vorn anfangen
	move.l	ActionPtr(pc),a0	; von der ersten Animation...
NoStartAgain1:
	move.w	(a0),Counter		; Dauer der Animation
	move.w	2(a0),SpeedX		; Geschwindigkeit X
	move.w	4(a0),SpeedY		; Geschwindigkeit Y
	move.l	6(a0),XPtrs			; Tabelle X
	move.l	10(a0),YPtrs		; Tabelle Y
	add.l	#14,ActionPtr		; Stellen Sie den Zeiger auf die nchste Animation
StessAnim:
	move.l	XPtrs(pc),a0		; Flugbahn x
	move.l	YPtrs(pc),a1		; Flugbahn y
	moveq	#8-1,d7				; Anzahl Sprites = 8
	moveq	#0,d2
	moveq	#0,d3
	move.w	SpeedX(pc),d5		; d5 = addx
	move.w	SpeedY(pc),d6		; d6 = addy
AnimLoop:
	move.w	(a0),d2				; Wert von tabx
	move.w	(a1),d3				; Wert von taby
	add.w	d5,d2				; hinzufgen speedX
	cmp.w	#360,d2				; 360 passiert?
	blt.s	NoMax
	sub.w	#360,d2				; wenn ja, hoch
NoMax:
	move.w	d2,(a0)+			; speichern X
	add.w	d6,d3				; spedd zu taby hinzufgen
	cmp.w	#360,d3				; 360 passiert?
	blt.s	NoMax2
	sub.w	#360,d3				; wenn ja, runter
NoMax2:
	move.w	d3,(a1)+			; speichern Y
	lea	Sinus(pc),a2
	move	(a2,d2.w),d0		; nimm Wert X von sintab
	lea	Cosinus(pc),a2
	move	(a2,d3.w),d1		; nimm Wert Y von costab
	movem.l	d0-d7/a0-a6,-(a7)
	mulu.w	#68,d7				; aktuelles sprite*68 = offset fr richtiges sprite
	lea	SpriteBuffer+7*68,a1			; Adresse letztes sprite
	sub.l	d7,a1				; Wir gehen, um das Sprite zu finden
	moveq	#0,d3				; 0 = nicht attacched
	moveq	#16,d2				; Hhe sprite
	add.l	#127+10,d0			; Zentrum X
	add.l	#43,d1				; Zentrum Y
	bsr.w	SprControl
	movem.l	(a7)+,d0-d7/a0-a6
	dbra	d7,AnimLoop
	rts


*****************************************************************************
; Die Routine kopiert die Sprites in den Puffer. Aus 1 Sprite machen wir XX *
*****************************************************************************

SpriteCopy:
	lea	Sprite1,a0				; Quelle: ein sprite
	moveq	#68/4,d0			; Jedes Sprite ist 68 Bytes lang
CopyLoop:
	move.l	(a0)+,(a1)+			; vom Sprite zum Ziel (buf)
	subq.w	#1,d0
	bne.s CopyLoop
	dbra d1,SpriteCopy			; mache d1 Kopien
	rts

ActionPtr	dc.l	Action
XPtrs:		dc.l	X2ptr
YPtrs:		dc.l	Y2ptr
Counter:	dc.w	1
SpeedX:		dc.w	4
SpeedY:		dc.w	4

;*****************************************************************************
; Routine Spritekontrolle. Parameter:
;
; a1 = Adresse des Sprites
; d0 = X Koordinate (0-512) (127 = minimal)
; d1 = Y Koordinate (0-512) (43  = minimal)
; d2 = Hhe des Sprites
; d3 = (0 = Normal , 1 = Attached)
;*****************************************************************************

SprControl:
	movem.l	d0-d3/a1,-(a7)		; Register retten
	cmp.w	#512,d0				; x >= 512 
	bge.s	Lab3 				; ja  --> to end 
	add.w	d1,d2	
	cmp.w	#512,d2				; y >= 512
	bge.s	Lab3				; ja  --> to end
	cmp.b	#01,d3				; test ob Attach Sprite
	bne.s	Lab0				; nein -->
	bset.b	#7,3(a1)			; sonst Attach Bit setzen
	bra.s	Lab1				; weiter
Lab0:
	bclr.b	#7,3(a1)			; Attach Bit Loeschen
Lab1:
	lsr.w	#1,d0				; X Position 1 Bit nach rechts schiften
	bcs.s	Sethorz				; Bit 0 gesetzt gewesen -->
	bclr.b	#0,3(a1)			; sonst Bit 0 der X Position setzen
	bra.s	Lab10				; weiter
Sethorz:
	bset.b	#0,3(a1)			; Bit 0 der X Position loeschen
Lab10:
	move.b	d0,1(a1)			; ermittelten Wert ablegen
	move.b	d1,(a1)				; Y Position ablegen
	btst.l	#8,d1				; Bit 8 in Y Position gesetzt
	beq.s	Yclr				; nein -->
	bset.b	#2,3(a1)			; sonst Bit 8 eintragen
	bra.s	Lab2				; weiter
Yclr:
	bclr.b	#2,3(a1)			; Bit 8 als geloescht eintragen
Lab2:
	move.b	d2,2(a1)			; Spritealtezza eintragen
	btst.l	#8,d2				; ist Bit 8 gesetzt
	beq.s	Ystopclr			; nein -->	
	bset.b	#1,3(a1)			; sonst Bit 8 als gesetzt eintragen
	bra.s	Lab3				; weiter
Ystopclr:
	bclr.b	#1,3(a1)			; Bit 8 als geloescht eintragen
Lab3:
	movem.l	(a7)+,d0-d3/a1		; Register wiederherstellen
	rts							; zurck


*****************************************************************************
; Die Tabelle mit den Merkmalen der verschiedenen Animationen nacheinander  *
*****************************************************************************

Action:	
	dc.w	100,2,4				; Tempo Dauer, SpeedX, SpeedY (Anzahl gerade!)
	dc.l	x10ptr,y10ptr		; Zeiger tabx, Zeiger tabY

	dc.w	100,4,2
	dc.l	x2ptr,y2ptr

	dc.w	100,6,2
	dc.l	x2ptr,y2ptr

	dc.w	100,8,2
	dc.l	x2ptr,y2ptr

	dc.w	100,10,2
	dc.l	x2ptr,y2ptr

	dc.w    100,10,4
	dc.l	x2ptr,y2ptr

	dc.w	150,2,4
	dc.l	x4ptr,y4ptr

	dc.w    200,4,2
	dc.l	x4ptr,y4ptr

	dc.w	200,2,2
	dc.l	x6ptr,y6ptr

	dc.w    150,4,2
	dc.l	x6ptr,y6ptr

	dc.w	200,4,4
	dc.l	x8ptr,y8ptr

	dc.w    150,2,4
	dc.l	x8ptr,y8ptr

	dc.w	200,4,2
	dc.l	x1ptr,y1ptr

	dc.w    150,4,4
	dc.l	x1ptr,y1ptr

	dc.w	200,6,2
	dc.l	x3ptr,y3ptr

	dc.w    50,8,2
	dc.l	x3ptr,y3ptr

	dc.w	200,2,10
	dc.l	x5ptr,y5ptr

	dc.w	100,2,2
	dc.l	x2ptr,y2ptr

	dc.w	200,4,4
	dc.l	x7ptr,y7ptr

	dc.w	150,4,4
	dc.l	x9ptr,y9ptr

	dc.w	$ffff				; Ende Flag der Tabelle

;
;******** end OF ANIMATION SEQUENCE DATA *********
;

*****************************************************************************
; Die verschiedenen Tabellen von X und Y addieren sich
*****************************************************************************

x2ptr:		dc.w	0,46,90,134,180,224,270,314
y2ptr:		dc.w	0,46,90,134,180,224,270,314

x4ptr:		dc.w	0,36,72,108,144,180,216,252,288,324
y4ptr:		dc.w	36,72,108,144,180,216,252,288,324,0

x6ptr:		dc.w	0,8,16,24,32,40,48,56,64,72
y6ptr:		dc.w	48,64,80,96,112,128,144,160,176,192

x8ptr:		dc.w	0,16,32,48,64,80,96,112,128,144
y8ptr:		dc.w	48,64,80,96,112,128,144,160,176,192

x1ptr:		dc.w	0,36,72,108,144,180,216,252,288,324
y1ptr:		dc.w	48,64,80,96,112,128,144,160,176,192

x3ptr:		dc.w	0,10,20,30,40,50,60,70,80,90
y3ptr:		dc.w	0,36,72,108,144,180,216,252,288,324

x5ptr:		dc.w	0,2,4,6,8,10,12,14,16,18
y5ptr:		dc.w	0,10,20,30,40,50,60,70,80,90

x7ptr:		dc.w	0,216,72,128,64,324,108,96,160,288
y7ptr:		dc.w	288,160,96,108,324,64,128,72,216,0

y9ptr:		dc.w	80,96,112,128,144,160,176,192,208,224
x9ptr:		dc.w	0,36,72,108,144,180,216,252,288,324

x10ptr:		dc.w	0,10,20,30,40,50,10,340
y10ptr:		dc.w	0,10,20,30,40,50,340,10

*****************************************************************************
; Tabelle SIN/COS fr gekrmmte Flugbahnen
*****************************************************************************

Sinus:
	dc.w	140,143,147,150,154,157,161,164,167,171
	dc.w	174,177,181,184,187,190,193,196,199,202
	dc.w	204,207,209,212,214,217,219,221,223,225
	dc.w	227,228,230,231,233,234,235,236,237,238
	dc.w	238,239,239,240,240,240,240,240,239,239
	dc.w	238,238,237,236,235,234,233,231,230,228
	dc.w	227,225,223,221,219,217,214,212,209,207
	dc.w	204,202,199,196,193,190,187,184,181,177
	dc.w	174,171,167,164,161,157,154,150,147,143
	dc.w	140,137,133,130,126,123,119,116,112,109
	dc.w	106,103,99,96,93,90,87,84,81,78,76,73,71
	dc.w	68,66,63,61,59,57,55,53,52,50,49,47,46,45
	dc.w	44,43,42,42,41,41,40,40,40,40,40,41,41
	dc.w	42,42,43,44,45,46,47,49,50,52,53,55,57
	dc.w	59,61,63,66,68,71,73,76,78,81,84,87,90
	dc.w	93,96,99,103,106,109,112,116,119,123,126
	dc.w	130,133,137
;
Cosinus:
	dc.w	168,168,168,168,167,167,166,166,165,164,163
	dc.w	162,161,160,158,157,155,154,152,150,149,147
	dc.w	145,143,141,138,136,134,131,129,127,124,121
	dc.w	119,116,113,111,108,105,102,99,97,94,91,88
	dc.w	85,82,79,76,73,71,68,65,62,59,57,54,51,49
	dc.w	46,44,41,39,36,34,32,29,27,25,23,21,20,18
	dc.w	16,15,13,12,10,9,8,7,6,5,4,4,3,3,2,2,2,2
	dc.w	2,2,2,3,3,4,4,5,6,7,8,9,10,12,13,15,16
	dc.w	18,20,21,23,25,27,29,32,34,36,39,41,44,46
	dc.w	49,51,54,57,59,62,65,68,71,73,76,79,82,85
	dc.w	88,91,94,97,99,102,105,108,111,113,116,119
	dc.w	121,124,127,129,131,134,136,138,141,143,145
	dc.w	147,149,150,152,154,155,157,158,160,161,162
	dc.w	163,164,165,166,166,167,167,168,168,168
EndSi:


*****************************************************************************
; Die Daten von 1 Sprite, die 8 mal in den Puffer im Chip-RAM kopiert werden
*****************************************************************************

Sprite1:				; Daten der Sprites
	dc.w 0,0
	dc.w $07c0,0
	dc.w $1010,$0fe0
	dc.w $3798,$0fe0
	dc.w $6fdc,$1fe0
	dc.w $6f1c,$1fe0
	dc.w $e77e,$1f80
	dc.w $f0fe,$0f00
	dc.w $fffe,$0000
	dc.w $fffe,$0000
	dc.w $fffe,$0000
	dc.w $7ffc,$0000
	dc.w $7ffc,$0000
	dc.w $3ff8,$0000
	dc.w $1ff0,$0000
	dc.w $07c0,$0000
	dc.w 0,0			; Ende sprite

*****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81	; DIWSTRT
	dc.w	$90,$2cc1	; DIWSTOP
	dc.w	$92,$38		; DDFSTRT
	dc.w	$94,$d0		; DDFSTOP

SpritePointers:
	dc.w	$120,0,$122,0,$124,0,$126,0,$128,0,$12a,0,$12c,0,$12e,0
	dc.w	$130,0,$132,0,$134,0,$136,0,$138,0,$13a,0,$13c,0,$13e,0

	dc.w	$108,0		; BPL1MOD
	dc.w	$10a,0		; BPL2MOD
	dc.w	$102,0		; BPLCON1
	dc.w	$104,0		; BPLCON2

Bplpointers:
	dc.w	$e0,0,$e2,0	; Bitplane 1

	dc.w	$100,$1200	; BPLCON0 - 1 Bitplane lowres

	dc.w	$180,0		; COLOR00 - schwarz
	dc.w	$182,$fff	; COLOR01 - wei

	dc.w	$180,$000,$182,$000

; Farben der Sprites - von COLOR17 bis COLOR31

	dc.w	$1a2,$4d0		; Farben sprite 0,1 (grn)
	dc.w	$1a4,$ad8
	dc.w	$1a6,$ffe
	dc.w	$1a8,$4f0

	dc.w	$1aa,$fe1		; Farben sprite 2,3 (gelb)
	dc.w	$1ac,$fe4
	dc.w	$1ae,$ffe
	dc.w	$1b0,$fe2

	dc.w	$1b2,$d20		; Farben sprite 4,5 (rot)
	dc.w	$1b4,$d88
	dc.w	$1b6,$ffe
	dc.w	$1b8,$f10

	dc.w	$1ba,$40d		; Farben sprite 6,7 (blau)
	dc.w	$1bc,$a8d
	dc.w	$1be,$fef
	dc.w	$1c0,$40f

	dc.w	$ffff,$fffe		; Ende Copperlist


; ****************************************************************************

	SECTION	BUFFER,BSS_C
	
SpriteBuffer:
	ds.b	68*CopiedSprites

; ****************************************************************************

	SECTION	LEEREPLANE,BSS_C

Bitplane:
	ds.b	40*256	; 1 Bitplane lowres "schwarz" wie Hintergrund.

