		************************************
		*       /\/\                       *
		*      /    \                      *
		*     / /\/\ \ O R B_I D           *
		*    / /    \ \   / /              *
		*   / /    __\ \ / /               *
		*        \ \/ / I S I O N S    *
		*           \ \/ /                 *
		*            \  /                  *
		*             \/                   *
		*     Feel the DEATH inside!       *
		************************************

; Code von unbekannten Autoren angepasst und verbessert von
; DeathBringer/Morbid Visions 
; Listing17d.s = ShadeBobs1
***********************************************************
* Shade Bobs
*
* Die ShadeBob-Routine ist im Wesentlichen die Implementierung einer
* Fhigkeit des Blitters. Denken Sie einfach daran, dass jeder
* Bildschirmpixel eine n-stellige binre Zahl ist (wobei n die
* Anzahl der Bitebenen ist), und daher muss 1 dazu addiert werden zur
* Nummer. Unser 1-Bitplane-Bob stellt die Maske dar, die anzeigt, welche
* Pixel uns zustzlich fr einen gegebenen Frame interessieren.
* Zuerst nehmen Sie den Bob und den betroffenen Bildschirmbereich und
* fhren ein UND durch und verwenden als Ziel einen zustzlichen Bereich
* namens Carry. Sobald dies erledigt ist, nehmen sie den Bob und fhren
* das XOR mit der entsprechenden Bildschirm-Bitebene aus.
* Verwenden Sie dann den Carry-Bereich weiter, als wenn es unser Bob 
* fr jede Bitplane war.
* Es werden eindeutig 2 Carry-Bereiche bentigt!!!
************************************************************

	SECTION	ShadeBobs,CODE

			;5432109876543210
DMASET	equ	%1000001111000000	; Copper,Bitplane,blitter DMA

WaitBlit:	macro
.\@	btst.b	#6,dmaconr(a5)		; kein Vortest
	bne.s	.\@					; das ist ein OCS-Fehler
	endm
	
WaitRast:	macro				; auf eine Rasterzeile warten
.\@	move.l	vposr(a5),d0
	lsr.l	#8,d0
	and.w	#$1FF,d0
	cmp.w	#\1,d0
	bne.b	.\@
	endm

	incdir	"/Sources/include/"
	include	MVstartup.s			; Startup Code: Nimmt
								; Systemprfung vor und Aufruf
								; durch Platzieren der START-Routine: 
								; a5=$DFF000

Start:

	lea	BmapPtrs-2,a0			; Geben Sie ^Bitplanes 
								; in der COPPERLISTE ein
    move.l  #Bmap,d0
    moveq.l	#5-1,d1
.Loop	
	addq.l	#4,a0
    swap d0
    move.w  d0,(a0)
    addq.l	#4,a0
    swap    d0
    move.w	d0,(a0)
    add.l	#8000,d0
    dbra    d1,.Loop

; a5 initialisiert mit Wert $DFF000 (Hardwareregisterbasis) in
; Startroutine
	move.l	#Copperlist,cop1lc(a5)	; Copperlist
	move.w	#DMASET,dmacon(a5)	; Copper+Blitter+Bplanes

Main:	
	WaitRast	$0f4			; warte auf die Rasterzeile 244

	move.l	x_ptr(pc),a3		; Zeiger auf Tabellen kopieren x und y
	move.l	y_ptr(pc),a4		; in a3 und in a4

	cmp.l	xl_ptr(pc),a3		; Ende der Tabelle von x?
	bne.b	.xok				; nein
	move.l	xr_ptr(pc),a3		; ja, den Zeiger zurcksetzen
.xok:
	cmp.l	yl_ptr(pc),a4		; Ende der Tabelle von y?
	bne.b	.yok				; nein
	move.l	yr_ptr(pc),a4		; ja, den Zeiger zurcksetzen
.yok:
	moveq	#0,d0				; lschen
	moveq	#0,d1				; d1 und d0
	 
	move.b	(a3)+,d0			; d0=x/2	(Siehe Anmerkung)
	move.b	(a4)+,d1			; d1=y
	add.w	d0,d0				; d0=x
	move.l	a3,x_ptr			; Update-Zeiger
	move.l	a4,y_ptr			; der Tabellen x und y
	bsr	ShadeBob				; zur Shade-Routine springen

	moveq	#0,d0
	moveq	#0,d1
	move.b	10(a3),d0			; neue Koordinatex
	move.b	(a4),d1				; gleiche Koordinate y
	add.w	d0,d0
	bsr	ShadeBob

	moveq	#0,d0
	moveq	#0,d1
	move.b	(a3),d0				; gleiche Koordinate x
	move.b	10(a4),d1			; neue Koordinate y
	add.w	d0,d0
	bsr	ShadeBob

	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.w	Main				; nein, weiter
	rts							; ja, exit

***********************************************************
* Shade Bob
* d0 : x
* d1 : y

ShadeBob:

	movem.l	d0-d5/a0-a3,-(a7)
	move.l	d0,d2				; Kopie d0 in d2
	lsr.w	#4,d2				; d2=word offset
	add.w	d2,d2				; welches das Pixel an der Stelle 'x' enthlt 

	andi.l	#$f,d0				; die vier hohen Bits von d0
	ror.l	#4,d0				; enthalten die Verschiebung fr den Blitter 

	mulu	#40,d1				; d1=offset in der Bitmap
								; das ist Zeile 'y' (jede Zeile 40 Byte)
	add.w	d1,d2				; Gesamt offset

	lea	Bob,a0
	lea	Bmap,a1
	lea	Carry1,a2
	lea	Carry2,a3

	adda.l	d2,a1				; Position des Bobs in der Bitmap

	moveq	#0,d2				; modulo
	moveq	#$22,d3				; modulo  (40-6)
	move.w	#(31<<6)+3,d5		; bltsize, Bob=31*(32+16) pixels

	move.l	#$0ba00000,d4		; Aktivieren Sie den dma der ACD-Kanle, Verschiebung einstellen
	or.l	d0,d4				; x Kanal A und berechne die Funktion d=a AND c
	
	move.w	#$8400,dmacon(a5)	; Blitternasty ON
		
	WaitBlit
	move.l	a0,bltapt(a5)		; Kanal A=bob
	move.l	a1,bltcpt(a5)		; Kanal C=Bitmap
	move.l	a2,bltdpt(a5)		; Kanal D=Carry1
	move.w	d3,bltcmod(a5)		; bltcmod=$22
	move.l	d2,bltamod(a5)		; bltamod und bltdmod=0
	move.l	d4,bltcon0(a5)		; bltcon0&bltcon1
 	move.w	d5,bltsize(a5)		; bltsize

	move.l	#$0b5a0000,d4		; d = a EOR c
	or.l	d0,d4
	
	WaitBlit
	move.l	a0,bltapt(a5)		; Kanal A=bob
	move.l	a1,bltcpt(a5)		; Kanal C=Bitmap
	move.l	a1,bltdpt(a5)		; Kanal D=bitmap
	move.w	d3,bltdmod(a5)		; bltdmod=$22 - die anderen Modulo sind konstant
	move.l	d4,bltcon0(a5)		; neue Minterm-Funktion
 	move.w	d5,bltsize(a5)

	moveq	#4-1,d7				; Bitplane verbleibend
; Jetzt wird der von a2 adressierte Carry-Bereich zu unserem Bob, und der 
; von a3 adressierte Carry-Bereich wird unser echter Carry-Bereich

.1
	adda.l	#8000,a1			; nchste Bitplane
	move.w	#$0ba0,d4			; d = a AND c

	WaitBlit
	move.l	a2,bltapt(a5)		; Kanal A=Carry1
	move.l	a1,bltcpt(a5)		; Kanal C=Bitmap
	move.l	a3,bltdpt(a5)		; Kanal D=Carry2
	move.w	d3,bltcmod(a5)		; bltcmod=$22
	move.w	d2,bltdmod(a5)		; bltdmod=0
	move.w	d4,bltcon0(a5)
 	move.w	d5,bltsize(a5)

	move.w	#$0b5a,d4			; d = a EOR c
	
	WaitBlit
	move.l	a2,bltapt(a5)		; Kanal A=Carry1
	move.l	a1,bltcpt(a5)		; Kanal C=Bitmap
	move.l	a1,bltdpt(a5)		; Kanal D=Bitmap
	move.w	d3,bltdmod(a5)		; bltdmod=$22
	move.w	d4,bltcon0(a5)
 	move.w	d5,bltsize(a5)

	exg	a2,a3					; die beiden Carry-Bereiche vertauschen 
	dbf	d7,.1

	move.w	#$0400,dmacon(a5)	; deaktivieren Blitternasty
	movem.l	(a7)+,d0-d5/a0-a3
	rts


***********************************************************************
;	DATEN, DIE NICHT AN CHIPRAM GEHEN

x_ptr:	dc.l	Sine1			; Zeiger Tabelle der x
y_ptr:	dc.l	Sine2			; Zeiger Tabelle der y
xr_ptr:	dc.l	Sine1			; START Adresse Tabelle der x
yr_ptr:	dc.l	Sine2			; START Adresse Tabelle der y
xl_ptr:	dc.l	Sine1e			; ENDE Adresse Tabelle der x
yl_ptr:	dc.l	Sine2e			; ENDE Adresse Tabelle der y

; Hinweis:	die x-Koordinaten werden durch 2 geteilt und gespeichert, 
; so dass sie eine Gre von 1 Byte haben.

Sine1:
	dc.b	$46,$43,$41,$3e,$3c,$39,$37,$35,$32,$30,$2d,$2b
	dc.b	$29,$27,$25,$22,$20,$1e,$1c,$1a,$18,$17,$15,$13
	dc.b	$11,$10,14,13,11,10,9,8,6,5,5,4,3,2,2,1,1,0,0,0,0
	dc.b	0,0,0,0,0,1,1,2,2,3,4,5,6,7,8,9,10,12,13,15,$10
	dc.b	$12,$13,$15,$17,$19,$1b,$1d,$1f,$21,$23,$25,$27
	dc.b	$29,$2c,$2e,$30,$33,$35,$37,$3a,$3c,$3f,$41,$44
	dc.b	$46,$49,$4b,$4d,$50,$52,$55,$57,$59,$5c,$5e,$60
	dc.b	$63,$65,$67,$69,$6b,$6d,$6f,$71,$73,$75,$77,$78
	dc.b	$7a,$7c,$7d,$7f,$80,$81,$83,$84,$85,$86,$87,$88
	dc.b	$88,$89,$8a,$8a,$8b,$8b,$8b,$8b,$8b,$8b,$8b,$8b
	dc.b	$8b,$8b,$8a,$8a,$89,$89,$88,$87,$86,$85,$84,$83
	dc.b	$82,$80,$7f,$7e,$7c,$7a,$79,$77,$75,$74,$72,$70
	dc.b	$6e,$6c,$6a,$68,$65,$63,$61,$5f,$5c,$5a,$58,$55
	dc.b	$53,$51,$4e,$4c,$49,$47
Sine1e:
	dc.b	$46,$43,$41,$3e,$3c,$39,$37,$35,$32,$30,$2d,$2b

Sine2:
	dc.b	$46,$43,$41,$3f,$3d,$3a,$38,$36,$34,$32,$2f,$2d
	dc.b	$2b,$29,$27,$25,$23,$21,$1f,$1e,$1c,$1a,$18,$17
	dc.b	$15,$13,$12,$10,15,13,12,11,10,9,8,6,6,5,4,3,2,2
	dc.b	1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,3,4,5,5,6,7,8
	dc.b	10,11,12,13,15,$10,$11,$13,$15,$16,$18,$1a,$1b
	dc.b	$1d,$1f,$21,$23,$25,$27,$29,$2b,$2d,$2f,$31,$33
	dc.b	$36,$38,$3a,$3c,$3e,$41,$43,$45,$47,$4a,$4c,$4e
	dc.b	$50,$52,$55,$57,$59,$5b,$5d,$5f,$61,$63,$65,$67
	dc.b	$69,$6b,$6d,$6f,$71,$73,$74,$76,$77,$79,$7a,$7c
	dc.b	$7d,$7f,$80,$81,$82,$83,$84,$85,$86,$87,$88,$88
	dc.b	$89,$8a,$8a,$8b,$8b,$8b,$8b,$8b,$8b,$8b,$8b,$8b
	dc.b	$8b,$8b,$8a,$8a,$89,$89,$88,$87,$87,$86,$85,$84
	dc.b	$83,$82,$81,$7f,$7e,$7d,$7b,$7a,$78,$77,$75,$73
	dc.b	$72,$70,$6e,$6c,$6a,$68,$67,$65,$63,$60,$5e,$5c
	dc.b	$5a,$58,$56,$54,$51,$4f,$4d,$4b,$49,$46
Sine2e:
	dc.b	$46,$43,$41,$3f,$3d,$3a,$38,$36,$34,$32,$2f,$2d

***********************************************************

	SECTION	GRAPHIC,DATA_C	

Copperlist:	
	dc.l	$1fc0000,$1060c00	; AGA zurcksetzen, falls vorhanden, 
								; sonst keine Bedeutung
	
		; DataFetch und Anzeigegre einstellen
	dc.l	$00920038,$009400D0,$008E2C81,$0090F4C1	 
		; Bplcon0, BPLCON1, und modulo
	dc.l	$01005200,$01020000,$01080000,$010A0000
		; color
	dc.l	$01800000,$01820003,$01840004,$01860005,$01880006,$018a0007
	dc.l	$018c0008,$018e0009,$0190000a,$0192000b,$0194000c,$0196000d
	dc.l	$0198000e,$019a000f,$019c020f,$019e030f,$01a0040f,$01a2050f
	dc.l	$01a4060f,$01a6070e,$01a8080d,$01aa090c,$01ac0a0b,$01ae0b0a
	dc.l	$01b00c09,$01b20d08,$01b40e07,$01b60f06,$01b80e35,$01ba0d44
	dc.l	$01bc0c53,$01be0b62
		; Zeiger BitPlanes 
BmapPtrs:
	dc.l	$00e00000,$00e20000,$00e40000,$00e60000,$00e80000,$00ea0000
	dc.l	$00ec0000,$00ee0000,$00f00000,$00f20000,$00f40000,$00f60000
	dc.l	-2,-2

Bob:	; Unser Bild
	dc.l	0,15,$e0000000,$7ffc00,$1ff,$ff000000,$3ffff80
	dc.l	$7ff,$ffc00000,$fffffe0,$1fff,$fff00000,$1ffffff0
	dc.l	$3fff,$fff80000,$3ffffff8,$3fff,$fff80000
	dc.l	$7ffffffc,$7fff,$fffc0000,$7ffffffc,$7fff
	dc.l	$fffc0000,$7ffffffc,$7fff,$fffc0000,$7ffffffc
	dc.l	$3fff,$fff80000,$3ffffff8,$3fff,$fff80000
	dc.l	$1ffffff0,$1fff,$fff00000,$fffffe0,$7ff,$ffc00000
	dc.l	$3ffff80,$1ff,$ff000000,$7ffc00,15,$e0000000,0

***********************************************************

	SECTION	THPT,BSS_C

Carry1:	ds.w	31*3			; erste area carry
Carry2:	ds.w	31*3			; zweites area carry
Bmap:	ds.b	8000*5			; Video-Speicher
