
; Listing17c6.s = plasma6.s
; Plasma6.s	Plasma RGB 4-Bitplanes und Welligkeit
; linke Taste zum Beenden

	SECTION	PLASMA,CODE

;	Include	"DaWorkBench.s"		; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup2.s"		; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001111000000	; Copper,Bitplane,Blitter DMA

WaitDisk	equ	10

WidthPlasma	equ	40				; Plasmabreite ausgedrckt
								; als Anzahl der Gruppen von 8 Pixeln

; Anzahl der Bytes, die in der Copperliste von jeder Zeile des Plasmas belegt sind:
; jeder Copperbefehl bentigt 4 Bytes. Jede Zeile besteht aus 1 WAIT, Width_plasm
; "Copper moves" fr Plasma.

BytesPerLine	equ	(WidthPlasma+1)*4

HighPlasma	equ	190				; Plasmahhe ausgedrckt
								; als Anzahl der Zeilen

NewLineR	equ	-4				; Wert hinzufgen zum Index R in der
								; SinTab zwischen einer Zeile und einer anderen
								; Es kann zum Erhalten von verschiedener Plasmen 
								; variiert werden, aber es MUSS IMMER GERADE SEIN !!

NewFrameR	equ	16				; Wert abziehen vom Index R in der
								; SinTab zwischen einem Frame und einem anderen
								; Es kann zum Erhalten von verschiedener Plasmen 
								; variiert werden, aber es MUSS IMMER GERADE SEIN !!

NewLineG	equ	-22				; wie "NewLineR" aber fr Komponente G
NewFrameG	equ	2				; wie "NewFrameR" aber fr Komponente G

NewLineB	equ	40				; wie "NewLineR" aber fr Komponente B
NewFrameB	equ	4				; wie "NewFrameR" aber fr Komponente B

NewLineO	equ	4				; wie "NewLineR" aber fr Oszillation
NewFrameO	equ	2				; wie "NewFrameR" aber fr Oszillation


Start:

; Zeiger Bitplanes in Copperlist

	lea	Copperlist1,a1			; Zeiger Copperlist 1
	lea	Copperlist2,a2			; Zeiger Copperlist 2
	move.l	#Buffer,d0			; Zeiger Puffer
	move.w	d0,6(a1)			; schreibt in Copperlist 1 
	move.w	d0,6(a2)			; schreibt in Copperlist 2
	swap	d0
	move.w	d0,2(a1)			; schreibt in Copperlist 1
	move.w	d0,2(a2)			; schreibt in Copperlist 2

; Bitplane 2 - Teil 2 Byte spter

	move.l	#Buffer+2,d0
	move.w	d0,6+8(a1)
	move.w	d0,6+8(a2)
	swap	d0
	move.w	d0,2+8(a1)
	move.w	d0,2+8(a2)

; Bitplane 3 - Teil 2 Byte spter

	move.l	#Buffer+2,d0
	move.w	d0,6+8*2(a1)
	move.w	d0,6+8*2(a2)
	swap	d0
	move.w	d0,2+8*2(a1)
	move.w	d0,2+8*2(a2)

; Bitplane 4 - Teil 4 Byte spter

	move.l	#Buffer+4,d0
	move.w	d0,6+8*3(a1)
	move.w	d0,6+8*3(a2)
	swap	d0
	move.w	d0,2+8*3(a1)
	move.w	d0,2+8*3(a2)

	lea	$dff000,a5				; Custom Register Base in a5

	bsr	InitPlasma				; initialisiert die Copperlist

; Blitter Register initialisieren

	btst	#6,2(a5)
WaitBlitInit:
	btst	#6,2(a5)			; auf den Blitter warten
	bne.s	WaitBlitInit

	moveq	#-1,d0				; d0 = $FFFFFFFF
	move.l	d0,$44(a5)			; BLTAFWM/BLTALWM

	move.w	#$8000,$42(a5)		; BLTCON1 - shift 8 pixel Kanal B
								; (verwendet fr Plasma)

mod_A	set	0					; modulo Kanal A
mod_D	set	BytesPerLine-2		; modulo Kanal D: geht zur nchsten Zeile

	move.l	#mod_A<<16+mod_D,$64(a5)	; Modulo Register laden

; modulo Kanle B und C = 0

	moveq	#0,d0
	move.l	d0,$60(a5)			; schreibt BLTBMOD und BLTCMOD

	move.w	#DMASET,$96(a5)		; DMACON - aktivieren Bitplane, Copper
	move.l	#Copperlist1,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist

;  Hardware-Register initialisieren
; d0=0
	move.w	d0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"
	move.l	d0,$180(a5)			; COLOR00 und COLOR01 - schwarz
	move.w	#$30b8,$8e(a5)		; DIWSTRT - Wir benutzen ein weiteres Fenster
								; kleiner Bildschirm zum Maskieren der
								; welligen Kanten.
	move.w	#$ee90,$90(a5)		; DIWSTOP

	move.w	#$0038,$92(a5)		; DDFSTRT - sind geholt 40 bytes
	move.w	#$00d0,$94(a5)		; DDFSTOP
	move.w	d0,$104(a5)			; BPLCON2
	move.w	#$0080,$102(a5)		; BPLCON1 - sogar Ebenen werden verschoben
								; 8 Pixel nach rechts
	move.w	#4,$108(a5)			; BPL1MOD = 4 - 40 Bytes von 44 abrufen
	move.w	#4,$10a(a5)			; BPL2MOD = 4 - 40 Bytes von 44 abrufen
	move.w	#$4200,$100(a5)		; BPLCON0 - 4 Bitplanes aktiv

Mouse2:
	move.l	#$1ff00,d1			; Bits durch UND auswhlen
	move.l	#$13000,d2			; warte auf Zeile $130 (304)
WaitY2:	
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l	d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l	D2,d0				; warte auf Zeile $130 (304)
	bne.s	WaitY2

	bsr	SwapClists				; Copperlist austauschen

	bsr	DoHoriz					; horizontaler Welleneffekt
	bsr	DoPlasma

	btst	#6,$bfe001			; Maus gedrckt?
	bne.s	Mouse2
	rts

;****************************************************************************
; Diese Routine erzeugt die Bitebenen, die den Swing-Effekt realisieren.
; Der Puffer bei "PlasmaLine" enthlt eine Zeile der Figur.
; Dieser Puffer wird so oft in den Videopuffer kopiert, wie das Plasma hoch
; ist und bildet so die ganze Figur. Jede Zeile wird in Richtung rechts 
; um einen variablen Wert verschoben, wodurch die Welligkeit erzeugt wird.
;****************************************************************************

DoHoriz:
	lea	HorizTab(pc),a0			; Adresse Tabelle Oszillation
	lea	Buffer,a1				; Adresse video buffer (Ziel)
	lea	PlasmaLine,a3			; Adresse buffer der die Zeile
								; enthlt (Quelle)

	move.w	#1*64+19,d2			; Gre Blitt:
								; Breite 38 bytes
								; Hhe 1 Zeile

; liest und ndert den Index

	move.w	IndexO(pc),d4		; liest den Startindex vom
								; vorheriger Rahmen
	sub.w	#NewFrameO,d4		; ndern des Index in der Tabelle
								; aus dem vorherigen Frame
	and.w	#$00ff,d4			; hlt den Index im Bereich
								; 0 - 127 (Offset in einer Tabelle von
								; 128 Byte)
	move.w	d4,IndexO			; speichert den Startindex fr
								; den nchsten frame

	move.w	#HighPlasma-1,d3		; Schleife fr jede Zeile
HorizLoop:
	move.b	0(a0,d4.w),d0		; Oszillationswert ablesen

	moveq	#0,d1				; reinigt d1
	move.b	d0,d1				; Kopie Wert Oszillation
	and.w	#$000f,d0			; nur die unteren 4 Bits lassen
	ror.w	#4,d0				; auf die obersten Positionen verschieben
	or.w	#$09f0,d0			; zu schreibender Wertin BLTCON0

	asr.w	#4,d1			
	add.w	d1,d1				; Anzahl Bytes berechnen
	lea	(a1,d1.w),a2			; Adresse Quelle

	btst	#6,2(a5)
WaitBlitHoriz:
	btst	#6,2(a5)			; auf den Blitter warten
	bne.s	WaitBlitHoriz

	move.w	d0,$40(a5)			; BLTCON0 - kopieren mit Shift von A nach D 
	move.l	a3,$50(a5)			; BLTAPT - Adresse Quelle
	move.l	a2,$54(a5)			; BLTDPT - Adresse Ziel
	move.w	d2,$58(a5)			; BLTSIZE

	lea	44(a1),a1				; zeigt auf die nchste Zeile
								; des Videopuffers

; Index fr nchste Zeile bearbeiten

	add.w	#NewLineO,d4		; ndern des Index in der Tabelle
								; fr die nchste Zeile

	and.w	#$00ff,d4			; hlt den Index im Bereich
								; 0 - 127 (Offset in einer Tabelle von
								; 128 Byte)
	dbra	d3,HorizLoop
	rts

;****************************************************************************
; Diese Routine realisiert den "double buffer" zwischen den Copperlisten.
; In der Praxis beginnt es, wo es gezeichnet wird, und visualisiert
; es durch Kopieren der Adresse in COP1LC. Tauschen Sie die Variablen so aus,
; dass im folgenden frame auf der anderen Copperlist gezeichnet wird. 
;****************************************************************************

SwapClists:
	move.l	DrawClist(pc),d0	; Adresse clist auf dem es geschrieben steht
	move.l	ViewClist(pc),DrawClist	; austauschen clists
	move.l	d0,ViewClist

	move.l	d0,$80(a5)			; kopiere die Adresse der Copperlist
								; in COP1LC damit es
								; im nchsten Frame angezeigt wird
	rts


;****************************************************************************
; Diese Routine initialisiert die Copperliste, die das Plasma erzeugt. System
; WAIT-Anweisungen und die erste Hlfte der COPPERMOVE.
;****************************************************************************

InitPlasma:
	lea	Plasma1,a0				; Adresse Plasma 1
	lea	Plasma2,a1				; Adresse Plasma 2
	move.l	#$303ffffe,d0		; ldt die erste wait-Anweisung in d0.
								; warte auf Zeile $30 und Position
								; horizontal $3E

	move.w	#HighPlasma-1,d3		; Schleife fr jede Zeile
InitLoop1:

	move.l	d0,(a0)+			; schreibe WAIT - (clist 1)
	move.l	d0,(a1)+			; schreibe WAIT - (clist 2)
	add.l	#$01000000,d0		; ndere das WAIT, um in
								; der folgenden Zeile zu warten

	moveq	#WidthPlasma/8-1,d2	; jede Iteration schreibt 8 Copper moves

InitLoop2:

; Copperlist 1

	move.w	#$0194,(a0)+		; Kamm 10
	addq.w	#2,a0				; Platz fr den zweiten Teil
								; des "Copper move"
	move.w	#$019a,(a0)+		; color 13
	addq.w	#2,a0
	move.w	#$018c,(a0)+		; color 6
	addq.w	#2,a0
	move.w	#$0196,(a0)+		; color 11
	addq.w	#2,a0
	move.w	#$018a,(a0)+		; color 5
	addq.w	#2,a0
	move.w	#$0184,(a0)+		; color 2
	addq.w	#2,a0
	move.w	#$0192,(a0)+		; color 9
	addq.w	#2,a0
	move.w	#$0188,(a0)+		; color 4
	addq.w	#2,a0

; Copperlist 2

	move.w	#$0194,(a1)+		; color 10
	addq.w	#2,a1				; Platz fr den zweiten Teil
								; des "Copper move"
	move.w	#$019a,(a1)+		; color 13
	addq.w	#2,a1
	move.w	#$018c,(a1)+		; color 6
	addq.w	#2,a1
	move.w	#$0196,(a1)+		; colore 11
	addq.w	#2,a1
	move.w	#$018a,(a1)+		; color 5
	addq.w	#2,a1
	move.w	#$0184,(a1)+		; color 2
	addq.w	#2,a1
	move.w	#$0192,(a1)+		; color 9
	addq.w	#2,a1
	move.w	#$0188,(a1)+		; color 4
	addq.w	#2,a1
	dbra	d2,InitLoop2
	dbra	d3,InitLoop1
	rts


;****************************************************************************
; Diese Routine macht das Plasma. Es macht jeweils eine Schleife von Blitts
; bei denen es eine "Spalte" des Plasmas schreibt, das heit, es schreibt
; die Farben in die COPPERMOVES-Spalte.
; Die in jeder Spalte geschriebenen Farben werden aus einer Tabelle gelesen,
; beginnend mit einer Adresse, die von einer Spalte zur anderen variiert,
; basierend auf Offsets die aus einer anderen Tabelle gelesen werden.
; Auch zwischen einem frame und einem anderen variieren die Offsets um
; den Effekt der Bewegung zu realisieren.
;****************************************************************************

DoPlasma:
	lea	Color,a0				; Adresse Farben
	lea	SinTab,a6				; Adresse Tabelle Offsets
	move.l	DrawClist(pc),a1	; Adresse Copperlist schreiben
	lea	38(a1),a1				; Adresse des ersten Wortes der ersten
								; Plasmasule
; liest und ndert den Index Komponente R

	move.w	IndexR(pc),d4		; liest den Startindex vom
								; vorherigen frame
	sub.w	#NewFrameR,d4		; ndern des Index in der Tabelle
								; aus dem vorherigen Frame
	and.w	#$00ff,d4			; hlt den Index im Bereich
								; 0 - 255 (Offset in einer Tabelle von
								; 128 words)
	move.w	d4,IndexR			; speichert den Startindex fr
								; das nchste Bild
; liest und ndert den Index Komponente G

	move.w	IndexG(pc),d5		; liest den Startindex vom
								; vorherigen frame
	sub.w	#NewFrameG,d5		; ndern des Index in der Tabelle
								; aus dem vorherigen Frame
	and.w	#$00ff,d5			; hlt den Index im Bereich
								; 0 - 255 (Offset in einer Tabelle von
								; 128 words)
	move.w	d5,IndexG			; speichert den Startindex fr
								; das nchste Bild
; liest und ndert den Index Komponente B

	move.w	IndexB(pc),d6		; liest den Startindex vom
								; vorherigen frame
	sub.w	#NewFrameB,d6		; ndern des Index in der Tabelle
								; aus dem vorherigen Frame
	and.w	#$00ff,d6			; hlt den Index im Bereich
								; 0 - 255 (Offset in einer Tabelle von
								; 128 words)
	move.w	d6,IndexB			; speichert den Startindex fr
								; das nchste Bild

	move.w	#HighPlasma<<6+1,d3	; Gre Blitt
								; Breite 1 word, Hhe gesamtes Plasma

	moveq	#WidthPlasma-6-1,d2	; die Schleife wird NICHT ber die Breite durchgehend
								; wiederholt. Die Spalten weiter
								; rechts sind nicht sichtbar
								
	btst	#6,2(a5)			; initialisiert die Blitterregister
WaitBlitPlasma:					; fr Plasma
	btst	#6,2(a5)			; auf den Blitter warten
	bne.s	WaitBlitPlasma

	move.w	#$4ffe,$40(a5)		; BLTCON0 - D=A+B+C, shift A = 4 pixel

PlasmaLoop:						; Startschleife Blitt

; Berechnung der Startadresse der Komponente R

	move.w	(a6,d4.w),d1		; liest Offset aus der Tabelle

	lea	(a0,d1.w),a2			; Startadresse = Farben
								; mehr Offset

; Berechnung der Startadresse der Komponente G

	move.w	(a6,d5.w),d1		; liest Offset aus der Tabelle

	lea	(a0,d1.w),a3			; Startadresse = Farben
								; mehr Offset

; Berechnung der Startadresse der Komponente B

	move.w	(a6,d6.w),d1		; liest Offset aus der Tabelle

	lea	(a0,d1.w),a4			; Startadresse = Farben
								; mehr Offset

	btst	#6,2(a5)
WaitBlit:
	btst	#6,2(a5)			; auf den Blitter warten
	bne.s	WaitBlit

	move.l	a2,$48(a5)			; BLTCPT - Adresse Quelle R
	move.l	a3,$50(a5)			; BLTAPT - Adresse Quelle G
	move.l	a4,$4c(a5)			; BLTBPT - Adresse Quelle B
	move.l	a1,$54(a5)			; BLTDPT - Adresse Ziel
	move.w	d3,$58(a5)			; BLTSIZE

	addq.w	#4,a1				; zeigt auf die nchste Spalte von
								; "Copper moves" in der Copperliste

; ndern Index Komponente R fr die nchste Zeile

	add.w	#NewLineR,d4		; ndern des Index in der Tabelle
								; fr die nchste Zeile

	and.w	#$00ff,d4			; hlt den Index im Bereich
								; 0 - 255 (Offset in einer Tabelle von
								; 128 Wrter)

; ndern Index Komponente G fr die nchste Zeile

	add.w	#NewLineG,d5		; ndern des Index in der Tabelle
								; fr die nchste Zeile

	and.w	#$00ff,d5			; hlt den Index im Bereich
								; 0 - 255 (Offset in einer Tabelle von
								; 128 Wrter)

; ndern Index Komponente B fr die nchste Zeile

	add.w	#NewLineB,d6		; ndern des Index in der Tabelle
								; fr die nchste Zeile

	and.w	#$00ff,d6			; hlt den Index im Bereich
								; 0 - 255 (Offset in einer Tabelle von
								; 128 Wrter)
	dbra	d2,PlasmaLoop
	rts


; Diese 2 Variablen enthalten die Adressen der 2 Copperlisten

ViewClist:	dc.l	Copperlist1	; Adresse clist Visualisierung
DrawClist:	dc.l	Copperlist2	; Adresse clist wo soll man zeichnen

; Diese Variable enthlt den Wert des Index in der Tabelle von
; Oszillationen

IndexO:	dc.w	0

; Diese Tabelle enthlt die Werte der Schwingungnen

HorizTab:
	dc.b	$1c,$1d,$1e,$1e,$1f,$20,$20,$21,$22,$22,$23,$24,$24,$25,$25,$26
	dc.b	$27,$27,$28,$28,$29,$2a,$2a,$2b,$2b,$2c,$2c,$2d,$2d,$2e,$2e,$2f
	dc.b	$2f,$30,$30,$31,$31,$31,$32,$32,$33,$33,$33,$34,$34,$34,$35,$35
	dc.b	$35,$35,$36,$36,$36,$36,$36,$36,$37,$37,$37,$37,$37,$37,$37,$37
	dc.b	$37,$37,$37,$37,$37,$37,$37,$37,$36,$36,$36,$36,$36,$36,$35,$35
	dc.b	$35,$35,$34,$34,$34,$33,$33,$33,$32,$32,$31,$31,$31,$30,$30,$2f
	dc.b	$2f,$2e,$2e,$2d,$2d,$2c,$2c,$2b,$2b,$2a,$2a,$29,$28,$28,$27,$27
	dc.b	$26,$25,$25,$24,$24,$23,$22,$22,$21,$20,$20,$1f,$1e,$1e,$1d,$1c
	dc.b	$1c,$1b,$1a,$1a,$19,$18,$18,$17,$16,$16,$15,$14,$14,$13,$13,$12
	dc.b	$11,$11,$10,$10,$0f,$0e,$0e,$0d,$0d,$0c,$0c,$0b,$0b,$0a,$0a,$09
	dc.b	$09,$08,$08,$07,$07,$07,$06,$06,$05,$05,$05,$04,$04,$04,$03,$03
	dc.b	$03,$03,$02,$02,$02,$02,$02,$02,$01,$01,$01,$01,$01,$01,$01,$01
	dc.b	$01,$01,$01,$01,$01,$01,$01,$01,$02,$02,$02,$02,$02,$02,$03,$03
	dc.b	$03,$03,$04,$04,$04,$05,$05,$05,$06,$06,$07,$07,$07,$08,$08,$09
	dc.b	$09,$0a,$0a,$0b,$0b,$0c,$0c,$0d,$0d,$0e,$0e,$0f,$10,$10,$11,$11
	dc.b	$12,$13,$13,$14,$14,$15,$16,$16,$17,$18,$18,$19,$1a,$1a,$1b,$1c

; Diese Variablen enthalten die Indexwerte fr die erste Spalte

IndexR:	dc.w	0
IndexG:	dc.w	0
IndexB:	dc.w	0

; Diese Tabelle enthlt die Offsets fr die Startadresse in der
; Farbtabelle

SinTab:
	dc.w	$0034,$0036,$0038,$003a,$003c,$0040,$0042,$0044,$0046,$0048
	dc.w	$004a,$004c,$004e,$0050,$0052,$0054,$0056,$0058,$005a,$005a
	dc.w	$005c,$005e,$005e,$0060,$0060,$0062,$0062,$0062,$0064,$0064
	dc.w	$0064,$0064,$0064,$0064,$0064,$0064,$0062,$0062,$0062,$0060
	dc.w	$0060,$005e,$005e,$005c,$005a,$005a,$0058,$0056,$0054,$0052
	dc.w	$0050,$004e,$004c,$004a,$0048,$0046,$0044,$0042,$0040,$003c
	dc.w	$003a,$0038,$0036,$0034,$0030,$002e,$002c,$002a,$0028,$0024
	dc.w	$0022,$0020,$001e,$001c,$001a,$0018,$0016,$0014,$0012,$0010
	dc.w	$000e,$000c,$000a,$000a,$0008,$0006,$0006,$0004,$0004,$0002
	dc.w	$0002,$0002,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	dc.w	$0002,$0002,$0002,$0004,$0004,$0006,$0006,$0008,$000a,$000a
	dc.w	$000c,$000e,$0010,$0012,$0014,$0016,$0018,$001a,$001c,$001e
	dc.w	$0020,$0022,$0024,$0028,$002a,$002c,$002e,$0030
EndSinTab:

;****************************************************************************

	SECTION	GRAPHIC,DATA_C

; Wir haben 2 Copperlists 

Copperlist1:
	dc.w	$e0,$0000,$e2,$0000	; bitplane 1
	dc.w	$e4,$0000,$e6,$0000	; bitplane 2
	dc.w	$e8,$0000,$ea,$0000	; bitplane 3
	dc.w	$ec,$0000,$ee,$0000	; bitplane 4

; Hier bleibt etwas Platz fr das Stck Copperliste, dass das Plasma erzeugt.
; Dieser Raum wird von den Routinen die den Effekt erstellen ausgefllt.

Plasma1:
	dcb.b	HighPlasma*BytesPerLine,0
	dc.w	$ffff,$fffe		; Ende der Copperlist

;****************************************************************************

Copperlist2:
	dc.w	$e0,$0000,$e2,$0000	; bitplane 1
	dc.w	$e4,$0000,$e6,$0000	; bitplane 2
	dc.w	$e8,$0000,$ea,$0000	; bitplane 3
	dc.w	$ec,$0000,$ee,$0000	; bitplane 4

; Hier bleibt etwas Platz fr das Stck Copperliste, dass das Plasma erzeugt.
; Dieser Raum wird von den Routinen die den Effekt erstellen ausgefllt.

Plasma2:
	dcb.b	HighPlasma*BytesPerLine,0
	dc.w	$ffff,$fffe		; Ende der Copperlist


;****************************************************************************
; Hier ist die Farbtabelle, die in das Plasma geschrieben wird.
; Es mssen gengend Farben vorhanden sein, um die Adresse des Starts
; lesen zu knnen. In diesem Beispiel kann die Startadresse von 
; der "Farbe" (erste Farbe) bis "Farbe + 100" (50. Farbe) abweichen, weil
; 100 der maximale Offset ist, der in der "SinTab" enthalten ist.
; Wenn Alt_plasm = 190 ist, bedeutet dies, dass jeder Blitt 190 Farben liest.
; Insgesamt mssen also 240 Farben vorhanden sein.
;****************************************************************************

Color:
	dc.w	$0f00,$0f00,$0e00,$0e00,$0e00,$0d00,$0d00,$0d00
	dc.w	$0c00,$0c00,$0c00,$0b00,$0b00,$0b00,$0a00,$0a00,$0a00
	dc.w	$0900,$0900,$0900,$0800,$0800,$0800,$0700,$0700,$0700
	dc.w	$0600,$0600,$0600,$0500,$0500,$0500,$0400,$0400,$0400
	dc.w	$0300,$0300,$0300,$0200,$0200,$0200,$0100,$0100,$0100
	dcb.w	18,0
	dc.w	$0100,$0100,$0100,$0100,$0200,$0200,$0200,$0200
	dc.w	$0300,$0300,$0300,$0300,$0400,$0400,$0400,$0400
	dc.w	$0500,$0500,$0500,$0500,$0600,$0600,$0600,$0600
	dc.w	$0700,$0700,$0700,$0700,$0800,$0800,$0800,$0800
	dc.w	$0900,$0900,$0900,$0900,$0a00,$0a00,$0a00,$0a00
	dc.w	$0b00,$0b00,$0b00,$0b00,$0c00,$0c00,$0c00,$0c00
	dc.w	$0d00,$0d00,$0d00,$0d00,$0e00,$0e00,$0e00,$0e00
	dc.w	$0f00,$0f00,$0f00,$0f00

	dc.w	$0f00,$0f00,$0f00,$0f00,$0e00,$0e00,$0e00,$0e00
	dc.w	$0d00,$0d00,$0d00,$0d00,$0c00,$0c00,$0c00,$0c00
	dc.w	$0b00,$0b00,$0b00,$0b00,$0a00,$0a00,$0a00,$0a00
	dc.w	$0900,$0900,$0900,$0800,$0800,$0800,$0800
	dc.w	$0700,$0700,$0700,$0700,$0600,$0600,$0600,$0600
	dc.w	$0500,$0500,$0500,$0500,$0400,$0400,$0400,$0400
	dc.w	$0300,$0300,$0300,$0300,$0200,$0200,$0200,$0200
	dc.w	$0100,$0100,$0100
	dcb.w	18,0
	dc.w	$0100,$0100,$0100,$0200,$0200,$0200,$0300,$0300,$0300
	dc.w	$0400,$0400,$0400,$0500,$0500,$0500,$0600,$0600,$0600
	dc.w	$0700,$0700,$0700,$0800,$0800,$0900,$0900,$0900
	dc.w	$0a00,$0a00,$0a00,$0b00,$0b00,$0b00,$0c00,$0c00,$0c00
	dc.w	$0d00,$0d00,$0d00,$0e00,$0e00,$0e00,$0f00

;****************************************************************************
; Puffer, das eine Bildzeile (44 Byte) enthlt, die die Ebenen bildet.
; Das Bild wird erstellt, indem dieser Puffer so oft kopiert wird, wie das 
; Plasma im Videopuffer gro ist.
;****************************************************************************

PlasmaLine:
	rept	5
	dc.l	$00ff00ff,$ff00ff00
	endr
	dc.l	$00ff00ff

;****************************************************************************

	SECTION	PlasmaBit,BSS_C

; Platz fr Bitplanes. Ein breites Bild wird fr alle 4 Bitplanes verwendet
; 44 Bytes und so hoch wie das Plasma

Buffer:
	ds.b	44*HighPlasma

	end
	
;****************************************************************************

In diesem Beispiel zeigen wir ein 4-Bitplane-Plasma mit Amplitudenwelligkeit
gleich 56 Pixel.
Dazu verwenden wir 8 Farbregister im Plasma, die zyklisch gendert werden.
Dies bedeutet, dass ein Register einen konstanten Wert fr 8 * 8 = 64 Pixel
enthlt. So kann sich eine Gruppe von 8 Pixeln von 64-8 = 56 Pixel bewegen
und bleiben immer innerhalb des Bereichs, in dem die Farbe konstant bleibt.
Um solch groe Wellenbewegungen zu erreichen, knnen wir den Hardware-Scroll
nicht verwenden. Daher knnen wir nicht dasselbe Bild fr das gesamte Bild
verwenden, wo die Zeilen mit dem negativen Modulo wiederholt werden. Wir
brauchen ein vollstndiges Bild, damit jede Zeile unabhngig von der
Anderen verschoben werden kann. Wir werden auf diese Weise vorankommen. Wir
haben einen Puffer, wo die Zeilen sind, die das Bild ausmachen. Der Inhalt
dieses Puffers wird in den Videopuffer kopiert, so oft es Zeilen gibt, aus
denen das Plasma besteht um das gewnschte Bild zeilenweise aufzubauen.
Jede Zeile wird passend verschoben, um die Wellenbewegung zu erreichen.
Wenn wir alle Zeilen aller Bitplanes kopieren mssten, mssten wir eine 
groe Anzahl von Blittings ausfhren. Um die Anzahl der Blittings zu
reduzieren, verwenden wir einen Aufbbau. Grundstzlich verwenden wir fr alle
Bitplanes das gleiche Bild.
Der Startpuffer erfolgt auf folgende Weise:

 dc.l	$00ff00ff,$ff00ff00,$00ff00ff,$ff00ff00 - - -

Sobald wir es in den Videopuffer kopiert haben, zeigen wir auf die erste
Bitebene am Anfang des Videopuffers das zweite und dritte 2 Byte nach dem
Start des Videopuffers und das vierte, 4 Byte nach dem Start des Videopuffers.
Auerdem verschieben wir die geraden Bitplanes um 8 Pixel.

Zusammenfassung:
bitplane 1 verweist auf BUFFER
bitplane 2 verweist auf BUFFER+2 + Verschiebung um 8 Pixel nach rechts
bitplane 3 verweist auf BUFFER+2
bitplane 4 verweist auf BUFFER+4 + Verschiebung um 8 Pixel nach rechts

Die Ebenen berlappen sich und erzeugen 8 Farben:

bitplane 1: dc.l $00ff00ffff00ff0000 ff00ffff00ff0000 ff00ffff00ff0000
bitplane 2: dc.l $--00ffff00ff0000ff 00ffff00ff0000ff 00ffff00ff0000
bitplane 3: dc.l $00ffff00ff0000ff00 ffff00ff0000ff00 ffff00ff0000
bitplane 4: dc.l $--ff00ff0000ff00ff ff00ff0000ff00ff ff00ff0000
                   | | | | | | | | |  | | | | | | | |
Farbe             --  06  05  09  10   06  05  09  10
					  13  11  02  04   13  11  02  04

wie Sie sehen, erzeugt es eine zyklische Wiederholung von 8 Farben, die 
in der Copperliste verwendet werden, um das Plasma zu erzeugen.
Auf diese Weise haben wir nur ein Bild, das fr alle 4 Ebenen verwendet wird
und dann kopieren wir dieses einzelne Bild. Wir kopieren 4 Bitebenen mit
einem Wisch und es beschleunigt die Wirkung enorm.
Kommen wir nun zu den technischen Details. Jede Bitebene ist 40 Byte breit.
Weil Bitebene 4 4 Bytes nach Bitebene 1 beginnt, muss sie auch 4 Byte spter
enden. Aufgrund dieser Tatsache ist der Videopuffer (der alle 4 Bitebenen
enthlt) 44 Byte breit, sodass die BPLxMOD-Register einen Wert von 4 haben.
Auerdem ist das Bild aufgrund der Bitebenenverschiebungen nicht rechteckig,
sondern es hat wellige Kanten. Ebenfalls am linken Rand ist die bereinstimmung
der Bitebenen nicht perfekt. Um die Kantenfehler nicht zu zeigen, haben wir das
Videofenster mit DIWSTRT- und DIWSTOP-Registern verengt. Wenn Sie sehen wollen
was an den Rndern passiert, verbreitern sie es.
Aufgrund dieser Verengung sind die Spalten ganz rechts des Plasmas nicht
zu sehen und deshalb ist es sinnlos, sie zu blitten (die weiter links auch, 
wenn nicht knnen Sie sehen, dass sie eine blitt-Einheit sein sollten, weil
das Band, in dem eine Farbe konstant bleibt teilweise sichtbar ist).

