
; Listing15i.s	- Wir visualisieren das erste Bild in 640x480 32kHz VGA ohne lace.
; Wenn Sie keinen geeigneten Monitor haben, sehen Sie nur Rauschen.
; korrigiert Rock'n Roll

	SECTION	AGARULEZ,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup2.s"	; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001110000000	; Copper, Bitplane DMA

WaitDisk	equ	30	; 50-150 zur Rettung (je nach Fall)

Start:
	move.l	#Picture,d0			; Zeiger auf das AGA-Bild
	lea	Bplpointers,a1	
	moveq	#8-1,d7				; Anzahl Bitplanes -1
PointBp:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	addi.l	#80*100,d0			; Lnge Bitplane
	addq.w	#8,a1
	dbra	d7,PointBp			; d7-mal wiederholen (d7= Anzahl Bitplanes)

	move.l	#$2c07fffe,d1		; erste Zeile YY wait: $2c
	moveq	#$00,d5				; Color start
	move.w	#99-1,d7			; Anzahl Zeilen: 99
	bsr.w	DoAGACopB			; einen blauen Farbton machen

	bsr.s	PutColors

	move.w	#DMASET,$96(a5)		; DMACON - aktivieren Bitplane, Copper
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; Fmode zurcksetzen, burst normal
	move.w	#$c00,$106(a5)		; BPLCON3 zurcksetzen
	move.w	#$11,$10c(a5)		; BPLCON4 zurcksetzen

	move.w	#113,$1c0(a5)	; HTOTAL - HIGHEST NUMBER COUNT, HORIZ LINE
				; Maximaler Farbtakt pro horizontale Zeile:
				; Der VGA hat 114 Farbtakte pro Scanlinie!
				; Der Wert liegt zwischen 0 und 255: 113 ist in Ordnung!

	move.w	#28,$1c2(a5)	; HORIZONTAL LINE POSITION FOR HSYNC STOP
							; Anzahl der Farbtakte fr Sync-stop.
	
	move.w	#%1000,$1c4(a5)	; HBSTRT - HORIZONTAL LINE POS FOR HBLANK Start
				; Die Bits 0-7 enthalten die Startpositionen
				; und horizontal blanking stop in
				; Inkrementen von 280 ns. Die Bits 8-10 sind fr
				; eine 35ns (1/4 Pixel) Positionierung.
				; In diesem Fall haben wir 2240ns eingestellt.

	move.w	#30,$1c6(a5)	; HORIZONTAL LINE POSITION FOR HBLANK STOP
							; horizontale Zeile fr Stop Horiz BLANK
							
	move.w	#524,$1c8(a5)	; VTOTAL - HIGHEST NUMBERED VERTICAL LINE
				; Maximale Anzahl Zeilen vertikal, d.h.
				; die Zeile in der der Zhler zurckgesetzt werden soll
				; vertikale Position.
				; Wir wissen das der VGA Mode 525 Zeilen hat.

	move.w	#$000f,$1ca(a5)	; VSSTOP	(fehlte im Original-Listing - Lezione15i.s)
	move.w	#$020e,$1cc(a5)	; VBSTRT	(fehlte im Original-Listing - Lezione15i.s)
	move.w	#$0016,$1ce(a5)	; VBSTOP	(fehlte im Original-Listing - Lezione15i.s)

			 ;5432109876543210
	move.w	#%0001101110001000,$1dc(a5) ; BEAMCON0 - Liste der gesetzten Bits:

			; 3 - BLANKEN - COMPOSITE BLANK OUT TO CSY PIN
			; 7 - VARBEAMEN - VARIABLE BEAM COUNTER COMP. ENABLED
			;     Aktivieren variable Elektronenstrahl-Komparatoren
			;	  als horizontalen Hauptzhler arbeiten,
			;	  und deaktivieren des Hardwarestopp des Displays in
			;     horizontal und vertikal.
			; 8 - VARHSYEN - VARIABLE HORIZONTAL SYNC ENABLED
			;     Aktiviert Register HSSTRT/HSSTOP (var. HSY)
			; 9 - VARVSYEN - VARIABLE VERTICAL SYNC ENABLED
			;     Aktiviert Register VSSTRT/VSSTOP (var. VSY)
			; 11- LOLDIS - DISABLE LONGLINE/SHORTLINE TOGGLE
			;     Deaktivieren des Umschaltens zwischen langen und kurzen Zeilen
			; 12- VARVBEN - VARIABLE VERTICAL BLANK ENABLED
			;     Aktiviert Register VBSTRT/VBSTOP, und deaktivieren
			;     "Hardware Ende" des Videofensters.

	
	move.w	#14,$1de(a5)	; HORIZONTAL SYNC Start - Anzahl der Farben
							; Takte fr Sync-Start.
							
	move.w	#$0007,$1e0(a5)	; VSSTRT	(fehlte im Original-Listing - Lezione15i.s)

	move.w	#70,$1e2(a5)	; HCENTER - POS. HORIZ. von VSYNCH in interlace
							; im Fall von variablen Strahlzhler.		

	bra Mouse

EabRoss:	; https://eab.abime.net/showpost.php?p=1436905&postcount=4
	move.w	#$0071,$1c0(a5)	; HTOTAL	(Randy: 113=$71)
	move.w	#$0015,$1c2(a5)	; HSSTOP	(Randy:  28=$1c)
	move.w	#$0007,$1c4(a5) ; HBSTRT	(Randy: %1000=8)
	move.w	#$0021,$1c6(a5)	; HBSTOP	(Randy:  30=$1e)
	move.w	#$020d,$1c8(a5)	; VTOTAL	(Randy:	524=$20c)
	move.w	#$000f,$1ca(a5)	; VSSTOP	(Randy: fehlt)
	move.w	#$020e,$1cc(a5)	; VBSTRT	(Randy: fehlt)
	move.w	#$0016,$1ce(a5)	; VBSTOP	(Randy: fehlt)
	move.w	#$1b88,$1dc(a5)	; BEAMCON0	(Randy:   =$1b88)
	move.w	#$000b,$1de(a5)	; HSSTRT	(Randy: 14=$e)
	move.w	#$0007,$1e0(a5)	; VSSTRT	(Randy: fehlt)
	move.w	#$0043,$1e2(a5)	; HCENTER	(Randy: 70=$46 )

Mouse:
	btst	#6,$bfe001			; Maus gedrckt?
	bne.s	Mouse
	rts

******************************************************************************

PutColors:
	lea	LogoPal(pc),a0			; Adresse der Farbpalette 
	lea	ColP0+2,a1				; Adresse des ersten Registers
								; auf hohes nibble eingestellt
	lea	ColP0b+2,a2				; Adresse des ersten Registers
								; auf niedriges nibble eingestellt
	moveq	#8-1,d7				; 8 Banken mit jeweils 32 Registern
ConvPaletteBank:
	moveq	#0,d0
	moveq	#0,d2
	moveq	#0,d3
	moveq	#32-1,d6			; 32 Farbregister pro Bank

ConvLongReg:					; Schleife, die die Farben $00RrGgBb.l in die 2 
								; Wrter $0RGB, $0rgb geeignet fr die
								; Copperregister umwandelt.

; Konvertieren niedriger Nibbles von $00RrGgBb (long) in die Farbe AGA $0rgb (word)

	move.b	1(a0),(a2)			; Hohes Byte der Farbe $00Rr0000 kopiert
								; in das Cop-Register fr niedriges Nibble
	andi.b	#%00001111,(a2)		; auswhlen nur niedriges Nibble ($0r)
	move.b	2(a0),d2			; Byte $0000Gg00 aus der 24-Bit-Farbe nehmen
	lsl.b	#4,d2				; verschiebt das niedrige Halbbyte um 4 Bit nach links
								; des GRNEN, "umwandeln" in ein hohes Nibble
								; des niedrigen Bytes von d2 ($g0)
	move.b	3(a0),d3			; Byte $000000Bb aus der 24-Bit-Farbe nehmen
	andi.b	#%00001111,d3		; auswhlen nur niedriges Nibble ($0b)
	or.b	d2,d3				; "MISCHEN" der niedrigen Nibble von grn und blau...
	move.b	d3,1(a2)			; Bilden des nachfolgenden Low-Bytes $gb zum Setzen
								; im Farbregister nach dem Byte $0r fr
								; das word $0rgb der niedrigen Nibble

; Konvertieren hohe Nibbles von $00RrGgBb (long) in die Farbe AGA $0RGB (word)

	move.b	1(a0),d0			; Hohes Byte der Farbe $00Rr0000 in d0
	andi.b	#%11110000,d0		; auswhlen nur hohes Nibble ($R0)
	lsr.b	#4,d0				; verschiebt das Nibble um 4 Bit nach rechts,
								; dadurch wird es zum Low-Byte-Nibble ($0R).
	move.b	d0,(a1)				; das High-Byte $0R in das Farbregister kopieren
	move.b	2(a0),d2			; das Byte $0000Gg00 aus der 24-Bit-Farbe nehmen
	andi.b	#%11110000,d2		; auswhlen nur hohes Nibble ($G0)
	move.b	3(a0),d3			; das Byte $000000Bb aus der 24-Bit-Farbe nehmen
	andi.b	#%11110000,d3		; auswhlen nur hohes Nibble ($B0)
	lsr.b	#4,d3				; verschiebt es um 4 Bit nach rechts
								; dadurch wird es zum Low-Byte-Nibble d3 ($0B)
	or.b	d2,d3				; Mischen der hohen Nibble von Grn und Blau ($G0 + $0B)
	move.b	d3,1(a1)			; Bilden des letzten Low-Bytes $GB zum Setzen
								; im Farbregister nach dem Byte $0R fr
								; das Wort $0RGB der hohen Nibble

	addq.w	#4,a0				; zur nchsten Farbe .l der Palette springen
								; am unteren Rand des Bildes angebracht
	addq.w	#4,a1				; zum nchsten Farbregister springen
								; fr hohes Nibble in Copperlist
	addq.w	#4,a2				; zum nchsten Farbregister springen
								; fr niedriges Nibble in Copperlist

	dbra	d6,ConvLongReg

	add.w	#(128+8),a1			; Farbregister berspringen + dc.w $106,xxx
								; des hohen Nibble
	add.w	#(128+8),a2			; Farbregister berspringen + dc.w $106,xxx
								; des niedrigen Nibble

	dbra	d7,ConvPaletteBank	; Konvertiert eine Bank mit 32 Farben pro
	rts							; Schleife. 8 Schleifen fr 256 Farben.

; Palette mit PicCon in Binrform gespeichert (Optionen: Als Binrdatei speichern, nicht als Cop)

LogoPal:
	incbin	"/Sources/Pic640x100x256.pal"

;*****************************************************************************
; Routine, die BLAUE AGA-Farbtne erzeugt:
;
; d1 = Erste zu wartende Zeile (Wait, z.B. $2c07fffe pro Zeile Y = $2c)
; d5 = Start Farbton ($00-$ff)
; d7 = Anzahl der zu erledigenden Zeilen
;*****************************************************************************

DoAGACopB:
	lea	AgaCopEff1,a0
	move.l	#$01060c00,d4		; BplCon3 - Nibble hoch
	move.l	#$01060e00,d3		; BplCon3 - Nibble niedrig
	move.w	#$180,d2			; Registro COLOR00
MakeAGALoopB:
	move.l	d1,(a0)+			; wait YYXXFFFE
	add.l	#$01000000,d1		; eine Zeile tiefer fr den nchsten
	move.l	d4,(a0)+			; BplCon3 - Auswahl Nibble hoch
	move.w	d2,(a0)+			; Register COLOR00
	addq.b	#1,d5				; "Hellt" die $Gg-Farbe leicht auf
	move.w	d5,d6				; Kopie in d6
	and.w	#%11110000,d6		; Auswahl nur Nibble hoch
	lsr.w	#4,d6				; An der richtigen Position, dh blau $xxB)
	move.w	d6,(a0)+			; Wert Color0 (Nibble hoch)
	move.l	d3,(a0)+			; BplCon3 - Auswahl Nibble niedrig
	move.w	d2,(a0)+			; Register COLOR00
	move.w	d5,d6				; Farbe $xx in d6
	and.w	#%00001111,d6		; Auswahl nur Nibble niedrig - Position $xxB
	move.w	d6,(a0)+			; Farbe in Copperlist eintragen (Nibble niedrig)
	dbra	d7,MakeAGALoopB
	rts

;*****************************************************************************
;*				COPPERLIST AGA												 *
;*****************************************************************************

	cnop	0,8					; ausgerichtet auf 64 bit

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$1c45			; DIWSTRT VGA
	dc.w	$90,$ffe5			; DIWSTOP VGA
	dc.w	$92,$0018			; DDFSTRT VGA
	dc.w	$94,$0068			; DDFSTOP VGA
	dc.w	$1e4,$100
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2
	dc.w	$108,-8				; modulo (-8 fr burst 64 bit)
	dc.w	$10a,-8				; -8
	
			    ; 5432109876543210
	dc.w	$100,%0000001001010001	; 8 bitplane SHIRES 640x480 VGA.

	dc.w	$1fc,$8003			; sprite scan Verdopplung??

Bplpointers:
	dc.w	$e0,0,$e2,0			; erste 	Bitplane
	dc.w	$e4,0,$e6,0			; zweite	   "
	dc.w	$e8,0,$ea,0			; dritte	   "
	dc.w	$ec,0,$ee,0			; vierte	   "
	dc.w	$f0,0,$f2,0			; fnfte	   "
	dc.w	$f4,0,$f6,0			; sechste	   "
	dc.w	$f8,0,$fa,0			; siebte	   "
	dc.w	$fc,0,$fe,0			; achte		   "

; In diesem Fall wird die Palette durch eine Routine aktualisiert, daher
; reicht es aus, die Registerwerte gelscht zu lassen.

	dc.w	$106,$c00	; Auswahl Palette 0 (0-31), Nibble hoch
ColP0:
	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$e00	; Auswahl Palette 0 (0-31), Nibble niedrig
ColP0b:
	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$2c00	; Auswahl Palette 1 (32-63), Nibble hoch

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$2e00	; Auswahl Palette 1 (32-63), Nibble niedrig

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$4c00	; Auswahl Palette 2 (64-95), Nibble hoch

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$4e00	; Auswahl Palette 2 (64-95), Nibble niedrig

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$6c00	; Auswahl Palette 3 (96-127), Nibble hoch

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$6e00	; Auswahl Palette 3 (96-127), Nibble niedrig

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$8c00	; Auswahl Palette 4 (128-159), Nibble hoch

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$8e00	; Auswahl Palette 4 (128-159), Nibble niedrig

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$ac00	; Auswahl Palette 5 (160-191), Nibble hoch

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$ae00	; Auswahl Palette 5 (160-191), Nibble niedrig

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$cc00	; Auswahl Palette 6 (192-223), Nibble hoch

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$ce00	; Auswahl Palette 6 (192-223), Nibble niedrig

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$ec00	; Auswahl Palette 7 (224-255), Nibble hoch

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$ee00	; Auswahl Palette 7 (224-255), Nibble niedrig

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0
	
	dc.w	$106,%0000110000100001		; 0 - external blank enable
								; 5 - BORDER BLANK
								; 10-11 AGA dual playfiled fix

AgaCopEff1:
	dcb.l	99*5				; dh: 99 Zeilen * 5 long:
								; 1 fr wait,
								; 1 fr BPLCON3
								; 1 fr COLOR00 (nib hoch)
								; 1 fr BPLCON3
								; 1 fr COLOR00 (nib niedrig)
	dc.w	$9007,$fffe			; auf das Ende des Logos warten
	dc.w	$100,$201			; null bitplanes

	dc.w	$ffff,$fffe	; Ende Copperlist

;******************************************************************************

; Bild RAW mit 8 bitplanes, das sind 256 Farben

	cnop	0,8	; auf 64 Bit ausrichten

Picture:
	incbin	"/Sources/Pic640x100x256.raw"	; (C) by Cristiano "KREEX" Evangelisti

	end