
; Listing15g4.s	- Schwanken einer HIRES-Figur mit dem AGA BPLCON1.
; Beachten Sie, dass wenn das Bild HIRES ist, der Scroll kann
; gehen von 0 bis 127, um insgesamt 32 Pixel mit niedriger Auflsung zu erhalten.
; In der Praxis ist das hchste Bit nicht aktiviert.

	SECTION	AGARULEZ,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup2.s"	; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001110000000	; Copper, Bitplane DMA

WaitDisk	equ	30	; 50-150 zur Rettung (je nach Fall)

Start:
	move.l	#Picture,d0			; Zeiger auf das AGA-Bild
	lea	Bplpointers,a1
	moveq	#8-1,d7				; Anzahl Bitplanes
PointBp:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	addi.l	#80*100,d0			; Lnge Bitplane
	addq.w	#8,a1
	dbra	d7,PointBp			; d7-mal wiederholen (d7= Anzahl Bitplanes)

	bsr.w	MakeAgaCopCon1		; Copperliste erstellen mit WAIT + BPLCON2 in jeder Zeile

	bsr.s	PutColors			; Farben des Bildes setzen

	bsr.w	FineScrollC2		; Diese Routine "konvertiert" die Dezimalwerte
								; in Bildlaufwerte fr die BPLCON1 AGA

	lea	$dff000,a5
	move.w	#DMASET,$96(a5)		; DMACON - aktivieren Bitplane, Copper
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; Fmode zurcksetzen, burst normale
	move.w	#$c00,$106(a5)		; BPLCON3 zurcksetzen
	move.w	#$11,$10c(a5)		; BPLCON4 zurcksetzen

Mouse:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$11000,d2			; warte auf Zeile $110
WarteY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l	d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l	d2,d0				; warte auf Zeile $110
	bne.s	WarteY1

	bsr.w	Wabble

	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$11000,d2			; warte auf Zeile $110
WarteY2:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l	d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l	d2,d0				; warte auf Zeile $110
	beq.s	WarteY2

	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse
	rts

;*****************************************************************************

PutColors:
	lea	LogoPal(pc),a0			; Adresse der Farbpalette 
	lea	ColP0+2,a1				; Adresse des ersten Registers
								; auf hohes Nibble eingestellt
	lea	ColP0b+2,a2				; Adresse des ersten Registers
								; auf niedriges Nibble eingestellt
	moveq	#8-1,d7				; 8 Banken mit jeweils 32 Registern
ConvPaletteBank:
	moveq	#0,d0
	moveq	#0,d2
	moveq	#0,d3
	moveq	#32-1,d6			; 32 Farbregister pro Bank

ConvLongReg:					; Schleife, die die Farben $00RrGgBb.l in die 2 
								; Wrter $0RGB, $0rgb geeignet fr Copperregister umwandelt.

; Konvertieren niedriger Nibbles von $00RgGgBb (long) in die Farbe AGA $0rgb (word)

	move.b	1(a0),(a2)			; Hohes Byte der Farbe $00Rr0000 kopiert
								; in das Cop-Register fr niedriges Nibble
	andi.b	#%00001111,(a2)		; auswhlen nur niedriges Nibble ($0r)
	move.b	2(a0),d2			; Byte $0000Gg00 aus der 24-Bit-Farbe nehmen
	lsl.b	#4,d2				; verschiebt das niedrige Halbbyte um 4 Bit nach links
								; des GRNEN, "umwandeln" in ein hohes Nibble
								; des niedrigen Bytes von d2 ($g0)
	move.b	3(a0),d3			; Byte $000000Bb aus der 24-Bit-Farbe nehmen
	andi.b	#%00001111,d3		; auswhlen nur niedriges Nibble ($0b)
	or.b	d2,d3				; "MISCHEN" der niedrigen Nibble von grn und blau...
	move.b	d3,1(a2)			; Bilden des nachfolgenden Low-Bytes $gb zum Setzen
								; im Farbregister nach dem Byte $0r fr
								; Bilden Sie das Wort $0rgb der niedrigen Nibble

; Konvertieren hohe Nibbles von $00RgGgBb (long) in die Farbe AGA $0RGB (word)

	move.b	1(a0),d0			; Hohes Byte der Farbe $00Rr0000 in d0
	andi.b	#%11110000,d0		; auswhlen nur hohes Nibble ($R0)
	lsr.b	#4,d0				; verschiebt das Nibble um 4 Bit nach rechts, also
								; dadurch wird es zum Low-Byte-Nibble ($0R).
	move.b	d0,(a1)				; Kopieren Sie das High-Byte $0R in das Farbregister
	move.b	2(a0),d2			; das Byte $0000Gg00 aus der 24-Bit-Farbe nehmen
	andi.b	#%11110000,d2		; auswhlen nur hohes Nibble ($G0)
	move.b	3(a0),d3			; das Byte $000000Bb aus der 24-Bit-Farbe nehmen
	andi.b	#%11110000,d3		; auswhlen nur hohes Nibble ($B0)
	lsr.b	#4,d3				; verschiebt es um 4 Bit nach rechts
								; dadurch wird es zum Low-Byte-Nibble d3 ($0B)
	or.b	d2,d3				; Mischen der hohen Nibble von Grn und Blau ($G0 + $0B)
	move.b	d3,1(a1)			; Bilden des letzten Low-Bytes $GB zum Setzen
								; im Farbregister nach dem Byte $0R fr
								; Bilden Sie das Wort $0RGB der hohen Nibble

	addq.w	#4,a0				; zur nchsten Farbe .l der Palette springen
								; am unteren Rand des Bildes angebracht
	addq.w	#4,a1				; zum nchsten Farbregister springen
								; fr hohes Nibble in Copperlist
	addq.w	#4,a2				; zum nchsten Farbregister springen
								; fr niedriges Nibble in Copperlist

	dbra	d6,ConvLongReg

	add.w	#(128+8),a1			; Farbregister berspringen + dc.w $106,xxx
								; des hohen Nibble
	add.w	#(128+8),a2			; Farbregister berspringen + dc.w $106,xxx
								; des niedrigen Nibble

	dbra	d7,ConvPaletteBank	; Konvertiert eine Bank mit 32 Farben von
	rts							; Schleife. 8 Schleifen fr 256 Farben.

; Palette mit PicCon in Binrform gespeichert (Optionen: Als Binrdatei 
; speichern, nicht als Cop)

LogoPal:
	incbin	"/Sources/Pic640x100x256.pal"

;*****************************************************************************
; Routine, die die Copperliste mit WAIT + BPLCON1 pro Zeile erstellt
;*****************************************************************************

MakeAgaCopCon1:
	lea	AgaCon1,a0				; Adresse buffer in Copperlist
	move.l	#$01020000,d0		; BPLCON1
	move.l	#$2c07fffe,d1		; WAIT - Zeilenanfang Y = $2c
	move.w	#99-1,d7			; Anzahl Zeilen zu erledigen
MakeAgaLoopC:
	move.l	d1,(a0)+			; Warte YYXXFFFE
	move.l	d0,(a0)+			; BPLCON1
	add.l	#$01000000,d1		; eine Zeile tiefer fr die nchste
	dbra	d7,MakeAgaLoopC
	rts

******************************************************************************
; Routine, die von "Dezimalzahlen" in Werte fr die BPLCON1 AGA konvertiert.
; In der Praxis wird die 8-Bit-Zahl durch Positionieren der Bits gem dem
; Schema der BPLCON1 aga. Diese Version hat eine einzelne Tabelle mit
; 0-255 Werten konvertiert in BPLCON1 mit dem gleichen Wert fr die
; 2 playfields, geeignet fr den Bildlaufscroll wie in diesem Beispiel.
******************************************************************************

FineScrollC2:
	lea	MovTab(pc),a0			; Tab Wert
	lea	Con1Values(pc),a1		; Tab Ziel fr $DFF002
	lea	MoveTabEnd(pc),a2		; Ende der Tabelle
ConvLoop:
	moveq	#0,d1
	moveq	#0,d2
	moveq	#0,d3
	moveq	#0,d4
	move.b	(a0)+,d1			; Wert "dezimal" PF1 in d1
	move.w	d1,d2				; Kopie Wert 1 in d2
	move.w	d1,d4				; Kopie Wert 1 in d4
;pf1
	and.w	#%11,d1				; Auswahl bits 0-1 (SCROLL 1/4 und 1/2 pixel)
	lsl.w	#8,d1				; Verschieben an die "richtige" Stelle: Bits 8 und 9
	move.w	d1,d3				; speichern in d3
;pf2
	lsl.w	#4,d1				; Verschieben an die richtige Stelle: bit 12 und 13
	or.w	d1,d3				; speichern in d3
;pf1
	and.w	#%111100,d2			; Auswhlen der "alten" 4 Bits des Scrolls auf 1
								; Pixel, maximal 16 Pixel.
	lsr.w	#2,d2				; Verschieben an die richtige Stelle: die ersten 4 Bits!
	or.w	d2,d3				; speichern in d3
;pf2
	lsl.w	#4,d2				; Verschieben an die richtige Stelle: 4,5,6,7 Bit
	or.w	d2,d3				; speichern in d3
;pf1
	and.w	#%11000000,d4		; hohe Bits auswhlen: Aufnahmen von 16/32 Pixel
	lsl.w	#4,d4				; Richtiger Ort: Bits 10&11 fr PF1
	or.w	d4,d3				; speichern in d3
;pf2
	lsl.w	#4,d4				; Richtiger Ort: Bits 14&15 fr PF2
	or.w	d4,d3				; add pf2 16 pixel scroll bits to d3

	move.w	d3,(a1)+			; speichern Endwert BPLCON1
	cmp.l	a0,a2				; Ende der Tabelle?
	bne.s	ConvLoop			; Wenn noch nicht, Konvertierung fortsetzen !
	rts
	

Wabble:
	move.l	TabPointer(pc),a0	; Zeiger aktuelle Tab in a0
	lea	Con1ValuesEnd(pc),a2	; Ende Tab
	lea	AgaCon1+6,a1			; Effekt Copper in a1
	move.w	#99-1,d7			; Anzahl Zeilen, d.h. loops
Scroll:
	move.w	(a0)+,(a1)			; Kopie der tab al BPLCON1 in Copperlist
	addq.w	#8,a1				; wait berspringen - bis zum nchsten BPLCON1
	cmp.l	a2,a0				; Ende Tab?
	bne.s	Okay				; Wenn noch nicht, weiter
	lea	Con1Values(pc),a0		; Andernfalls von vorne beginnen
Okay:
	dbra	d7,Scroll			; d7 mal

	move.l	TabPointer(pc),a0	; Zeiger aktuelle Tab in a0
	addq.w	#2,a0				; vorwrts "scrollen" 
	cmp.l	a2,a0				; Ende Tab?
	bne.s	Okay2				; Wenn noch nicht, weiter
	lea	Con1Values(pc),a0		; Andernfalls von vorne beginnen
Okay2:
	move.l	a0,TabPointer		; Zeiger aktualisieren
	rts

TabPointer:
	dc.l	Con1Values


; Tabelle mit Endwerten fr $dff102 (BPLCON1)

NUMVAL	equ	256


Con1Values:
	dcb.w	NUMVAL,0
Con1ValuesEnd:

	ds.b	10000

;IS
;BEG>0
;end>360
;AMOUNT>128
;AMPLITUDE>63	; Wenn das Bild in HIRES ist, geht der Scroll von 0 bis 127 !!
;YOFFSET>63

;AMOUNT>64
;AMPLITUDE>63	; Wenn das Bild in HIRES ist, geht der Scroll von 0 bis 127 !!
;YOFFSET>63

;AMOUNT>32
;AMPLITUDE>63	; Wenn das Bild in HIRES ist, geht der Scroll von 0 bis 127 !!
;YOFFSET>63

;AMOUNT>32
;AMPLITUDE>63	; Wenn das Bild in HIRES ist, geht der Scroll von 0 bis 127 !!
;YOFFSET>63


MovTab:
	dc.b	$41,$44,$47,$4a,$4d,$50,$53,$56,$59,$5b,$5e,$61,$63,$66,$68,$6a
	dc.b	$6d,$6f,$71,$73,$74,$76,$77,$79,$7a,$7b,$7c,$7c,$7d,$7e,$7e,$7e
	dc.b	$7e,$7e,$7e,$7d,$7c,$7c,$7b,$7a,$79,$77,$76,$74,$73,$71,$6f,$6d
	dc.b	$6a,$68,$66,$63,$61,$5e,$5b,$59,$56,$53,$50,$4d,$4a,$47,$44,$41
	dc.b	$3d,$3a,$37,$34,$31,$2e,$2b,$28,$25,$23,$20,$1d,$1b,$18,$16,$14
	dc.b	$11,$0f,$0d,$0b,$0a,$08,$07,$05,$04,$03,$02,$02,$01,$00,$00,$00
	dc.b	$00,$00,$00,$01,$02,$02,$03,$04,$05,$07,$08,$0a,$0b,$0d,$0f,$11
	dc.b	$14,$16,$18,$1b,$1d,$20,$23,$25,$28,$2b,$2e,$31,$34,$37,$3a,$3d

	dc.b	$42,$48,$4e,$54,$5a,$5f,$65,$69,$6e,$72,$75,$78,$7a,$7c,$7d,$7e
	dc.b	$7e,$7d,$7c,$7a,$78,$75,$72,$6e,$69,$65,$5f,$5a,$54,$4e,$48,$42
	dc.b	$3c,$36,$30,$2a,$24,$1f,$19,$15,$10,$0c,$09,$06,$04,$02,$01,$00
	dc.b	$00,$01,$02,$04,$06,$09,$0c,$10,$15,$19,$1f,$24,$2a,$30,$36,$3c

	dc.b	$45,$51,$5d,$67,$70,$77,$7b,$7e,$7e,$7b,$77,$70,$67,$5d,$51,$45
	dc.b	$39,$2d,$21,$17,$0e,$07,$03,$00,$00,$03,$07,$0e,$17,$21,$2d,$39

	dc.b	$45,$51,$5d,$67,$70,$77,$7b,$7e,$7e,$7b,$77,$70,$67,$5d,$51,$45
	dc.b	$39,$2d,$21,$17,$0e,$07,$03,$00,$00,$03,$07,$0e,$17,$21,$2d,$39
MoveTabEnd:


;*****************************************************************************
;*				COPPERLIST				     *
;*****************************************************************************

	cnop	0,8					; ausgerichtet auf 64 bit

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP

; Hinweis: Die ddfstart / stop HIRES wren $003c und $00d4, jedoch mit aktivem Burst
; Der gleiche Wert wie bei LOWRES ist in Ordnung, dh $0038 und $00d0.

	dc.w	$92,$0038			; DDFSTRT
	dc.w	$94,$00d0			; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2
	dc.w	$108,-8				; BPL1MOD (burst 64bit, modulo=modulo-8)
	dc.w	$10a,-8				; BPL2MOD (wie oben)

				; 5432109876543210
	dc.w	$100,%1000001000010001	; 8 Bitplane HIRES 640x256. Zum
					; Setzen von 8 planes, Bit 4 setzen
					; Bit 12,13,14 zurcksetzen. Bit 0 ist gesetzt,
					; da es viele AGA-Funktionen ermglicht
					; die wir spter sehen werden.

	dc.w	$1fc,3				; Burst mode 64 bit

Bplpointers:
	dc.w	$e0,0,$e2,0			; erste 	Bitplane
	dc.w	$e4,0,$e6,0			; zweite	   "
	dc.w	$e8,0,$ea,0			; dritte	   "
	dc.w	$ec,0,$ee,0			; vierte	   "
	dc.w	$f0,0,$f2,0			; fnfte	   "
	dc.w	$f4,0,$f6,0			; sechste	   "
	dc.w	$f8,0,$fa,0			; siebte	   "
	dc.w	$fc,0,$fe,0			; achte		   "

; In diesem Fall wird die Palette durch eine Routine aktualisiert, daher
; reicht es aus, die Registerwerte gelscht zu lassen.

	dc.w	$106,$c00	; Auswahl Palette 0 (0-31), Nibble hoch
ColP0:
	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$e00	; Auswahl Palette 0 (0-31), Nibble niedrig
ColP0b:
	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$2c00	; Auswahl Palette 1 (32-63), Nibble hoch

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$2e00	; Auswahl Palette 1 (32-63), Nibble niedrig

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$4c00	; Auswahl Palette 2 (64-95), Nibble hoch

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$4e00	; Auswahl Palette 2 (64-95), Nibble niedrig

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$6c00	; Auswahl Palette 3 (96-127), Nibble hoch

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$6e00	; Auswahl Palette 3 (96-127), Nibble niedrig

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$8c00	; Auswahl Palette 4 (128-159), Nibble hoch

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$8e00	; Auswahl Palette 4 (128-159), Nibble niedrig

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$ac00	; Auswahl Palette 5 (160-191), Nibble hoch

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$ae00	; Auswahl Palette 5 (160-191), Nibble niedrig

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$cc00	; Auswahl Palette 6 (192-223), Nibble hoch

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$ce00	; Auswahl Palette 6 (192-223), Nibble niedrig

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$ec00	; Auswahl Palette 7 (224-255), Nibble hoch

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$ee00	; Auswahl Palette 7 (224-255), Nibble niedrig
		            
	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

AgaCon1:
	dcb.l	99*2				; d.h.: 99 Zeilen * 2 long:
								; 1 fr wait,
								; 1 fr bplcon1
	dc.w	$9007,$fffe			; auf das Ende des Logos warten
	dc.w	$100,$200			; null bitplanes

	dc.w	$ffff,$fffe			; Ende copperlist

;******************************************************************************

; Bild RAW mit 8 bitplanes, das sind 256 Farben

	cnop	0,8	; auf 64 Bit ausrichten

Picture:
	incbin	"/Sources/Pic640x100x256.raw"	; (C) by Cristiano "KREEX" Evangelisti

	end

Fr die Bilder in Hires haben wir eine Hardware-Einschrnkung beim Scroll:
Das hchste Bit ist nicht aktiviert, das des Scrolls von 32 Pixeln gleichzeitig,
geht der Wert von 0 auf 127 anstatt von 0 auf 255.

