
; Listing15g3.s	- 	Schwanken einer LORES Figur mit dem AGA BPLCON1.

	SECTION	AGARULEZ,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup2.s"	; speichern Copperlist etc.
*****************************************************************************

		    ;5432109876543210
DMASET	equ	%1000001110000000	; Copper, Bitplane DMA

WaitDisk	equ	30	; 50-150 zur Rettung (je nach Fall)

Start:
	move.l	#Picture,d0			; Zeiger auf das AGA-Bild
	lea	Bplpointers,a1
	moveq	#8-1,d7				; Anzahl Bitplanes
PointBp:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	addi.l	#40*256,d0			; Lnge Bitplane
	addq.w	#8,a1
	dbra	d7,PointBp			; d7-mal wiederholen (d7= Anzahl Bitplanes)

	bsr.w	MakeAgaCopCon1		; Copperliste erstellen mit WAIT + BPLCON2 in jeder Zeile

	bsr.s	PutColors			; Farben des Bildes setzen

	bsr.w	FineScrollC2		; Diese Routine "konvertiert" die Dezimalwerte
								; in Bildlaufwerte fr die BPLCON1 AGA

	lea	$dff000,a5
	move.w	#DMASET,$96(a5)		; DMACON - aktivieren Bitplane, Copper
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; Fmode zurcksetzen, burst normale
	move.w	#$c00,$106(a5)		; BPLCON3 zurcksetzen
	move.w	#$11,$10c(a5)		; BPLCON4 zurcksetzen

Mouse:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$11000,d2			; warte auf Zeile $110
WarteY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l	d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l	d2,d0				; warte auf Zeile $110
	bne.s	WarteY1

	bsr.w	Wabble

	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$11000,d2			; warte auf Zeile $110
WarteY2:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l	d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l	d2,d0				; warte auf Zeile $110
	beq.s	WarteY2

	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse
	rts

;*****************************************************************************

PutColors:
	lea	Picture+(10240*8),a0	; Adresse der Farbpalette am
								; Ende des Bildes -> in a0
	lea	ColP0+2,a1				; Adresse des ersten Registers
								; auf hohes Nibble eingestellt
	lea	ColP0b+2,a2				; Adresse des ersten Registers
								; auf niedriges Nibble eingestellt
	moveq	#8-1,d7				; 8 Banken mit jeweils 32 Registern
ConvPaletteBank:
	moveq	#0,d0
	moveq	#0,d2
	moveq	#0,d3
	moveq	#32-1,d6			; 32 Farbregister pro Bank

ConvLongReg:				; Schleife, die die Farben $00RrGgBb.l in die 2 
			; Wrter $0RGB, $0rgb geeignet fr Copperregister umwandelt.

; Konvertieren niedriger Nibbles von $00RrGgBb (long) in die Farbe AGA $0rgb (word)

	move.b	1(a0),(a2)			; Hohes Byte der Farbe $00Rr0000 kopiert
								; in das Cop-Register fr niedriges Nibble
	andi.b	#%00001111,(a2)		; auswhlen nur niedriges Nibble ($0r)
	move.b	2(a0),d2			; Byte $0000Gg00 aus der 24-Bit-Farbe nehmen
	lsl.b	#4,d2				; verschiebt das niedrige Halbbyte um 4 Bit nach links
								; des GRNEN, "umwandeln" in ein hohes Nibble
								; des niedrigen Bytes von d2 ($g0)
	move.b	3(a0),d3			; Byte $000000Bb aus der 24-Bit-Farbe nehmen
	andi.b	#%00001111,d3		; auswhlen nur niedriges Nibble ($0b)
	or.b	d2,d3				; "MISCHEN" der niedrigen Nibble von grn und blau...
	move.b	d3,1(a2)			; Bilden des nachfolgenden Low-Bytes $gb zum Setzen
								; im Farbregister nach dem Byte $0r fr
								; Bilden Sie das Wort $0rgb der niedrigen Nibble

; Konvertieren hohe Nibbles von $00RrGgBb (long) in die Farbe AGA $0RGB (word)

	move.b	1(a0),d0			; Hohes Byte der Farbe $00Rr0000 in d0
	andi.b	#%11110000,d0		; auswhlen nur hohes Nibble ($R0)
	lsr.b	#4,d0				; verschiebt das Nibble um 4 Bit nach rechts, also
								; dadurch wird es zum Low-Byte-Nibble ($0R).
	move.b	d0,(a1)				; Kopieren Sie das High-Byte $0R in das Farbregister
	move.b	2(a0),d2			; das Byte $0000Gg00 aus der 24-Bit-Farbe nehmen
	andi.b	#%11110000,d2		; auswhlen nur hohes Nibble ($G0)
	move.b	3(a0),d3			; das Byte $000000Bb aus der 24-Bit-Farbe nehmen
	andi.b	#%11110000,d3		; auswhlen nur hohes Nibble ($B0)
	lsr.b	#4,d3				; verschiebt es um 4 Bit nach rechts
								; dadurch wird es zum Low-Byte-Nibble d3 ($0B)
	or.b	d2,d3				; Mischen der hohen Nibble von Grn und Blau ($G0 + $0B)
	move.b	d3,1(a1)			; Bilden des letzten Low-Bytes $GB zum Setzen
								; im Farbregister nach dem Byte $0R fr
								; Bilden Sie das Wort $0RGB der hohen Nibble

	addq.w	#4,a0				; zur nchsten Farbe .l der Palette springen
								; am unteren Rand des Bildes angebracht
	addq.w	#4,a1				; zum nchsten Farbregister springen
								; fr hohes Nibble in Copperlist
	addq.w	#4,a2				; zum nchsten Farbregister springen
								; fr niedriges Nibble in Copperlist

	dbra	d6,ConvLongReg

	add.w	#(128+8),a1			; Farbregister berspringen + dc.w $106,xxx
								; des hohen Nibble
	add.w	#(128+8),a2			; Farbregister berspringen + dc.w $106,xxx
								; des niedrigen Nibble

	dbra	d7,ConvPaletteBank	; Konvertiert eine Bank mit 32 Farben von
	rts							; Schleife. 8 Schleifen fr 256 Farben.

; Palette mit PicCon in Binrform gespeichert (Optionen: Als Binrdatei 
; speichern, nicht als Cop)

LogoPal:
	incbin	"/Sources/Pic640x100x256.pal"

;*****************************************************************************
; Routine, die die Copperliste mit WAIT + BPLCON1 pro Zeile erstellt
;*****************************************************************************

MakeAgaCopCon1:
	lea	AgaCon1,a0				; Adresse buffer in Copperlist
	move.l	#$01020000,d0		; BPLCON1
	move.l	#$2c07fffe,d1		; WAIT - Zeilenanfang Y = $2c
	move.w	#200-1,d7			; Anzahl Zeilen zu erledigen
MakeAgaLoopC:
	move.l	d1,(a0)+			; Warte YYXXFFFE
	move.l	d0,(a0)+			; BPLCON1
	add.l	#$01000000,d1		; eine Zeile tiefer fr die nchste
	dbra	d7,MakeAgaLoopC
	rts

******************************************************************************
; Routine, die von "Dezimalzahlen" in Werte fr die BPLCON1 AGA konvertiert.
; In der Praxis wird die 8-Bit-Zahl durch Positionieren der Bits gem dem
; Schema der BPLCON1 aga. Diese Version hat eine einzelne Tabelle mit
; 0-255 Werten konvertiert in BPLCON1 mit dem gleichen Wert fr die
; 2 playfields, geeignet fr den Bildlaufscroll wie in diesem Beispiel.
******************************************************************************

FineScrollC2:
	lea	MovTab(pc),a0			; Tab Wert
	lea	Con1Values(pc),a1		; Tab Ziel fr $DFF002
	lea	MoveTabEnd(pc),a2		; Ende der Tabelle
ConvLoop:
	moveq	#0,d1
	moveq	#0,d2
	moveq	#0,d3
	moveq	#0,d4
	move.b	(a0)+,d1			; Wert "dezimal" PF1 in d1
	move.w	d1,d2				; Kopie Wert 1 in d2
	move.w	d1,d4				; Kopie Wert 1 in d4
;pf1
	and.w	#%11,d1				; Auswahl bits 0-1 (SCROLL 1/4 und 1/2 pixel)
	lsl.w	#8,d1				; Verschieben an die "richtige" Stelle: Bits 8 und 9
	move.w	d1,d3				; speichern in d3
;pf2
	lsl.w	#4,d1				; Verschieben an die richtige Stelle: bit 12 und 13
	or.w	d1,d3				; speichern in d3
;pf1
	and.w	#%111100,d2			; Auswhlen der "alten" 4 Bits des Scrolls auf 1
								; Pixel, maximal 16 Pixel.
	lsr.w	#2,d2				; Verschieben an die richtige Stelle: die ersten 4 Bits!
	or.w	d2,d3				; speichern in d3
;pf2
	lsl.w	#4,d2				; Verschieben an die richtige Stelle: 4,5,6,7 Bit
	or.w	d2,d3				; speichern in d3
;pf1
	and.w	#%11000000,d4		; hohe Bits auswhlen: Aufnahmen von 16/32 Pixel
	lsl.w	#4,d4				; Richtiger Ort: Bits 10&11 fr PF1
	or.w	d4,d3				; speichern in d3
;pf2
	lsl.w	#4,d4				; Richtiger Ort: Bits 14&15 fr PF2
	or.w	d4,d3				; add pf2 16 pixel scroll bits to d3

	move.w	d3,(a1)+			; speichern Endwert BPLCON1
	cmp.l	a0,a2				; Ende der Tabelle?
	bne.s	ConvLoop			; Wenn noch nicht, Konvertierung fortsetzen !
	rts
	

Wabble:
	btst	#2,$dff016
	beq.s	Wabble
	move.l	TabPointer(pc),a0	; Zeiger aktuelle Tab in a0
	lea	Con1ValuesEnd(pc),a2	; Ende Tab
	lea	AgaCon1+6,a1			; Effekt Copper in a1
	move.w	#200-1,d7			; Anzahl Zeilen, d.h. loops
Scroll:
	cmp.l	a2,a0				; Ende Tab?
	bne.s	Okay				; Wenn noch nicht, weiter
	lea	Con1Values(pc),a0		; Andernfalls von vorne beginnen
Okay:
	move.w	(a0)+,(a1)			; Kopie der tab al BPLCON1 in Copperlist
	addq.w	#8,a1				; wait berspringen - bis zum nchsten BPLCON1
	dbra	d7,Scroll			; d7 MAL

	move.l	TabPointer(pc),a0	; Zeiger aktuelle Tab in a0
	addq.w	#2,a0				; vorwrts "scrollen" 
	cmp.l	a2,a0				; Ende Tab?
	bne.s	Okay2				; Wenn noch nicht, weiter
	lea	Con1Values(pc),a0		; Andernfalls von vorne beginnen
Okay2:
	move.l	a0,TabPointer		; Zeiger aktualisieren
	rts

TabPointer:
	dc.l	Con1Values


; Tabelle mit Endwerten fr $dff102 (BPLCON1)

NUMVAL	equ	400+300+200+100

Con1Values:
	dcb.w	NUMVAL,0
Con1ValuesEnd:

;IS
;BEG>0
;end>360
;AMOUNT>400
;AMPLITUDE>127	; Wenn das Bild in LORES ist, geht der Scroll von 0 auf 255 !!
;YOFFSET>127

;AMOUNT>300

;AMOUNT>200

;AMOUNT>100

; Hier sind 4 Sintabs untereinander...

MovTab:
	dc.b	$80,$82,$84,$86,$88,$8a,$8c,$8e,$90,$92,$94,$96,$98,$9a,$9c,$9e
	dc.b	$a0,$a1,$a3,$a5,$a7,$a9,$ab,$ad,$af,$b1,$b2,$b4,$b6,$b8,$ba,$bb
	dc.b	$bd,$bf,$c1,$c2,$c4,$c6,$c7,$c9,$ca,$cc,$ce,$cf,$d1,$d2,$d4,$d5
	dc.b	$d7,$d8,$da,$db,$dc,$de,$df,$e0,$e1,$e3,$e4,$e5,$e6,$e7,$e9,$ea
	dc.b	$eb,$ec,$ed,$ee,$ef,$f0,$f1,$f1,$f2,$f3,$f4,$f5,$f5,$f6,$f7,$f7
	dc.b	$f8,$f9,$f9,$fa,$fa,$fb,$fb,$fc,$fc,$fc,$fd,$fd,$fd,$fd,$fe,$fe
	dc.b	$fe,$fe,$fe,$fe,$fe,$fe,$fe,$fe,$fe,$fe,$fd,$fd,$fd,$fd,$fc,$fc
	dc.b	$fc,$fb,$fb,$fa,$fa,$f9,$f9,$f8,$f7,$f7,$f6,$f5,$f5,$f4,$f3,$f2
	dc.b	$f1,$f1,$f0,$ef,$ee,$ed,$ec,$eb,$ea,$e9,$e7,$e6,$e5,$e4,$e3,$e1
	dc.b	$e0,$df,$de,$dc,$db,$da,$d8,$d7,$d5,$d4,$d2,$d1,$cf,$ce,$cc,$ca
	dc.b	$c9,$c7,$c6,$c4,$c2,$c1,$bf,$bd,$bb,$ba,$b8,$b6,$b4,$b2,$b1,$af
	dc.b	$ad,$ab,$a9,$a7,$a5,$a3,$a1,$a0,$9e,$9c,$9a,$98,$96,$94,$92,$90
	dc.b	$8e,$8c,$8a,$88,$86,$84,$82,$80,$7e,$7c,$7a,$78,$76,$74,$72,$70
	dc.b	$6e,$6c,$6a,$68,$66,$64,$62,$60,$5e,$5d,$5b,$59,$57,$55,$53,$51
	dc.b	$4f,$4d,$4c,$4a,$48,$46,$44,$43,$41,$3f,$3d,$3c,$3a,$38,$37,$35
	dc.b	$34,$32,$30,$2f,$2d,$2c,$2a,$29,$27,$26,$24,$23,$22,$20,$1f,$1e
	dc.b	$1d,$1b,$1a,$19,$18,$17,$15,$14,$13,$12,$11,$10,$0f,$0e,$0d,$0d
	dc.b	$0c,$0b,$0a,$09,$09,$08,$07,$07,$06,$05,$05,$04,$04,$03,$03,$02
	dc.b	$02,$02,$01,$01,$01,$01,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	dc.b	$00,$00,$01,$01,$01,$01,$02,$02,$02,$03,$03,$04,$04,$05,$05,$06
	dc.b	$07,$07,$08,$09,$09,$0a,$0b,$0c,$0d,$0d,$0e,$0f,$10,$11,$12,$13
	dc.b	$14,$15,$17,$18,$19,$1a,$1b,$1d,$1e,$1f,$20,$22,$23,$24,$26,$27
	dc.b	$29,$2a,$2c,$2d,$2f,$30,$32,$34,$35,$37,$38,$3a,$3c,$3d,$3f,$41
	dc.b	$43,$44,$46,$48,$4a,$4c,$4d,$4f,$51,$53,$55,$57,$59,$5b,$5d,$5e
	dc.b	$60,$62,$64,$66,$68,$6a,$6c,$6e,$70,$72,$74,$76,$78,$7a,$7c,$7e

	dc.b	$80,$83,$86,$88,$8b,$8e,$90,$93,$95,$98,$9b,$9d,$a0,$a2,$a5,$a8
	dc.b	$aa,$ad,$af,$b1,$b4,$b6,$b9,$bb,$bd,$c0,$c2,$c4,$c6,$c9,$cb,$cd
	dc.b	$cf,$d1,$d3,$d5,$d7,$d9,$db,$dc,$de,$e0,$e2,$e3,$e5,$e7,$e8,$ea
	dc.b	$eb,$ec,$ee,$ef,$f0,$f1,$f2,$f4,$f5,$f6,$f6,$f7,$f8,$f9,$fa,$fa
	dc.b	$fb,$fb,$fc,$fc,$fd,$fd,$fd,$fe,$fe,$fe,$fe,$fe,$fe,$fe,$fe,$fd
	dc.b	$fd,$fd,$fc,$fc,$fb,$fb,$fa,$fa,$f9,$f8,$f7,$f6,$f6,$f5,$f4,$f2
	dc.b	$f1,$f0,$ef,$ee,$ec,$eb,$ea,$e8,$e7,$e5,$e3,$e2,$e0,$de,$dc,$db
	dc.b	$d9,$d7,$d5,$d3,$d1,$cf,$cd,$cb,$c9,$c6,$c4,$c2,$c0,$bd,$bb,$b9
	dc.b	$b6,$b4,$b1,$af,$ad,$aa,$a8,$a5,$a2,$a0,$9d,$9b,$98,$95,$93,$90
	dc.b	$8e,$8b,$88,$86,$83,$80,$7e,$7b,$78,$76,$73,$70,$6e,$6b,$69,$66
	dc.b	$63,$61,$5e,$5c,$59,$56,$54,$51,$4f,$4d,$4a,$48,$45,$43,$41,$3e
	dc.b	$3c,$3a,$38,$35,$33,$31,$2f,$2d,$2b,$29,$27,$25,$23,$22,$20,$1e
	dc.b	$1c,$1b,$19,$17,$16,$14,$13,$12,$10,$0f,$0e,$0d,$0c,$0a,$09,$08
	dc.b	$08,$07,$06,$05,$04,$04,$03,$03,$02,$02,$01,$01,$01,$00,$00,$00
	dc.b	$00,$00,$00,$00,$00,$01,$01,$01,$02,$02,$03,$03,$04,$04,$05,$06
	dc.b	$07,$08,$08,$09,$0a,$0c,$0d,$0e,$0f,$10,$12,$13,$14,$16,$17,$19
	dc.b	$1b,$1c,$1e,$20,$22,$23,$25,$27,$29,$2b,$2d,$2f,$31,$33,$35,$38
	dc.b	$3a,$3c,$3e,$41,$43,$45,$48,$4a,$4d,$4f,$51,$54,$56,$59,$5c,$5e
	dc.b	$61,$63,$66,$69,$6b,$6e,$70,$73,$76,$78,$7b,$7e

	dc.b	$81,$85,$89,$8d,$91,$95,$99,$9d,$a1,$a4,$a8,$ac,$b0,$b3,$b7,$ba
	dc.b	$be,$c1,$c5,$c8,$cb,$ce,$d1,$d4,$d7,$da,$dd,$e0,$e2,$e5,$e7,$e9
	dc.b	$eb,$ed,$ef,$f1,$f3,$f4,$f6,$f7,$f8,$f9,$fa,$fb,$fc,$fd,$fd,$fe
	dc.b	$fe,$fe,$fe,$fe,$fe,$fd,$fd,$fc,$fb,$fa,$f9,$f8,$f7,$f6,$f4,$f3
	dc.b	$f1,$ef,$ed,$eb,$e9,$e7,$e5,$e2,$e0,$dd,$da,$d7,$d4,$d1,$ce,$cb
	dc.b	$c8,$c5,$c1,$be,$ba,$b7,$b3,$b0,$ac,$a8,$a4,$a1,$9d,$99,$95,$91
	dc.b	$8d,$89,$85,$81,$7d,$79,$75,$71,$6d,$69,$65,$61,$5d,$5a,$56,$52
	dc.b	$4e,$4b,$47,$44,$40,$3d,$39,$36,$33,$30,$2d,$2a,$27,$24,$21,$1e
	dc.b	$1c,$19,$17,$15,$13,$11,$0f,$0d,$0b,$0a,$08,$07,$06,$05,$04,$03
	dc.b	$02,$01,$01,$00,$00,$00,$00,$00,$00,$01,$01,$02,$03,$04,$05,$06
	dc.b	$07,$08,$0a,$0b,$0d,$0f,$11,$13,$15,$17,$19,$1c,$1e,$21,$24,$27
	dc.b	$2a,$2d,$30,$33,$36,$39,$3d,$40,$44,$47,$4b,$4e,$52,$56,$5a,$5d
	dc.b	$61,$65,$69,$6d,$71,$75,$79,$7d

	dc.b	$83,$8b,$93,$9b,$a2,$aa,$b1,$b9,$c0,$c6,$cd,$d3,$d9,$de,$e3,$e8
	dc.b	$ec,$f0,$f4,$f6,$f9,$fb,$fc,$fd,$fe,$fe,$fd,$fc,$fb,$f9,$f6,$f4
	dc.b	$f0,$ec,$e8,$e3,$de,$d9,$d3,$cd,$c6,$c0,$b9,$b1,$aa,$a2,$9b,$93
	dc.b	$8b,$83,$7b,$73,$6b,$63,$5c,$54,$4d,$45,$3e,$38,$31,$2b,$25,$20
	dc.b	$1b,$16,$12,$0e,$0a,$08,$05,$03,$02,$01,$00,$00,$01,$02,$03,$05
	dc.b	$08,$0a,$0e,$12,$16,$1b,$20,$25,$2b,$31,$38,$3e,$45,$4d,$54,$5c
	dc.b	$63,$6b,$73,$7b
MoveTabEnd:

;*****************************************************************************
;*				COPPERLIST				     *
;*****************************************************************************

	cnop	0,8					; ausgerichtet auf 64 bit

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP

; Hinweis: Die ddfstart / stop HIRES wren $003c und $00d4, jedoch mit aktivem Burst
; Der gleiche Wert wie bei LOWRES ist in Ordnung, dh $0038 und $00d0.

	dc.w	$92,$0038			; DDFSTRT
	dc.w	$94,$00d0			; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2
	dc.w	$108,-8				; BPL1MOD (burst 64bit, modulo=modulo-8)
	dc.w	$10a,-8				; BPL2MOD (wie oben)

				; 5432109876543210
	dc.w	$100,%0000001000010001	; 8 Bitplane Lores 640x256. Zum
					; Setzen von 8 planes, Bit 4 setzen
					; Bit 12,13,14 zurcksetzen. Bit 0 ist gesetzt,
					; da es viele AGA-Funktionen ermglicht
					; die wir spter sehen werden.

	dc.w	$1fc,3				; Burst mode 64 bit

Bplpointers:
	dc.w	$e0,0,$e2,0			; erste 	Bitplane
	dc.w	$e4,0,$e6,0			; zweite	   "
	dc.w	$e8,0,$ea,0			; dritte	   "
	dc.w	$ec,0,$ee,0			; vierte	   "
	dc.w	$f0,0,$f2,0			; fnfte	   "
	dc.w	$f4,0,$f6,0			; sechste	   "
	dc.w	$f8,0,$fa,0			; siebte	   "
	dc.w	$fc,0,$fe,0			; achte		   "

; In diesem Fall wird die Palette durch eine Routine aktualisiert, daher
; reicht es aus, die Registerwerte gelscht zu lassen.

	dc.w	$106,$c00	; Auswahl Palette 0 (0-31), Nibble hoch
ColP0:
	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$e00	; Auswahl Palette 0 (0-31), Nibble niedrig
ColP0b:
	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$2c00	; Auswahl Palette 1 (32-63), Nibble hoch

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$2e00	; Auswahl Palette 1 (32-63), Nibble niedrig

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$4c00	; Auswahl Palette 2 (64-95), Nibble hoch

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$4e00	; Auswahl Palette 2 (64-95), Nibble niedrig

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$6c00	; Auswahl Palette 3 (96-127), Nibble hoch

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$6e00	; Auswahl Palette 3 (96-127), Nibble niedrig

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$8c00	; Auswahl Palette 4 (128-159), Nibble hoch

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$8e00	; Auswahl Palette 4 (128-159), Nibble niedrig

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$ac00	; Auswahl Palette 5 (160-191), Nibble hoch

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$ae00	; Auswahl Palette 5 (160-191), Nibble niedrig

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$cc00	; Auswahl Palette 6 (192-223), Nibble hoch

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$ce00	; Auswahl Palette 6 (192-223), Nibble niedrig

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$ec00	; Auswahl Palette 7 (224-255), Nibble hoch

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$ee00	; Auswahl Palette 7 (224-255), Nibble niedrig

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

AgaCon1:
	dcb.l	200*2		; d.h.: 200 Zeilen * 2 long:
						; 1 fr wait,
						; 1 fr BPLCON1

	dc.w	$ffff,$fffe	; Ende Copperlist

;******************************************************************************

; Bild RAW mit 8 bitplanes, das sind 256 Farben

	cnop	0,8	; auf 64 Bit ausrichten

Picture:
	incbin	"/Sources/MURALE320x256x256c.raw"

	end

Die Striche, die sich von Zeit zu Zeit links erheben, sind ein Rtsel.
Da die Routine funktioniert, glaube ich, dass es ein Fehler in der
Amiga-Hardware ist!

