
; Listing15g1.s		- AGA Scroll von Bitplanes in Schritten von 1/4 Pixel,
; fr maximal 64 Pixel. 

; HINWEIS: Die 2 hohen Bits des Scrolls, welche das "Einrasten" von 16 oder 32 Pixel ermglichen.
; Fr maximal 64 Pixel Bildlauf funktionieren sie nur, wenn der Burst-Modus aktiviert ist
; bei 64 Pixel (durch Setzen der 2 niedrigen Bits von FMODE, dh $dff1fc).


	SECTION	AGARULEZ,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup2.s"	; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001110000000	; Copper, Bitplane DMA

WaitDisk	equ	30				; 50-150 zur Rettung (je nach Fall)

Start:
	move.l	#Picture,d0			; Zeiger auf das AGA-Bild
	lea	EvenBplPt,a1			; Zeiger in Copperlist
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

	bsr.w	MakeMoveTab			; Diese einfache Routine macht eine Tabelle
								; mit Werten von 0 bis 255, dann zurck zu 0

	bsr.w	FineScrollC			; Diese Routine "konvertiert" die Dezimalwerte
								; in Bildlaufwerte fr die BPLCON1 AGA

	lea	$dff000,a5
	move.w	#DMASET,$96(a5)		; DMACON - aktivieren Bitplane, Copper
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; Fmode zurcksetzen, burst normal
	move.w	#$c00,$106(a5)		; BPLCON3 zurcksetzen
	move.w	#$11,$10c(a5)		; BPLCON4 zurcksetzen

Mouse:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$11000,d2			; warte auf Zeile $110
WarteY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l	d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l	d2,d0				; warte auf Zeile $110
	bne.s	WarteY1

	bsr.w	Wabble

	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$11000,d2			; warte auf Zeile $110
WarteY2:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l	d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l	d2,d0				; warte auf Zeile $110
	beq.s	WarteY2

	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse
	rts

******************************************************************************
; Diese Routine macht eine Tabelle mit "Dezimal"-Werten von 0-255-0
******************************************************************************

NUMVAL = 255					; Der neue BPLCON1 kann von 0 bis 255 gehen, 
								; lass es uns benutzen!

MakeMoveTab:
	lea	MovTab(pc),a0			; Tab Werte playfield 1
	moveq	#0,d0				; MINIMUM PLAYFIELD 1 : 0
	move.l	#NUMVAL,d1			; MAXIMUM : 255
AmtLoop:
	move.w	d0,(a0)+			; Wert playfield 1
	addq.l	#1,d0				; addiere 1 zum Wert playfield 1
	cmp.l	d1,d0				; pf1=numval? (dann pf2=null)
	bne.s	AmtLoop				; Wenn noch nicht, weiter machen
AmtLoop2:
	move.w	d0,(a0)+			; Wert Pf1 - (Ziffer auf 0)
	subq.l	#1,d0				; Sub Wert Pf1
	bne.s	AmtLoop2			; d0=null? (flag Z) - wenn noch nicht loop!
	rts

MovTab:
	dcb.w	NUMVAL*2,0			; *2 weil es Worte sind
MoveTabEnd:


******************************************************************************
; Routine, die von "Dezimalzahlen" in Werte fr die BPLCON1 AGA konvertiert.
; In der Praxis wird die 8-Bit-Nummer durch Positionieren der Bits gem der
; Diagramm der BPLCON1 aga:
;
;	15	64 PIXEL Scroll PF2 (AGA)
;	14 	64 PIXEL Scroll PF2 (AGA)
;	13 	ENDE Scroll PF2 (AGA Scroll 35ns 1/4 of pixel)
;	12 	ENDE Scroll PF2
;	11 	64 PIXEL Scroll PF1 (AGA)
;	10 	64 PIXEL Scroll PF1 (AGA)
;	09 	ENDE Scroll PF1 (AGA Scroll 35ns 1/4 of pixel)
;	08	ENDE Scroll PF1
;	07	PF2H3
;	06	PF2H2
;	05	PF2H1
;	04	PF2H0
;	03	PF1H3
;	02	PF1H2
;	01	PF1H1
;	00	PF1H0

******************************************************************************

FineScrollC:
	lea	MovTab(pc),a0			; Tab Wert playfield 2
	lea	Con1Values(pc),a1		; Tab Ziel fr $DFF002
	lea	MoveTabEnd(pc),a2		; Ende der Tabelle
ConvLoop:
	moveq	#0,d1
	move.w	(a0)+,d1			; Wert "DEZIMAL" PF1 in d1
	move.w	d1,d2				; Kopie Wert 1 in d2
	move.w	d1,d4				; Kopie Wert 1 in d4
;
	and.w	#%11,d1				; Auswahl bits 0-1 (Scroll 1/4 und 1/2 pixel)
	lsl.w	#8,d1				; an die richtige Position verschieben: bit 8 und 9
	move.w	d1,d3				; speichern in d3
;		
	and.w	#%111100,d2			; die alten 4 bit des Scrolls auswhlen auf 1
								; pixel, max 16 pixel.
	lsr.w	#2,d2				; an die richtige Position verschieben: ersten 4 bits!
	or.w	d2,d3				; speichern in d3
;
	and.w	#%11000000,d4		; hohe Bits auswhlen: Aufnahmen von 16/32 Pixel
	lsl.w	#4,d4				; Richtiger Ort: Bits 10 & 11 fr PF1
	or.w	d4,d3				; speichern in d3

	move.w	d3,(a1)+			; endgltigen BPLCON1-Wert speichern
	cmp.l	a0,a2				; Ende der Tabelle?
	bne.s	ConvLoop			; Wenn noch nicht, Konvertierung fortsetzen!
	rts

; Tabelle mit Endwerten fr $dff102 (BPLCON1)

Con1Values:
	dcb.w	NUMVAL*2,0
Con1ValuesEnd:

******************************************************************************
; Routine, die die Werte aus der Tabelle Con1Values in BPLCON1 in die
; Copperliste kopiert. Sobald Sie die gesamte Tabelle gelesen hat, stoppt sie.
******************************************************************************

Wabble:
	tst.w	Flag				; sind wir mit der Tabelle fertig?
	beq.s	Exit				; wenn ja, exit!
	move.l	Con1TabPointer(pc),a0	; Con1TabPointer in a0
	move.w	(a0)+,ScrlVal		; Kopie Wert in Copperlist
	cmp.l	#Con1ValuesEnd,a0	; sind wir am Ende der Tabelle?
	bne.s	Okay				; Wenn noch nicht, ok
	clr.w	Flag				; Ansonsten bedeutet es, dass wir fertig sind
Okay:
	lea	Con1TabPointer(pc),a0	; Con1TabPointer in a0
	addq.l	#2,(a0)				; zum nchsten Wert gehen
Exit:
	rts

Flag:
	dc.w	-1

Con1TabPointer:
	dc.l	Con1Values

*************************************************************************
;			COPPERLIST AGA
*************************************************************************

	cnop	0,8

		SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP
	dc.w	$92,$0038			; DDFSTRT
	dc.w	$94,$00d0			; DDFSTOP

	dc.w	$102				; BPLCON1
ScrlVal:
	dc.w	0					; Wert BPLCON1 - von der Routine gendert

	dc.w	$104,0				; BPLCON2
	dc.w	$108,-8				; BPL1MOD
	dc.w	$10a,-8				; BPL2MOD

	dc.w	$1fc,3				; Burst mode 64bit - Hinweis: Die hohen Bits von
								; BPLCON1, die das ruckartige Scrollen von 16 oder 32 Pixel 
								; ermglichen, funktionieren nur, wenn der
								; Burst 32 bzw. 64 Bit ist.

EvenBplPt:
	dc.w	$e0,0,$e2,0			; Bitplane  0

			    ; 5432109876543210
	dc.w	$100,%0001001000000001	; 1 Bitplane LOWRES 320x256.

	dc.w	$106,$C00			; Nibble hoch
	dc.w	$180,$001			; COLOR00 REGISTER
	dc.w	$182,$081			; COLOR01 REGISTER
	dc.w	$106,$200			; Nibble niedrig
	dc.w	$180,$124			; COLOR00 REGISTER
	dc.w	$182,$567			; COLOR01 REGISTER

	dc.w	$ffff,$fffe			; Ende Copperlist

*************************************************************************
;			   BITPLANES
*************************************************************************

	cnop	0,8

Picture:
	dcb.b	40*256,%00000111

	end

    


