
; Listing15f5.s		UniMoveSprite-Routine zum Scrollen von AGA horizontal
; in Schritten von 1/4 Pixel verbessert. Mit einer Tabelle
; machen wir die grere Scrollfhigkeit deutlicher.

	SECTION	AGARULEZ,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup2.s"	; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001110100000	; Copper, Bitplane, Sprite DMA

WaitDisk	equ	30	; 50-150 zur Rettung (je nach Fall)

Start:
	move.l	#Bitplane,d0	
	lea	Bplpointers,a1			; Zeiger in Copperlist
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

;	alle Sprites zeigen auf das Null-Sprite 

	move.l	#SpriteNull,d0		; Adresse des Sprites in d0
	lea	SpritePointers,a1		; Zeiger in Copperlist
	moveq	#8-1,d1				; alle 8 Sprites
NulLoop:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	addq.w	#8,a1
	dbra	d1,NulLoop

;	Zeiger auf Sprite

	move.l	#MeinSprite64,d0		; Adresse des Sprites in d0
	lea	SpritePointers,a1		; Zeiger in Copperlist
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

	move.w	#DMASET,$96(a5)		; DMACON - aktivieren Bitplane, Copper
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; Fmode zurcksetzen, burst normal
	move.w	#$c00,$106(a5)		; BPLCON3 zurcksetzen
	move.w	#$11,$10c(a5)		; BPLCON4 zurcksetzen

Mouse:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$12000,d2			; warte auf Zeile $120
WaitY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l	d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l	d2,d0				; warte auf Zeile $120
	bne.s	WaitY1

	bsr.s	MoveSpriteX			; liest aus der Tabelle und bewegt das Sprite

	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$12000,d2			; warte auf Zeile $120
WaitY2:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l	d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l	d2,d0				; warte auf Zeile $120
	beq.s	WaitY2

	btst.b	#2,$dff016		; rechte Maustaste gedrckt?
	bne.s	DoNotChangeRes	; Wenn nicht, ndern Sie das Ergebnis des Sprites nicht

	bchg.b	#7,BplCon3		; Wenn ja, wechseln Sie von LowRes zu Hires oder umgekehrt.

DoNotChangeRes:
	btst.b	#6,$bfe001		; linke Maustaste gedrckt?
	bne.s	Mouse
	rts

MoveSpriteX:
	addq.l	#2,TabXpoint		; auf das nchste Wort zeigen
	move.l	TabXpoint(pc),a0	; Adresse in langem TabXpoint enthalten
								; kopiert nach a0
	cmp.l	#EndeTabX-2,a0		; sind wir beim letzten Wort der TAB?
	bne.s	NobStartX			; noch nicht? dann weiter
	move.l	#TabX-2,TabXpoint	; wir beginnen bei dem ersten word-2
NobStartX:
	moveq	#0,d1				; zurcksetzen d0
	move.w	(a0),d1				; wir setzen den Wert der Tabelle in d0
;	add.w	#128*4,d1			; 128*4 - um das Sprite zu zentrieren.
	moveq	#100,d0				; Position Y
	moveq	#52,d2				; Hhe Sprite
	lea	MeinSprite64,a1			; Adresse Sprite
	bsr.w	UniMoveSprite64F	; universelle Routine aufrufen
	rts

TabXpoint:
	dc.l	TabX-2		; HINWEIS: Die Werte in der Tabelle hier sind Wrter.

; Hier erfahren Sie, wie Sie die Tabelle bekommen:

;							___1280
; DEST> tabx	           /   \ 640 (1280/2)
; BEG> 0		      \___/     0
; end> 360
; AMOUNT> 150*4
; AMPLITUDE> (1280-64*4)/2	; Amplitude sowohl ber Null als auch unter Null
							; es muss halb ber und halb unter Null sein,
							; Das heit, wir teilen die Amplitude durch 2
; YOFFSET> (1280-64*4)/2	; und wir bewegen alles nach oben
; SIZE (B/W/L)> w
; MULTIPLIER> 1

TabX:
	dc.w	$0203,$0208,$020d,$0213,$0218,$021d,$0223,$0228,$022e,$0233
	dc.w	$0238,$023e,$0243,$0248,$024d,$0253,$0258,$025d,$0263,$0268
	dc.w	$026d,$0272,$0278,$027d,$0282,$0287,$028c,$0291,$0297,$029c
	dc.w	$02a1,$02a6,$02ab,$02b0,$02b5,$02ba,$02bf,$02c4,$02c9,$02ce
	dc.w	$02d3,$02d8,$02dc,$02e1,$02e6,$02eb,$02f0,$02f4,$02f9,$02fe
	dc.w	$0302,$0307,$030c,$0310,$0315,$0319,$031e,$0322,$0326,$032b
	dc.w	$032f,$0333,$0338,$033c,$0340,$0344,$0348,$034d,$0351,$0355
	dc.w	$0359,$035d,$0360,$0364,$0368,$036c,$0370,$0373,$0377,$037b
	dc.w	$037e,$0382,$0385,$0389,$038c,$0390,$0393,$0396,$0399,$039d
	dc.w	$03a0,$03a3,$03a6,$03a9,$03ac,$03af,$03b2,$03b5,$03b7,$03ba
	dc.w	$03bd,$03bf,$03c2,$03c4,$03c7,$03c9,$03cc,$03ce,$03d0,$03d3
	dc.w	$03d5,$03d7,$03d9,$03db,$03dd,$03df,$03e1,$03e3,$03e4,$03e6
	dc.w	$03e8,$03e9,$03eb,$03ec,$03ee,$03ef,$03f1,$03f2,$03f3,$03f4
	dc.w	$03f5,$03f6,$03f7,$03f8,$03f9,$03fa,$03fb,$03fc,$03fc,$03fd
	dc.w	$03fd,$03fe,$03fe,$03ff,$03ff,$03ff,$0400,$0400,$0400,$0400
	dc.w	$0400,$0400,$0400,$0400,$03ff,$03ff,$03ff,$03fe,$03fe,$03fd
	dc.w	$03fd,$03fc,$03fc,$03fb,$03fa,$03f9,$03f8,$03f7,$03f6,$03f5
	dc.w	$03f4,$03f3,$03f2,$03f1,$03ef,$03ee,$03ec,$03eb,$03e9,$03e8
	dc.w	$03e6,$03e4,$03e3,$03e1,$03df,$03dd,$03db,$03d9,$03d7,$03d5
	dc.w	$03d3,$03d0,$03ce,$03cc,$03c9,$03c7,$03c4,$03c2,$03bf,$03bd
	dc.w	$03ba,$03b7,$03b5,$03b2,$03af,$03ac,$03a9,$03a6,$03a3,$03a0
	dc.w	$039d,$0399,$0396,$0393,$0390,$038c,$0389,$0385,$0382,$037e
	dc.w	$037b,$0377,$0373,$0370,$036c,$0368,$0364,$0360,$035d,$0359
	dc.w	$0355,$0351,$034d,$0348,$0344,$0340,$033c,$0338,$0333,$032f
	dc.w	$032b,$0326,$0322,$031e,$0319,$0315,$0310,$030c,$0307,$0302
	dc.w	$02fe,$02f9,$02f4,$02f0,$02eb,$02e6,$02e1,$02dc,$02d8,$02d3
	dc.w	$02ce,$02c9,$02c4,$02bf,$02ba,$02b5,$02b0,$02ab,$02a6,$02a1
	dc.w	$029c,$0297,$0291,$028c,$0287,$0282,$027d,$0278,$0272,$026d
	dc.w	$0268,$0263,$025d,$0258,$0253,$024d,$0248,$0243,$023e,$0238
	dc.w	$0233,$022e,$0228,$0223,$021d,$0218,$0213,$020d,$0208,$0203
	dc.w	$01fd,$01f8,$01f3,$01ed,$01e8,$01e3,$01dd,$01d8,$01d2,$01cd
	dc.w	$01c8,$01c2,$01bd,$01b8,$01b3,$01ad,$01a8,$01a3,$019d,$0198
	dc.w	$0193,$018e,$0188,$0183,$017e,$0179,$0174,$016f,$0169,$0164
	dc.w	$015f,$015a,$0155,$0150,$014b,$0146,$0141,$013c,$0137,$0132
	dc.w	$012d,$0128,$0124,$011f,$011a,$0115,$0110,$010c,$0107,$0102
	dc.w	$00fe,$00f9,$00f4,$00f0,$00eb,$00e7,$00e2,$00de,$00da,$00d5
	dc.w	$00d1,$00cd,$00c8,$00c4,$00c0,$00bc,$00b8,$00b3,$00af,$00ab
	dc.w	$00a7,$00a3,$00a0,$009c,$0098,$0094,$0090,$008d,$0089,$0085
	dc.w	$0082,$007e,$007b,$0077,$0074,$0070,$006d,$006a,$0067,$0063
	dc.w	$0060,$005d,$005a,$0057,$0054,$0051,$004e,$004b,$0049,$0046
	dc.w	$0043,$0041,$003e,$003c,$0039,$0037,$0034,$0032,$0030,$002d
	dc.w	$002b,$0029,$0027,$0025,$0023,$0021,$001f,$001d,$001c,$001a
	dc.w	$0018,$0017,$0015,$0014,$0012,$0011,$000f,$000e,$000d,$000c
	dc.w	$000b,$000a,$0009,$0008,$0007,$0006,$0005,$0004,$0004,$0003
	dc.w	$0003,$0002,$0002,$0001,$0001,$0001,$0000,$0000,$0000,$0000
	dc.w	$0000,$0000,$0000,$0000,$0001,$0001,$0001,$0002,$0002,$0003
	dc.w	$0003,$0004,$0004,$0005,$0006,$0007,$0008,$0009,$000a,$000b
	dc.w	$000c,$000d,$000e,$000f,$0011,$0012,$0014,$0015,$0017,$0018
	dc.w	$001a,$001c,$001d,$001f,$0021,$0023,$0025,$0027,$0029,$002b
	dc.w	$002d,$0030,$0032,$0034,$0037,$0039,$003c,$003e,$0041,$0043
	dc.w	$0046,$0049,$004b,$004e,$0051,$0054,$0057,$005a,$005d,$0060
	dc.w	$0063,$0067,$006a,$006d,$0070,$0074,$0077,$007b,$007e,$0082
	dc.w	$0085,$0089,$008d,$0090,$0094,$0098,$009c,$00a0,$00a3,$00a7
	dc.w	$00ab,$00af,$00b3,$00b8,$00bc,$00c0,$00c4,$00c8,$00cd,$00d1
	dc.w	$00d5,$00da,$00de,$00e2,$00e7,$00eb,$00f0,$00f4,$00f9,$00fe
	dc.w	$0102,$0107,$010c,$0110,$0115,$011a,$011f,$0124,$0128,$012d
	dc.w	$0132,$0137,$013c,$0141,$0146,$014b,$0150,$0155,$015a,$015f
	dc.w	$0164,$0169,$016f,$0174,$0179,$017e,$0183,$0188,$018e,$0193
	dc.w	$0198,$019d,$01a3,$01a8,$01ad,$01b3,$01b8,$01bd,$01c2,$01c8
	dc.w	$01cd,$01d2,$01d8,$01dd,$01e3,$01e8,$01ed,$01f3,$01f8,$01fd
EndeTabX:


; Universelle Positionierungsroutine fr Sprites mit einer Breite von 64 pixel, mit
; Position X von 0 bis 1280, wobei der neue 1/4 Pixel AGA-Scroll verwendet wird

;
;	Eingehende Parameter von UniMoveSprite64F:
;
;	a1 = Adresse des Sprites
;	d0 = vertikale Y-Position des Sprites auf dem Bildschirm (0-1280)
;	d1 = horizontale X-Position des Sprites auf dem Bildschirm (0-320)
;	d2 = Hhe des Sprites
;

UniMoveSprite64F:
; vertikale Platzierung
	add.w	#$2c,d0		; Versatz des Bildschirmanfangs hinzufgen

; a1 enthlt die Adresse des Sprites
	move.b	d0,(a1)			; Kopie byte in Vstart
	btst.l	#8,d0
	beq.s	NichtVstartSet
	bset.b	#2,3+4+2(a1)	; Bit 8 von Vstart setzen (Nummer > $FF)
	bra.s	ToVstop
NichtVstartSet:
	bclr.b	#2,3+4+2(a1)	; Bit 8 von Vstart zurcksetzen (Nummer < $FF)
ToVstop:
	add.w	d2,d0			; die Hhe des Sprites hinzufgen
							; Bestimmen der Endposition (Vstop)
	move.b	d0,2+4+2(a1)	; den richtigen Wert in Vstop verschieben
	btst.l	#8,d0
	beq.s	NichtVstopSet
	bset.b	#1,3+4+2(a1)	; Bit 8 von Vstop setzen  (Nummer > $FF)
	bra.w	VstopEnde
NichtVstopSet:
	bclr.b	#1,3+4+2(a1)	; Bit 8 von Vstop zurcksetzen (Numer < $FF)
VstopEnde:

; horizontale Platzierung - Hier sind die nderungen !!!

	add.w	#128*4,d1		; 128*4 - um das Sprite zu zentrieren.
	btst.l	#0,d1			; niedriges Bit 0 der X-Koordinate gelscht?
	beq.s	NiederBitNull
	bset.b	#3,3+4+2(a1)	; SH0 - das niedrige Bit von Hstart setzen
	bra.w	PlaceCoords1

NiederBitNull:
	bclr.b	#3,3+4+2(a1)	; das niedrige Bit von Hstart lschen
PlaceCoords1:
	btst.l	#1,d1			; niedriges Bit 1 der X-Koordinate gelscht?
	beq.s	NiederBitNull1
	bset.b	#4,3+4+2(a1)	; SH1 - das niedrige Bit von Hstart setzen
	bra.w	PlaceCoords2

NiederBitNull1:
	bclr.b	#4,3+4+2(a1)	; SH1 - das niedrige Bit von Hstart lschen
PlaceCoords2:
	btst.l	#2,d1			; niedriges Bit 2 der X-Koordinate gelscht?
	beq.s	NiederBitNull2
	bset.b	#0,3+4+2(a1)	; SH2 - das niedrige Bit von Hstart setzen
	bra.w	PlaceCoords3

NiederBitNull2:
	bclr.b	#0,3+4+2(a1)	; SH2 - das niedrige Bit von Hstart lschen
PlaceCoords3:
	lsr.w	#3,d1			; SHIFT, das heit, wir verschieben den Wert von
							; Hstart um 1 Bit nach rechts, um ihn in "umzuwandeln"
							; Wert setzt in das Hstart-Byte, ohne die
							; niedrige 3 Bits.
	move.b	d1,1(a1)		; wir setzen den Wert XX in das Hstart-Byte
	rts

;*****************************************************************************
;*				Copperlist				     *
;*****************************************************************************

	cnop	0,8	; auf 64 Bit ausrichten

	SECTION	GRAPHIC,DATA_C

Copperlist:
SpritePointers:
	dc.w	$120,0,$122,0,$124,0,$126,0,$128,0 ; Sprite
	dc.w	$12a,0,$12c,0,$12e,0,$130,0,$132,0
	dc.w	$134,0,$136,0,$138,0,$13a,0,$13c,0
	dc.w	$13e,0

	dc.w	$8e,$2c81	; DIWSTRT
	dc.w	$90,$2cc1	; DIWSTOP

	dc.w	$92,$0038	; DDFSTRT
	dc.w	$94,$00d0	; DDFSTOP
	dc.w	$102,0		; BPLCON1
	dc.w	$104,0		; BPLCON2
	dc.w	$108,-8		; BPL1MOD (burst 64bit, modulo=modulo-8)
	dc.w	$10a,-8		; BPL2MOD (wie oben)

			    ; 5432109876543210
	dc.w	$100,%0001001000000001	; 1 Bitplane LORES 320x256.

	dc.w	$1fc,%1111	; Burst mode 64 bit, Sprite Gre 64 pixel


Bplpointers:
	dc.w	$e0,0,$e2,0	; erste 	Bitplane
	dc.w	$e4,0,$e6,0	; zweite	   "
	dc.w	$e8,0,$ea,0	; dritte	   "
	dc.w	$ec,0,$ee,0	; vierte	   "
	dc.w	$f0,0,$f2,0	; fnfte	   "
	dc.w	$f4,0,$f6,0	; sechste	   "
	dc.w	$f8,0,$fa,0	; siebte	   "
	dc.w	$fc,0,$fe,0	; achte		   "

; Beachten Sie, dass die Sprite-Farben 24 Bit sind, auch wenn es nur 3 sind.

	dc.w	$106,$c00	; Auswahl Palette 0 (0-31), Nibble hoch
ColP0:
	dc.w	$180,$000	; COLOR00	; schwarzer Hintergrund
	dc.w	$182,$123	; COLOR01	; Farbe 1 der Bitebene, die
									; in diesem Fall leer ist,
									; so erscheint sie nicht.

	dc.w	$1a2,$f00	; COLOR17, das ist COLOR1 von sprite0 - rot
	dc.w	$1a4,$0f0	; COLOR18, das ist COLOR2 von sprite0 - grn
	dc.w	$1a6,$ff0	; COLOR19, das ist COLOR3 von sprite0 - gelb


	dc.w	$106,$e00	; Auswahl Palette 0 (0-31), Nibble niedrig
ColP0b:
	dc.w	$180,$000	; COLOR00	; schwarzer Hintergrund
	dc.w	$182,$000	; COLOR01	; Farbe 1 der Bitebene, die
									; in diesem Fall leer ist,
									; so erscheint sie nicht.

	dc.w	$1a2,$462	; COLOR17, Nibble niedrig
	dc.w	$1a4,$2e4	; COLOR18, Nibble niedrig
	dc.w	$1a6,$672	; COLOR19, Nibble niedrig

	dc.w	$106		; BPLCON3
	dc.b	0
BplCon3:
	       ; 76543210
	dc.b	%00000000	; bit 7: Sprites hires oder lowres. Wenn
		; sowohl Bit 7 als auch Bit 6 gesetzt sind ist das Sprite
		; in Superhires (1280x256), aber es kommt viel zu  "eng",
		; ich denke es ist nutzlos, nur hires!

	dc.w	$ffff,$fffe	; Ende Copperlist


;*****************************************************************************
; Hier sind die Sprites: Offensichtlich mssen sie sich im CHIP-RAM befinden!
;*****************************************************************************

	cnop	0,8

SpriteNull:			; Null-Sprite, um in der copperliste auf sie zu zeigen
	dc.l	0,0,0,0		; in nicht verwendeten Zeigern


	cnop	0,8

MeinSprite64:	; Lnge 13*4 Zeilen
Vstart:
	dc.b $50	; Vertikale Sprite-Startposition ($2c bis $f2)
Hstart:
	dc.b $90	; Horizontale Sprite-Startposition ($40 bis $d8)
	dc.w 0		; word + longword hinzugefgt, um das Doppelte zu erreichen
	dc.l 0		; longword fr Sprite Gre 64 pixel (2 long!)
Vstop:
	dc.b $5d	; $50+13=$5d	; vertikale Position des Endsprites
Vhbits:
	dc.b $00	; bit
	dc.w 0		; word + longword hinzugefgt, um das Doppelte zu erreichen
	dc.l 0		; longword fr Sprite Gre 64 pixel (2 long!)

	dc.l	$00000000,$00000000,$00003000,$000c0000 ; gespeichert mit PicCon
	dc.l	$00000000,$00000000,$00003800,$001c0000
	dc.l	$00000000,$00000000,$00001c00,$00380000
	dc.l	$00000000,$00000000,$00000e00,$00700000
	dc.l	$00000000,$00000000,$00000700,$00e00000
	dc.l	$00000000,$00000000,$00000380,$01c00000
	dc.l	$00000000,$00000000,$000001c0,$03800000
	dc.l	$00000000,$00000000,$000000e0,$07000000
	dc.l	$00000000,$00000000,$00000070,$0e000000
	dc.l	$00000000,$00000000,$00000038,$1c000000
	dc.l	$00000000,$00000000,$00000038,$1c000000
	dc.l	$00000000,$00000000,$0000001c,$38000000
	dc.l	$0000000f,$f0000000,$000f001f,$f800f000
	dc.l	$0000003f,$fc000000,$003f003f,$fc00fc00
	dc.l	$0000007f,$fe000000,$007c007f,$fe003e00
	dc.l	$000000ff,$ff000000,$00f800ff,$ff001f00
	dc.l	$000001ff,$ff800000,$01f001ff,$ff800f80
	dc.l	$000003ff,$ffc00000,$03e003ff,$ffc007c0
	dc.l	$000007ff,$ffe00000,$07c007ff,$ffe003e0
	dc.l	$00000fff,$fff00000,$0f800fff,$fff001f0
	dc.l	$00001fff,$fff80000,$1f001c3f,$fc3800f8
	dc.l	$00003fff,$fffc0000,$3e00381f,$f81c007c
	dc.l	$00003fff,$fffc0000,$7c00300f,$f00c003e
	dc.l	$00007fff,$fffe0000,$fc00700f,$f00e003f
	dc.l	$00007f8f,$f1fe0000,$fffff00f,$f00fffff
	dc.l	$00007f0f,$f0fe0000,$fffff00f,$f00fffff
	dc.l	$00007f0f,$f0fe0000,$fffff80f,$f01fffff
	dc.l	$00007f1f,$f8fe0000,$7ffffc1f,$f83ffffe
	dc.l	$00003fff,$fffc0000,$00003fff,$fffc0000
	dc.l	$00003fff,$fffc0000,$00003fff,$fffc0000
	dc.l	$00001fff,$fff80000,$00007fff,$fffe0000
	dc.l	$00001fff,$fff80000,$0000ffff,$ffff0000
	dc.l	$00000fff,$fff00000,$0001ff80,$01ff8000
	dc.l	$00000fff,$fff00000,$0003ffc0,$03ffc000
	dc.l	$000007ff,$ffe00000,$0007ffe0,$07ffe000
	dc.l	$000003ff,$ffc00000,$0007fff0,$0fffe000
	dc.l	$000001ff,$ff800000,$000ff1ff,$ff8ff000
	dc.l	$000001ff,$ff800000,$001fe1ff,$ff87f800
	dc.l	$000000ff,$ff000000,$003fc0ff,$ff03fc00
	dc.l	$0000007f,$fe000000,$003fc07f,$fe03fc00
	dc.l	$0000003f,$fc000000,$007f803f,$fc01fe00
	dc.l	$0000001f,$f8000000,$007f801f,$f801fe00
	dc.l	$0000000f,$f0000000,$00ff000f,$f000ff00
	dc.l	$00000003,$c0000000,$00ff0003,$c000ff00
	dc.l	$00000000,$00000000,$03fe0000,$00007fc0
	dc.l	$00000000,$00000000,$0ffe0000,$00007ff0
	dc.l	$00000000,$00000000,$3ffe0000,$00007ffc
	dc.l	$00000000,$00000000,$7fff0000,$0000fffe
	dc.l	$00000000,$00000000,$ffff0000,$0000ffff
	dc.l	$00000000,$00000000,$ffff8000,$0001ffff
	dc.l	$00000000,$00000000,$ffff8000,$0001ffff
	dc.l	$00000000,$00000000,$ffff8000,$0001ffff

	dc.l	0,0,0,0		; Ende Sprite (2 doppelte longword).

	cnop	0,8

	SECTION	LEEREPLANE,BSS_C	; Die von uns verwendete Reset-Bitebene,
								; weil um die Sprites zu sehen
								; muss es aktivierte Bitebenen geben

Bitplane:
	ds.b	40*256		; Bitplane leer lowres

	end

Beachten Sie, dass ein solcher Bildlauf auf MSDOS-PCs nicht mglich ist und 
auch nicht auf dem Super Nintendo, ganz zu schweigen von der Sega Megadrive ...

