
; Listing15c5.s		24-Bit-Fade in Echtzeit, nicht vorberechnet

	SECTION	AGARULEZ,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup2.s"	; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001110000000	; Copper, Bitplane DMA

WaitDisk	equ	30				; 50-150 zur Rettung (je nach Fall)

Start:
	move.l	#Picture,d0			; Zeiger auf das AGA-Bild
	lea	Bplpointers,a1	
	moveq	#8-1,d7				; Anzahl Bitplanes -1
PointBp:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	addi.l	#10240,d0			; Lnge Bitplane
	addq.w	#8,a1
	dbra	d7,PointBp			; d7-mal wiederholen (d7= Anzahl Bitplanes)

	move.w	#DMASET,$96(a5)		; DMACON - aktivieren Bitplane, Copper
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; Fmode zurcksetzen, burst normal
	move.w	#$c00,$106(a5)		; BPLCON3 zurcksetzen
	move.w	#$11,$10c(a5)		; BPLCON4 zurcksetzen

Mouse:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$08000,d2			; warte auf Zeile $80
WaitY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l	d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l	d2,d0				; warte auf Zeile $80
	bne.s	WaitY1

	bsr.s	MainFadeInOut		; Routine, die von schwarz zu Vollfarbe bergeht
								; und umgekehrt.

	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$08000,d2			; warte auf Zeile $80
WaitY2:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l	d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l	d2,d0				; warte auf Zeile $80
	beq.s	WaitY2

	btst	#6,$bfe001			; Maus gedrckt?
	bne.s	Mouse
	rts
	
*****************************************************************************
* Diese Routine erhht oder verringert den Multiplier fr das Ein- und		*
* Ausblenden. Das FlagFadeInOut wird verwendet, um zu berprfen,			*
* ob die berblendung ein- oder ausgeht.									*
*****************************************************************************

MainFadeInOut:
	bsr.w	CalColCopl ; Berechnen der 256 Farben in diesem Schritt des Fade
	; konvertiert sie in Abhngigkeit des Multiplier und konvertiert sie
	; in die Wrter fr die AGA Copperliste und kopiert sie
	; in der Copperliste selbst.

	btst.b	#1,FlagFadeInOut	; Fade In oder fade Out?
	bne.s	FadeOut
FadeIn:
	addq.w	#1,Multiplier		; Nchste Phase der berblendung (heller)
	cmp.w	#255,Multiplier		; sind wir zu maximaler Helligkeit 
								; des Verblassens angekommen? (Volle und helle Farben)
	bne.s	Finished			; Wenn noch nicht, -> unvollendet, -> Finished
	bchg.b	#1,FlagFadeInOut	; Andernfalls ndern Sie die Richtung der berblendung
FadeOut:
	subq.w	#1,Multiplier		; Nchste Phase der berblendung (dunkler)
	bne.w	Finished			; multiplier=null? Wenn noch nicht -> Nonfinito
	bchg.b	#1,FlagFadeInOut	; Andernfalls ndern Sie die Richtung der berblendung
Finished:
	rts

FlagFadeInOut:					; Wird verwendet, um zu entscheiden, ob FadeIn oder FadeOut
	dc.w	0

Multiplier:
	dc.w	0

Temporary:
	dc.l	0

******************************************************************************
* Diese Routine konvertiert Farben in 24-Bit, was wie ein Langwort $00RrGgBb *
* aussieht, (wobei R = ROT hohes nibble, r = ROT niedriges nibble,			 *
* G = hohes nibble von GRN usw.) im Format der copperliste aga, d.h.		 *
* in zwei Worten: $0RGB mit hohen nibbles und $0rgb mit niedrigen nibbles.   *
******************************************************************************

CalColCopl:
	lea	Temporary(pc),a0 		; Long temporr fr Farbe bei 24
								; Bit im Format $00RrGgBb
	lea	ColP0+2,a1				; Adresse des ersten Registers
								; auf hohes nibble eingestellt
	lea	ColP0b+2,a2				; Adresse des ersten Registers
								; auf niedriges nibble eingestellt
	lea	PalettePic(pc),a3		; 24bit colors tab address

	moveq	#8-1,d7				; 8 Banken mit jeweils 32 Registern
ConvPaletteBank:
	moveq	#0,d0
	moveq	#0,d2
	moveq	#0,d3
	moveq	#32-1,d6			; 32 Farbregister pro Bank

ConvLongReg:					; Schleife, die die Farben $00RrGgBb.l in die 2 
								; Wrter $0RGB, $0rgb geeignet fr 
								; Copperregister umwandelt.

;	blau berechnen

	move.l	(a3),d4				; read color from tab
	andi.l	#%000011111111,d4	; select blue
	mulu.w	multiplier(pc),d4	; multiplier
	asr.w	#8,d4				; -> 8 bits
	andi.l	#%000011111111,d4	; select blue val
	move.l	d4,d5				; save blue to d5

;	grn berechnen

	move.l	(a3),d4				; read color from tab
	andi.l	#%1111111100000000,d4	; select green
	lsr.l	#8,d4				; -> 8 bits (so from 0 to 7)
	mulu.w	multiplier(pc),d4	; multiplier
	asr.w	#8,d4				; -> 8 bits
	andi.l	#%0000000011111111,d4	; select green
	lsl.l	#8,d4				; <- 8 bits (so from 8 to 15)
	or.l	d4,d5				; save green to d5

;	rot berechnen

	move.l	(a3)+,d4			; read color from tab and go to next
	andi.l	#%111111110000000000000000,d4	; select red
	lsr.l	#8,d4				; -> 8 bits (so from 8 to 15)
	lsr.l	#8,d4				; -> 8 bits (so from 0 to 7)
	mulu.w	multiplier(pc),d4	; multiplier
	asr.w	#8,d4				; -> 8 bits
	andi.l	#%0000000011111111,d4	; select red
	lsl.l	#8,d4				; <- 8 bits (so from 8 to 15)
	lsl.l	#8,d4				; <- 8 bits (so from 0 to 7)
	or.l	d4,d5				; save red to d5
	move.l	d5,(a0)				; save 24 bit value in temporaneo


; Konvertieren niedriger Nibbles von $00RrGgBb (long) in die Farbe AGA $0rgb (Word)

	move.b	1(a0),(a2)			; Hohes Byte der Farbe $00Rr0000 kopiert
								; in das Cop-Register fr niedriges nibble
	andi.b	#%00001111,(a2)		; auswhlen nur niedriges nibble ($0r)
	move.b	2(a0),d2			; Byte $0000Gg00 aus der 24-Bit-Farbe nehmen
	lsl.b	#4,d2				; verschiebt das niedrige Halbbyte um 4 Bit nach links
								; des GRNEN, "umwandeln" in ein hohes nibble
								; des niedrigen Bytes von d2 ($g0)
	move.b	3(a0),d3			; Byte $000000Bb aus der 24-Bit-Farbe nehmen
	andi.b	#%00001111,d3		; auswhlen nur niedriges nibble ($0b)
	or.b	d2,d3				; "MISCHEN" der niedrigen nibble von grn und blau...
	move.b	d3,1(a2)			; Bilden des nachfolgenden Low-Bytes $gb zum Setzen
								; im Farbregister nach dem Byte $0r fr
								; das word $0rgb der niedrigen nibble

; Konvertieren hohe Nibbles von $00RrGgBb (long) in die Farbe AGA $0RGB (word)

	move.b	1(a0),d0			; Hohes Byte der Farbe $00Rr0000 in d0
	andi.b	#%11110000,d0		; auswhlen nur hohes nibble ($R0)
	lsr.b	#4,d0				; verschiebt das nibble um 4 Bit nach rechts, also
								; dadurch wird es zum Low-Byte-Nibble ($0R).
	move.b	d0,(a1)				; das High-Byte $0R in das Farbregister kopieren
	move.b	2(a0),d2			; das Byte $0000Gg00 aus der 24-Bit-Farbe nehmen
	andi.b	#%11110000,d2		; auswhlen nur hohes nibble ($G0)
	move.b	3(a0),d3			; das Byte $000000Bb aus der 24-Bit-Farbe nehmen
	andi.b	#%11110000,d3		; auswhlen nur hohes nibble ($B0)
	lsr.b	#4,d3				; verschiebt es um 4 Bit nach rechts
								; dadurch wird es zum Low-Byte-Nibble d3 ($0B)
	or.b	d2,d3				; Mischen der hohen nibble von Grn und Blau ($G0+$0B)
	move.b	d3,1(a1)			; Bilden des letzten Low-Bytes $GB zum Setzen
								; im Farbregister nach dem Byte $0R fr
								; das Wort $0RGB der hohen nibble

	addq.w	#4,a1				; zum nchsten Farbregister springen
								; fr hohes nibble in Copperlist
	addq.w	#4,a2				; zum nchsten Farbregister springen
								; fr niedriges nibble in Copperlist

	dbra	d6,ConvLongReg

	add.w	#(128+8),a1			; Farbregister berspringen + dc.w $106,xxx
								; des hohen nibble
	add.w	#(128+8),a2			; Farbregister berspringen + dc.w $106,xxx
								; des niedrigen nibble

	dbra	d7,ConvPaletteBank	; Konvertiert eine Bank mit 32 Farben von
	rts							; Schleife. 8 Schleifen fr 256 Farben.

; Tabelle mit der 24-Bit-Palette im Format $00RRGGBB. Wir htten genauso gut 
; die am unteren Rand des PIC angebrachte verwenden knnen, 
; aber um hier zu variieren, ist sie in dc.l!
; Sie knnen sie von PicCon speichern, wenn sie nicht "Copperlist" auswhlen.


PalettePic:
	dc.l	$021104,$150f04,$001115,$191609,$092206,$182707
	dc.l	$052420,$2f1506,$17291c,$1f3108,$341613,$35230b
	dc.l	$1c331c,$2c3409,$00203d,$35241f,$323420,$21470a
	dc.l	$103937,$4a2007,$47201b,$243a32,$002a4a,$35440d
	dc.l	$492822,$443c0a,$21550a,$54280b,$483421,$3a3931
	dc.l	$07364f,$233e45,$1d4d3c,$32590c,$01335d,$27503d
	dc.l	$484f11,$5a3e0e,$354e3c,$5c3921,$593431,$70230e
	dc.l	$4c5b12,$064066,$5b442c,$5d4d11,$465a30,$104367
	dc.l	$732e11,$316143,$5b4838,$324662,$506714,$763b0f
	dc.l	$704023,$655711,$4d5d44,$733f31,$19536e,$8a2012
	dc.l	$2b6261,$6c552e,$784f19,$0d4c7d,$79492e,$8f2713
	dc.l	$716217,$6c612b,$455e61,$8f370f,$1b5081,$705845
	dc.l	$716e16,$943c17,$516463,$8b4e1f,$1e5f83,$8f510f
	dc.l	$746d2d,$89512e,$588a24,$776a45,$8c631d,$8e5e2f
	dc.l	$72635d,$8c5644,$b02015,$1d6791,$aa3c15,$af2d14
	dc.l	$8d7419,$2b6d90,$a1552d,$788a2a,$a25f13,$936d31
	dc.l	$ac4e13,$6e7071,$3a7192,$bd2a16,$878b1e,$a1672e
	dc.l	$926f47,$a46e13,$5d8e67,$8d7054,$a06546,$2f739f
	dc.l	$a37331,$c92b16,$b66110,$8e8b3b,$818d55,$c74013
	dc.l	$3d79a4,$8c7173,$b36e2b,$ba6c11,$ad7244,$a77253
	dc.l	$a58b27,$8f8c60,$a58444,$4489a4,$a59720,$a77661
	dc.l	$cd6214,$ba763e,$a78f41,$db4114,$a48b55,$4589b0
	dc.l	$b87754,$608fa2,$c97728,$8ba268,$d46d10,$c58428
	dc.l	$b8894a,$c88614,$a48c6e,$d86b22,$a59e59,$898f97
	dc.l	$5a94b3,$e46217,$c59427,$c98940,$b99259,$df6a39
	dc.l	$c39443,$c2a025,$a79a74,$da734c,$5595c1,$8c9f95
	dc.l	$c79156,$b99271,$ef6327,$ea7515,$de8b1a,$a89988
	dc.l	$eb7623,$df8d29,$c7a93e,$dd903f,$669ac7,$c5a55b
	dc.l	$c79770,$5da6c8,$f08a18,$d6995f,$ea971a,$dda043
	dc.l	$f3872b,$e1a42d,$caa472,$a8a2a3,$71a7cb,$ef9341
	dc.l	$80a6c6,$caae6f,$f2982a,$c7a287,$f69a1c,$e99959
	dc.l	$d7a86a,$f2a13e,$ccb678,$c6a499,$efb127,$e8b247
	dc.l	$89b2c9,$e5a868,$c8af94,$e2b363,$bcc28f,$f7af2d
	dc.l	$deb577,$8bb1d6,$d1b295,$beb5aa,$f7b34b,$dbb191
	dc.l	$f5b462,$8cb3e3,$f1b375,$d2ba9f,$fdc42f,$dfc189
	dc.l	$fac34a,$87c0e3,$c3c4ae,$a6bbd4,$e2ba94,$fbd232
	dc.l	$f3c967,$98bee4,$f0bf85,$d6c6a4,$fbd24a,$d3baba
	dc.l	$c1bfcd,$e8ce8d,$fdd457,$a3c3e9,$dbd0a8,$d3cbbd
	dc.l	$f0c4a0,$fcdb66,$adcde0,$f7cf8a,$b3c5e9,$dfcebc
	dc.l	$c4d2d8,$feea66,$f3e489,$b5ceeb,$d2ced4,$f5d0a8
	dc.l	$fee885,$f3dfa7,$d8dfca,$c5d2ec,$f5d2bc,$d1d2e7
	dc.l	$ede1c2,$d9d4e7,$fde7aa,$f2d2d5,$f9e2c0,$d2dfef
	dc.l	$e9dedf,$f9f3c4,$f8efda,$f9f5ee

;*****************************************************************************
;*				Copperlist AGA												 *
;*****************************************************************************

	cnop	0,8					; ausgerichtet auf 64 bit

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP
	dc.w	$92,$0038			; DDFSTRT
	dc.w	$94,$00d0			; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2
	dc.w	$108,0				; BPL1MOD
	dc.w	$10a,0				; BPL2MOD

				; 5432109876543210
	dc.w	$100,%0000001000010001	; 8 Bitplane LOWRES 320x256. Zum
								; Setzen von 8 planes, Bit 4 setzen
								; Bit 12,13,14 zurcksetzen. Bit 0 ist gesetzt,
								; da es viele AGA-Funktionen ermglicht
								; die wir spter sehen werden.

	dc.w	$1fc,0				; Burst mode gelscht (vorerst!)

Bplpointers:
	dc.w	$e0,0,$e2,0			; erste 	Bitplane
	dc.w	$e4,0,$e6,0			; zweite	   "
	dc.w	$e8,0,$ea,0			; dritte	   "
	dc.w	$ec,0,$ee,0			; vierte	   "
	dc.w	$f0,0,$f2,0			; fnfte	   "
	dc.w	$f4,0,$f6,0			; sechste	   "
	dc.w	$f8,0,$fa,0			; siebte	   "
	dc.w	$fc,0,$fe,0			; achte		   "

; In diesem Fall wird die Palette durch eine Routine aktualisiert, daher
; reicht es aus, die Registerwerte gelscht zu lassen.

	dc.w	$106,$c00	; Auswahl Palette 0 (0-31), Nibble hoch
ColP0:
	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0


	dc.w	$106,$e00	; Auswahl Palette 0 (0-31), Nibble niedrig
ColP0b:
	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$2c00	; Auswahl Palette 1 (32-63), Nibble hoch

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$2e00	; Auswahl Palette 1 (32-63), Nibble niedrig

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$4c00	; Auswahl Palette 2 (64-95), Nibble hoch

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$4e00	; Auswahl Palette 2 (64-95), Nibble niedrig

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$6c00	; Auswahl Palette 3 (96-127), Nibble hoch

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$6e00	; Auswahl Palette 3 (96-127), Nibble niedrig

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$8c00	; Auswahl Palette 4 (128-159), Nibble hoch

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$8e00	; Auswahl Palette 4 (128-159), Nibble niedrig

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$ac00	; Auswahl Palette 5 (160-191), Nibble hoch

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$ae00	; Auswahl Palette 5 (160-191), Nibble niedrig

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$cc00	; Auswahl Palette 6 (192-223), Nibble hoch

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$ce00	; Auswahl Palette 6 (192-223), Nibble niedrig

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$ec00	; Auswahl Palette 7 (224-255), Nibble hoch

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$ee00	; Auswahl Palette 7 (224-255), Nibble niedrig

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$ffff,$fffe	; Ende Copperlist

;******************************************************************************

; Bild RAW mit 8 Bitplanes, das sind 256 Farben

	cnop	0,8					; auf 64 Bit ausrichten

Picture:
	incbin	"/Sources/MURALE320x256x256c.RAW"

	end

Wir haben das ColTabY eliminiert, und dies kann als "FADE IN REALTIME" bezeichnet
werden, da es Frame fr Frame berechnet wird. Es ist viel langsamer als das 
vorberechnete, bentigt aber kein 256k Puffer. Es kann verwendet werden, wenn
es notwendig ist, eine statische Figur auszublenden oder in jedem Fall, wenn es
keine sehr zeitaufwndigen Routinen gibt. Beachten Sie, dass die Palette von
einer Tabelle stammt, anstatt vom Ende des Bildes.