
; Listing15c3.s		Ein erster Test von AGA 24Bit Fade (berblendung).
; der Fade ist in einer Tabelle vorberechnet.

	SECTION	AGARULEZ,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup2.s"	; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001110000000	; Copper, Bitplane DMA

WaitDisk	equ	30	; 50-150 zur Rettung (je nach Fall)

Start:
	move.l	#Picture,d0			; Zeiger auf das AGA-Bild
	lea	Bplpointers,a1	
	moveq	#8-1,d7				; Anzahl Bitplanes -1
PointBp:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	addi.l	#40*256,d0			; Lnge Bitplane
	addq.w	#8,a1
	dbra	d7,PointBp			; d7-mal wiederholen (d7= Anzahl Bitplanes)

	bsr.w	Fade256PreCalc		; berechnet die Werte der gesamten berblendung vor, 
								; insgesamt 256 Farben. in 256 Schritten von
								; schwarz bis vollfarbig, d.h. 4256256 Bytes
								; der Tabelle: 262144 Bytes vorberechnet !!!

	move.w	#DMASET,$96(a5)		; DMACON - aktivieren Bitplane, Copper
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; Fmode zurcksetzen, burst normal
	move.w	#$c00,$106(a5)		; BPLCON3 zurcksetzen
	move.w	#$11,$10c(a5)		; BPLCON4 zurcksetzen

Mouse:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$11000,d2			; warte auf Zeile $110
WarteY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l	d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l	d2,d0				; warte auf Zeile $110
	bne.s	WarteY1

	bsr.s	MainFadeInOut		; Routine, die von schwarz zu Vollfarbe bergeht
								; und umgekehrt.

	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$11000,d2			; warte auf Zeile $110
WarteY2:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l	d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l	d2,d0				; warte auf Zeile $110
	beq.s	WarteY2

	btst	#6,$bfe001			; Maus gedrckt?
	bne.s	Mouse
	rts


*****************************************************************************
* Diese Routine dreht den Farbzeiger vorwrts oder rckwrts vorberechnetes *
* ActualFadeTab. Wenn die berblendung von Schwarz zur vollen Farbe wechselt*
* fgt es dem Zeiger 256 Langwrter hinzu und zeigt auf die nchsten 256    *
* Farben, dh der nchst dunkelste vorberechnete Rahmen. Im anderen Fall     *
* geht es zurck zum vorherigen Frame. Das Label FlagFadeInOut wird ver-    *
* wendet, um zu berprfen, ob die berblendung ein- oder ausgeschaltet ist.*
*****************************************************************************

MainFadeInOut:
	bsr.w	PutColors			; Ordnen Sie die Farben dieses frames
								; Nehmen Sie sie und konvertieren Sie sie von der Tabelle
								; der vorberechneten berblendung.
	btst.b	#1,FlagFadeInOut	; Fade In oder fade Out?
	bne.s	FadeOut
FadeIn:
	add.l	#256*4,ActualFadeTab	; nchstes Bild (256 color.l)
	lea	ColTabYEnd,a0				; Adresse Tabellenende
	cmp.l	ActualFadeTab(pc),a0	; Sind wir am Ende der Tabelle des
									; Verblassens angekommen? (Volle und helle Farben)
	bne.s	Finished
	bchg.b	#1,FlagFadeInOut		; ndern der Richtung der berblendung
FadeOut:
	sub.l	#256*4,ActualFadeTab	; Vorheriger Schritt (dunkler)
	lea	ColTabY,a0					; Adresse Start Tabelle
	cmp.l	ActualFadeTab(pc),a0	; Sind wir am Anfang des Tabelle des 
									; Verblassens angekommen? (schwarze Farbe)
	bne.w	Finished
	bchg.b	#1,FlagFadeInOut		; ndern der Richtung der berblendung
Finished:
	rts

FlagFadeInOut:					; Wird verwendet, um zu entscheiden, ob FadeIn 
	dc.w	0					; oder FadeOut verwendet werden soll

ActualFadeTab:					; Zeiger auf den vorberechneten "Frame" des
	dc.l	ColTabY				; berblendens in der Tabelle ColTabY.

******************************************************************************
* Diese Routine berechnet alle 24-Bit-Farben der berblendung vor und macht  *
* ziemlich viel, da es 256 * 256 Langwrter schreiben muss, das				 *
* sind 262144 Bytes! Es ist nichts anderes als die Fade-Routine, die fr die * 
* 12-Bit-Farben des normalen Amiga verwendet wird normalerweise,			 *
* nur es nimmt 1 Byte pro RGB-Komponente anstelle von 4 Bit.				 *
******************************************************************************

Fade256PreCalc:
	lea	ColTabY,a1				; dest calculated colors tab
	moveq	#0,d6				; multiplier Start (0-255)
FadeSteps:
	lea	Picture+(10240*8),a0	; 24bit colors tab address
	move.w	#256-1,d7			; Anzahl Farben = 256

ColCalcLoop:

;	blau berechnen

	move.l	(a0),d4				; read color from tab
	andi.l	#%000011111111,d4	; select blue
	mulu.w	d6,d4				; multiplier
	asr.w	#8,d4				; -> 8 bits
	andi.l	#%000011111111,d4	; select blue val
	move.l	d4,d5				; save blue to d5

;	grn berechnen

	move.l	(a0),d4				; read color from tab
	andi.l	#%1111111100000000,d4	; select green
	lsr.l	#8,d4				; -> 8 bits (so from 0 to 7)
	mulu.w	d6,d4				; multiplier
	asr.w	#8,d4				; -> 8 bits
	andi.l	#%0000000011111111,d4	; select green
	lsl.l	#8,d4				; <- 8 bits (so from 8 to 15)
	or.l	d4,d5				; save green to d5

;	rot berechnen

	move.l	(a0)+,d4			; read color from tab and go to next
	andi.l	#%111111110000000000000000,d4	; select red
	lsr.l	#8,d4				; -> 8 bits (so from 8 to 15)
	lsr.l	#8,d4				; -> 8 bits (so from 0 to 7)
	mulu.w	d6,d4				; multiplier
	asr.w	#8,d4				; -> 8 bits
	andi.l	#%0000000011111111,d4	; select red
	lsl.l	#8,d4				; <- 8 bits (so from 8 to 15)
	lsl.l	#8,d4				; <- 8 bits (so from 0 to 7)
	or.l	d4,d5				; save red to d5
	move.l	d5,(a1)+			; save 24 bit value in tab
	dbra	d7,ColCalcLoop		; 256 times for 256 colors

	addq.w	#1,d6				; add 1 to multiplier
	cmpi.w	#255,d6				; multiplier max = 256
	ble.s	FadeSteps			; if not max next fade step
	rts


******************************************************************************
* Diese Routine konvertiert Farben in 24-Bit, was wie ein Langwort $00RrGgBb *
* aussieht, (wobei R = rot hohes Nibble, r = rot niedriges Nibble,			 *
* G = hohes Nibble von grn usw.) im Format der Copperliste aga, ist es		 *
* in zwei Worten: $0RGB mit hohen nibbles und $0rgb mit niedrigen nibbles.   *
******************************************************************************

PutColors:
	move.l	ActualFadeTab(pc),a0	; Adresse der Farbpalette al
								; aktueller Punkt der berblendung von TAB
	lea	ColP0+2,a1				; Adresse des ersten Registers
								; auf hohes Nibble eingestellt
	lea	ColP0b+2,a2				; Adresse des ersten Registers
								; auf niedriges Nibble eingestellt
	moveq	#8-1,d7				; 8 Banken mit jeweils 32 Registern
ConvPaletteBank:
	moveq	#0,d0
	moveq	#0,d2
	moveq	#0,d3
	moveq	#32-1,d6			; 32 Farbregister pro Bank

ConvLongReg:					; Schleife, die die Farben $00RrGgBb.l in die 2 
								; Wrter $0RGB, $0rgb geeignet fr die
								; Copperregister umwandelt.

; Konvertieren niedriger Nibbles von $00RrGgBb (long) in die Farbe AGA $0rgb (word)

	move.b	1(a0),(a2)			; Hohes Byte der Farbe $00Rr0000 kopiert
								; in das Cop-Register fr niedriges Nibble
	andi.b	#%00001111,(a2)		; auswhlen nur niedriges Nibble ($0r)
	move.b	2(a0),d2			; Byte $0000Gg00 aus der 24-Bit-Farbe nehmen
	lsl.b	#4,d2				; verschiebt das niedrige Halbbyte um 4 Bit nach links
								; des GRNEN, "umwandeln" in ein hohes Nibble
								; des niedrigen Bytes von d2 ($g0)
	move.b	3(a0),d3			; Byte $000000Bb aus der 24-Bit-Farbe nehmen
	andi.b	#%00001111,d3		; auswhlen nur niedriges Nibble ($0b)
	or.b	d2,d3				; "MISCHEN" der niedrigen Nibble von grn und blau...
	move.b	d3,1(a2)			; Bilden des nachfolgenden Low-Bytes $gb zum Setzen
								; im Farbregister nach dem Byte $0r fr
								; das word $0rgb der niedrigen Nibble

; Konvertieren hohe Nibbles von $00RrGgBb (long) in die Farbe AGA $0RGB (word)

	move.b	1(a0),d0			; Hohes Byte der Farbe $00Rr0000 in d0
	andi.b	#%11110000,d0		; auswhlen nur hohes Nibble ($R0)
	lsr.b	#4,d0				; verschiebt das Nibble um 4 Bit nach rechts,
								; dadurch wird es zum Low-Byte-Nibble ($0R).
	move.b	d0,(a1)				; das High-Byte $0R in das Farbregister kopieren
	move.b	2(a0),d2			; das Byte $0000Gg00 aus der 24-Bit-Farbe nehmen
	andi.b	#%11110000,d2		; auswhlen nur hohes Nibble ($G0)
	move.b	3(a0),d3			; das Byte $000000Bb aus der 24-Bit-Farbe nehmen
	andi.b	#%11110000,d3		; auswhlen nur hohes Nibble ($B0)
	lsr.b	#4,d3				; verschiebt es um 4 Bit nach rechts
								; dadurch wird es zum Low-Byte-Nibble d3 ($0B)
	or.b	d2,d3				; Mischen der hohen Nibble von Grn und Blau ($G0 + $0B)
	move.b	d3,1(a1)			; Bilden des letzten Low-Bytes $GB zum Setzen
								; im Farbregister nach dem Byte $0R fr
								; das Wort $0RGB der hohen Nibble
	addq.w	#4,a0				; zur nchsten Farbe .l der Palette springen
								; am unteren Rand des Bildes angebracht
	addq.w	#4,a1				; zum nchsten Farbregister springen
								; fr hohes Nibble in Copperlist
	addq.w	#4,a2				; zum nchsten Farbregister springen
								; fr niedriges Nibble in Copperlist

	dbra	d6,ConvLongReg

	add.w	#(128+8),a1			; Farbregister berspringen + dc.w $106,xxx
								; des hohen Nibble
	add.w	#(128+8),a2			; Farbregister berspringen + dc.w $106,xxx
								; des niedrigen Nibble

	dbra	d7,ConvPaletteBank	; Konvertiert eine Bank mit 32 Farben pro
	rts							; Schleife. 8 Schleifen fr 256 Farben.


;*****************************************************************************
;*				COPPERLIST AGA												 *
;*****************************************************************************

	cnop	0,8					; ausgerichtet auf 64 bit

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP
	dc.w	$92,$0038			; DDFSTRT
	dc.w	$94,$00d0			; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2
	dc.w	$108,0				; BPL1MOD
	dc.w	$10a,0				; BPL2MOD

			    ; 5432109876543210
	dc.w	$100,%0000001000010001	; 8 Bitplane LOWRES 320x256. Zum
								; Setzen von 8 planes, Bit 4 setzen
								; Bit 12,13,14 zurcksetzen. Bit 0 ist gesetzt,
								; da es viele AGA-Funktionen ermglicht
								; die wir spter sehen werden.

	dc.w	$1fc,0				; Burst mode gelscht (vorerst!)

Bplpointers:
	dc.w	$e0,0,$e2,0			; erste 	Bitplane
	dc.w	$e4,0,$e6,0			; zweite	   "
	dc.w	$e8,0,$ea,0			; dritte	   "
	dc.w	$ec,0,$ee,0			; vierte	   "
	dc.w	$f0,0,$f2,0			; fnfte	   "
	dc.w	$f4,0,$f6,0			; sechste	   "
	dc.w	$f8,0,$fa,0			; siebte	   "
	dc.w	$fc,0,$fe,0			; achte		   "

; In diesem Fall wird die Palette durch eine Routine aktualisiert, daher
; reicht es aus, die Registerwerte gelscht zu lassen.

	dc.w	$106,$c00	; Auswahl Palette 0 (0-31), Nibble hoch
ColP0:
	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$e00	; Auswahl Palette 0 (0-31), Nibble niedrig
ColP0b:
	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$2c00	; Auswahl Palette 1 (32-63), Nibble hoch

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$2e00	; Auswahl Palette 1 (32-63), Nibble niedrig

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$4c00	; Auswahl Palette 2 (64-95), Nibble hoch

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$4e00	; Auswahl Palette 2 (64-95), Nibble niedrig

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$6c00	; Auswahl Palette 3 (96-127), Nibble hoch

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$6e00	; Auswahl Palette 3 (96-127), Nibble niedrig

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$8c00	; Auswahl Palette 4 (128-159), Nibble hoch

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$8e00	; Auswahl Palette 4 (128-159), Nibble niedrig

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$ac00	; Auswahl Palette 5 (160-191), Nibble hoch

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$ae00	; Auswahl Palette 5 (160-191), Nibble niedrig

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$cc00	; Auswahl Palette 6 (192-223), Nibble hoch

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$ce00	; Auswahl Palette 6 (192-223), Nibble niedrig

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$ec00	; Auswahl Palette 7 (224-255), Nibble hoch

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$106,$ee00	; Auswahl Palette 7 (224-255), Nibble niedrig

	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

	dc.w	$ffff,$fffe	; Ende Copperlist

;******************************************************************************

; Bild RAW mit 8 Bitplanes, das sind 256 Farben

	cnop	0,8			; auf 64 Bit ausrichten

Picture:
	incbin	"/Sources/MURALE320x256x256c.raw"
	
*************************************************************************

	SECTION	BUFFER,BSS	; es ist auch gro und schnell!

; 256 COLOR.L * 256

ColTabY:
	ds.b	4*256*256	; 262144 bytes vorberechnen!
ColTabYEnd:

	end

Immerhin ist es ein "Upgrade" der alten Fade-Routine! Nein?