
; Listing15b.s		Copper-AGA-Nuance unter Verwendung der 24-Bit-Palette.
; wir verwenden eine Routine, um das Mischen durchzufhren.
; linke und rechte Taste zum Beenden

	SECTION	AGARULEZ,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup2.s"	; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001010000000	; Copper DMA

WaitDisk	equ	30				; 50-150 zur Rettung (je nach Fall)

Start:
	move.l	#$2c07fffe,d1		; erste Zeile YY wait: $2c
	moveq	#$00,d5				; Farbe Start
	move.w	#200-1,d7			; Anzahl Zeilen: 200!
	bsr.w	DoAGACopR			; Mache einen roten Farbton

	move.w	#DMASET,$96(a5)		; DMACON - aktivieren Bitplane, Copper
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; Fmode zurcksetzen, burst normal
	move.w	#$c00,$106(a5)		; BPLCON3 zurcksetzen
	move.w	#$11,$10c(a5)		; BPLCON4 zurcksetzen

Mouse1:
	btst.b	#6,$bfe001			; linke Maustaste?
	bne.s	Mouse1
	
	move.l	#$2c07fffe,d1		; erste Zeile YY wait: $2c
	moveq	#$00,d5				; Farbe Start
	move.w	#200-1,d7			; Anzahl Zeilen: 200!
	bsr.w	DoAGACopG			; Farbverlauf machen GREEN (grn)

Mouse2:
	btst.b	#2,$16(a5)			; rechte Maustaste?
	bne.s	Mouse2

	move.l	#$2c07fffe,d1		; erste Zeile YY wait: $2c
	moveq	#$00,d5				; Farbe Start
	move.w	#200-1,d7			; Anzahl Zeilen: 200!
	bsr.w	DoAGACopB			; Farbverlauf machen blau

Mouse3:
	btst.b	#6,$bfe001			; linke Maustaste?
	bne.s	Mouse3

	move.l	#$2c07fffe,d1		; erste Zeile YY wait: $2c
	moveq	#$00,d5				; Farbe Start
	move.w	#150-1,d7			; Anzahl Zeilen: 150!
	bsr.s	DoAGACopG			; Farbverlauf machen GREEN (grn)
		
Mouse4:
	btst.b	#2,$16(a5)			; rechte Maustaste?
	bne.s	Mouse4

	move.l	#$2c07fffe,d1		; erste Zeile YY wait: $2c
	moveq	#$00,d5				; Farbe Start
	move.w	#60-1,d7			; Anzahl Zeilen: 60!
	bsr.w	DoAGACopR			; Farbverlauf machen rot

Mouse5:
	btst.b	#6,$bfe001			; linke Maustaste?
	bne.s	Mouse5

	rts

;*****************************************************************************
; Routine, die ROTE AGA-Farbtne erzeugt:
;
; d1 = erste Zeile zu warten (Wait, bei: $2c07fffe bei Zeile Y=$2c)
; d5 = Beginn Farbton ($00-$ff)
; d7 = Anzahl Zeilen zu machen
;*****************************************************************************

DoAGACopR:
	lea	AgaCopEff1,a0
	move.l	#$01060c00,d4		; BplCon3 - Nibble hoch
	move.l	#$01060e00,d3		; BplCon3 - Nibble niedrig
	move.w	#$180,d2			; Register COLOR00
DoAGALoopR:
	move.l	d1,(a0)+			; warte YYXXFFFE
	add.l	#$01000000,d1		; warte eine Zeile tiefer fr die nchste
	move.l	d4,(a0)+			; BplCon3 - Auswahl Nibble hoch
	move.w	d2,(a0)+			; Register COLOR00
	addq.b	#1,d5				; "Hellt" die $Gg-Farbe leicht auf
	move.w	d5,d6				; Kopie in d6
	and.w	#%11110000,d6		; Auswahl nur Nibble hoch
	lsl.w	#4,d6				; an die richtige Position, d.h. bei rot ($Rxx)
	move.w	d6,(a0)+			; Wert COLOR00 (Nibble hoch)
	move.l	d3,(a0)+			; BplCon3 - Auswahl Nibble niedrig
	move.w	d2,(a0)+			; Register COLOR00
	move.w	d5,d6				; Color $xx in d6
	and.w	#%00001111,d6		; Auswahl nur Nibble niedrig
	lsl.w	#8,d6				; in die rote Position bewegen
	move.w	d6,(a0)+			; Farbe in Copperlist (Nibble niedrig) eingeben
	dbra	d7,DoAGALoopR
	rts

;*****************************************************************************
; Routine, die GRNE AGA-Farbtne erzeugt:
;
; d1 = erste Zeile zu warten (Wait, bei: $2c07fffe bei Zeile Y=$2c)
; d5 = Beginn Farbton ($00-$ff)
; d7 = Anzahl Zeilen zu machen
;*****************************************************************************

DoAGACopG:
	lea	AgaCopEff1,a0
	move.l	#$01060c00,d4		; BplCon3 - Nibble hoch
	move.l	#$01060e00,d3		; BplCon3 - Nibble niedrig
	move.w	#$180,d2			; Register COLOR00
DoAGALoopG:
	move.l	d1,(a0)+			; warte YYXXFFFE
	add.l	#$01000000,d1		; warte eine Zeile tiefer fr die nchste
	move.l	d4,(a0)+			; BplCon3 - Auswahl Nibble hoch
	move.w	d2,(a0)+			; Register COLOR00
	addq.b	#1,d5				; "Hellt" die $Gg-Farbe leicht auf
	move.w	d5,d6				; Kopie in d6
	and.w	#%11110000,d6		; Auswahl nur Nibble hoch (es ist schon an
								; der richtigen Position, d.h. bei grn $xGx)
	move.w	d6,(a0)+			; Wert COLOR00 (Nibble hoch)
	move.l	d3,(a0)+			; BplCon3 - Auswahl Nibble niedrig
	move.w	d2,(a0)+			; Register COLOR00
	move.w	d5,d6				; Color $xx in d6
	and.w	#%00001111,d6		; Auswahl nur Nibble niedrig
	lsl.w	#4,d6				; in die grne Position bewegen
	move.w	d6,(a0)+			; Farbe in Copperlist (Nibble niedrig) eingeben
	dbra	d7,DoAGALoopG
	rts

;*****************************************************************************
; Routine, die BLAUE AGA-Farbtne erzeugt:
;
; d1 = erste Zeile zu warten (Wait, bei: $2c07fffe bei Zeile Y=$2c)
; d5 = Beginn Farbton ($00-$ff)
; d7 = Anzahl Zeilen zu machen
;*****************************************************************************

DoAGACopB:
	lea	AgaCopEff1,a0
	move.l	#$01060c00,d4		; BplCon3 - Nibble hoch
	move.l	#$01060e00,d3		; BplCon3 - Nibble niedrig
	move.w	#$180,d2			; Register COLOR00
DoAGALoopB:
	move.l	d1,(a0)+			; warte YYXXFFFE
	add.l	#$01000000,d1		; warte eine Zeile tiefer fr die nchste
	move.l	d4,(a0)+			; BplCon3 - Auswahl Nibble hoch
	move.w	d2,(a0)+			; Register COLOR00
	addq.b	#1,d5				; "Hellt" die $Gg-Farbe leicht auf
	move.w	d5,d6				; Kopie in d6
	and.w	#%11110000,d6		; Auswahl nur Nibble hoch
	lsr.w	#4,d6				; an der richtigen Position, d.h. blau $xxB)
	move.w	d6,(a0)+			; Wert COLOR00 (Nibble hoch)
	move.l	d3,(a0)+			; BplCon3 - Auswahl Nibble niedrig
	move.w	d2,(a0)+			; Register COLOR00
	move.w	d5,d6				; Color $xx in d6
	and.w	#%00001111,d6		; Auswahl nur Nibble niedrig - Position $xxB
	move.w	d6,(a0)+			; Farbe in Copperlist (Nibble niedrig) eingeben
	dbra	d7,DoAGALoopB
	rts

;*****************************************************************************
;*				COPPERLIST													 *
;*****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP
	dc.w	$92,$0038			; DDFSTRT
	dc.w	$94,$00d0			; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2
	dc.w	$108,0				; BPL1MOD
	dc.w	$10a,0				; BPL2MOD
	dc.w	$100,$201			; keine Bitplanes (bit 1 aktiviert jedoch!)

	dc.w	$106,$c00			; Auswahl Nibble hoch
	dc.w	$180,$000			; COLOR00 - Nibble hoch
								; (Wir lassen die niedrigen Nibble bei Null...)

AgaCopEff1:
	dcb.l	200*5				; das ist: 200 Zeilen * 5 long:
								; 1 fr wait,
								; 1 fr BPLCON3
								; 1 fr COLOR00 (nib hoch)
								; 1 fr BPLCON3
								; 1 fr COLOR00 (nib niedrig)

	dc.w	$ffff,$fffe			; Ende Copperlist

	end

Es hat sich gelohnt, eine Routine fr diese Nuance zu erstellen. Knnen Sie
sich vorstellen, wie viele Zeilen wir htten schreiben mssen???

                                                                                                                                                                                                                                                                                                                                                                                                                                       n HAM8.


