
; Listing14-7c:		* MODULIEREN DER AMPLITUDE UND FREQUENZ EINER HARMONISCHER  *

	SECTION	MODULATION,CODE

Start:
	lea	ModVolFq,a0
	moveq	#0,d0
	moveq	#123,d1
	move.w	#64-1,d7
.Lp1:	
	move.w	d0,(a0)+
	addq.w	#1,d0
	move.w	d1,(a0)+
	addq.w	#4,d1
	dbra	d7,.Lp1
	move.w	#64-1,d7
.Lp2:	
	move.w	d0,(a0)+
	subq.w	#1,d0
	move.w	d1,(a0)+
	subq.w	#4,d1
	dbra	d7,.Lp2

_LVODisable	equ	-120
_LVOEnable	equ	-126

	move.l	4.w,a6
	jsr	_LVODisable(a6)

	bset	#1,$bfe001			; schaltet den Tiefpassfilter aus

	lea	$dff000,a6
	move.w	$2(a6),d7			; speichern DMA von OS
	move.w	$10(a6),d6			; speichern ADKCON von OS

CLOCK equ 3546895

	move.l	#Harmonic,$b0(a6)							; AUD1LCH
	move.w	#16/2,$b4(a6)								; AUD1LEN (in word)

	move.l	#ModVolFq,$a0(a6)							; AUD0LCH
	move.w	#(ModVolFqEnd-ModVolFq)/2,$a4(a6)			; AUD0LEN
	move.w	#CLOCK/((ModVolFqEnd-ModVolFq)/2),$a6(a6)	; AUD0PER

	move.w	#$8011,$9e(a6)		; USE0V1 und USE0P1 einstellen
	move.w	#$8203,$96(a6)		; einschalten AUD0 und AUD1 in DMACONW

Mouse:	
	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse

	move.w	#$0011,$9e(a6)		; USE0V1 und USE0P1 ausschalten
	or.w	#$8000,d6			; Bit 15 schaltet ein (SET/CLR)
	move.w	d6,$9e(a6)			; rcksetzen ADKCON von OS
	move.w	#$0003,$96(a6)		; ausschalten AUD0 und AUD1
	or.w	#$8000,d7			; Bit 15 schaltet ein (SET/CLR)
	move.w	d7,$96(a6)			; rcksetzen DMA von OS
	move.l	4.w,a6
	jsr	_LVOEnable(a6)
	rts

	SECTION	SAMPLE,DATA_C	; Wird es von der DMA gelesen, muss es sich im CHIP befinden

Harmonic:	; Harmonische von 16 Werten, die mit dem IC des Trash'm-One erzeugt wurden
	dc.b	$19,$46,$69,$7c,$7d,$6a,$47,$1a,$e8,$bb,$97,$84,$83,$95,$b8,$e5
ModVolFq:
	blk.w	64*2*2
ModVolFqEnd:
	end

So modulieren Sie einen Klang sowohl in der Amplitude als auch in der Frequenz:
Die Tabelle besteht aus 2 alternierenden Werten, zunchst ein Wort mit dem
7-Bit-Volumen fr AUD1VOL und dann ein zweites Wort mit der 16-Bit-Periode
fr AUD0PER. In derselben Reihenfolge werden die Daten auch in AUD0DAT
eingegeben: zuerst das Volume, dann die Periode.
Natrlich werden sowohl das Bit fr die Frequenzmodulation als auch das fr
die Amplitudenmodulation von Kanal 0 in Bezug auf Kanal 1 gesetzt.
