
; Listing14-7a1:	** MODULATION DER AMPLITUDE EINER HARMONISCHEN **

	SECTION	MODULATION,CODE

Start:
	lea	ModVol,a0
	moveq	#0,d0
	moveq	#65-1,d7
.Lp1:	
	move.w	d0,(a0)+
	addq.w	#1,d0
	dbra	d7,.Lp1
	subq.w	#1,d0
.Lp2:	
	move.w	d0,(a0)+
	dbra	d0,.Lp2

_LVODisable	equ	-120
_LVOEnable	equ	-126

	move.l	4.w,a6
	jsr	_LVODisable(a6)

	bset	#1,$bfe001			; schaltet den Tiefpassfilter aus

	lea	$dff000,a6
	move.w	$2(a6),d7			; speichern DMA von OS
	move.w	$10(a6),d6			; speichern ADKCON von OS

CLOCK equ 3546895

	move.l	#Harmonic,$b0(a6)					; AUD1LCH
	move.w	#16/2,$b4(a6)						; AUD1LEN (in word)
	move.w	#CLOCK/(16*880),$b6(a6)				; AUD1PER

	move.l	#ModVol,$a0(a6)						; AUD0LCH
	move.w	#(ModVolEnd-ModVol)/2,$a4(a6)		; AUD0LEN (in word)
	move.w	#CLOCK/(ModVolEnd-ModVol),$a6(a6)	; AUD0PER

	move.w	#$8001,$9e(a6)		; USE0V1 einstellen
	move.w	#$8203,$96(a6)		; einschalten AUD0 und AUD1 in DMACONW

Mouse:	
	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse
								
	move.w	#$0001,$9e(a6)		; ausschalten USE0V1						
	or.w	#$8000,d6			; Bit 15 schaltet ein (SET/CLR)
	move.w	d6,$9e(a6)			; rcksetzen ADKCON von OS
	move.w	#$0003,$96(a6)		; ausschalten AUD0 und AUD1
	or.w	#$8000,d7			; Bit 15 schaltet ein (SET/CLR)
	move.w	d7,$96(a6)			; rcksetzen DMA von OS
	move.l	4.w,a6
	jsr	_LVOEnable(a6)
	rts

	SECTION	SAMPLE,DATA_C	; Wird es von der DMA gelesen, muss es sich im CHIP befinden

Harmonic:	; Harmonische von 16 Werten, die mit dem IC des Trash'm-One erzeugt wurden
	dc.b	$19,$46,$69,$7c,$7d,$6a,$47,$1a,$e8,$bb,$97,$84,$83,$95,$b8,$e5			
ModVol:
	blk.w	65*2
ModVolEnd:
	end


Ganz einfach, wir haben zuerst eine Tabelle mit 130 Werten erstellt von
0 bis 64 und von 64 bis 0 fr die AUD1VOL-Volumes, die wir ber Kanal 0
gelesen haben, whrend Kanal 1 die Harmonische bei der LA3 - Frequenz
(880 Hz) ausliest.
Als eine Periode des Modulatorkanals gaben wir vor, dass er die normale
Probe las und wir gaben ihm die Lesegeschwindigkeit: weil die Tabelle
in 1 Sekunde gelesen wird, muss die Abtastperiode gerade bei der
Taktkonstante geteilt durch die Lnge in Bytes der Tabelle = 1 Hz sein.

N.B.:	Beachten Sie, dass die Lautstrke von Kanal 0 (AUD0VOL) nicht
	eingestellt wurde, da es nicht notwendig ist, da seine Ausgabe nicht
	verstrkt wird (64 = -0 dB) und direkt im AUD1VOL-Register endet.
	AUD1VOL wurde auch am Anfang nicht eingestellt, da es sofort
	modifiziert wird durch den Modulator.
 