
; Listing14-3b.s	** HAUPTAKKORD DER HARMONISCHEN MIT 4 STIMMEN **

	SECTION	HARMONIC,CODE

Start:
	move.l	4.w,a6
	jsr	-$78(a6)				; _LVODisable
	bset	#1,$bfe001			; Schaltet den Tiefpassfilter aus
	lea	$dff000,a6
	move.w	$2(a6),d7			; DMACONR - speichern DMA fr OS

	move.l	#Harmonic,$a0(a6)	; AUD0LCH.w+AUD0LCL.w=AUD0LC.l
	move.l	#Harmonic,$b0(a6)	; AUD1LCH.w+AUD1LCL.w=AUD1LC.l
	move.l	#Harmonic,$c0(a6)	; AUD2LCH.w+AUD2LCL.w=AUD2LC.l
	move.l	#Harmonic,$d0(a6)	; AUD3LCH.w+AUD2LCL.w=AUD3LC.l
	move.w	#16/2,$a4(a6)		; 16 bytes/2=8 word der Daten (AUD0LEN)
	move.w	#16/2,$b4(a6)		; 16 bytes/2=8 word der Daten (AUD1LEN)
	move.w	#16/2,$c4(a6)		; 16 bytes/2=8 word der Daten (AUD2LEN)
	move.w	#16/2,$d4(a6)		; 16 bytes/2=8 word der Daten (AUD3LEN)

	moveq	#16,d1
	moveq	#12*1+0,d2			; DO2 (Akkord per DO)

	move.l	d2,d0
	bsr.s	HalfTone2Per
	move.w	d0,$a6(a6)			; AUD0PER
	addq.w	#2*2,d2				; + 2 Ton = MI
	move.l	d2,d0
	bsr.s	HalfTone2Per
	move.w	d0,$b6(a6)			; AUD1PER
	addq.w	#2+1,d2				; + 1 Ton + 1 Halbton = SOL
	move.l	d2,d0
	bsr.s	HalfTone2Per
	move.w	d0,$c6(a6)			; AUD2PER
	addq.w	#2+1,d2				; + 1 Ton + 1 Halbton = LA#
	move.l	d2,d0
	bsr.s	HalfTone2Per
	move.w	d0,$d6(a6)			; AUD3PER

	move.w	#64,$a8(a6)			; AUD0VOL maximal (0 dB)
	move.w	#64,$b8(a6)			; AUD1VOL maximal (0 dB)
	move.w	#64,$c8(a6)			; AUD2VOL maximal (0 dB)
	move.w	#64,$d8(a6)			; AUD3VOL maximal (0 dB)
	move.w	#$800f,$96(a6)		; einschalten AUD0-AUD3 DMA in DMACONW

Mouse:
	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse

	ori.w	#$8000,d7			; Bit 15 schaltet ein (SET/CLR)
	move.w	#$000f,$96(a6)		; ausschalten DMA
	move.w	d7,$96(a6)			; DMACON - reset DMA von OS
	move.l	4.w,a6
	jsr	-$7e(a6)				; _LVOEnable
	rts

******************************************************************************
;			 Periode der Halbtne 
;
; Berechnen Sie die Periode, die in AUDxPER eingefgt werden soll, wenn der 
; Halbton von DO1 ausgeht
; d0.w   = Halbton (ab DO1 = 0)
; d1.w   = Lnge Harmonische (in byte)
******************************************************************************

CLOCK equ 3546895
DO1	equ	131				; Frequenz [Hz] fr DO1  ; C3 = 130,81HZ

HalfTone2Per:
	move.l	d2,-(sp)
	divu.w	#12,d0
	move.w	#do1,d2
	lsl.w	d0,d2
	swap	d0
	add.w	d0,d0
	add.w	d0,d0
	mulu.w	HalfTones(pc,d0.w),d2
	divu.w	HalfTones+2(pc,d0.w),d2
	move.l	#CLOCK,d0
	mulu.w	d2,d1
	divu.w	d1,d0		; DIVISION BY ZERO!!!
	move.l	(sp)+,d2
	rts					; [d0.w=Periode fr Sampling]

HalfTones:
	dc.w	10000,10000	; DO=1.0
	dc.w	10595,10000	; DO#=1.0595
	dc.w	11225,10000	; RE=1.1225
	dc.w	11892,10000	; RE#=1.1892
	dc.w	12599,10000	; MI=1.2599
	dc.w	13348,10000	; FA=1.3348
	dc.w	14142,10000	; FA#=1.4142
	dc.w	14983,10000	; SOL=1.4983
	dc.w	15874,10000	; SOL#=1.5874
	dc.w	16818,10000	; LA=1.6818
	dc.w	17818,10000	; LA#=1.7818
	dc.w	18877,10000	; SI=1.8877

******************************************************************************

	SECTION	SAMPLE,DATA_C	; wird es von der DMA gelesen, muss es sich in CHIP befinden

	; Harmonische von 16 Werten, die mit dem IS von trash'm-one erzeugt wurden

Harmonic:
	dc.b	$19,$46,$69,$7c,$7d,$6a,$47,$1a,$e8,$bb,$97,$84,$83,$95,$b8,$e5

	end

******************************************************************************

Diese Quelle unterscheidet sich in keiner Weise von der vorherigen. Die einzige
Neuerung, die eingefhrt wurde, ist die Verwendung aller Hardware-Kanle des
Sound-Chips des Amiga... eigentlich nichts kompliziertes: Um das gleiche Sample
mit unterschiedlichen Frequenzen zu spielen ist es ausreichend, alle Register
AUDxLC, AUDxLEN und AUDxVOL mit demselben Wert fr alle Kanle zu setzen und
nur die Perioden in AUDxPER zu ndern.

In der Musik, um einen HAUPTAKKORD mit 3 oder mehr Noten zu erstellen (wir
haben hier 4, nur um die letzte Stimme nicht leer zu lassen ...) mssen sie 
GLEICHZEITIG alle 3 richtigen Tne, aus denen der Akkord besteht spielen.
Hier ist das allgemeine Schema:

				******* WICHTIGE VEREINBARUNGEN *********
				+------+--------------------------------+
				| NOTE |       TONART				    |
				+------+--------------------------------+
				|  1a  |   Grundton des Akkords         |
				|  2a  |  + 2 Tne = 4 Halbtne         |
				|  3a  |  + 1 Ton und halbe =3 Halbtne |
				|  4a  |  + 1 Ton und halbe =3 Halbtne |
				+------+--------------------------------+

Zum Beispiel fr den MI-Akkord mit 3 Stimmen: MI + SOL # + SI
fr den LA-Akkord mit 4 Stimmen: LA + DO # + MI + SOL.