
; Listing14-10b.s	Verwendung der Routine player6.1a fr ein komprimiertes Modul
; die Routine P61_Music wird bei jedem vertical blank aufgerufen

	SECTION	USEPLAY61A,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup2.s" ; nur Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001010000000	; nur Copper DMA

WaitDisk	equ	30	; 50-150 zur Rettung (je nach Fall)

Start:

;
; Call P61_Init to initialize the playroutine	
; d0 --> Timer detection (for CIA-version)	
; A0 --> Address to the module			
; a1 --> Address to Samples/0			
; a2 --> Address to Sample buffer		
; d0 <-- 0 if succeeded			
; a6 <-- $DFF000				
;

	movem.l	d0-d7/a0-a6,-(sp)
	lea	P61_Data,a0				; Adresse des Moduls in a0
	lea	$dff000,a6				; wir merken uns die $dff000 in a6!
	sub.l	a1,a1				; die Sample sind nicht getrennt, wir setzen Null
	lea	Samples,a2				; Modul komprimiert! Zeiger auf Zielpuffer fr
								; die Samples (in chip ram) !
	bsr.w	P61_Init			; Hinweis: das Dekomprimieren dauert einige Sekunden!
	movem.l	(sp)+,d0-d7/a0-a6

	lea	$dff000,a5
	move.w	#DMASET,$96(a5)		; DMACON - nur Copper aktivieren
								; + Bitplane und Sprites (%1000001111000000)

	move.w	#$e000,$9a(a5)		; INTENA - aktivieren Master und lev6
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$08000,d2			; warte auf Zeile $80
WarteY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; whle nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; warte auf Zeile $12c
	bne.s	WarteY1
WarteY2:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; whle nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; warte auf Zeile $12c
	beq.s	WarteY2

;
; Call P61_Music every frame to play the music	
;	  _NOT_ if CIA-version is used!		
; a6 --> Customchip baseaddress ($DFF000)	
;

	move.w	#$f00,$180(a5)		; COLOR00 rot -> fr Copper monitor

	movem.l	d0-d7/a0-a6,-(sp)
	lea	$dff000,a6				; wir merken uns $dff000 in a6!
	bsr.w	P61_Music
	movem.l	(sp)+,d0-d7/a0-a6

	move.w	#$003,$180(a5)		; COLOR00 schwarz

	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse

;
; Call P61_End to stop the music		
;   a6 --> Customchip baseaddress ($DFF000)	
;		Uses d0/d1/A0/a1/a3		
;

	lea	$dff000,a6				; wir merken uns $dff000 in a6!
	bsr.w	P61_End

	rts


*****************************************************************************
*		 The Player 6.1A for Asm-One 1.09 and later 						*
*****************************************************************************

fade  = 0	; 0 = Normal, NO master volume control possible
			; 1 = Use master volume (P61_Master)

jump = 0	; 0 = do NOT include position jump code (P61_SetPosition)
			; 1 = include

system = 0	; 0 = killer
			; 1 = friendly

CIA = 0		; 0 = CIA disabled
			; 1 = CIA enabled

exec = 1	; 0 = ExecBase destroyed
			; 1 = ExecBase valid

opt020 = 0	; 0 = MC680x0 code
			; 1 = MC68020+ or better

use = $b55a	; Usecode (Setze den von p61con angegebenen Wert zum Speichern
			; fr jedes Modul unterschiedlich!)

*****************************************************************************
	include	"/Sources/play.s"	; die wahre Routine!
*****************************************************************************


*****************************************************************************
;	Copperlist
*****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$100,$200			; BPLCON0 - keine Bitplanes
	dc.w	$180,$003			; COLOR00 schwarz
	dc.w	$ffff,$fffe			; Ende Copperlist

*****************************************************************************
;	Musikmodul in Format P61 konvertiert, KOMPRIMIERT! (Option pack!)
*****************************************************************************

	SECTION	MODUL,DATA		; Es muss nicht im Chip-RAM sein, weil es 
								; komprimiert ist und woanders ausgepackt wird!

; Das Modul ist Jester/Sanity. Original 153676, gepackt 71950

P61_Data:
	incbin	"/Sources/P61.stardust"	; komprimiert, (Option PACK SAMPLES),
		; Sie knnen es auch in den FAST RAM legen: es wird verwendet
		; zum Entpacken der Samples in den Puffer Samples
		; und wird nicht direkt "gespielt".
		; Es geht also nicht direkt ber die Audio DMA-Kanle
		; sondern nur ber die Depack-Routine durch den Prozessor.
		; Also nur DATEN (nicht _C!)


*****************************************************************************
;	Wo die Samples entpackt werden (SECTION bss in chip ram!)
*****************************************************************************

	SECTION	SMP,BSS_C

Samples:
	ds.b	132112				; Lnge gemeldet von p61con

	end

Dieses Beispiel ist wie das vorherige, nur dass das Modul komprimierte Samples
enthlt (Option "Pack Samples" aktiv, aber "Delta" ist nicht aktiv, was jedoch
ob es aktiv ist oder nicht, habe ich festgestellt, dass sich fast nichts ndert !!!)
Bevor Sie sich fr die Komprimierung von Samples entscheiden, denken sie zwei oder drei
Mal nach. In der Tat ist es manchmal notwendig, mehr Speicher zu verwenden, um einen 
Puffer fr unkomprimierte Samples zu erstellen, in dem sie abgelegt werden sollen.
Beim Entpacken von Samples verlieren Sie Zeit und Sie knnen Audio Qualitt verlieren.
In diesem Zusammenhang, wenn Sie sich fr komprimierte Samples von einem Modul
entscheiden erscheint ein requester, der uns erlaubt auszuwhlen ob wir Sample fr
Sample packen wollen oder nicht und das Original und jede gepackte Version zu hren.
Wenn Sie sich die verschiedenen Samples in der normalen und komprimierten Version
anhren, werden Sie feststellen dass einige besonders viel Qualitt verlieren .......                                                              