
; Listing14-1.s		** HARMONISCHE SPIELEN **

	SECTION	HARMONIC,CODE

Start:
	move.l	4.w,a6
	jsr	-$78(a6)				; _LVODisable

	bset	#1,$bfe001			; Schaltet den Tiefpassfilter aus

	lea	$dff000,a6
	move.w	$2(a6),d7			; DMACONR - speichern DMA von OS

CLOCK	equ	3546895

	move.l	#Harmonic,$a0(a6)	; AUD0LCH.w+AUD0LCL.w=AUD0LC.l
	move.w	#16/2,$a4(a6)		; 16 bytes/2=8 word der Daten (AUD0LEN)
	move.w	#CLOCK/(16*880),$a6(a6)	; AUD0PER zu 251
	move.w	#64,$a8(a6)			; AUD0VOL maximal (0 dB)
	move.w	#$8201,$96(a6)		; einschalten AUD0 DMA in DMACONW

Mouse:
	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse

	ori.w	#$8000,d7			; Bit 15 schaltet ein (SET/CLR)
	move.w	#$0001,$96(a6)		; DMACON - ausschalten AUD0
	move.w	d7,$96(a6)			; DMACON - Reset DMA von OS
	move.l	4.w,a6
	jsr	-$7e(a6)				; _LVOEnable
	rts

******************************************************************************

	SECTION	SAMPLE,DATA_C		; Wird es von der DMA gelesen, muss es sich in CHIP befinden

	; Harmonische von 16 Werten, die mit dem IS von trash'm-one erzeugt wurden 

Harmonic:
	dc.b	$19,$46,$69,$7c,$7d,$6a,$47,$1a,$e8,$bb,$97,$84,$83,$95,$b8,$e5

	end

******************************************************************************

Die Harmonische ist ein 16-Byte-Sample, das auf Kanal 0 mit Samplingrate 251
gespielt wird.
Um 16 Bytes in 1 Sekunde (1 Hz) abzuspielen, sollte der AUDPER-Wert 1/16 des
Wertes der Taktkonstante sein, da der DMA 1/16 der Zeit fr 16 = die ganze 
Zeit = 1 Sekunde warten soll.
Um beispielsweise einen LA3 (= 440 Hz) zu erzeugen, msste man mit 880 Hz 
abtasten (Nyquist Theorem), wobei die Harmonische mit einer Frequenz von 1 
gelesen werden soll 880 Hz Messwert und die Abtastperiode (= einzugebender
Wert) AUDxPER wre 1/880 der 1/16 der Taktkonstante:
3546895/16 = 221680 = 1 Hz, Auerdem kann es nicht in das Register eingetragen 
werden da es ber dem 16-Bit-Bereich liegt (AUDxPER = 1 word ohne Zeichen);
(3546895/16)/880 = 3546895/(16*880) = 251 = 880 Hz.

N.B.:	Die beiden jsr auf die Funktionen "deaktivieren" und "aktivieren" des 
    exec knnten weggelassen werden, aber fr die elegante Codierung, wren 
    sie obligatorisch:
	Unter dem Betriebssystem wre es nicht mglich, die DMA-Kanle direkt zu
	berhren (nicht einmal die Audio-Kanle), nicht so sehr wegen der Gefahr, 
	dass es dazu kommt, dass der Computer abgestrzt ist
    (Exec kann nicht alle Eventualitten berprfen)
	Zugriffe auf Hardwareregister, da die Hardware keine Schaltkreise hat
	Schutz und Systembibliotheken wirken keine Wunder die Gewissheit, dass
	Ihre Aufgabe / Ihr Prozess mit anderen in Konflikt steht
    Aufgaben / Prozesse, die Audioressourcen verwenden: Der Amiga hat nur
    einen Soundchip und jeder muss darauf zugreifen, um zu spielen. 
	Der Kernel im ROM stellt AUDIO.DEVICE zur Verfgung
	jede Aufgabe, den Chip zu nutzen und per Software zu vermitteln
	Zugriff und Nutzung zwischen den verschiedenen Prozessen.
	Da dieser Kurs die Verwendung der Hardware durch Zugriff 
	auf die Register beinhaltet, werden wir die devices nicht verwenden und 
	deshalb werden wir immer verpflichtet sein (auch wenn sich niemand anmeldet).
	Zu der Soundhardware wre es eigentlich nicht ntig 
	"legal" (mit einer exec-Funktion) das Betriebssystem auszuschalten.