
; Listing11n2.s - Timing-Routine, mit der Sie auf eine
; bestimmte Anzahl Hertz warten knnen

Start:
	move.l	4.w,a6				; Execbase in a6
	;jsr	-$84(a6)			; forbid
	jsr	-$78(a6)				; disable
	lea	$dff000,a5
	
	;bsr.s	CiaHz				; Warten Sie ein paar Sekunden
	bsr.s   CiaHz2		
	
	move.l	4.w,a6				; Execbase in a6
	jsr	-$7e(a6)				; enable
	;jsr	-$8a(a6)			; permit
	rts


; bfe801 todlo	-	1=~0,02 secs oder 1/50 sec (PAL) oder 1/60 sec (NTSC)
; bfe901 todmid	-	1=~3 secs
; bfea01 todhi	-	1=~21 mins
;
; In der Praxis handelt es sich um einen Timer, der eine 24-Bit-Zahl 
; enthalten kann.
; geteilt: 0-7 Bits in TODLO, Bits 8-15 in TODMID und Bits 16-23 in TODHI.


CiaHz2:
	move.l	a2,-(sp)
	lea	$bfe001,a2				; CIAA base -> verwendet
;	lea	$bfd000,a2				; CIAB base

	move.b	#0,$800(a2)			; TODLO - Bit 7-0 fr Timer zu 50-60Hz
								; reset timer!
Wcia:
	cmpi.b	#50*2,$800(a2)		; TODLO - Wait time = 2 Sekunden...
	;bge.s	Done				; vorzeichenbehaftet bis 127 => 2,54s 
	bhi.s	Done				; vorzeichenlos bis 255 => 5,1s 
	bra.s	Wcia
Done:
	move.l	(sp)+,a2
	rts

	end

Beachten Sie, dass, wenn Sie CIAB verwenden mchten, zu einem horizontalen
und nicht vertikalen Sync-Timer wechseln, so ist es sehr schnell. Um
ungefhr 2 Sekunden zu warten mssen die TODMID bemhen:

CiaHz:
	move.l	a2,-(sp)
;	lea	$bfe001,a2				; CIAA base
	lea	$bfd000,a2				; CIAB base -> verwendet

	move.b	#0,$800(a2)			; TODLO - Bit 7-0 fr Timer zu 50-60Hz
								; reset timer!
Wcia:
	cmpi.b	#120,$900(a2)		; TODMID - Wait time = 2 Sekunden...
	bge.s	Done
	bra.s	Wcia
Done:
	move.l	(sp)+,a2
	rts

Beachten Sie, dass der CIAA TOD von timer.device verwendet wird,
TOD des CIAB wird von graphics.library verwendet!

Wenn Sie knnen, warten Sie fr eine kurze Zeit mit der klassischen Routine:

	lea	$dff006,a0				; VHPOSR
	moveq	#XXX-1,d0			; Anzahl der zu wartenden Zeilen
WaitLines:
	move.b	(a0),d1				; $dff006 - aktuelle vertikale Linie in d1
StepLine:
	cmp.b	(a0),d1				; sind wir immer noch auf der gleichen Zeile?
	beq.s	StepLine			; wenn ja warten
	dbra	d0,WaitLines		; Zeile "warten", warten d0-1 Zeilen