
; Listing11l7.s		8 Sprites attached (daher 4 bis 16 Farben) verwendet,
; 128 mal pro Zeile "wiederverwendet".

	SECTION	SPRITE,CODE

;	include	"DaWorkBench.s"		; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include "/Sources/startup2.s"	; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001110100000	; $83a0 - Bitplane, Copper, Sprites
;			 -----a-bcdefghij

Waitdisk	equ	30

NUMBERLINES	=	128
LENGSPR		=	NUMBERLINES*8

Start:

; Zeiger Sprites

	move.l	#SpritesBuffer,d0
	lea	SpritePointers,a1
	moveq	#8-1,d1				; Anzahl Sprites = 8
PointBp:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	add.l	#LENGSPR,d0			; Spritelnge
	addq.w	#8,a1
	dbra	d1,PointBp			; wiederhole d1 mal

; Wir zeigen auf die genullte Bitplane

	move.l	#Bitplane,d0
	lea	Bplpointers,a1
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

	bsr.s	CreaSprites			; Routine, die die 4 angehngten Sprites erstellt,
								; dh alle 8 Sprites, hergestellt aus
								; 128 Wiederholungen je 1 Zeile!

	lea	$dff000,a5
	move.w	#DMASET,$96(a5)		; DMACON - aktivieren Bitplane, Copper
								; und Sprites
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$12c00,d2			; warte auf Zeile $12c
WarteY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; warte auf Zeile $12c
	bne.s	WarteY1

	btst	#2,$16(a5)			; rechte Maustaste gedrckt?
	beq.s	DoNotWave

	bsr.w	WaveSprites			; bewegt die 8 wiederverwendeten Sprites

DoNotWave:
	btst	#6,$bfe001			; Maus gedrckt?
	bne.s	Mouse
	rts

; ****************************************************************************
; Routine, die die 8 Sprites (d.h. 4 attached) im "SpritesBuffer" erstellt.
; Beachte, dass die attached Sprites wiederum 2 zu 2 flankiert werden,
; um 2 Balken 16*2=32 Pixel breit und 16 Farben zu erhalten.
; Zuerst mssen wir daran denken, dass jedes Sprite "wiederverwendet" werden
; kann, das heit "unter" einem Sprite, nach dem Ende des Sprites kann man
; ein anderes Sprite setzen, solange eine vertikale Position "leere" Zeile
; am Anfang stehen bleibt. Wir setzen das hier massiv ein. Tatschlich ist 
; jede Wiederverwendung des Sprites 1 Zeile, also bekommen wir eine Zeile.
; vertikaler Streifen (16 Pixel breit) aus vielen "Sprites", eine Zeile hoch
; durch eine "leere" Zeile getrennt. Fr 256 vertikalen Zeilen des Bildschirms
; machen wir 128 Verwendungen fr jedes Sprite! Aber wenigstens knnen wir
; sie in der Zeile "biegen" so viel wie wir wollen, da jeder Streifen eine
; eigene unabhngige HSTART (horizontale Position) hat.
;
; Wir erinnern uns an die Struktur eines Sprites:
;
;Vstart:
;	dc.b xx						; Pos. vertikal (von $2c bis $f2)
;Hstart:
;	dc.b xx+(xx)				; Pos. horizontal (von $40 bis $d8)
;Vstop:
;	dc.b xx						; Ende vertikal.
;	dc.b $00					; Byte spezial: Bit 7 fr ATTACCHED!!
;	dc.l	XXXXX				; Bitplane Sprite (Zeichnung!) hier 1 Zeile
;	(dc.w	0,0)				; 2 word zurckgesetzt fr ENDE SPRITE, dass wir hier
								; nicht setzen ... also hier wird es schon den Vstart
								; und den Vstop des nchsten Sprites geben!
;
; 4 Bytes -> Steuerwrter + 4 Bytes -> Figur (1 Streifen)
; 4*2= 8 -> Lnge eines Sprites; 8*128 = 1024, Lnge 1 Sprite.
; Wir machen 128 Wiederverwendungen von jedem Sprite: 2 Zeilen pro Sprite = 256 Zeilen!
;
; ****************************************************************************

; 1024 Bytes (8*128) pro Sprite

CreaSprites:
	lea	SpritesBuffer,a0			; Ziel
	move.l	#%10000000,d5			; Bit 7 gesetzt - fr attached in Sprite+3
	moveq	#$2c,d0					; Vstart - anfangen von $2c
CreaLoop:
	move.b	d0,(a0)					; Setze den Vstart auf die 8 Sprites
	move.b	d0,LENGSPR(a0)			; 2 (Jedes Sprite ist 1024 Bytes lang)
	move.b	d0,LENGSPR*2(a0)		; 3
	move.b	d0,LENGSPR*3(a0)		; 4
	move.b	d0,LENGSPR*4(a0)		; 5
	move.b	d0,LENGSPR*5(a0)		; 6
	move.b	d0,LENGSPR*6(a0)		; 7
	move.b	d0,LENGSPR*7(a0)		; 8

	move.l	d0,d1
	addq.w	#1,d1				; Vstart 1 Zeile darunter -> Lass es uns als Vstop verwenden

	move.b	d1,2(a0)				; Setze den Vstop auf die 8 Sprites
	move.b	d1,LENGSPR+2(a0)		; 2 (Jedes Sprite ist 1024 Bytes lang.)
	move.b	d1,(LENGSPR*2)+2(a0)	; 3
	move.b	d1,(LENGSPR*3)+2(a0)	; 4
	move.b	d1,(LENGSPR*4)+2(a0)	; 5
	move.b	d1,(LENGSPR*5)+2(a0)	; 6
	move.b	d1,(LENGSPR*6)+2(a0)	; 7
	move.b	d1,(LENGSPR*7)+2(a0)	; 8

; Wir setzen das attached Bit, um angehngte Sprites zu erhalten

	;move.b	d5,3(a0)				; Setze das spezifizierte Byte. zu den 8 Sprites
	move.b	d5,LENGSPR+3(a0)		; 2 (Jedes Sprite ist 1024 bytes lang)
	;move.b	d5,(LENGSPR*2)+3(a0)	; 3 
	move.b	d5,(LENGSPR*3)+3(a0)	; 4	es ist ausreichend es nur in den ungeraden Sprite zu setzen
	;move.b	d5,(LENGSPR*4)+3(a0)	; 5	
	move.b	d5,(LENGSPR*5)+3(a0)	; 6	also in SPR1,3,5,7
	;move.b	d5,(LENGSPR*6)+3(a0)	; 7
	move.b	d5,(LENGSPR*7)+3(a0)	; 8

	addq.w	#4,a0				; berspringe die 2 Steuerwrter
								; und lass uns zu den Sprite-planes gehen!

	move.l	#$55553333,(a0)				; 1 \ Verlaufslinie setzen
	move.l	#$0f0f00ff,LENGSPR(a0)		; 2 / attacched 1!

	move.l	#$aaaacccc,LENGSPR*2(a0)	; 3 \ attacched 2!
	move.l	#$f0f0ff00,LENGSPR*3(a0)	; 4 /

	move.l	#$55553333,LENGSPR*4(a0)	; 5 \ attacched 3!
	move.l	#$0f0f00ff,LENGSPR*5(a0)	; 6 /

	move.l	#$aaaacccc,LENGSPR*6(a0)	; 7 \ attacched 4!
	move.l	#$f0f0ff00,LENGSPR*7(a0)	; 8 /

	addq.w	#4,a0				; berspringe die 2 Wrter der Bitplane,
								; zu den nchsten 2 Steuerwrter gehen
								; Es wurden keine 2 Wrter zurckgesetzt
								; fr das Ende Sprite.

	cmp.b	#%10000110,d5		; sind wir unter der Zeile $ff?
	beq.s	WeAreUnderFF
	addq.b	#2,d0				; Vstart 2 Zeilen tiefer fr die nchste
								; Wiederverwendung des Sprites. Vorausgesetzt, dass 
								; jeder Sprite 1 Zeile hoch ist und das zwischen 
								; einem verwendeten und einem anderen
								; eine leere Zeile vorhanden ist, addiere 2.
	bne.w	CreaLoop			; sind wir angekommen bei $fe+2 = $00?
								; wenn ja, mssen wir das hohe Bit von 
								; Vstart und Vstop einstellen. Sonst mach weiter

	move.b	#%10000110,d5		; %10000110 -> setze die 2 hohen Bits von Vstart
								; und Vstop unter die Zeile $ff gehen 
	subq.b	#2,d0				; wir gehen einen Schritt zurck...

WeAreUnderFF:
	addq.b	#2,d0				; Vstart 2 Zeilen unten...
	cmpi.b	#$2c,d0				; sind wir bei Position $ff+$2c?
	bne.w	CreaLoop			; wenn noch nicht, mach weiter!
	rts

; ****************************************************************************

; Parameter per "IS"

; BEG> 0
; end> 360
; AMOUNT> 250
; AMPLITUDE> $20
; YOFFSET> $20
; SIZE (B/W/L)> b
; MULTIPLIER> 1

SinTabHstarts:
	dc.b	$20,$21,$22,$23,$24,$24,$25,$26,$27,$28,$28,$29,$2a,$2b,$2b,$2c
	dc.b	$2d,$2e,$2e,$2f,$30,$30,$31,$32,$32,$33,$34,$34,$35,$36,$36,$37
	dc.b	$37,$38,$38,$39,$39,$3a,$3a,$3b,$3b,$3c,$3c,$3c,$3d,$3d,$3d,$3e
	dc.b	$3e,$3e,$3f,$3f,$3f,$3f,$3f,$40,$40,$40,$40,$40,$40,$40,$40,$40
	dc.b	$40,$40,$40,$40,$40,$40,$3f,$3f,$3f,$3f,$3f,$3e,$3e,$3e,$3d,$3d
	dc.b	$3d,$3c,$3c,$3c,$3b,$3b,$3a,$3a,$39,$39,$38,$38,$37,$37,$36,$36
	dc.b	$35,$34,$34,$33,$32,$32,$31,$30,$30,$2f,$2e,$2e,$2d,$2c,$2b,$2b
	dc.b	$2a,$29,$28,$28,$27,$26,$25,$24,$24,$23,$22,$21,$20,$20,$1f,$1e
	dc.b	$1d,$1c,$1c,$1b,$1a,$19,$18,$18,$17,$16,$15,$15,$14,$13,$12,$12
	dc.b	$11,$10,$10,$0f,$0e,$0e,$0d,$0c,$0c,$0b,$0a,$0a,$09,$09,$08,$08
	dc.b	$07,$07,$06,$06,$05,$05,$04,$04,$04,$03,$03,$03,$02,$02,$02,$01
	dc.b	$01,$01,$01,$01,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	dc.b	$00,$00,$00,$01,$01,$01,$01,$01,$02,$02,$02,$03,$03,$03,$04,$04
	dc.b	$04,$05,$05,$06,$06,$07,$07,$08,$08,$09,$09,$0a,$0a,$0b,$0c,$0c
	dc.b	$0d,$0e,$0e,$0f,$10,$10,$11,$12,$12,$13,$14,$15,$15,$16,$17,$18
	dc.b	$18,$19,$1a,$1b,$1c,$1c,$1d,$1e,$1f,$20
EndSinTabHstarts:

TabLength	= EndSinTabHstarts-SinTabHstarts

WaveSprites:
	addq.b	#1,Bar1Off
	moveq	#0,d0
	move.b	Bar1Off(pc),d0
	cmp.w	#TabLength,d0		; haben wir den maximalen offset?
	bne.s	NoStartingOver1
	clr.b	Bar1Off				; von vorne anfangen
NoStartingOver1:
	addq.b	#2,Bar2Off
	moveq	#0,d0
	move.b	Bar2Off(pc),d0
	cmp.w	#TabLength,d0
	bne.s	NoStartingOver2
	clr.b	Bar2Off				; von vorne anfangen
NoStartingOver2:
	moveq	#0,d1
	moveq	#0,d2
	moveq	#0,d3
	moveq	#0,d4
	moveq	#0,d5
	lea	SpritesBuffer,a0		; Adresse erstes Sprite
	lea	SinTabHstarts(pc),a1
	move.b	Bar1Off(pc),d0
	move.b	Bar2Off(pc),d2
	move.b	0(a1,d0.w),d5		; von sintab zweiter Bar1Off
WavyLoop:
	move.b	0(a1,d0.w),d3		; von sintab - fr Balken 1
	move.b	0(a1,d2.w),d4		; von sintab - fr Balken 2

; bearbeite alles

	add.b	d4,d3				; Balken 1
	sub.b	d5,d3				; 

	add.b	d5,d4				; Balken 2

	add.b	#105,d3				; mittlere Balken 1
	add.b	#75,d4				; mittlere Balken 2

; ndern Sie den HSTART (horizontale Position) der 8 Sprites

; ** erster Balken

	move.b	d3,1(a0)			; Sprite 1
	move.b	d3,LENGSPR+1(a0)	; 2

; jetzt das angehngte Sprite desselben Balkens, aber nebeneinander (16 Pixel spter)

	addq.w	#8,d3				; addiere 8, oder 16 pixel,
								; HSTART addiere 2 jedes Mal
	move.b	d3,(LENGSPR*2)+1(a0)	; 3
	move.b	d3,(LENGSPR*3)+1(a0)	; 4

; ** zweiter Balken

	move.b	d4,(LENGSPR*4)+1(a0)	; 5
	move.b	d4,(LENGSPR*5)+1(a0)	; 6

	addq.w	#8,d4				; addiere 8, oder 16 pixel,
								; HSTART addiere 2 jedes Mal
	move.b	d4,(LENGSPR*6)+1(a0)	; 7
	move.b	d4,(LENGSPR*7)+1(a0)	; 8

	addq.w	#1,d2				; nchster Versatz - Balken 2...
	cmpi.w	#TabLength,d2		; sind wir am Maximum?
	bne.s	NoRestart2
	moveq	#0,d2				; Lesen Sie den ersten Wert erneut...
NoRestart2:
	addq.w	#1,d0				; nchster Versatz - Balken 1
	cmp.w	#TabLength,d0		; sind wir am Maximum?
	bne.s	NoRestart1
	moveq	#0,d0				; Lesen Sie den ersten Wert erneut
NoRestart1:
	addq.w	#8,a0				; Fahren Sie mit der nchsten Wiederverwendung von Sprites fort

	cmpa.l	#SpritesBuffer+LENGSPR,a0 ; sind wir am Ende?
	bne.s	WavyLoop
	rts

Bar1Off:
	dc.w	0
Bar2Off:
	dc.w	0


; ****************************************************************************
;				Copperlist
; ****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP
	dc.w	$92,$38				; DDFSTRT
	dc.w	$94,$d0				; DDFSTOP

SpritePointers:
	dc.w	$120,0,$122,0,$124,0,$126,0,$128,0,$12a,0,$12c,0,$12e,0
	dc.w	$130,0,$132,0,$134,0,$136,0,$138,0,$13a,0,$13c,0,$13e,0

	dc.w	$108,0				; BPL1MOD
	dc.w	$10a,0				; BPL2MOD
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2

Bplpointers:
	dc.w	$e0,0,$e2,0			; erste Bitplane

	dc.w	$100,$1200			; BPLCON0 - 1 Bitplane lowres

	dc.w	$180,0				; COLOR00 - schwarz
	dc.w	$182,$fff			; COLOR01 - wei

; Sprite-Farben (attacched) - von COLOR17 bis COLOR31

	dc.w	$1a2,$010,$1a4,$020,$1a6,$030
	dc.w	$1a8,$140,$1aa,$250,$1ac,$360,$1ae,$470
	dc.w	$1b0,$580,$1b2,$690,$1b4,$7a0,$1b6,$8b0
	dc.w	$1b8,$9c0,$1ba,$ad0,$1bc,$be0,$1be,$cf0

	dc.w	$ffff,$fffe			; Ende Copperlist

; ****************************************************************************

	SECTION	BUFFER,BSS_C

SpritesBuffer:
	ds.b	LENGSPR*8			; 1024 bytes jedes Mega-Sprite

; ****************************************************************************

Bitplane:
	ds.b	40*256				; 1 Bitplane lowres "schwarz" wie Hintergrund.

	end