
; Listing11i2.s	- Bar in "Pseudoparallaxe"

	SECTION	COPPERADVANCED,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup2.s" ; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001010000000	; nur Copper DMA

WAITDISK	equ	30				; 50-150 zur Rettung (je nach Fall)

Start:
	bsr.w	WriteWaits				; erstelle 2 Copperlisten...

	lea	$dff000,a5					; Custom Register Base in a5
	move.w	#DMASET,$96(a5)			; DMACON - aktivieren Copper
	move.l	#Copperlist1,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)				; Start Copperlist
	move.w	#0,$1fc(a5)				; AGA "deaktivieren"
	move.w	#$c00,$106(a5)			; AGA "deaktivieren"
	move.w	#$11,$10c(a5)			; AGA "deaktivieren"

Mouse:
	bsr.w	WaitVb					; warte auf vertical Blank
	move.l	#Copperlist2,$dff080
	move.l	#Cop1Waits+6,Write		; Anfang Copperlist
	move.l	#Cop1Waits+6+(8*200),a4	; Ende Copperlist
	bsr.w	ClearCop				; Reinige die Copperlist
	bsr.w	MakeBeams				; erstelle die Bar

	bsr.w	WaitVb					; warte auf vertical Blank
	move.l	#Copperlist1,$dff080
	move.l	#Cop2Waits+6,Write		; Anfang  Copperlist
	move.l	#Cop2Waits+6+(8*200),a4	; Ende Copperlist
	bsr.w	ClearCop				; Reinige die Copperlist
	bsr.w	MakeBeams				; erstelle die Bar

	btst	#6,$bfe001				; Maus gedrckt?
	bne.s	Mouse
	rts								; Exit

*****************************************************************************
;	Routine die 2 Copperlist erstellt
*****************************************************************************

;	__/\__
;	\(Oo)/
;	/_()_\
;	  \/

WriteWaits:
	lea	Cop1Waits,a1
	lea	Cop2Waits,a2
	move.l	#$2c07ff00,d0		; Wait (erste Zeile $2c)
	move.l	#$01800000,d2		; COLOR00
	move.w	#200-1,d1			; Anzahl waits (200 fr Bereich NTSC)
WWLoop:
	move.l	d0,(a1)+			; Wait in coplist 1
	move.l	d0,(a2)+			; Wait in coplist 2

	move.l	d2,(a1)+			; COLOR00 in coplist1
	move.l	d2,(a2)+			; COLOR00 in coplist2
	add.l	#$01000000,d0		; Warten Sie 1 Zeile darunter
	dbra	d1,WWLoop
	rts

*****************************************************************************
;	Routine die den Hintergrund "subert"
*****************************************************************************

;	__/\__
;	\[oO]/
;	/_--_\
;	  \/

ClearCop:
	move.l	Write(pc),a0		; Copper aktuell
	moveq	#$001,d0			; Hintergrundfarbe
	move.w	#(200/4)-1,d1		; Anzahl waits
ClearLoop:
	move.w	d0,(a0)				; lschen
	move.w	d0,8(a0)			; ...
	move.w	d0,8*2(a0)
	move.w	d0,8*3(a0)
	lea	8*4(a0),a0
	dbra	d1,ClearLoop		; 200/4 mal wiederholen, weil es 4 
	rts							; words pro Schleife reinigt! (schneller!)

*****************************************************************************
;	Routine warten auf vblank
*****************************************************************************

;	__/\__
;	\-OO-/
;	/_\/_\
;	  \/

WaitVb:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$0ff00,d2			; warte auf Zeile $ff
WarteY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; warte auf Zeile $ff
	bne.s	WarteY1
WarteY2:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; warte auf Zeile $ff
	beq.s	WarteY2
	rts

*****************************************************************************
;	Routine die die Copperlist modifiziert
*****************************************************************************

;	__/\__
;	\(OO)/
;	/_==_\
;	  \/

MakeBeams:
	lea	Beam01(pc),a1			; Tabelle Farbe Bar 1
	move.l	Beam01x(pc),d0		; das x...
	moveq	#10,d1				; Abstand zwischen dem einen und dem anderen
	bsr.w	WriteBeam

	lea	Beam02(pc),a1			; Tabelle Farbe Bar 2
	move.l	Beam02x(pc),d0		; das x...
	moveq	#25,d1				; Abstand zwischen dem einen und dem anderen
	bsr.w	WriteBeam

	lea	Beam03(pc),a1			; Tabelle Farbe Bar 2
	move.l	Beam03x(pc),d0		; das x...
	moveq	#55,d1				; Abstand zwischen dem einen und dem anderen
	bsr.w	WriteBeam

; Beam01x sinkt um 1 alle 2 Frames.

	subq.b	#1,Timer01x			; 1 frame jeder 2.
	bne.s	Non01x				; frame vorbei? (Timer1x=0?)
	move.b	#2,Timer01x			; Reset 2 frame

	addq.l	#1,Beam01x			; heruntergehen um 1 Beam01x
	cmp.l	#8+10,Beam01x		; sind wir ganz unten?
	bne.s	Non01x
	clr.l	Beam01x				; wenn ja, wieder starten
Non01x:

; Beam02x sinkt um 1 bei jedem Frame.

	addq.l	#1,Beam02x			; heruntergehen um 1 Beam02x
	cmp.l	#16+25,Beam02x		; sind wir ganz unten?
	bmi.s	NonOn2
	clr.l	Beam02x				; wenn ja, wieder starten
NonOn2:

; Beam03x sinkt um 2 pro Frame.

	addq.l	#2,Beam03x			; heruntergehen um 2 Beam03x
	cmp.l	#16+55,Beam03x		; sind wir ganz unten?
	bmi.s	NonOn3

	clr.l	Beam03x				; wenn ja, wieder starten.
NonOn3:
	rts

Timer01x:
	dc.b	2

	even

Write:		dc.l	Cop1Waits+6		; Copper aktuell

Beam01x:	dc.l 10
Beam02x:	dc.l 5
Beam03x:	dc.l 2


*****************************************************************************
;	Routine die die Bars "schreibt"
*****************************************************************************
;	lea	Beam01(pc),a1	; Farbtabelle Beam01
;	move.l	Beam01x(pc),d0	; das x...
;	moveq	#10,d1		; der Abstand zwischen dem einen und dem anderen

;	__/\__
;	\ $$ /
;	/_()_\
;	  \/  

WriteBeam:
	move.l	Write(pc),a0		; Adresse Copper aktuell
	move.l	a1,a2				; Adresse Farbtabelle in a1 und a2
	lsl.w	#3,d0				; X * 8
	lsl.w	#3,d1				; Abstand zwischen den Stben * 8
	add.w	d0,a0				; Offset legen (x*8)
WBLoop2:
	move.l	a2,a1				; Farbtabelle
WBLoop:
	tst.w	(a1)				; Ende Farbtabelle?
	beq.s	EndOfBeam			; wenn ja, raus!
	move.w	(a1)+,(a0)			; Kopiere die Farbe aus der Tabelle in die Copbar
	addq.w	#8,a0				; gehe zur nchsten COLOR00
	cmp.l	a4,a0				; Ende Copperlist?
	bmi.s	WBloop				; wenn noch nicht, bleiben
EndOfBeam:
	add.w	d1,a0				; Sobald ein Takt fertig ist, wird ein weiterer mehr gemacht
								; unten: Wir addieren den Abstand * 8 per
								; Finden Sie heraus, wo der nchste Takt beginnt
	cmp.l	a4,a0				; und wir stellen sicher, dass wir kein Copper mehr haben
	bmi.s	WBloop2				; Wenn wir nicht drauen sind, knnen wir gehen!
	rts


; Farbtabelle der "entferntesten" und langsamsten Balken (blau)

Beam01:
	dc.w	$003
	dc.w	$005
	dc.w	$007
	dc.w	$009
	dc.w	$00a
	dc.w	$007
	dc.w	$005
	dc.w	$003
	dc.w	0

; Farbtabelle der Zwischenstbe (grn)

Beam02:
	dc.w	$001
	dc.w	$001
	dc.w	$010
	dc.w	$020
	dc.w	$030
	dc.w	$040
	dc.w	$050
	dc.w	$060
	dc.w	$070
	dc.w	$060
	dc.w	$050
	dc.w	$040
	dc.w	$030
	dc.w	$020
	dc.w	$010
	dc.w	$001
	dc.w	0

; Farbtabelle "in der Nhe" Balken (orange)

Beam03:
	dc.w	$110
	dc.w	$320
	dc.w	$520
	dc.w	$730
	dc.w	$940
	dc.w	$b50
	dc.w	$d60
	dc.w	$f70
	dc.w	$f60
	dc.w	$b50
	dc.w	$940
	dc.w	$730
	dc.w	$520
	dc.w	$420
	dc.w	$320
	dc.w	$210
	dc.w	$110
	dc.w	0


*****************************************************************************

	SECTION	COPPERLIST,DATA_C

; erste Copperlist

Copperlist1:
	dc.w	$180,$666			; COLOR00
	dc.w	$100,$200			; BPLCON0 - keine Bitplanes
Cop1Waits:
	dcb.w	4*200,0				; Raum fr Effekt
	dc.w	$180,$666			; COLOR00
	dc.w    $ffff,$fffe			; Ende Copperlist

; zweite Copperlist, ausgetauscht mit der ersten wie eine Art "Doppelpufferung"
; um die Mglichkeit auszuschlieen, nicht in der Lage zu sein, in die Copperliste
; rein zu schreiben, whrend sie angezeigt wird

Copperlist2:
	dc.w	$180,$666			; COLOR00
	dc.w	$100,$200			; BPLCON0 - keine Bitplanes
Cop2Waits:
	dcb.w	4*200,0				; Raum fr Effekt
	dc.w	$180,$666			; COLOR00
	dc.w    $ffff,$fffe			; Ende Copperlist

	end

Dieses Listing hat die Besonderheit, eine "doppelte Vercopperrung" zu sein, dh
er schreibt auf einen GRAPHIC, whrend man ein anderes sieht, das vorher
geschrieben wurde, um zu vermeiden, dass Sie ein langsames Schreiben auf dem
Bildschirm bemerken. Sie knnten auch das COP2LC + COPJMP2-System verwenden, um
Copperlisten auszutauschen.            