
; Listing11h2.s	- Routine, die ausgeblendete Balken erzeugt - benutzen sie die
; rechte Maustaste um die Balkenhhe zu erhhen.

	SECTION	COPPERADVANCED,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup2.s" ; speichern Sie Interrupt, DMA und so weiter.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001010000000	; nur Copper DMA

WAITDISK	equ	30				; 50-150 zur Rettung (je nach Fall)
LINES		equ	211

Start:
	bsr.s	MakeCop				; Copperliste erstellen

	lea	$dff000,a5
	move.w	#DMASET,$96(a5)		; DMACON - aktivieren Copper	
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$10500,d2			; warte auf Zeile $105
WarteY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; warte auf Zeile $105
	bne.s	WarteY1

 	bsr.s	ChangeCop			; Rufe die Routine auf, die den Copper ndert

	btst	#6,$bfe001			; Maus gedrckt?
	bne.s	Mouse
	rts

*****************************************************************************
; Routine die die Copperlist erstellt
*****************************************************************************

MakeCop:
	lea	CopCols,a0				; Adresse Puffer in Copperlist
	move.l	#$2c07fffe,d1		; Copper Wait-Anweisung, die startet
								; Warten auf Zeile $2c
	move.l	#$1800000,d2		; $dff180 = COLOR00 fr das Copper
	move.w	#LINES-1,d0			; Anzahl der Zeilen des Loop
CopLoop:
	move.l	d1,(a0)+			; Setzen des WAIT
	move.l	d2,(a0)+			; Setzen des $180 (COLOR00) auf schwarz gelscht
	add.l	#$01000000,d1		; Warten Sie eine Zeile darunter WAIT 1
	dbra	d0,CopLoop			; Wiederholen Sie dies bis zum Ende der Zeilen
	rts

*****************************************************************************
; Routine, die die Farben in der Copperlist ndert 
*****************************************************************************

;	            ________________________
;	           /                        \
;	  ___   ___\       ehHHHHhHh?        \
;	 /_    _\\_ ______________________/
;	 \ \_____/ / / /
;	  \_(I)_/ / /
;	  _l_U_l_ \/
;	 /  TT  \
;	/ _________ \ xCz
;	         

ChangeCop:
	btst	#2,$dff016			; rechte Maustaste gedrckt?
	bne.s	NoAdd				; Wenn nicht, springe zu NoAdd
	cmp.b	#$24,BarLen			; Andernfalls berprfen wir, ob wir bereits bei $24 sind
	beq.s	NoAdd				; In diesem Fall springt es zu NoAdd
	addq.b	#1,BarLen			; oder die Copperbar vergrern (BarLen)
NoAdd:
	lea	CopCols,a0				; Adresse Puffer in Copperlist
	move.w	#LINES-1,d0			; Anzahl der Zeilen des Loop
	move.l	PointerTabCol(pc),a1	; Beginn der Farbtabelle in a1
	move.l	a1,PointerTemporary	; gespeichert in PointerTemporary
	moveq	#0,d1				; d1 zurcksetzen
LineLoop:
	move.w	(a1)+,6(a0)			; Kopiere die Farbe aus der Tabelle in die Copperliste
	addq.w	#8,a0				; nchste COLOR00 in Copperlist
 	addq.b	#1,d1				; erhhe die Lnge der Bar in d1
 	cmp.b	BarLen(pc),d1		; Ende der Bar?
	bne.s	WaitUnderBar

	move.l	PointerTemporary(pc),a1
	addq.w	#2,a1				; Punkt nach frben
	cmp.l	#EndTabColBar,PointerTemporary	; sind wir am Ende der Tab?
	bne.s	DoNotStartAgain		; wenn nicht, weiter mit DoNotStartAgain
	lea	TabColBar(pc),a1		; ansonsten ab dem ersten col!
DoNotStartAgain:
	move.l	a1,PointerTemporary	; und speichern den Wert in Poi. vorbergehend
	moveq	#0,d1				; d1 zurcksetzen
WaitUnderBar:
	dbra d0,LineLoop			; Mach alle Zeilen	

	addq.l	#2,PointerTabCol	; nchste Farbe
	cmp.l	#EndTabColBar+2,PointerTabCol ; sind wir am Ende der Farbttabelle?							
	bne.s EndRoutine			; wenn nicht, raus, sonst...
	move.l #TabColBar,PointerTabCol	 ; ab dem ersten Wert von
								; TabColBar
EndRoutine:
	rts

; Balkenhhe

BarLen:
	dc.b	1

	even


; Tabelle mit RGB-Farbwerten. In diesem Fall handelt es sich um Blautne

TabColBar:
	dc.w	$000,$001,$002,$003,$004,$005,$006,$007
	dc.w	$008,$009,$00a,$00b,$00c,$00d,$00d,$00e
	dc.w	$00e,$00f,$00f,$00f,$00e,$00e,$00d,$00d
	dc.w	$00c,$00b,$00a,$009,$008,$007,$006,$005
	dc.w	$004,$003,$002,$001,$000,$000,$000,$000
	dcb.w	10,$000
EndTabColBar:
	dc.w	$000,$001,$002,$003,$004,$005,$006,$007	; diese Werte werden bentigt
	dc.w	$008,$009,$00a,$00b,$00c,$00d,$00d,$00e ; fr die Nebenstangen
	dc.w	$00e,$00f,$00f,$00f,$00e,$00e,$00d,$00d
	dc.w	$00c,$00b,$00a,$009,$008,$007,$006,$005
	dc.w	$004,$003,$002,$001,$000,$000,$000,$000


PointerTemporary:
 	dc.l	TabColBar

PointerTabCol:
 	dc.l	TabColBar

*****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$180,$000			; COLOR00 schwarz
	dc.w	$100,$200			; BPLCON0 - keine Bitplanes

CopCols:
	dcb.b	LINES*8,0			; Platz fr 100 Zeilen in diesem Format:
								; WAIT xx07,$fffe
								; MOVE $180,$xxx	; COLOR00
	dc.w	$ffdf,$fffe
	dc.w	$0107,$fffe
	dc.w	$180,$010
	dc.w	$0207,$fffe
	dc.w	$180,$020
	dc.w	$0307,$fffe
	dc.w	$180,$030
	dc.w	$0507,$fffe
	dc.w	$180,$040
	dc.w	$0707,$fffe
	dc.w	$180,$050
	dc.w	$0907,$fffe
	dc.w	$180,$060
	dc.w	$0c07,$fffe
	dc.w	$180,$070
	dc.w	$0f07,$fffe
	dc.w	$180,$080
	dc.w	$1207,$fffe
	dc.w	$180,$090
	dc.w	$1507,$fffe
	dc.w	$180,$0a0

	dc.w	$180,$000			; COLOR00 schwarz
	dc.w	$ffff,$fffe			; Ende Copperlist
 
	end