
; Listing11g7.s -  Verwendung der Coppereigenschaft, einen "MOVE"
; durchzufhren erfordert horizontal 8 Pixel.
; Plasma. rechte Taste, um es zu sperren.	

	SECTION	COPPERADVANCED,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup2.s" ; speichern Sie Interrupt, DMA und so weiter.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001010000000	; Copper DMA aktivieren

WAITDISK	equ	30				; 50-150 zur Rettung (je nach Fall)

Start:
	bsr.w	MakePlasma			; festlegen der Farben fr "Pseudoplasma"

	lea	$dff000,a5
	move.w	#DMASET,$96(a5)		; DMACON - aktivieren Copper
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$0e000,d2			; warte auf Zeile $e0
WarteY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; warte auf Zeile $e0
	bne.s	WarteY1

	btst	#2,$dff016			; rechte Maustaste gedrckt?
	beq.s	Mouse2				; wenn nicht, dann Plasma

	bsr.w	Plasma				; Plasma-Effekt (mehr oder weniger ...)

Mouse2:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$0e000,d2			; warte auf Zeile $e0
WarteY2:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; warte auf Zeile $e0
	beq.s	WarteY2

	btst	#6,$bfe001			; Maus gedrckt?
	bne.s	Mouse
	rts

******************************************************************************
;			GENERIEREN DER FARBEN DES PLASMAS
******************************************************************************

;		       __
;	            ./  \:
;	            |    |
;	          __(_  _)__
;	   _    ___( )( )___
;	 _| |   \_/  \ \_/
;	| |_|_  _/   (__)   \_
;	|_|\_ \ \ (________) /
;	 (_  _/  \  V -- V  /        __
;	   \ \    \________/        /_(
;	    \ \_____ _\/_ ________ ((__)
;	     \______(    )__________(__)
;	             \__/
;	             ||||
;	           __||||__
;	          /___||___\ gm


MakePlasma:
	lea	PlasmaZone,a0			; Adresse Farben in coplist
	lea	ColCopDat,a1			; Tabelle Farben
	moveq	#80-1,d7			; Anzahl Zeilen
	moveq	#9,d2				; und stelle den Zhler auf 9
MakeLine:
	moveq	#52-1,d6			; Anzahl der COLOR00 fr jede Zeile
	addq.w	#4,a0				; berspringe das WAIT zwischen den Zeilen
MakeOneLine:
	addq.w	#2,a0				; berspringe das dc.w $180
	move.w	(a1)+,(a0)+			; sofort danach die Farbe platzieren
	dbra	d6,MakeOneLine
	subq.b	#1,d2				; markiert, dass wir eine Zeile gemacht haben
	bne.s	DoNotStartAgain		; Wenn wir 9 gemacht haben, ist d6 = 0, 
								; dann ist es notwendig mit der ersten Farbe
								; in der Tabelle neu zu starten.
	lea	ColCopDat(pc),a1		; Tab Farben in a1 - beginne mit den Farben.
	moveq	#9,d2				; und stelle den Zhler auf 9
DoNotStartAgain:
	dbra	d7,MakeLine
	rts


;	Tabelle mit 52 * 9 Farben einer horizontalen Zeile.

ColCopDat:
	dc.w	$26f,$27e,$28d,$29c,$2ab,$2ba,$2c9,$2d8,$2e7,$2f6
	dc.w	$4e7,$6d8,$8c9,$aba,$caa,$d9a,$e8a,$f7a,$f6c,$f5c
	dc.w	$d6d,$b6e,$96f,$76f,$56f,$36f,$26f,$27e,$28d,$29c
	dc.w	$2ab,$2ba,$2c9,$2d8,$2e7,$2f6,$4e7,$6d8,$8c9,$aba
	dc.w	$caa,$d9a,$e8a,$f7a,$f6b,$f5c,$d6d,$b6e,$96f,$76f
	dc.w	$56f,$36f,$36f,$37e,$38d,$39c,$3ab,$3ba,$3c9,$3d8
	dc.w	$3e7,$3f6,$4e7,$7d8,$9c9,$bba,$daa,$e9a,$f8a,$f7a
	dc.w	$f6c,$f5c,$e6d,$c6e,$a6f,$86f,$66f,$46f,$36f,$37e
	dc.w	$38d,$39c,$3ab,$3ba,$3c9,$3d8,$3e7,$3f6,$5e7,$7d8
	dc.w	$9c9,$bba,$daa,$e9a,$f8a,$f7a,$f6b,$f5c,$e6d,$c6e ; 10
	dc.w	$a6f,$86f,$46f,$46f,$36e,$37d,$38c,$39b,$3aa,$3b9
	dc.w	$3c8,$3d7,$3e6,$3f5,$4e6,$7d7,$9c8,$bb9,$da9,$e99
	dc.w	$f89,$f79,$f6b,$f5b,$e6c,$c6d,$a6e,$86e,$66e,$46e
	dc.w	$36e,$37d,$38c,$39b,$3aa,$3b9,$3c8,$3d7,$3e6,$3f5
	dc.w	$5e6,$7d7,$9c8,$bb9,$da9,$e99,$f89,$f79,$f6a,$f5b
	dc.w	$e6c,$c6e,$a6e,$86e,$46e,$46e,$46e,$47d,$48c,$49b
	dc.w	$4aa,$4b9,$4c8,$4d7,$4e6,$4f5,$5e6,$8d7,$ac8,$cb9
	dc.w	$ea9,$f99,$f89,$f79,$f6b,$f5b,$f6c,$d6d,$b6e,$96e
	dc.w	$76e,$56e,$46e,$47d,$48c,$49b,$4aa,$4b9,$4c8,$4d7
	dc.w	$4e6,$4f5,$6e6,$8d7,$ac8,$cb9,$ea9,$f99,$f89,$f79 ; 20
	dc.w	$f6a,$f5b,$f6c,$d6e,$b6e,$96e,$56e,$56e,$45e,$46d
	dc.w	$47c,$48b,$49a,$4a9,$4b8,$4c7,$4d6,$4e5,$5d6,$8c7
	dc.w	$ab8,$ca9,$e99,$f89,$f79,$f69,$f5b,$f4b,$f5c,$d5d
	dc.w	$b5e,$95e,$75e,$55e,$45e,$46d,$47c,$48b,$49a,$4a9
	dc.w	$4b8,$4c7,$4d6,$4e5,$6d6,$8c7,$ab8,$ca9,$e99,$f89
	dc.w	$f79,$f69,$f5a,$f4b,$f5c,$d5e,$b5e,$95e,$55e,$55e
	dc.w	$44d,$45c,$46b,$47a,$489,$498,$4a7,$4b6,$4c5,$4d4
	dc.w	$5c5,$8b6,$aa7,$c98,$e88,$f78,$f68,$f68,$f59,$f4a
	dc.w	$f4b,$d4c,$b4d,$94d,$74d,$54d,$44d,$45c,$46b,$47a
	dc.w	$489,$498,$4a7,$4b6,$4c5,$4d4,$6c5,$8b6,$aa7,$c98 ; 30
	dc.w	$e88,$f78,$f68,$f58,$f49,$f3a,$f4b,$d4d,$b4d,$94d
	dc.w	$54d,$54d,$44c,$45b,$46a,$479,$488,$499,$4a6,$4b5
	dc.w	$4c4,$4d3,$5c4,$8b5,$aa6,$c97,$e87,$f77,$f67,$f67
	dc.w	$f58,$f49,$f4c,$d4b,$b4c,$94c,$74c,$54c,$44c,$45b
	dc.w	$46a,$479,$488,$497,$4a6,$4b5,$4c4,$4d3,$6c4,$8b5
	dc.w	$aa6,$c97,$e87,$f77,$f67,$f57,$f48,$f39,$f4a,$d4c
	dc.w	$b4c,$94c,$54c,$54c,$44b,$45a,$469,$478,$487,$498
	dc.w	$4a5,$4b4,$4c3,$4d2,$5c3,$8b4,$aa5,$c96,$e86,$f76
	dc.w	$f66,$f66,$f57,$f48,$f4b,$d4a,$b4b,$94b,$74b,$54b
	dc.w	$44b,$45a,$469,$478,$487,$496,$4a5,$4b4,$4c3,$4d2 ; 40
	dc.w	$6c3,$8b4,$aa5,$c96,$e86,$f76,$f66,$f56,$f47,$f38
	dc.w	$f49,$d4b,$b4b,$94b,$54b,$54b,$44a,$459,$468,$477
	dc.w	$486,$497,$4a4,$4b3,$4c2,$4d1,$5c2,$8b3,$aa4,$c95
	dc.w	$e85,$f75,$f65,$f65,$f56,$f47,$f4a,$d49,$b4a,$94a
	dc.w	$74a,$54a,$44a,$459,$468,$477,$486,$495,$4a4,$4b3
	dc.w	$4c2,$4d1,$6c2,$8b3,$aa4,$c95,$e85,$f75,$f65,$f55 ; 46*10=460
	dc.w	$f46,$f37,$f48,$d4a,$b4a,$94a,$54a,$54a			  ; 468 = (52*9)	
	
Pvar1:
	dc.b	0
Pvar2:
	dc.b	0
Pvar3:
	dc.w	0

******************************************************************************
; Diese Routine, ndert alle 54 * 80 = 4320 Farben der Copperliste. Es
; ndert die 80 WAIT zwischen einer und der anderen Zeile, um die Zeilen
; an verschiedenen horizontalen Positionen zu starten. Dieses System ist
; schnell und kann  die Zeilen einfach nach rechts oder links scrollen. 
; Wir werden ein echtes Plasma spter sehen.
******************************************************************************

;	   _________           :
;	___\_      /           :
;	\_________/       __.____
;	  |     |    .-  (_______)
;	  !     _    :  __'''''`_
;	 _-----(_)__ `- \_   _  __)
;	( __  _  ___)     \__/  \_
;	 \_/ /__/           \  __/
;	  /    (_            )).
;	  \_____/--------------'gm


Plasma:
	moveq	#0,d1				; wir nullen die Register
	moveq	#0,d3
	moveq	#0,d5
	move.b	Pvar1(pc),d1
	move.b	Pvar2(pc),d4
	move.b	Pvar3(pc),d5
	lea	PlasmaZone,a0			; Adresse Plasma in Copperlist
	lea	PlasmaMoves(pc),a1		; Adresse Tabelle mit Bewegungen
	move.w	#$8101,d3			; Wait Minimum hinzuzufgen
	move.w	#79-1,d7			; Anzahl Zeilen des "Plasmas"
Plasma2:
	moveq	#0,d0				; d0 zurcksetzen
	move.b	0(a1,d1.w),d0		; und wir nehmen von der Tabelle in gewisser Weise
	add.b	0(a1,d4.w),d0		; die wenig vernderten richtigen zweiten Werte
	add.b	0(a1,d5.w),d0		; die 3 Variablen
	bclr.l	#0,d0				; Wir brauchen das niedrige Stck nicht
	add.w	d3,d0				; Fge die minimale Wartezeit hinzu
	add.w	#$0100,d3			; und verschieben die minimale Wartezeit um eine Zeile darunter
	move.w	d0,(a0)				; Setze das genderte WAIT 
	add.w	#(52*4)+4,a0		; und zum nchsten WAIT springen
	add.b	#$ff,d1				; whle nur das Low-Byte von d1
	addq.b	#4,d4				; addiere 4 zu d4
	add.b	#$7d,d5				; und 125 zu d5 (was fr ein Durcheinander...)
	dbra	d7,Plasma2

	addq.b	#1,Pvar1			; Nach diesen 3 Variablen ndert sich das Casino
	addq.b	#2,Pvar2
	addq.b	#1,Pvar3
	rts


; Parameter fr den Befehl "IS":
;
; BEG> 0
; end> 180
; AMOUNT> 256
; AMPLITUDE> $4A
; YOFFSET> 0
; SIZE> B
; MULTIPLIER> 1

PlasmaMoves:	; 256 bytes
	dc.b	$00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0a,$0a,$0b,$0c,$0d,$0e
	dc.b	$0f,$10,$11,$12,$12,$13,$14,$15,$16,$17,$18,$19,$19,$1a,$1b,$1c
	dc.b	$1d,$1e,$1e,$1f,$20,$21,$22,$22,$23,$24,$25,$26,$26,$27,$28,$29
	dc.b	$29,$2a,$2b,$2c,$2c,$2d,$2e,$2f,$2f,$30,$31,$31,$32,$33,$33,$34
	dc.b	$35,$35,$36,$37,$37,$38,$38,$39,$39,$3a,$3b,$3b,$3c,$3c,$3d,$3d
	dc.b	$3e,$3e,$3f,$3f,$40,$40,$41,$41,$41,$42,$42,$43,$43,$43,$44,$44
	dc.b	$45,$45,$45,$46,$46,$46,$46,$47,$47,$47,$47,$48,$48,$48,$48,$48
	dc.b	$49,$49,$49,$49,$49,$49,$49,$4a,$4a,$4a,$4a,$4a,$4a,$4a,$4a,$4a
	dc.b	$4a,$4a,$4a,$4a,$4a,$4a,$4a,$4a,$4a,$49,$49,$49,$49,$49,$49,$49
	dc.b	$48,$48,$48,$48,$48,$47,$47,$47,$47,$46,$46,$46,$46,$45,$45,$45
	dc.b	$44,$44,$43,$43,$43,$42,$42,$41,$41,$41,$40,$40,$3f,$3f,$3e,$3e
	dc.b	$3d,$3d,$3c,$3c,$3b,$3b,$3a,$39,$39,$38,$38,$37,$37,$36,$35,$35
	dc.b	$34,$33,$33,$32,$31,$31,$30,$2f,$2f,$2e,$2d,$2c,$2c,$2b,$2a,$29
	dc.b	$29,$28,$27,$26,$26,$25,$24,$23,$22,$22,$21,$20,$1f,$1e,$1e,$1d
	dc.b	$1c,$1b,$1a,$19,$19,$18,$17,$16,$15,$14,$13,$12,$12,$11,$10,$0f
	dc.b	$0e,$0d,$0c,$0b,$0a,$0a,$09,$08,$07,$06,$05,$04,$03,$02,$01,$00

******************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$100,$200			; BPLCON0 - keine Bitplanes
	dc.w	$180,$000			; COLOR00 schwarz
	dc.w	$7f19,$fffe
	dc.w	$180,$ff0			; gelb
	dc.w	$8007,$fffe
	dc.w	$180,$06a			; Farben dazwischen

PlasmaZone:
								; Wir htten dieses Stck Copperliste 
								; auch mit einer Routine machen knnen...
	dc.l	$8101fffe			; wait
	dcb.l	52,$1800000			; 52*COLOR00
	dc.l	$8201fffe			; wait
	dcb.l	52,$1800000			; 52*COLOR00
	dc.l	$8301fffe			; etc	
	dcb.l	52,$1800000
	dc.l	$8401fffe
	dcb.l	52,$1800000
	dc.l	$8501fffe
	dcb.l	52,$1800000
	dc.l	$8601fffe
	dcb.l	52,$1800000
	dc.l	$8701fffe
	dcb.l	52,$1800000
	dc.l	$8801fffe
	dcb.l	52,$1800000
	dc.l	$8901fffe
	dcb.l	52,$1800000
	dc.l	$8a01fffe
	dcb.l	52,$1800000
	dc.l	$8b01fffe
	dcb.l	52,$1800000
	dc.l	$8c01fffe
	dcb.l	52,$1800000
	dc.l	$8d01fffe
	dcb.l	52,$1800000
	dc.l	$8e01fffe
	dcb.l	52,$1800000
	dc.l	$8f01fffe
	dcb.l	52,$1800000
	dc.l	$9001fffe
	dcb.l	52,$1800000
	dc.l	$9101fffe
	dcb.l	52,$1800000
	dc.l	$9201fffe
	dcb.l	52,$1800000
	dc.l	$9301fffe
	dcb.l	52,$1800000
	dc.l	$9401fffe
	dcb.l	52,$1800000
	dc.l	$9501fffe
	dcb.l	52,$1800000
	dc.l	$9601fffe
	dcb.l	52,$1800000
	dc.l	$9701fffe
	dcb.l	52,$1800000
	dc.l	$9801fffe
	dcb.l	52,$1800000
	dc.l	$9901fffe
	dcb.l	52,$1800000
	dc.l	$9a01fffe
	dcb.l	52,$1800000
	dc.l	$9b01fffe
	dcb.l	52,$1800000
	dc.l	$9c01fffe
	dcb.l	52,$1800000
	dc.l	$9d01fffe
	dcb.l	52,$1800000
	dc.l	$9e01fffe
	dcb.l	52,$1800000
	dc.l	$9f01fffe
	dcb.l	52,$1800000
	dc.l	$a001fffe
	dcb.l	52,$1800000
	dc.l	$a101fffe
	dcb.l	52,$1800000
	dc.l	$a201fffe
	dcb.l	52,$1800000
	dc.l	$a301fffe
	dcb.l	52,$1800000
	dc.l	$a401fffe
	dcb.l	52,$1800000
	dc.l	$a501fffe
	dcb.l	52,$1800000
	dc.l	$a601fffe
	dcb.l	52,$1800000
	dc.l	$a701fffe
	dcb.l	52,$1800000
	dc.l	$a801fffe
	dcb.l	52,$1800000
	dc.l	$a901fffe
	dcb.l	52,$1800000
	dc.l	$aa01fffe
	dcb.l	52,$1800000
	dc.l	$ab01fffe
	dcb.l	52,$1800000
	dc.l	$ac01fffe
	dcb.l	52,$1800000
	dc.l	$ad01fffe
	dcb.l	52,$1800000
	dc.l	$ae01fffe
	dcb.l	52,$1800000
	dc.l	$af01fffe
	dcb.l	52,$1800000
	dc.l	$b001fffe
	dcb.l	52,$1800000
	dc.l	$b101fffe
	dcb.l	52,$1800000
	dc.l	$b201fffe
	dcb.l	52,$1800000
	dc.l	$b301fffe
	dcb.l	52,$1800000
	dc.l	$b401fffe
	dcb.l	52,$1800000
	dc.l	$b501fffe
	dcb.l	52,$1800000
	dc.l	$b601fffe
	dcb.l	52,$1800000
	dc.l	$b701fffe
	dcb.l	52,$1800000
	dc.l	$b801fffe
	dcb.l	52,$1800000
	dc.l	$b901fffe
	dcb.l	52,$1800000
	dc.l	$ba01fffe
	dcb.l	52,$1800000
	dc.l	$bb01fffe
	dcb.l	52,$1800000
	dc.l	$bc01fffe
	dcb.l	52,$1800000
	dc.l	$bd01fffe
	dcb.l	52,$1800000
	dc.l	$be01fffe
	dcb.l	52,$1800000
	dc.l	$bf01fffe
	dcb.l	52,$1800000
	dc.l	$c001fffe
	dcb.l	52,$1800000
	dc.l	$c101fffe
	dcb.l	52,$1800000
	dc.l	$c201fffe
	dcb.l	52,$1800000
	dc.l	$c301fffe
	dcb.l	52,$1800000
	dc.l	$c401fffe
	dcb.l	52,$1800000
	dc.l	$c501fffe
	dcb.l	52,$1800000
	dc.l	$c601fffe
	dcb.l	52,$1800000
	dc.l	$c701fffe
	dcb.l	52,$1800000
	dc.l	$c801fffe
	dcb.l	52,$1800000
	dc.l	$c901fffe
	dcb.l	52,$1800000
	dc.l	$ca01fffe
	dcb.l	52,$1800000
	dc.l	$cb01fffe
	dcb.l	52,$1800000
	dc.l	$cc01fffe
	dcb.l	52,$1800000
	dc.l	$cd01fffe
	dcb.l	52,$1800000
	dc.l	$ce01fffe
	dcb.l	52,$1800000
	dc.l	$cf01fffe
	dcb.l	52,$1800000
	dc.l	$d001fffe
	dcb.l	52,$1800000
	dc.l	$d101fffe

	dc.l	$d219fffe			; Wait $d2
	dc.l	$1800ff0			; COLOR00 gelb
	dc.l	$d311fffe			; Wait $d3
	dc.l	$1800000			; COLOR00 schwarz
	dc.l	$fffffffe			; Ende Copperlist

	end
