
; Listing11g6.s -  Verwendung der Coppereigenschaft, einen "MOVE"
; durchzufhren erfordert horizontal 8 Pixel.

	SECTION	COPPERADVANCED,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup2.s" ; speichern Sie Interrupt, DMA und so weiter.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001010000000	; Copper DMA aktivieren

WAITDISK	equ	30				; 50-150 zur Rettung (je nach Fall)
NUMLINES	=	80

Start:	
	bsr.w	MakeIt				; Copperliste erstellen!

	lea	$dff000,a5
	move.w	#DMASET,$96(a5)		; DMACON - aktivieren Copper
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$0e000,d2			; warte auf Zeile $e0
WarteY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; warte auf Zeile $e0
	bne.s	WarteY1

	btst	#2,$16(a5)			; rechte Maustaste gedrckt?
	beq.s	Mouse2

	bsr.w	FantaCop			; Farben rollen...

Mouse2:
	btst	#6,$bfe001			; Maus gedrckt?
	bne.s	Mouse

	rts

*****************************************************************************
*		Routine dadurch wird die Copperliste mit dem Effekt erstellt	    *
*****************************************************************************

;	  ____________
;	  \          /
;	   \________/
;	     |  ._|_
;	    ____|o \
;	 ___(__|___)___
;	 \_/  (___)/\\_/
;	  / \_____/  \\
;	_/     \______\\_
;	\_______________/gm


MakeIt:
	move.l	#$5001fffe,d2		; $50 = erste vertikale Zeile
	lea	CopBuf,a0				; Adresse Copper Puffer
	moveq	#NUMLINES-1,d6		; Anzahl Zeilen...
Main0:
	lea	Colors(pc),a1			; Tabelle mit Farben...
	moveq	#32-1,d7			; Anzahl 
	move.l	d2,(a0)+			; das WAIT setzen
	move.l	#$01800505,(a0)+	; COLOR00
Cop0:
	move.w	#$0180,(a0)+		; Register COLOR00
	move.w	(a1)+,(a0)+			; Wert von COLOR00 aus der Tabelle entnommen
	dbra	d7,Cop0				; Mache eine Zeile mit 32 COLOR00...
	move.l	#$01800505,(a0)+	; COLOR00 setzen
	addi.l	#$01020000,d2		; Warte 1 Zeile darunter und 2 weitere nach vorne
								; um die "diagonale" zu erstellen.
	dbra	d6,Main0			; alle Zeilen machen
	rts

; Tabelle Farben

Colors:
	dc.w	$100,$101,$202,$303,$404,$505,$606,$707
	dc.w	$808,$909,$a0a,$b0b,$c0c,$d0d,$e0e,$f0f
	dc.w	$f0f,$e0e,$d0d,$c0c,$b0b,$a0a,$909,$808
	dc.w	$707,$606,$505,$404,$303,$202,$101,$100

*****************************************************************************
*		Routine, die die Farben des Effekts wechselt					    *
*****************************************************************************

;	    __
;	   (((________.
;	    \_____.---|
;	     ____ |---|
;	  ___(__||---|__
;	 /   ___  )__/_ /
;	/______)\   _/_/
;	     \___\ /\
;	       \__/gm


FantaCop:
	lea	CopBuf+8,a0				; erste Adresse mit dem Zyklus
	moveq	#NUMLINES-1,d6		; Anzahl der zu erledigenden Zeilen
Move1:
	move.w	2(a0),d0			; Speichern der ersten Farbe in d0
Move0:
	move.w	2(a0),-2(a0)		; Kopiere die 32 Farben der Zeile
	move.w	6(a0),2(a0)			; "zurck" an einen Ort.							
	move.w	6+4(a0),2+4(a0)
	move.w	6+4*2(a0),2+4*2(a0)
	move.w	6+4*3(a0),2+4*3(a0)
	move.w	6+4*4(a0),2+4*4(a0)
	move.w	6+4*5(a0),2+4*5(a0)
	move.w	6+4*6(a0),2+4*6(a0)
	move.w	6+4*7(a0),2+4*7(a0)
	move.w	6+4*8(a0),2+4*8(a0)
	move.w	6+4*9(a0),2+4*9(a0)
	move.w	6+4*10(a0),2+4*10(a0)
	move.w	6+4*11(a0),2+4*11(a0)
	move.w	6+4*12(a0),2+4*12(a0)
	move.w	6+4*13(a0),2+4*13(a0)
	move.w	6+4*14(a0),2+4*14(a0)
	move.w	6+4*15(a0),2+4*15(a0)
	move.w	6+4*16(a0),2+4*16(a0)
	move.w	6+4*17(a0),2+4*17(a0)
	move.w	6+4*18(a0),2+4*18(a0)
	move.w	6+4*19(a0),2+4*19(a0)
	move.w	6+4*20(a0),2+4*20(a0)
	move.w	6+4*21(a0),2+4*21(a0)
	move.w	6+4*22(a0),2+4*22(a0)
	move.w	6+4*23(a0),2+4*23(a0)
	move.w	6+4*24(a0),2+4*24(a0)
	move.w	6+4*25(a0),2+4*25(a0)
	move.w	6+4*26(a0),2+4*26(a0)
	move.w	6+4*27(a0),2+4*27(a0)
	move.w	6+4*28(a0),2+4*28(a0)
	move.w	6+4*29(a0),2+4*29(a0)
	move.w	6+4*30(a0),2+4*30(a0)
	move.w	6+4*31(a0),2+4*31(a0)
	lea	4*32(a0),a0				; Wir zeigen auf die nchste Zeile
	move.w	d0,-(a0)			; Legen Sie die erste als letzte gespeicherte Farbe ein,
								; um den Zyklus nicht zu unterbrechen.
	lea	14(a0),a0				; berspringe das Warten + bewege "extern"
	dbra	d6,Move1			; Wir fhren alle Zeilen aus
	rts

*****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$100,$200			; BPLCON0 - keine Bitplanes.
CopBuf:
	ds.b	NUMLINES*12+NUMLINES*$20*4 ; Raum fr den Effekt
	dc.w	$ffff,$fffe			; Ende Copperlist

	end
                                      