
; Listing11g3.s -  Verwendung der Coppereigenschaft, einen "MOVE"
; durchzufhren erfordert horizontal 8 Pixel.

	SECTION	COPPERADVANCED,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup2.s"	; speichern Sie Interrupt, DMA und so weiter.
*****************************************************************************

; Mit DMASET entscheiden wir, welche DMA-Kanle geffnet und welche geschlossen werden sollen

			;5432109876543210
DMASET	equ	%1000001010000000	; Copper DMA aktivieren

WAITDISK	equ	30				; 50-150 zur Rettung (je nach Fall)

Start:
	bsr.w	MakeIt				; Copperlist vorbereiten

	move.w	#DMASET,$96(a5)		; DMACON - aktivieren Copper								
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse:
	btst	#$06,$bfe001		; Maus gedrckt?
	bne.s	Mouse

	rts

*************************************************************************
* Diese Routine erstellt eine Copperliste mit 52 COLOR00 Registern fr	*
* eine Zeile, also, da jeder move in der Copperliste 8 Pixel (lowres)	*
* der auszufhrenden Zeit dauert, wird COLOR00							*
* 52-mal HORIZONTAL in Schritten von 8 Pixeln gendert					*
*************************************************************************

;	  .:::::.
;	 ::::::
;	 | _ - |
;	C|  o   l)
;	 _ (_) _|
;	 |\_____/|
;	 l_l|_!
;	  `-----'xCz

LINSTART	equ	$8021fffe		; ndern von "$80", um in einer
								; anderen vertikalen Zeile zu starten.
LINES		equ	80				; Anzahl der zu erledigenden Zeilen.

MakeIt:
	lea	Cols(pc),a0				; Adresstabelle mit Farben in a0
	lea	CopBuf,a1				; Adressraum in Copperlist
	move.l	#LINSTART,d0		; erstes "wait"
	move.w	#LINES-1,d1			; Anzahl der zu erledigenden Zeilen
	move.w	#$180,d3			; Word fr Register COLOR00 in coplist
	move.l	#$01000000,d4		; Wert, der zum Wait zur nchsten Zeile
								; hinzugefgt werden soll.
	moveq	#9,d6				; und stelle den Zhler auf 9
Colcon1:
	move.w	#52-1,d2			; 52 color pro Zeile
	move.l	d0,(a1)+			; Setzen des WAIT in der Copperlist
Colcon2:
	move.w	d3,(a1)+			; Setzen des Registers COLOR00 ($180)
	move.w	(a0)+,(a1)+			; Setze den Wert von COLOR00 (aus der Tabelle)
	dbra	d2,Colcon2			; Fhre eine ganze Zeile aus
	add.l	d4,d0				; "WAIT" machen eine Zeile darunter (+$01000000)
	subq.b	#1,d6				; markiert, dass wir eine Zeile gemacht haben
	bne.s	DoNotStartAgain		; Wenn wir 9 gemacht haben, ist d6 = 0, dann ist es notwendig
								; Starten Sie ab der ersten Farbe in der Tabelle neu.
	lea	Cols(pc),a0				; Tab Farben in a0 - mit Farben teilen.
	moveq	#9,d6				; und stelle den Zhler auf 9
DoNotStartAgain:
	dbra	d1,Colcon1			; Wiederholen Sie dies fr die Anzahl
								; der zu erledigenden Zeilen
	rts


;	Tabelle mit 52 * 9 Farben einer horizontalen Zeile.

Cols:
	dc.w	$26f,$27e,$28d,$29c,$2ab,$2ba,$2c9,$2d8,$2e7,$2f6
	dc.w	$4e7,$6d8,$8c9,$aba,$caa,$d9a,$e8a,$f7a,$f6c,$f5c
	dc.w	$d6d,$b6e,$96f,$76f,$56f,$36f,$26f,$27e,$28d,$29c
	dc.w	$2ab,$2ba,$2c9,$2d8,$2e7,$2f6,$4e7,$6d8,$8c9,$aba
	dc.w	$caa,$d9a,$e8a,$f7a,$f6b,$f5c,$d6d,$b6e,$96f,$76f
	dc.w	$56f,$36f,$36f,$37e,$38d,$39c,$3ab,$3ba,$3c9,$3d8
	dc.w	$3e7,$3f6,$4e7,$7d8,$9c9,$bba,$daa,$e9a,$f8a,$f7a
	dc.w	$f6c,$f5c,$e6d,$c6e,$a6f,$86f,$66f,$46f,$36f,$37e
	dc.w	$38d,$39c,$3ab,$3ba,$3c9,$3d8,$3e7,$3f6,$5e7,$7d8
	dc.w	$9c9,$bba,$daa,$e9a,$f8a,$f7a,$f6b,$f5c,$e6d,$c6e
	dc.w	$a6f,$86f,$46f,$46f,$36e,$37d,$38c,$39b,$3aa,$3b9
	dc.w	$3c8,$3d7,$3e6,$3f5,$4e6,$7d7,$9c8,$bb9,$da9,$e99
	dc.w	$f89,$f79,$f6b,$f5b,$e6c,$c6d,$a6e,$86e,$66e,$46e
	dc.w	$36e,$37d,$38c,$39b,$3aa,$3b9,$3c8,$3d7,$3e6,$3f5
	dc.w	$5e6,$7d7,$9c8,$bb9,$da9,$e99,$f89,$f79,$f6a,$f5b
	dc.w	$e6c,$c6e,$a6e,$86e,$46e,$46e,$46e,$47d,$48c,$49b
	dc.w	$4aa,$4b9,$4c8,$4d7,$4e6,$4f5,$5e6,$8d7,$ac8,$cb9
	dc.w	$ea9,$f99,$f89,$f79,$f6b,$f5b,$f6c,$d6d,$b6e,$96e
	dc.w	$76e,$56e,$46e,$47d,$48c,$49b,$4aa,$4b9,$4c8,$4d7
	dc.w	$4e6,$4f5,$6e6,$8d7,$ac8,$cb9,$ea9,$f99,$f89,$f79
	dc.w	$f6a,$f5b,$f6c,$d6e,$b6e,$96e,$56e,$56e,$45e,$46d
	dc.w	$47c,$48b,$49a,$4a9,$4b8,$4c7,$4d6,$4e5,$5d6,$8c7
	dc.w	$ab8,$ca9,$e99,$f89,$f79,$f69,$f5b,$f4b,$f5c,$d5d
	dc.w	$b5e,$95e,$75e,$55e,$45e,$46d,$47c,$48b,$49a,$4a9
	dc.w	$4b8,$4c7,$4d6,$4e5,$6d6,$8c7,$ab8,$ca9,$e99,$f89
	dc.w	$f79,$f69,$f5a,$f4b,$f5c,$d5e,$b5e,$95e,$55e,$55e
	dc.w	$44d,$45c,$46b,$47a,$489,$498,$4a7,$4b6,$4c5,$4d4
	dc.w	$5c5,$8b6,$aa7,$c98,$e88,$f78,$f68,$f68,$f59,$f4a
	dc.w	$f4b,$d4c,$b4d,$94d,$74d,$54d,$44d,$45c,$46b,$47a
	dc.w	$489,$498,$4a7,$4b6,$4c5,$4d4,$6c5,$8b6,$aa7,$c98
	dc.w	$e88,$f78,$f68,$f58,$f49,$f3a,$f4b,$d4d,$b4d,$94d
	dc.w	$54d,$54d,$44c,$45b,$46a,$479,$488,$499,$4a6,$4b5
	dc.w	$4c4,$4d3,$5c4,$8b5,$aa6,$c97,$e87,$f77,$f67,$f67
	dc.w	$f58,$f49,$f4c,$d4b,$b4c,$94c,$74c,$54c,$44c,$45b
	dc.w	$46a,$479,$488,$497,$4a6,$4b5,$4c4,$4d3,$6c4,$8b5
	dc.w	$aa6,$c97,$e87,$f77,$f67,$f57,$f48,$f39,$f4a,$d4c
	dc.w	$b4c,$94c,$54c,$54c,$44b,$45a,$469,$478,$487,$498
	dc.w	$4a5,$4b4,$4c3,$4d2,$5c3,$8b4,$aa5,$c96,$e86,$f76
	dc.w	$f66,$f66,$f57,$f48,$f4b,$d4a,$b4b,$94b,$74b,$54b
	dc.w	$44b,$45a,$469,$478,$487,$496,$4a5,$4b4,$4c3,$4d2
	dc.w	$6c3,$8b4,$aa5,$c96,$e86,$f76,$f66,$f56,$f47,$f38
	dc.w	$f49,$d4b,$b4b,$94b,$54b,$54b,$44a,$459,$468,$477
	dc.w	$486,$497,$4a4,$4b3,$4c2,$4d1,$5c2,$8b3,$aa4,$c95
	dc.w	$e85,$f75,$f65,$f65,$f56,$f47,$f4a,$d49,$b4a,$94a
	dc.w	$74a,$54a,$44a,$459,$468,$477,$486,$495,$4a4,$4b3
	dc.w	$4c2,$4d1,$6c2,$8b3,$aa4,$c95,$e85,$f75,$f65,$f55
	dc.w	$f46,$f37,$f48,$d4a,$b4a,$94a,$54a,$54a

*****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$100,$200			; BPLCON0 - keine Bitplanes
	dc.w	$180,$003			; COLOR00 - blau
CopBuf:
	dcb.w	(52*2)*LINES+(2*LINES),0	; Platz fr die Copperlist.

	dc.w	$180,$003			; COLOR00 - blau
	dc.w	$ffff,$fffe			; Ende Copperlist

	end

Immer bunter, aber im Grunde hat sich zu Listing11g1.s nichts gendert.
