
; Listing11e.s - Verwendung von COPER- und VERTB-Interrupt per Level 3 ($6c).
; In diesem Fall definieren wir alle Interrupts richtig neu, 
; um eine Vorstellung davon zu geben, wie es gemacht wird.

	SECTION	INTERRUPT,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup2.s"	; speichern Sie Interrupt, DMA und so weiter.
*****************************************************************************


; Mit DMASET entscheiden wir, welche DMA-Kanle geffnet und welche geschlossen werden sollen

			;5432109876543210
DMASET	equ	%1000001010000000	; Copper DMA aktivieren

WAITDISK	equ	30				; 50-150 zur Rettung (je nach Fall)

Start:
	move.l	BaseVBR(pc),a0	    ; in a0 ist der Wert des VBR

	move.l	#NoInt1,$64(a0)		; Interrupt "leer"
	move.l	#NoInt2,$68(a0)		; int leer
	move.l	#MyInt6c,$6c(a0)	; ich lege meinen Interrupt-Level 3 fest
	move.l	#NoInt4,$70(a0)		; int leer
	move.l	#NoInt5,$74(a0)		; " "
	move.l	#NoInt6,$78(a0)		; " "

	move.w	#DMASET,$96(a5)		; DMACON - aktivieren Copper								
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

	movem.l	d0-d7/a0-a6,-(sp)
	bsr.w	mt_init				; initialisieren der Musik Routine
	movem.l	(sp)+,d0-d7/a0-a6

			; 5432109876543210
	move.w	#%1111111111111111,$9a(a5)  ; INTENA - aktivieren Sie alle
								; interrupts!

Mouse:
	btst	#6,$bfe001			; Maus gedrckt? (Der Prozessor 
	bne.s	Mouse				; unterbricht die Schleife zu jedem vertical blank
								; um die Musik zu spielen!
								; sowie jedes WAIT der Rasterzeile $a0).						
				
	bsr.w	mt_end				; Ende der Wiederholung!

	rts							; Exit


*****************************************************************************
*	INTERRUPT-Routine $64 (Level 1)
*****************************************************************************

;	.:......
;	 ::::::::::.
;	  ::::::::::
;	  ( _____:::
;	   \____` ::|
;	   _( _)  l
;	  /      .)
;	 /         T
;	/  ,_  ___ _j
;	 l____\  \
;	        \\  \ xCz
;	__________)   \
;	\_      _____  \
;	 `------'   \___)

;02	SOFT	1 ($64)	Reserviert fr durch Software ausgelste Interrupts.
;01	DSKBLK	1 ($64)	Ende der bertragung eines Datenblocks von der Diskette.
;00	TBE		1 ($64)	Puffer UART-bertragungs der seriellen Schnittstelle leer
				
NoInt1:	; $64
	btst.b	#0,$dff01f			; INTREQR - TBE?
	beq.w	NoTbe
	; tbe Routine
NoTbe:
	btst.b	#1,$dff01f			; INTREQR - DSKBLK?
	beq.w	NoDskblk
	; DSKBLK Routine
NoDskblk:
	btst.b	#2,$dff01f			; INTREQR - SOFT?
	beq.w	NoSoft
	; SOFT Routine
NoSoft:
			; 210
	move.w	#%111,$dff09c		; INTREQ - soft,dskblk,serial port tbe
	rte

*****************************************************************************
*	INTERRUPT-Routine $68 (Level 2)
*****************************************************************************

;	    .:::::::::.
;	   :       :
;	   |'         `|
;	   |    ,      |
;	   |     `-- |
;	  _!   __  __  |
;	 (C \ ( )(o ) |
;	  7 /\ (__) _!
;	 / /  \______/\\
;	/  \_______l__//
;	\   \:::::::::\\ xCz
;	 \   \:::::::::\\
;	  \___/
;	     `---------'

;03	PORTS	2 ($68)	Input/Output Ports und Timer, die an die INT2-Leitung angeschlossen sind
					
NoInt2:	; $68
	btst.b	#3,$dff01f			; INTREQR - PORTS?
	beq.w	NoPorts
	; Routine PORTS
NoPorts:
	move.l	d0,-(sp)			; speichern d0
	move.b	$bfed01,d0			; CIAA ICR - ist es ein Interrupt der Tastatur?
	and.b	#$8,d0
	beq.w	NoKey
	; Routine zum Lesen der Tastatur
NoKey:
	move.l	(sp)+,d0			; Wiederherstellung d0
			; 3210
	move.w	#%1000,$dff09c		; INTREQ - ports
	rte

*****************************************************************************
*	INTERRUPT-Routine $6c (Level 3) - VERTB und COPER benutzt.				*
*****************************************************************************
;	    __________________
;	 __/  _______________/
;	( .      (___)\_T
;	 \_,             \ |
;	  T            C. )|
;	  l____________  _ |
;	       T      l___!
;	       |   (_) T`-'
;	       l__      xCz
;	         `-----'

;06	BLIT	3 ($6c)	Wenn der Blitter einen Blitt beendet hat, wird es auf 1 gesetzt
;05	VERTB	3 ($6c)	Wird jedes Mal generiert, wenn der Elektronenstrahl in Betrieb ist
					; und zur Zeile 00 geht, dh zu jedem vertical blank.
;04	COPER	3 ($6c)	; Sie knnen es mit dem Copper einstellen, um ihn zu einem 
					; bestimmten Zeitpunkt (Videozeile) zu erzeugen. Fordern Sie ihn  
					; einfach nach einer gewissen Wartezeit an.

MyInt6c:
	btst.b	#6,$dff01f			; INTREQR - BLIT?
	beq.w	NoBlit
	; Routine BLIT
NoBlit:
	btst.b	#5,$dff01f			; INTREQR - ist Bit 5, VERTB zurckgesetzt?
	beq.s	NoIntVertb			; Wenn ja, ist es kein "echter" VERTB Interrupt!
	movem.l	d0-d7/a0-a6,-(sp)	; Register speichern auf dem stack
	bsr.w	mt_music			; Musik spielen
	movem.l	(sp)+,d0-d7/a0-a6	; Register vom stack nehmen
NoIntVertb:
	btst.b	#4,$dff01f			; INTREQR - ist Bit 4, COPER zurckgesetzt?
	beq.s	NoIntCoper			; wenn ja, ist es kein COPER Interrupt!
	move.w	#$f00,$dff180		; int COPER, dann COLOR00 = rot
NoIntCoper:
			 ;6543210
	move.w	#%1110000,$dff09c	; INTREQ - Lschen Flag BLIT,VERTB,COPER
	rte							; Ende vom Interrupt BLIT,VERTB,COPER

*****************************************************************************
*	INTERRUPT-Routine $70 (Level 4)
*****************************************************************************

;	    _/\__/\_
;	  _/ '_  _`\_
;	 (/  ()()  \)
;	 /  _  _  \
;	/    YY    \
;	\____ '  ` ____/
;	   `--------' xCz

;10	AUD3	4 ($70)	Lesen eines Datenblocks ber den Kanal Audio 3 beendet
;09	AUD2	4 ($70)	Lesen eines Datenblocks ber den Kanal Audio 2 beendet
;08	AUD1	4 ($70)	Lesen eines Datenblocks ber den Kanal Audio 1 beendet
;07	AUD0	4 ($70)	Lesen eines Datenblocks ber den Kanal Audio 0 beendet


NoInt4: ; $70
	btst.b	#7,$dff01f			; INTREQR - AUD0?
	beq.w	NoAud0
	; Routine aud0
NoAud0:
	btst.b	#8-7,$dff01e		; INTREQR - AUD1? Notiz: $dff01e und nicht $dff01f
								; weil das bit> 7 ist!
	beq.w	NoAud1
	; Routine aud1
NoAud1:
	btst.b	#9-7,$dff01e		; INTREQR - AUD2?
	Beq.w	NoAud2
	; Routine aud2
NoAud2:
	btst.b	#10-7,$dff01e		; INTREQR - AUD3?
	Beq.w	NoAud3
	; Routins aud3
NoAud3:
			; 09876543210
	move.w	#%11110000000,$dff09c	; aud0,aud1,aud2,aud3
	rte

*****************************************************************************
*	INTERRUPT-Routine $74 (Level 5)
*****************************************************************************

;	 .:::::.
;	 :_ _!
;	 ! (T)
;	( , ,\\
;	 \`---/
;	  `---' xCz

;12	DSKSYN	5 ($74)	wird generiert, wenn das DSKSYNC-Register mit den Daten bereinstimmt
				; Lesen Sie von der Diskette im Laufwerk. Achten Sie auf Hardwarelader.
;11	RBF		5 ($74)	UART-Puffer zum Empfangen des FULL-Serial-Ports.


NoInt5: ; $74
	btst.b	#12-7,$dff01e		; INTREQR - DSKSYN?
	beq.w	NoDsksyn
	; Routine dsksyn
NoDsksyn:
	btst.b	#11-7,$dff01e		; INTREQR - RBF?
	beq.w	NoRbf
	; Routine rbf
NoRbf:
			; 2109876543210
	move.w	#%1100000000000,$dff09c	; serial port rbf, dsksyn
	rte

*****************************************************************************
*	INTERRUPT-Routine  $78 (Level 6)										*
*****************************************************************************

;	 ......
;	 ,:
;	| u. )
;	l_`--'_!
;	 `----'xCz

;14	INTEN	6 ($78)
;13	EXTER	6 ($78)	Interrupt extern, an die INT6 + TOD CIAB-Leitung angeschlossen

NoInt6: ; $78
	tst.b	$bfdd00				; CIAB ICR - rcksetzen interrupt timer
	btst.b	#14-7,$dff01e		; INTREQR - INTEN?
	beq.w	NoInten
	; Routine inten
NoInten:
	btst.b	#13-7,$dff01e		; INTREQR - EXTER?
	beq.w	NoExter
	; Routine exter
NoExter:
			; 432109876543210
	move.w	#%110000000000000,$dff09c ; INTREQ - external int + ciab
	rte

*****************************************************************************
;	Wiederholungsroutine protracker/soundtracker/noisetracker
;
	include	"/Sources/music.s"
*****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$100,$200			; BPLCON0 - keine Bitplanes
	dc.w	$180,$00e			; COLOR00 blau
	dc.w	$a007,$fffe			; WAIT - warte auf Zeile $a0
	dc.w	$9c,$8010			; INTREQ - Fordere einen COPER-Interrupt an,
								; wodurch COLOR00 mit einem "move.w" gendert wird.
	dc.w	$ffff,$fffe			; Ende der Copperlist

*****************************************************************************
;				MUSIK
*****************************************************************************

mt_data:
	dc.l	mt_data1

mt_data1:
	incbin	"/Sources/mod.fairlight"

	end

Wir haben alle Interrupts neu definiert. Dies kann ein Schema fr den
Start sein, um ein "Betriebssystem" zu machen, aber ich empfehle es nicht!
