
; Listing10u2.s		Effekte mit Linien
; rechte Taste, um andere Effekte zu sehen, links zum Beenden

	SECTION	BLIT,CODE

;	include	"DaWorkBench.s"	; entferne das ; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup1.s"	; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001111000000	; Bitplane, Copper, Blitter DMA


Start:
	move.l	#Bitplane,d0		; Zeiger auf die "leere" Bitplane
	lea	Bplpointers,a1			; Bitplanepointer
	move.w	d0,6(a1)	
	swap	d0
	move.w	d0,2(a1)

	lea	$dff000,a5				; Custom Register Base in a5
	move.w	#DMASET,$96(a5)		; DMACON - einschalten Bitplane, Copper, Blitter
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

	bsr.w	InitLine			; initialisiert line-mode

	move.w	#$ffff,d0			; durchgehende Linie
	bsr.w	SetPattern			; definiert Muster
	
Mouse:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$12c00,d2			; Warte auf Zeile $12c
WarteY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; Whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; Warte auf Zeile $12c
	bne.s	WarteY1

	bsr.w	SwapBuffer			; Diese Routine tauscht die 2 Puffer aus

	bsr.w	ClearScreen			; Bildschirm reinigen

	btst	#2,$dff016			; rechte Maustaste gedrckt?
	bne.s	DoNotChange			; wenn nicht, berspringen ..
	bsr.s	ChangeParameters	; .. Andernfalls ndern Sie die Parameter der Zeiger

DoNotChange:
	bsr.w	MovePoints			; ndern der Koordinaten der ersten Punkte
								; der Linie

	move.w	IndexX1(pc),d4		; Lesen Sie die Indizes der ersten Zeile
	move.w	IndexX2(pc),d5
	move.w	IndexY1(pc),d6
	move.w	IndexY2(pc),d7

	move.w	NumLines(pc),d0

LineLoop:

; Zeichne die Linie

	movem.l	d0-d7,-(a7)			; Speichern der Register
	move.w	CoordX1(pc),d0		; lies die Koordinaten der Punkte
	move.w	CoordY1(pc),d1
	move.w	CoordX2(pc),d2
	move.w	CoordY2(pc),d3
	move.l	DrawBuffer(pc),a0
	bsr.w	Drawline
	movem.l	(a7)+,d0-d7			; wiederherstellen der Register

	bsr.w	NextLine

	dbra	d0,LineLoop			; Wiederholen Sie es fr jede Zeile

	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.w	Mouse

	rts


;***************************************************************************
; Diese Routine ndert die Parameterwerte. Die genderten Werte sind: 
; "NumLines", die 4 "Index", die 4 "Add", die 4 "NextAdd".
; Die neuen Werte sind in einer bestimmten Tabelle enthalten.
; Da alle zu ndernden Werte im Speicher aufeinander folgen, ist dies durch
; die Verwendung einer einzelnen Kopierschleife mglich
;***************************************************************************

;	          _ _
;	   .   __/ V \__  ..
;	   .  /___ : ___\  ::
;	 .: _/____\_/____\_ ::
;	:::/ (@:)_(@:) \:::
;	_::\_ __//_\\__ _/:::
;	  ::\:| . : . |:/ ::::
;	   .:.:_|_|_|_:.::::
;	    ::( V_V_V ):::
;	        \|   |/

ChangeParameters:
	move.l	PointerParam(pc),a0	; Zeiger auf neue Werte
	lea	NumLines(pc),a1			; Zeiger auf die Variablen

	moveq	#13-1,d0			; Anzahl der zu ndernden Werte
ChangeLoop:
	move.w	(a0)+,(a1)+			; Kopierschleife
	dbra	d0,ChangeLoop

	cmp.l	#EndTabParam,a0		; Sind wir am Ende der Tabelle?
	blo.s	NoRestart			; wenn nicht, berspringen ..
	lea	TabParam(pc),a0			; ... sonst nochmal von vorne anfangen

NoRestart:
	move.l	a0,PointerParam		; speichert den Zeiger

; Warten Sie, bis die Maustaste gedrckt wird

Waitmouse:
	btst	#2,$dff016			; rechte Maustaste gedrckt?
	beq.s	Waitmouse			; wenn du wartest

	rts

; Zeiger auf die Parametertabelle

PointerParam:	dc.l	TabParam

; Tabelle der Parameter
; Sie knnen versuchen, Parameter anzugeben. Parameter (auer dem ersten)
; MSSEN gerade-Nummern sein

TabParam:
	dc.w	$3a,0,$40,0,$40,2,2,2,2,8,8,$10,$10
	dc.w	$32,0,$80,0,$80,2,2,4,4,$7e,$80,$7e,$80

	dc.w	$3a,0,0,0,0,-2,2,4,4,$7e,$7e,$7e,$7e

	dc.w	$38,0,$68,0,$68,2,2,4,4,8,8,10,10
	dc.w	$28,$64,0,0,0,6,4,4,2,6,6,4,8
	dc.w	$3a,$40,$40,$40,$40,2,2,2,8,2,2,4,4
	dc.w	$39,2,0,$68,0,-2,2,4,4,8,8,10,10

	dc.w	$27,$64,0,0,0,8,4,4,2,4,2,2,4
	dc.w	$3a,0,$40,0,$40,2,2,4,4,4,4,$104,$104
EndTabParam:

;***************************************************************************
; Diese Routine liest die Koordinaten der Punkte der Zeilen aus Tabellen
; nach dem ersten und speichert Sie in den entsprechenden Variablen.
; Das Lesen aus den Tabellen erfolgt durch die indirekte Adressierung
; mit Index. Um sich in den Tabellen zu bewegen, ndern wir die Indizes
; (was Wrter sind) anstelle von Zeigern (Langwrtern). Das erlaubt uns 
; zu vermeiden mit einem einfachen AND aus der Tabelle zu kommen. 
; Der Index liegt im Bereich 0 - 512 (tatschlich sind die Tabellen 
; aus 256 Wrtern (512 Bytes) zusammengesetzt.
; Die Indizes der vorherigen Koordinaten werden gespeichert
; in den Registern d4, d5, D6, D7
; Die Werte, die zum Index hinzugefgt werden sollen, um von einer Zeile 
; zur anderen zu wechseln, sind in bestimmten Variablen abgelegt.
;***************************************************************************

NextLine:
	lea	TabX(pc),a0

; Koordinate X1

	add.w	NextAddX1(pc),d4	; ndern Sie den Index des Punktes
								; der neue Koordinate
	and.w	#$1ff,d4			; behalte den Index in der Tabelle							
	move.w	0(a0,d4.w),CoordX1	; kopiere die Koordinate aus der Tabelle
								; in die Variable

; Koordinate X2

	add.w	NextAddX2(pc),d5	; ndern Sie den Index des Punktes
								; der neue Koordinate
	and.w	#$1ff,d5			; behalte den Index in der Tabelle								
	move.w	0(a0,d5.w),CoordX2	; kopiere die Koordinate aus der Tabelle
								; in die Variable

	lea	TabY(pc),a0

; Koordinate Y1

	add.w	NextAddY1(pc),d6	; ndern Sie den Index des Punktes
								; der neue Koordinate
	and.w	#$1ff,d6			; behalte den Index in der Tabelle							
	move.w	0(a0,d6.w),CoordY1	; kopiere die Koordinate aus der Tabelle
								; in die Variable
; Koordinate Y2

	add.w	NextAddY2(pc),d7	; ndern Sie den Index des Punktes
								; der neue Koordinate
	and.w	#$1ff,d7			; behalte den Index in der Tabelle								
	move.w	0(a0,d7.w),CoordY2	; kopiere die Koordinate aus der Tabelle
								; in die Variable
	rts

;***************************************************************************
; Diese Routine liest die Koordinaten der verschiedenen Punkte aus Tabellen
; und speichert sie in den entsprechenden Variablen.
; Das Lesen von den Tabellen erfolgt durch die indirekte Adressierung mit
; Index. Um die Tabellen zu verschieben, ndern wir die Indizes (das sind
; Wrter) anstelle von Zeigern (Langwrter). Das erlaubt uns zu vermeiden
; mit einem einfachen AND aus dem Tabelle zu kommen. 
; Der Index liegt im Bereich 0 - 512 (tatschlich sind die Tabellen 
; aus 256 Wrtern (512 Bytes) zusammengesetzt.
;***************************************************************************

MovePoints:
	lea	TabX(pc),a0

; Koordinate X1

	move.w	IndexX1(pc),d0		; Index der vorherigen Koordinate
	add.w	AddX1(pc),d0		; ndern Sie den Index des Punktes
								; der neuen Koordinate
	and.w	#$1ff,d0			; behalte den Index in der Tabelle
	move.w	d0,IndexX1			; speichert den Index
	move.w	0(a0,d0.w),d1		; lies die Koordinate aus der Tabelle
	move.w	d1,CoordX1			; kopiere die Koordinate in die Variable

; Koordinate X2

	move.w	IndexX2(pc),d0		; Index der vorherigen Koordinate
	add.w	AddX2(pc),d0		; ndern Sie den Index des Punktes
								; der neuen Koordinate
	and.w	#$1ff,d0			; behalte den Index in der Tabelle								
	move.w	d0,IndexX2			; speichert den Index
	move.w	0(a0,d0.w),d1		; lies die Koordinate aus der Tabelle
	move.w	d1,CoordX2			; kopiere die Koordinate in die Variable

	lea	TabY(pc),a0

; Koordinate Y1

	move.w	IndexY1(pc),d0		; Index der vorherigen Koordinate
	add.w	AddY1(pc),d0		; ndern Sie den Index des Punktes
								; der neuen Koordinate
	and.w	#$1ff,d0			; behalte den Index in der Tabelle						
	move.w	d0,IndexY1			; speichert den Index
	move.w	0(a0,d0.w),d1		; lies die Koordinate aus der Tabelle
	move.w	d1,CoordY1			; kopiere die Koordinate in die Variable

; Koordinate Y2

	move.w	IndexY2(pc),d0		; Index der vorherigen Koordinate
	add.w	AddY2(pc),d0		; ndern Sie den Index des Punktes
								; der neuen Koordinate
	and.w	#$1ff,d0			; behalte den Index in der Tabelle								
	move.w	d0,IndexY2			; speichert den Index
	move.w	0(a0,d0.w),d1		; lies die Koordinate aus der Tabelle
	move.w	d1,CoordY2			; kopiere die Koordinate in die Variable
	rts

; Diese Tabelle enthlt die X-Koordinaten

TabX:
	dc.w	$00a2,$00a6,$00a9,$00ad,$00b1,$00b4,$00b8,$00bb,$00bf,$00c3
	dc.w	$00c6,$00ca,$00cd,$00d1,$00d4,$00d8,$00db,$00de,$00e2,$00e5
	dc.w	$00e8,$00ec,$00ef,$00f2,$00f5,$00f8,$00fb,$00fe,$0101,$0103
	dc.w	$0106,$0109,$010b,$010e,$0110,$0113,$0115,$0117,$011a,$011c
	dc.w	$011e,$0120,$0122,$0123,$0125,$0127,$0128,$012a,$012b,$012d
	dc.w	$012e,$012f,$0130,$0131,$0132,$0133,$0133,$0134,$0135,$0135
	dc.w	$0135,$0136,$0136,$0136,$0136,$0136,$0136,$0135,$0135,$0135
	dc.w	$0134,$0133,$0133,$0132,$0131,$0130,$012f,$012e,$012d,$012b
	dc.w	$012a,$0128,$0127,$0125,$0123,$0122,$0120,$011e,$011c,$011a
	dc.w	$0117,$0115,$0113,$0110,$010e,$010b,$0109,$0106,$0103,$0101
	dc.w	$00fe,$00fb,$00f8,$00f5,$00f2,$00ef,$00ec,$00e8,$00e5,$00e2
	dc.w	$00de,$00db,$00d8,$00d4,$00d1,$00cd,$00ca,$00c6,$00c3,$00bf
	dc.w	$00bb,$00b8,$00b4,$00b1,$00ad,$00a9,$00a6,$00a2,$009e,$009a
	dc.w	$0097,$0093,$008f,$008c,$0088,$0085,$0081,$007d,$007a,$0076
	dc.w	$0073,$006f,$006c,$0068,$0065,$0062,$005e,$005b,$0058,$0054
	dc.w	$0051,$004e,$004b,$0048,$0045,$0042,$003f,$003d,$003a,$0037
	dc.w	$0035,$0032,$0030,$002d,$002b,$0029,$0026,$0024,$0022,$0020
	dc.w	$001e,$001d,$001b,$0019,$0018,$0016,$0015,$0013,$0012,$0011
	dc.w	$0010,$000f,$000e,$000d,$000d,$000c,$000b,$000b,$000b,$000a
	dc.w	$000a,$000a,$000a,$000a,$000a,$000b,$000b,$000b,$000c,$000d
	dc.w	$000d,$000e,$000f,$0010,$0011,$0012,$0013,$0015,$0016,$0018
	dc.w	$0019,$001b,$001d,$001e,$0020,$0022,$0024,$0026,$0029,$002b
	dc.w	$002d,$0030,$0032,$0035,$0037,$003a,$003d,$003f,$0042,$0045
	dc.w	$0048,$004b,$004e,$0051,$0054,$0058,$005b,$005e,$0062,$0065
	dc.w	$0068,$006c,$006f,$0073,$0076,$007a,$007d,$0081,$0085,$0088
	dc.w	$008c,$008f,$0093,$0097,$009a,$009e
	
; Diese Tabelle enthlt die Y-Koordinaten

TabY:
	dc.w	$0080,$0083,$0086,$0088,$008b,$008e,$0090,$0093,$0096,$0098
	dc.w	$009b,$009e,$00a0,$00a3,$00a5,$00a8,$00aa,$00ad,$00af,$00b2
	dc.w	$00b4,$00b6,$00b9,$00bb,$00bd,$00bf,$00c2,$00c4,$00c6,$00c8
	dc.w	$00ca,$00cc,$00ce,$00d0,$00d1,$00d3,$00d5,$00d7,$00d8,$00da
	dc.w	$00db,$00dd,$00de,$00df,$00e1,$00e2,$00e3,$00e4,$00e5,$00e6
	dc.w	$00e7,$00e8,$00e9,$00e9,$00ea,$00eb,$00eb,$00ec,$00ec,$00ec
	dc.w	$00ed,$00ed,$00ed,$00ed,$00ed,$00ed,$00ed,$00ed,$00ec,$00ec
	dc.w	$00ec,$00eb,$00eb,$00ea,$00e9,$00e9,$00e8,$00e7,$00e6,$00e5
	dc.w	$00e4,$00e3,$00e2,$00e1,$00df,$00de,$00dd,$00db,$00da,$00d8
	dc.w	$00d7,$00d5,$00d3,$00d1,$00d0,$00ce,$00cc,$00ca,$00c8,$00c6
	dc.w	$00c4,$00c2,$00bf,$00bd,$00bb,$00b9,$00b6,$00b4,$00b2,$00af
	dc.w	$00ad,$00aa,$00a8,$00a5,$00a3,$00a0,$009e,$009b,$0098,$0096
	dc.w	$0093,$0090,$008e,$008b,$0088,$0086,$0083,$0080,$007e,$007b
	dc.w	$0078,$0076,$0073,$0070,$006e,$006b,$0068,$0066,$0063,$0060
	dc.w	$005e,$005b,$0059,$0056,$0054,$0051,$004f,$004c,$004a,$0048
	dc.w	$0045,$0043,$0041,$003f,$003c,$003a,$0038,$0036,$0034,$0032
	dc.w	$0030,$002e,$002d,$002b,$0029,$0027,$0026,$0024,$0023,$0021
	dc.w	$0020,$001f,$001d,$001c,$001b,$001a,$0019,$0018,$0017,$0016
	dc.w	$0015,$0015,$0014,$0013,$0013,$0012,$0012,$0012,$0011,$0011
	dc.w	$0011,$0011,$0011,$0011,$0011,$0011,$0012,$0012,$0012,$0013
	dc.w	$0013,$0014,$0015,$0015,$0016,$0017,$0018,$0019,$001a,$001b
	dc.w	$001c,$001d,$001f,$0020,$0021,$0023,$0024,$0026,$0027,$0029
	dc.w	$002b,$002d,$002e,$0030,$0032,$0034,$0036,$0038,$003a,$003c
	dc.w	$003f,$0041,$0043,$0045,$0048,$004a,$004c,$004f,$0051,$0054
	dc.w	$0056,$0059,$005b,$005e,$0060,$0063,$0066,$0068,$006b,$006e
	dc.w	$0070,$0073,$0076,$0078,$007b,$007e	


; Hier werden die Koordinaten der Eckpunkte der Linie jedes Mal gespeichert

CoordX1:	dc.w	0
CoordY1:	dc.w	0
CoordX2:	dc.w	0
CoordY2:	dc.w	0

; Die Anzahl der gezeichneten Zeilen wird hier gespeichert

NumLines:	dc.w	10

; Hier werden die Indizes innerhalb der Tabelle fr jede Koordinate gespeichert

IndexX1:	dc.w	20
IndexY1:	dc.w	50
IndexX2:	dc.w	30
IndexY2:	dc.w	40

; Hier werden die Werte, die jedem Frame hinzugefgt werden sollen,
; fr jede Koordinate gespeichert
; zu den Tabellenindizes fr die Scheitelpunkte der ersten Zeile

AddX1:	dc.w	4
AddY1:	dc.w	-6
AddX2:	dc.w	-2
AddY2:	dc.w	2

; Hier werden die zu den Indizes hinzuzufgenden Werte fr jede Koordinate 
; der Tabelle fr die Scheitelpunkte der aufeinanderfolgenden Linien gespeichert

NextaddX1:	dc.w	10
NextaddY1:	dc.w	14
NextaddX2:	dc.w	6
NextaddY2:	dc.w	-4

;******************************************************************************
; Diese Routine zeichnet die Linie. Sie bentigt als Parameter die Koordinaten
; der Punkte P1 und P2 und die Adresse der Bitebene, auf der gezeichnet werden soll.
; d0 - X1 (X-Koordinate von P1)
; d1 - Y1 (Y-Koordinate von P1)
; d2 - X2 (X-Koordinate von P2)
; d3 - Y2 (Y-Koordinate von P2)
; a0 - Bitplane Adresse
;******************************************************************************

; Konstanten

DL_FILL		=	0				; 0=NOFILL / 1=Fill

	IFEQ	DL_FILL
DL_MINTERMS	=	$CA
	ELSE
DL_MINTERMS	=	$4a
	ENDC


DrawLine:
	sub.w	d1,d3				; d3=Y2-Y1

	IFNE	DL_FILL
	beq.s	.end				; Fr die Fllung werden keine horizontalen Linien bentigt
	ENDC

	bgt.s	.y2gy1				; springen wenn positiv ..
	exg	d0,d2					; .. Ansonsten tauschen Sie Punkte aus
	add.w	d3,d1				; setzt das kleinere Y in d1
	neg.w	d3					; d3=DY
.y2gy1:
	mulu.w	#40,d1				; Offset Y
	add.l	d1,a0
	moveq	#0,d1				; d1-Index in der Oktantentabelle
	sub.w	d0,d2				; d2=X2-X1
	bge.s	.xdpos				; springen wenn positiv ..
	addq.w	#2,d1				; .. andernfalls verschieben Sie den Index
	neg.w	d2					; und machen den Unterschied positiv
.xdpos:
	moveq	#$f,d4				; Maske fr die 4 niedrigen Bits
	and.w	d0,d4				; whlen sie d4 aus
		
	IFNE	DL_FILL				; Diese Anweisungen sind zusammengestellt
								; nur wenn DL_FILL = 1
	move.b	d4,d5				; berechnet die Nummer des zu invertierenden Bits
	not.b	d5					; (das BCHG nummeriert die inversen Bits)
	ENDC

	lsr.w	#3,d0				; Offset X:
								; In Bytes ausrichten (dient fr BCHG)
	add.w	d0,a0				; zur Adresse hinzufgen
								; Beachten Sie, dass auch wenn die Adresse
								; Es ist seltsam, dass es nichts macht, weil
								; der Blitter bercksichtigt nicht die
								; niedrigstwertiges Bit von BLTxPT
				
	ror.w	#4,d4				; d4 = Wert der Verschiebung A
	or.w	#$b00+DL_MINTERMS,d4	; fge das passende hinzu
								; Minterm (OR oder EOR)
	swap	d4					; Wert von BLTCON0 im High-Word
		
	cmp.w	d2,d3				; vergleiche DiffX und DiffY
	bge.s	.dygdx				; berspringen wenn >=0..
	addq.w	#1,d1				; andernfalls setzen Sie das Bit 0 des Indexes
	exg	d2,d3					; und tausche das Diff
.dygdx:
	add.w	d2,d2				; d2 = 2*DiffX
	move.w	d2,d0				; Kopie in d0
	sub.w	d3,d0				; d0 = 2*DiffX-DiffY
	addx.w	d1,d1				; multiplizieren Sie den Index mit 2 und
								; gleichzeitig fgt er die Flagge hinzu
								; X ist 1, wenn 2 * DiffX-DiffY <0 ist
								; (eingestellt von sub.w)
	move.b	Oktants(pc,d1.w),d4	; liest den Oktanten
	swap	d2					; BLTBMOD-Wert in High-Word
	move.w	d0,d2				; niedriges Word d2=2*DiffX-DiffY
	sub.w	d3,d2				; niedriges Word d2=2*DiffX-2*DiffY
	moveq	#6,d1				; Wert der Verschiebung und Test fr
								; die Wartezeit Blitter

	lsl.w	d1,d3				; berechnet den Wert von BLTSIZE
	add.w	#$42,d3

	lea	$52(a5),a1				; a1 = BLTAPTL-Adresse
								; Er schreibt einige Register
								; nacheinander mit
								; MOVE #XX,(Ax)+

	btst	d1,2(a5)			; warte auf den Blitter
.wb:
	btst	d1,2(a5)
	bne.s	.wb

	IFNE	DL_FILL				; Diese Anweisung ist zusammengestellt
								; nur wenn DL_FILL = 1
	bchg	d5,(a0)				; Invertiert das erste Bit der Zeile
	ENDC

	move.l	d4,$40(a5)			; BLTCON0/1
	move.l	d2,$62(a5)			; BLTBMOD und BLTAMOD
	move.l	a0,$48(a5)			; BLTCPT
	move.w	d0,(a1)+			; BLTAPTL
	move.l	a0,(a1)+			; BLTDPT
	move.w	d3,(a1)				; BLTSIZE
.end:
	rts

; Wenn wir Zeilen fr die Fllung ausfhren mchten, setzt der Octant-Code 
; durch die Konstante SML das SING-Bit auf 1

	IFNE	DL_Fill
SML		= 	2
	ELSE
SML		=	0
	ENDC

; Tabelle Oktanten

Oktants:
	dc.b	SML+1,SML+1+$40
	dc.b	SML+17,SML+17+$40
	dc.b	SML+9,SML+9+$40
	dc.b	SML+21,SML+21+$40

;******************************************************************************
; Diese Routine legt die Blitter-Register fest, die sich 
; zwischen einer Zeile und einer anderen nicht ndern
;******************************************************************************

InitLine
	btst	#6,2(a5)			; DMACONR
WBlitInit:
	btst	#6,2(a5)			; DMACONR - warte auf das Ende des Blitters
	bne.s	WblitInit

	moveq	#-1,d5
	move.l	d5,$44(a5)			; BLTAFWM/BLTALWM = $FFFF
	move.w	#$8000,$74(a5)		; BLTADAT = $8000
	move.w	#40,$60(a5)			; BLTCMOD = 40
	move.w	#40,$66(a5)			; BLTDMOD = 40
	rts

;******************************************************************************
; Diese Routine definiert das Muster, das zum Zeichnen der Linien verwendet 
; werden soll. In der Praxis setzt man einfach das BLTBDAT-Register.
; D0 - enthlt das Linienmuster
;******************************************************************************

SetPattern:
	btst	#6,2(a5)			; DMACONR
WBlitSet:
	btst	#6,2(a5) 			; DMACONR - warte auf das Ende des Blitters
	bne.s	WblitSet

	move.w	d0,$72(a5)			; BLTBDAT = Linienmuster
	rts


;****************************************************************************
; Diese Routine lscht den Bildschirm mit dem Blitter.
;****************************************************************************

ClearScreen:
	move.l	DrawBuffer(pc),a0	; Adresse die gelscht werden soll

	btst	#6,2(a5)
WaitBlit3:
	btst	#6,2(a5)			; warte auf das Ende des Blitters
	bne.s	WaitBlit3

	move.l	#$01000000,$40(a5)	; BLTCON0 und BLTCON1: Lschung
	move.w	#$0000,$66(a5)		; BLTDMOD=0
	move.l	a0,$54(a5)			; BLTDPT
	move.w	#(64*256)+20,$58(a5)	; BLTSIZE (Blitter starten!)
								; lsche den gesamten Bildschirm
	rts

;****************************************************************************
; Diese Routine tauscht die 2 Puffer aus, indem die Adressen der
; VIEW_BUFFER- und DRAW_BUFFER-Variablen getauscht werden.
; Auerdem werden die Anweisungen aktualisiert, mit denen die Register 
; BPLxPT in der copperlist geladen werden, damit sie auf den neuen Puffer 
; zeigen, der angezeigt werden soll.
;****************************************************************************

SwapBuffer:
	move.l	DrawBuffer(pc),d0	; den Inhalt ndern
	move.l	ViewBuffer(pc),DrawBuffer	; der Variablen
	move.l	d0,ViewBuffer		; in d0 gibt es die Adresse
								; des neuen Puffers
								; anzeigen

; Aktualisieren Sie die copperlist, indem Sie auf die Bitebenen des neuen Puffers 
; zeigen, der angezeigt werden soll

	lea	Bplpointers,A1			; Zeiger Copperlist
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	rts


; Zeiger auf 2 Puffer

ViewBuffer:	dc.l	Bitplane	; Puffer anzeigen
DrawBuffer:	dc.l	Bitplane2	; Puffer Zeichnen

;****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP
	dc.w	$92,$38				; DDFSTRT
	dc.w	$94,$d0				; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2
	dc.w	$108,0				; BPL1MOD
	dc.w	$10a,0				; BPL2MOD

	dc.w	$100,$1200			; BPLCON0 - 1 Bitplane lowres

Bplpointers:
	dc.w	$e0,$0000,$e2,$0000	; erste Bitplane

	dc.w	$0180,$000			; COLOR00
	dc.w	$0182,$eee			; COLOR01
	dc.w	$ffff,$fffe			; Ende Copperlist

;****************************************************************************

	SECTION	LEEREPLANE,BSS_C

; Puffer 1

Bitplane:
	ds.b	40*256				; Bitplane lowres

; Puffer 2

Bitplane2:
	ds.b	40*256				; Bitplane lowres

	end

;****************************************************************************

In diesem Beispiel fgen wir dem Programm Listing10u1.s weitere Zeilen hinzu
um komplexere Effekte zu machen. Zum Zeichnen der Linien werden die Koordinaten
der Werte immer aus der Tabelle gelesen. Zur Berechnung der neuen Koordinaten
werden die Indizes zu den Werten in jeder Zeile hinzugefgt. Diese Werte sind
in den Variablen "NextAdd" enthalten. Durch Drcken der rechten Taste knnen
Sie auerdem alle Werte der Variablen ndern. Auf diese Weise knnen Sie
einfach durch das variieren der Parameter neue Effekte erhalten.