
; Listing10r.s		Fllen eines geschlossenen Polygons
; rechte Maustaste zum Sperren, links zum Beenden

	SECTION	BLIT,CODE

;	include	"DaWorkBench.s"	; entferne das ; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup1.s"	; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001111000000	; Bitplane, Copper, Blitter DMA


Start:
	move.l	#Bitplane,d0		; Zeiger auf die "leere" Bitplane
	lea	Bplpointers,a1			; Bitplanepointer
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

	lea	$dff000,a5				; Custom Register Base in a5
	move.w	#DMASET,$96(a5)		; DMACON - einschalten Bitplane, Copper, Blitter
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

	bsr.w	InitLine			; initialisiert line-mode

	move.w	#$ffff,d0			; durchgehende Linie
	bsr.w	SetPattern			; definiert Muster

	move.w	#30,d0				; x1
	move.w	#125,d1				; y1
	move.w	#130,d2				; x2
	move.w	#180,d3				; y2
	lea	Bitplane,a0
	bsr.w	DrawlineFill

	move.w	#220,d0				; x1
	move.w	#105,d1				; y1
	move.w	#130,d2				; x2
	move.w	#180,d3				; y2
	lea	Bitplane,a0
	bsr.w	DrawlineFill

	move.w	#220,d0				; x1
	move.w	#105,d1				; y1
	move.w	#150,d2				; x2
	move.w	#60,d3				; y2
	lea	Bitplane,a0
	bsr.w	DrawlineFill

	move.w	#30,d0				; x1
	move.w	#125,d1				; y1
	move.w	#150,d2				; x2
	move.w	#60,d3				; y2
	lea	Bitplane,a0
	bsr.s	DrawlineFill

Mouse1:
	btst	#2,$dff016			; rechte Maustaste gedrckt?
	bne.s	Mouse1

	move.w	#0,d0				; inklusiv
	move.w	#0,d1				; CARRYIN = 0
	lea	Bitplane+180*40+28,a0
	bsr.s	Fill

Mouse2:
	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse2
	rts


;****************************************************************************
; Diese Routine kopiert ein Bildschirmrechteck von einer festen Position
; an eine Adresse, die als Parameter angegeben ist. Das Bildschirmrechteck
; das kopiert wird umschliet die 2 Zeilen vollstndig.
; Das Fllen wird auch whrend der Kopie durchgefhrt. Die Art der Fllung
; wird ber Parameter angegeben.
; Die Parameter sind:
; a0 - Zieladresse
; d0 - wenn es 0 ist, macht es inklusive Fllung, sonst fllt es exklusiv
; d1 - wenn es 0 ist, dann wird FILL_CARRYIN = 0, andernfalls FILL_CARRYIN = 1
;****************************************************************************

Fill:
	btst	#6,2(a5)			; DMACONR
WaitBlit1:
	btst	#6,2(a5)			; DMACONR - warte auf das Ende des Blitters
	bne.s	WaitBlit1

	move.w	#$09f0,$40(a5)		; BLTCON0 normale Kopie

	tst.w	d0					; test d0, um die Art der Fllung zu bestimmen
	bne.s	FillExclusiv
	move.w	#$000a,d2			; Wert von BLTCON1: setze die Bits fr den
								; inklusiven Fll- und Abstiegsmodus
	bra.s	TestFillCarry

FillExclusiv:
	move.w	#$0012,d2			; Wert von BLTCON1: setze die Bits fr den
								; exklusiven Fll- und Abstiegsmodus

TestFillCarry:
	tst.w	d1					; test d1, um zu sehen, ob das
								; FILL_CARRYIN-Bit gesetzt werden soll

	beq.s	MakeBltcon1			; wenn d1 = 0 berspringe ..
	bset	#2,d2				; ansonsten setze Bit 2 von d2

MakeBltcon1:
	move.w	d2,$42(a5)			; BLTCON1

	move.w	#12,$64(a5)			; BLTAMOD Breite 12 words (40-28=12)
	move.w	#12,$66(a5)			; BLTDMOD (40-28=12)

	move.l	#Bitplane+180*40+28,$50(a5)
								; BLTAPT (am Quellrechteck fixiert)
								; das Quellrechteck umschliet
								; die 2 Zeilen ganz.
								; Wir zeigen auf das letzte Wort des Rechtecks
								; wegen des absteigenden Weges

	move.l	a0,$54(a5)			; BLTDPT (Ziel)
	move.w	#(64*121)+14,$58(a5) ; BLTSIZE (Blitter starten!)
								; Breite 14 words
								; Hhe 121 Zeilen (1 plane)
	rts

;******************************************************************************
; Diese Routine zeichnet die Linie. Sie bentigt als Parameter die Koordinaten
; der Punkte P1 und P2 und die Adresse der Bitebene, auf der gezeichnet werden soll.
; d0 - X1 (X-Koordinate von P1)
; d1 - Y1 (Y-Koordinate von P1)
; d2 - X2 (X-Koordinate von P2)
; d3 - Y2 (Y-Koordinate von P2)
; a0 - Bitplane Adresse
;******************************************************************************

;	   ("`-/")_.-'"``-._
;	    . . `; -._    )-;-,_`)
;	   (v_,)'  _  )`-.\  ``-'
;	  _.- _..-_/ / ((.'
;	((,.-'   ((,/

DrawlineFill:

* bestimme Oktante

	sub.w	d0,d2				; d2=X2-X1
	bmi.s	Draw4				; Wenn negativ, berspringen Sie andernfalls d2=DiffX
	sub.w	d1,d3				; d3=Y2-Y1
	bmi.s	Draw2				; Wenn negativ, berspringen Sie andernfalls d3=DiffY
	cmp.w	d3,d2				; vergleicht DiffX und DiffY
	bmi.s	Draw1				; wenn d2 < d3 berspringt ..
								; .. sonst d3 = DY und d2 = DX
	moveq	#$10,d5				; Oktantencode
	bra.s	DrawL
Draw1:
	exg.l	d2,d3				; es schaltet zwischen d2 und d3 um, so dass d3 = DY und d2 = DX
	moveq	#0,d5				; Oktantencode
	bra.s	DrawL
Draw2:
	neg.w	d3					; macht d3 positiv
	cmp.w	d3,d2				; vergleiche DiffX und DiffY
	bmi.s	Draw3				; wenn d2 < d3 berspringt ..
								; .. sonst d3 = DY und d2 = DX
	moveq	#$18,d5				; Oktantencode
	bra.s	DrawL
Draw3:
	exg.l	d2,d3				; es schaltet zwischen d2 und d3 um, so dass d3 = DY und d2 = DX
	moveq	#$04,d5				; Oktantencode
	bra.s	DrawL
Draw4:
	neg.w	d2					; macht d2 positiv
	sub.w	d1,d3				; d3=Y2-Y1
	bmi.s	Draw6				; wenn Negativ berspringt, sonst d3 = DiffY
	cmp.w	d3,d2				; vergleiche DiffX und DiffY
	bmi.s	Draw5				; wenn d2 < d3 berspringt ..
								; .. sonst d3 = DY und d2 = DX
	moveq	#$14,d5				; Oktantencode
	bra.s	DrawL
Draw5:
	exg.l	d2,d3				; es schaltet zwischen d2 und d3 um, so dass d3 = DY und d2 = DX
	moveq	#$08,d5				; Oktantencode
	bra.s	DrawL
Draw6:
	neg.w	d3					; macht d3 positiv
	cmp.w	d3,d2				; vergleiche DiffX und DiffY
	bmi.s	Draw7				; wenn d2 < d3 berspringt ..
								; .. sonst d3 = DY und d2 = DX
	moveq	#$1c,d5				; Oktantencode
	bra.s	DrawL
Draw7:
	exg.l	d2,d3				; es schaltet zwischen d2 und d3 um, so dass d3 = DY und d2 = DX
	moveq	#$0c,d5				; Oktantencode

; Wenn die Ausfhrung diesen Punkt erreicht, haben wir:
; d2 = DX
; d3 = DY
; d5 = Oktantencode

DrawL:
	mulu.w	#40,d1				; Offset Y
	add.l	d1,a0				; Fgt der Adresse den Y-Offset hinzu

	move.w	d0,d1				; Kopiere die X-Koordinate
	and.w	#$000F,d0			; Whle die 4 niedrigsten Bits des X ..
	ror.w	#4,d0				;.. und bewegt sie in den Bits 12 bis 15
	or.w	#$0b4a,d0			; mit einem OR bekomme ich den zu schreibenen Wert
								; in BLTCON0. Mit diesem LF-Wert ($4a)
								; Zeichnen Sie Linien in EOR mit dem Hintergrund.

	lsr.w	#4,d1				; lsche die 4 unteren Bits des X
	add.w	d1,d1				; Ruft den X-Offset in Bytes ab
	add.w	d1,a0				; Fgt der Adresse den X-Offset hinzu

	move.w	d2,d1				; Kopie DX in d1
	addq.w	#1,d1				; d1=DX+1
	lsl.w	#$06,d1				; berechnet in d1 den Wert, der in BLTSIZE eingegeben werden soll
	addq.w	#$0002,d1			; addiert die Breite, gleich 2 Wrtern

	lsl.w	#$02,d3				; d3=4*DY
	add.w	d2,d2				; d2=2*DX

	btst.b	#6,2(a5)
WaitBlit2:
	btst	#6,2(a5)			; DMACONR - warte auf das Ende des Blitters
	bne	WaitBlit2

	move.w	d3,$62(a5)			; BLTBMOD=4*DY
	sub.w	d2,d3				; d3=4*DY-2*DX
	move.w	d3,$52(a5)			; BLTAPTL=4*DY-2*DX

								; Bereite den Wert vor, um in BLTCON1 zu schreiben				
	or.w	#$0003,d5			; Bit 0=1 (aktiver Zeilenmodus), und														
								; Bit 1 (spezielle Zeilen zum Fllen)
	tst.w	d3
	bpl.s	Ok1					; wenn 4 * DY-2 * DX> 0 berspringen ..
	or.w	#$0040,d5			; Ansonsten setze das SIGN-Bit
Ok1:
	move.w	d0,$40(a5)			; BLTCON0
	move.w	d5,$42(a5)			; BLTCON1
	sub.w	d2,d3				; d3=4*DY-4*DX
	move.w	d3,$64(a5)			; BLTAMOD=4*DY-4*DX
	move.l	a0,$48(a5)			; BLTCPT - Adresse Bildschirm
	move.l	a0,$54(a5)			; BLTDPT - Adresse Bildschirm
	move.w	d1,$58(a5)			; BLTSIZE
	rts
	

;******************************************************************************
; Diese Routine legt die Blitter-Register fest, die sich 
; zwischen einer Zeile und einer anderen nicht ndern
;******************************************************************************

InitLine
	btst	#6,2(a5) 			; DMACONR
WaitBlit3:
	btst	#6,2(a5) 			; DMACONR - warte auf das Ende des Blitters
	bne.s	WaitBlit3

	moveq.l	#-1,d5
	move.l	d5,$44(a5)			; BLTAFWM/BLTALWM = $ffff
	move.w	#$8000,$74(a5)		; BLTADAT = $8000
	move.w	#40,$60(a5)			; BLTCMOD = 40
	move.w	#40,$66(a5)			; BLTDMOD = 40
	rts


;******************************************************************************
; Diese Routine definiert das Muster, das zum Zeichnen der Linien verwendet 
; werden soll. In der Praxis setzt man einfach das BLTBDAT-Register.
; d0 - enthlt das Linienmuster
;******************************************************************************

SetPattern:
	btst	#6,2(a5)			; DMACONR
WaitBlit4:
	btst	#6,2(a5)			; DMACONR - warte auf das Ende des Blitters
	bne.s	WaitBlit4

	move.w	d0,$72(a5)			; BLTBDAT = Linienmuster
	rts


;****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP
	dc.w	$92,$38				; DDFSTRT
	dc.w	$94,$d0				; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2
	dc.w	$108,0				; BPL1MOD
	dc.w	$10a,0				; BPL2MOD

	dc.w	$100,$1200			; BPLCON0 - 1 Bitplane lowres

Bplpointers:
	dc.w	$e0,$0000,$e2,$0000	; erste Bitplane

	dc.w	$0180,$000			; COLOR00
	dc.w	$0182,$eee			; COLOR01
	dc.w	$ffff,$fffe			; Ende Copperlist

;****************************************************************************

	SECTION	LEEREPLANE,BSS_C

Bitplane:
	ds.b	40*256				; Bitplane lowres

	end

;****************************************************************************

In diesem Beispiel zeichnen wir ein Polygon, das durch Linien geschlossen wird.
Wie Sie sehen knnen, entsteht ein kleines Problem in den Punkten, wo die
Linien sich berhren, wie wir in der Lektion erklrten. Im nchsten Beispiel
sehen Sie die Lsung fr dieses Problem.                                                                                                                                                                                                                                                                 e sehen knnen werden die durch die Linien
