
; Listing10m1.s		Universalroutine Bob
; linke Taste zum Beenden.

	SECTION	BLIT,CODE

;	include	"DaWorkBench.s"	; entferne das ; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup1.s"	; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001111000000	; Bitplane, Copper, Blitter DMA


Start:
	move.l	#Bitplane,d0		; Zeiger auf die "leere" Bitplane
	lea	Bplpointers,a1			; Bitplanepointer
	moveq	#2-1,d1				; Anzahl der Bitplanes (hier sind es 2)
PointBp:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	add.l	#40*256,d0			; + Bitplane Lnge (hier 256 Zeilen hoch)
	addq.w	#8,a1
	dbra	d1,PointBp

	lea	$dff000,a5				; Custom Register Base in a5
	move.w	#DMASET,$96(a5)		; DMACON - einschalten Bitplane, Copper, Blitter
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse:

; Parameter fr Hintergrund speichern

	move.w	ObjX(pc),d0			; Position X
	move.w	ObjY(pc),d1			; Position Y
	move.w	#32,d2				; Dimension X
	move.w	#30,d3				; Dimension Y
	bsr.w	SaveBackground		; Speichere den Hintergrund

; Parameter fr UniBob-Routinen

	move.l	FrameTab(pc),a0		; setzt den Zeiger auf den frame
								; in a0 zum Zeichnen
	lea	2*4*30(a0),a1			; Zeiger auf die Maske in a1
	move.w	ObjX(pc),d0			; Position X
	move.w	ObjY(pc),d1			; Position Y
	move.w	#32,d2				; Dimension X
	move.w	#30,d3				; Dimension Y
	bsr.w	UniBob			    ; zeichne den Bob mit der 
								; universal Routine

	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$13000,d2			; Warte auf Zeile $130 (304)
WarteY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; Whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; Warte auf Zeile $130 (304)
	bne.s	WarteY1

; Parameter fr die Routine Hintergrund wiederherstellen

	move.w	ObjX(pc),d0			; Position X
	move.w	ObjY(pc),d1			; Position Y
	move.w	#32,d2				; Dimension X
	move.w	#30,d3				; Dimension Y
	bsr.w	RestoreBackground	; stelle den Hintergrund wieder her

	bsr.s	MoveObject			; verschiebe das Objekt auf dem Bildschirm
	bsr.s	Animation			; verschiebt die frames in der Tabelle

	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse				; Wenn nicht, gehe zurck zu Mouse:
	rts


;****************************************************************************
; Diese Routine bewegt den Bob auf dem Bildschirm.
;****************************************************************************

MoveObject:
	addq.w	#1,ObjX				; Verschiebe den Bob nach rechts
	cmp.w	#320-32,ObjX		; hat es die rechte Kante erreicht?
	bls.s	EndMove				; wenn kein Ende
	clr.w	ObjX				; ansonsten von links starten
EndMove
	rts

;****************************************************************************
; Diese Routine erstellt die Animation und verschiebt die Frameadressen
; so dass jedes Mal, der erste zum letzten Platz der Tabelle geht,
; die anderen liegen alle in der Richtung des ersten
;****************************************************************************

Animation:
	addq.b	#1,CounterAnim		; Diese drei Anweisungen machen das die
	cmp.b	#4,CounterAnim		; Frames immer einmal gendert werden
	bne.s	DoNotChange			; 3x nein und 1 x ja
	clr.b	CounterAnim			; fr die Geschwindigkeit der Animation
	lea	FrameTab(pc),a0			; Tabelle mit den Adressen der 4 Bilder
	move.l	(a0),d0				; Speichere die erste Adresse in d0
	move.l	4(a0),(a0)			; verschiebe die anderen Adressen zurck
	move.l	4*2(a0),4(a0)		; Diese Anweisungen "rotieren" die Adressen
	move.l	4*3(a0),4*2(a0)		; von der Tabelle.
	move.l	d0,4*3(a0)			; Stelle die erste Adresse auf den achten Platz

DoNotChange:
	rts

CounterAnim:
	dc.w	0

; Dies ist die Frame-Adressentabelle. Die Adressen die in der Tabelle 
; vorhanden sind rotieren innerhalb der Animationsroutine, so dass
; der erste in der Tabelle das erste Mal Frame1 ist, durch die Rotation
; dann Frame2, dann die 3,4 und dann wieder der erste, immer zyklisch.
; Auf diese Weise nehmen Sie einfach die Adresse, die am Anfang der 
; Tabelle steht.

FrameTab:
	dc.l	Frame1
	dc.l	Frame2
	dc.l	Frame3
	dc.l	Frame4

; BOB-Positionsvariablen

ObjY:		dc.w	100			; das Y des Objekts wird hier gespeichert
ObjX:		dc.w	50			; das X des Objekts wird hier gespeichert

;***************************************************************************
; Dies ist die universelle Routine zum Zeichnen von Bobs in Form und Gre
; willkrlich. Alle Parameter werden ber Register weitergegeben.
; Die Routine funktioniert auf einem normalen Bildschirm.
;
; a0 - Adresse Figur bob
; a1 - Bobmaskenadresse
; d0 - X Koordinate des oberen linken Eckpunkts
; d1 - Y-Koordinate des oberen linken Eckpunkts
; d2 - Rechteckbreite in Pixel
; d3 - Rechteckhhe
;****************************************************************************

;	       ___  Oo          .:/
;	      (___)o_o        ,,///;,   ,;/
;	 //====--//(_)       o:::::::;;///
;	         \\ ^       >::::::::;;\\\
;	                      ''\\\\\'" ';\

UniBob:

; Berechnung der Startadresse des Blitters

	lea	Bitplane,a2				; Adresse Bitplane
	mulu.w	#40,d1				; Offset Y
	add.l	d1,a2				; zur Adresse hinzufgen
	move.w	d0,d6				; kopiere das X
	lsr.w	#3,d0				; teile das X durch 8
	and.w	#$fffe,d0			; mach es gerade
	add.w	d0,a2				; addieren zur Adresse der Bitebene, 
								; um die richtige Zieladresse zu finden

	and.w	#$000f,d6			; whle die ersten 4 Bits des X aus
; Sie mssen in den Shifter der Kanle A, B eingefgt werden 
	lsl.w	#8,d6				; Die 4 Bits werden zum High-Nibble bewegt
	lsl.w	#4,d6				; des Wortes. Dies ist der Wert von BLTCON1

	move.w	d6,d5				; kopieren, um den Wert von BLTCON0 zu berechnen
	or.w	#$0fca,d5			; Werte, die in BLTCON0 gesetzt werden sollen

; berechnet den Versatz zwischen den Ebenen der Figur
	lsr.w	#3,d2				; dividiere die Breite durch 8
	and.w	#$fffe,d2			; Ich nulle Bit 0 (ich bin gerade)
	move.w	d2,d0				; Kopie Breite geteilt durch 8
	mulu	d3,d2				; multiplizieren mit der Hhe

; Blitter Modulo Berechnung

	addq.w	#2,d0				; Blitt ist ein greres Wort
	move.w	#40,d4				; Bildschirmbreite in Bytes
	sub.w	d0,d4				; Modulo=Breite Bildschirm - Breite Rechteck

; Berechnung der gemischten Gre

	lsl.w	#6,d3				; Hhe multipliziert mit 64
	lsr.w	#1,d0				; Pixelbreite geteilt durch 16
								; das heit, Breite in Worten
	or	d0,d3					; setze die Dimension zusammen

; initialisiere die Register, die konstant bleiben
	btst	#6,2(a5)
WaitBlit1:
	btst	#6,2(a5)			; warte auf das Ende des Blitters
	bne.s	WaitBlit1

	move.l	#$ffff0000,$44(a5)	; BLTAFWM = $ffff es passiert alles
								; BLTALWM = $0000 setzt das letzte Wort zurck

	move.w	d6,$42(a5)			; BLTCON1 - Verschiebungswert
								; kein besonderer Modi

	move.w	d5,$40(a5)			; BLTCON0 - Verschiebungswert
								; cookie-cut

	move.l	#$fffefffe,$62(a5)	; BLTBMOD und BLTAMOD=$fffe=-2
								; zurck zum Anfang der Zeile

	move.w	d4,$60(a5)			; BLTCMOD berechneter Wert
	move.w	d4,$66(a5)			; BLTDMOD berechneter Wert

	moveq	#2-1,d7				; wiederhole es fr jede Ebene
PlaneLoop:
	btst	#6,2(a5)
WaitBlit2:
	btst	#6,2(a5)			; warte auf das Ende des Blitters
	bne.s	WaitBlit2
	
	move.l	a1,$50(a5)			; BLTAPT (Maske)
	move.l	a0,$4c(a5)			; BLTBPT (Figur Bob)
	move.l	a2,$48(a5)			; BLTCPT (Bildschirm)
	move.l	a2,$54(a5)			; BLTDPT (Bildschirm)
	move.w	d3,$58(a5)			; BLTSIZE (Blitter starten!)

	add.l	d2,a0				; zeigt auf die nchste Quellebene

	lea	40*256(a2),a2			; zeigt auf die nchste Zielebene
	dbra	d7,PlaneLoop	

	rts

;****************************************************************************
; Diese Routine kopiert das Hintergrundrechteck, das mit dem BOB berschrieben 
; wird in einen Puffer. Die Routine behandelt einen Bob beliebiger Gre.
; Wenn Sie diese Routine fr Bobs unterschiedlicher Gre verwenden, seien Sie 
; vorsichtig dass der Puffer die maximale Gre des Bobs halten kann!
; Die Position und Gre des Rechtecks sind Parameter
;
; d0 - X Koordinate des oberen linken Eckpunkts
; d1 - Y-Koordinate des oberen linken Eckpunkts
; d2 - Rechteckbreite in Pixel
; d3 - Rechteckhhe
;****************************************************************************

SaveBackground:
; Berechnung der Startadresse des Blitters

	lea	Bitplane,a1				; Adresse Bitplane
	mulu.w	#40,d1				; Offset Y
	add.l	d1,a1				; zur Adresse hinzufgen
	lsr.w	#3,d0				; teile das X durch 8
	and.w	#$fffe,d0			; mach es gerade
	add.w	d0,a1				; addieren zur Adresse der Bitebene, 
								; um die richtige Zieladresse zu finden

; berechnet den Versatz zwischen den Ebenen der Figur
	lsr.w	#3,d2				; dividiere die Breite durch 8
	and.w	#$fffe,d2			; Ich nulle Bit 0 (ich bin gerade)
	addq.w	#2,d2				; Der Blitt ist 1 Wort mehr
	move.w	d2,d0				; Kopie Breite geteilt durch 8
	mulu	d3,d0				; multiplizieren mit der Hhe

; Blitter Modulo Berechnung
	move.w	#40,d4				; Bildschirmbreite in bytes
	sub.w	d2,d4				; Modulo=Breite Bildschirm - Breite Rechteck

; Berechnung der gemischten Gre
	lsl.w	#6,d3				; Hhe multipliziert mit 64
	lsr.w	#1,d2				; Pixelbreite geteilt durch 16
								; das heit, Breite in Worten
	or	d2,d3					; setze die Dimension zusammen

	lea	Buffer,a2				; Adresse Ziel
	moveq	#2-1,d7				; wiederhole es fr jede Ebene
PlaneLoop2:
	btst	#6,2(a5)			; DMACONR
WaitBlit3:
	btst	#6,2(a5)			; DMACONR - warte auf das Ende des Blitters
	bne.s	WaitBlit3

	move.l	#$ffffffff,$44(a5)	; BLTAFWM = $ffff es passiert alles
								; BLTALWM = $ffff es passiert alles

	move.l	#$09f00000,$40(a5)	; BLTCON0 und BLTCON1 Kopie von A nach D
	move.w	d4,$64(a5)			; BLTAMOD berechneter Wert
	move.w	#0,$66(a5)			; BLTDMOD=0 im Puffer
	move.l	a1,$50(a5)			; BLTAPT - Adresse Quelle
	move.l	a2,$54(a5)			; BLTDPT - Puffer
	move.w	d3,$58(a5)			; BLTSIZE (Blitter starten !)

	lea	40*256(a1),a1			; zeigt auf die nchste Quellebene
	add.l	d0,a2				; zeigt auf die nchste Quellebene

	dbra	d7,PlaneLoop2

	rts

;****************************************************************************
; Diese Routine kopiert den Inhalt des Puffers in das Bildschirmrechteck
; was es vor der BOB-Zeichnung enthielt. Auf diese Weise kommt es auch, das
; das BOB vom alten Standort gelscht wird. Die Routine behandelt einen Bob 
; von willkrlicher Dimension.
; Wenn Sie diese Routine fr Bobs unterschiedlicher Gre verwenden, seien Sie 
; vorsichtig dass der Puffer die maximale Gre des Bobs halten kann!
; Die Position und Gre des Rechtecks sind Parameter
;
; d0 - X Koordinate des oberen linken Eckpunkts
; d1 - Y-Koordinate des oberen linken Eckpunkts
; d2 - Rechteckbreite in Pixel
; d3 - Rechteckhhe
;****************************************************************************

RestoreBackground:
; Berechnung der Startadresse des Blitters

	lea	Bitplane,a1				; Adresse Bitplane
	mulu.w	#40,d1				; Offset Y
	add.l	d1,a1				; zur Adresse hinzufgen
	lsr.w	#3,d0				; teile das X durch 8
	and.w	#$fffe,d0			; mach es gerade
	add.w	d0,a1				; addieren zur Adresse der Bitebene, 
								; um die richtige Zieladresse zu finden

; berechnet den Versatz zwischen den Ebenen der Figur
	lsr.w	#3,d2				; dividiere die Breite durch 8
	and.w	#$fffe,d2			; Ich nulle Bit 0 (ich bin gerade)
	addq.w	#2,d2				; Der Blitt ist 1 Wort mehr
	move.w	d2,d0				; Kopie Breite geteilt durch 8
	mulu	d3,d0				; multiplizieren mit der Hhe

; Berechnung Modulo Blitter
	move.w	#40,d4				; Bildschirmbreite in Bytes
	sub.w	d2,d4				; Modulo=Breite Bildschirm-Breite Rechteck

; Berechnung Dimension blitt
	lsl.w	#6,d3				; Hhe multipliziert mit 64
	lsr.w	#1,d2				; Pixelbreite geteilt durch 16
								; das heit, Breite in Worten
	or	d2,d3					; setze die Dimension zusammen

	lea	Buffer,a2				; Adresse Ziel
	moveq	#2-1,d7				; wiederhole es fr jede Ebene
PlaneLoop3:
	btst	#6,2(a5)			; DMACONR
WaitBlit4:
	btst	#6,2(a5)			; DMACONR - warte auf das Ende des Blitters
	bne.s	WaitBlit4

	move.l	#$ffffffff,$44(a5)	; BLTAFWM = $ffff es passiert alles
								; BLTALWM = $ffff es passiert alles

	move.l	#$09f00000,$40(a5)	; BLTCON0 und BLTCON1 Kopie von A nach D
	move.w	d4,$66(a5)			; BLTDMOD berechneter Wert
	move.w	#0,$64(a5)			; BLTAMOD=0 im Puffer
	move.l	a2,$50(a5)			; BLTAPT - Puffer
	move.l	a1,$54(a5)			; BLTDPT - Bildschirm
	move.w	d3,$58(a5)			; BLTSIZE (Blitter starten!)

	lea	40*256(a1),a1			; zeigt auf die nchste Zielebene
	add.l	d0,a2				; zeigt auf die nchste Quellebene

	dbra	d7,PlaneLoop3

	rts


;****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP
	dc.w	$92,$38				; DDFSTRT
	dc.w	$94,$d0				; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2
	dc.w	$108,0				; BPL1MOD
	dc.w	$10a,0				; BPL2MOD

	dc.w	$100,$2200			; BPLCON0

Bplpointers:
	dc.w	$e0,$0000,$e2,$0000	; erste Bitplane
	dc.w	$e4,$0000,$e6,$0000

	dc.w	$180,$000			; COLOR00
	dc.w	$182,$00b			; COLOR01
	dc.w	$184,$cc0			; COLOR02
	dc.w	$186,$b00			; COLOR03

	dc.w	$ffff,$fffe			; Ende Copperlist

;****************************************************************************
; Dies sind die Frames, die die Animation ausmachen

Frame1:
	dc.l	$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
	dc.l	$00000000,$00000000,$00000000,$00000000,$03ffff80,$03ffff80
	dc.l	$03ffff80,$03ffff80,$03ffff80,$03ffff80,$03ffff80,$03ffff80
	dc.l	$03ffff80,$03ffff80,$00000000,$00000000,$00000000,$00000000
	dc.l	$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
	dc.l	$00010000,$00038000,$0007c000,$000fe000,$001ff000,$003ff800
	dc.l	$007ffc00,$00fffe00,$01ffff00,$03ffff80,$03ffff80,$03ffff80
	dc.l	$03ffff80,$03ffff80,$03ffff80,$03ffff80,$03ffff80,$03ffff80
	dc.l	$03ffff80,$03ffff80,$03ffff80,$01ffff00,$00fffe00,$007ffc00
	dc.l	$003ff800,$001ff000,$000fe000,$0007c000,$00038000,$00010000
; Maske
	dc.l	$00010000,$00038000,$0007c000,$000fe000,$001ff000,$003ff800
	dc.l	$007ffc00,$00fffe00,$01ffff00,$03ffff80,$03ffff80,$03ffff80
	dc.l	$03ffff80,$03ffff80,$03ffff80,$03ffff80,$03ffff80,$03ffff80
	dc.l	$03ffff80,$03ffff80,$03ffff80,$01ffff00,$00fffe00,$007ffc00
	dc.l	$003ff800,$001ff000,$000fe000,$0007c000,$00038000,$00010000


Frame2:
	dc.l	$00000000,$00000000,$00000000,$00000000,$00000000,$00300000
	dc.l	$00780000,$00fc0000,$01fe0000,$03ff0000,$07ff8000,$0fffc000
	dc.l	$07ffe000,$03fff000,$01fff800,$00fffc00,$007ffe00,$003fff00
	dc.l	$001fff80,$000fff00,$0007fe00,$0003fc00,$0001f800,$0000f000
	dc.l	$00006000,$00000000,$00000000,$00000000,$00000000,$00000000
	dc.l	$00000000,$00000000,$00000000,$00000000,$001fffc0,$003fffc0
	dc.l	$007fffc0,$00ffffc0,$01ffffc0,$03ffffc0,$07ffffc0,$0fffffc0
	dc.l	$0fffffc0,$0fffffc0,$0fffffc0,$0fffffc0,$0fffffc0,$0fffffc0
	dc.l	$0fffff80,$0fffff00,$0ffffe00,$0ffffc00,$0ffff800,$0ffff000
	dc.l	$0fffe000,$00000000,$00000000,$00000000,$00000000,$00000000

	dc.l	$00000000,$00000000,$00000000,$00000000,$001fffc0,$003fffc0
	dc.l	$007fffc0,$00ffffc0,$01ffffc0,$03ffffc0,$07ffffc0,$0fffffc0
	dc.l	$0fffffc0,$0fffffc0,$0fffffc0,$0fffffc0,$0fffffc0,$0fffffc0
	dc.l	$0fffff80,$0fffff00,$0ffffe00,$0ffffc00,$0ffff800,$0ffff000
	dc.l	$0fffe000,$00000000,$00000000,$00000000,$00000000,$00000000

Frame3:
	dc.l	$00000000,$00000000,$00000000,$00000000,$00000000,$003ff000
	dc.l	$003ff000,$003ff000,$003ff000,$003ff000,$003ff000,$003ff000
	dc.l	$003ff000,$003ff000,$003ff000,$003ff000,$003ff000,$003ff000
	dc.l	$003ff000,$003ff000,$003ff000,$003ff000,$003ff000,$003ff000
	dc.l	$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
	dc.l	$00000000,$00000000,$00000000,$00000000,$00000000,$007ff800
	dc.l	$00fffc00,$01fffe00,$03ffff00,$07ffff80,$0fffffc0,$1fffffe0
	dc.l	$3ffffff0,$7ffffff8,$fffffffc,$7ffffff8,$3ffffff0,$1fffffe0
	dc.l	$0fffffc0,$07ffff80,$03ffff00,$01fffe00,$00fffc00,$007ff800
	dc.l	$00000000,$00000000,$00000000,$00000000,$00000000,$00000000

	dc.l	$00000000,$00000000,$00000000,$00000000,$00000000,$007ff800
	dc.l	$00fffc00,$01fffe00,$03ffff00,$07ffff80,$0fffffc0,$1fffffe0
	dc.l	$3ffffff0,$7ffffff8,$fffffffc,$7ffffff8,$3ffffff0,$1fffffe0
	dc.l	$0fffffc0,$07ffff80,$03ffff00,$01fffe00,$00fffc00,$007ff800
	dc.l	$00000000,$00000000,$00000000,$00000000,$00000000,$00000000

Frame4:
	dc.l	$00000000,$00000000,$00000000,$00000000,$00006000,$0000f000
	dc.l	$0001f800,$0003fc00,$0007fe00,$000fff00,$001fff80,$003fff00
	dc.l	$007ffe00,$00fffc00,$01fff800,$03fff000,$07ffe000,$0fffc000
	dc.l	$07ff8000,$03ff0000,$01fe0000,$00fc0000,$00780000,$00300000
	dc.l	$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
	dc.l	$00000000,$00000000,$00000000,$00000000,$0fffe000,$0ffff000
	dc.l	$0ffff800,$0ffffc00,$0ffffe00,$0fffff00,$0fffff80,$0fffffc0
	dc.l	$0fffffc0,$0fffffc0,$0fffffc0,$0fffffc0,$0fffffc0,$0fffffc0
	dc.l	$07ffffc0,$03ffffc0,$01ffffc0,$00ffffc0,$007fffc0,$003fffc0
	dc.l	$001fffc0,$00000000,$00000000,$00000000,$00000000,$00000000

	dc.l	$00000000,$00000000,$00000000,$00000000,$0fffe000,$0ffff000
	dc.l	$0ffff800,$0ffffc00,$0ffffe00,$0fffff00,$0fffff80,$0fffffc0
	dc.l	$0fffffc0,$0fffffc0,$0fffffc0,$0fffffc0,$0fffffc0,$0fffffc0
	dc.l	$07ffffc0,$03ffffc0,$01ffffc0,$00ffffc0,$007fffc0,$003fffc0
	dc.l	$001fffc0,$00000000,$00000000,$00000000,$00000000,$00000000

;****************************************************************************

; Dies ist der Puffer, in dem wir den Hintergrund von Zeit zu Zeit speichern.
; Er hat die gleichen Abmessungen wie ein Blitt: Hhe 30 Zeilen,
; Breite 3 Wrter, 2 Bitebenen

Buffer:
	ds.w	30*3*2

; Die Bitebene enthlt ein Bild von 1 Ebene 320 * 100
Bitplane:

; plane 1
	ds.b	40*56				; 56 Linien
	incbin	"/Sources/sfondo320x100.raw"	; 100 Linien

	ds.b	40*100				; 100 Linien

	ds.b	40*256				; plane 2

;****************************************************************************

	end

In diesem Beispiel prsentieren wir eine universelle Routine zum Zeichnen von
Bobs. Die Routine behandelt Bobs unterschiedlicher Gre. Die Position, die
Dimension und die Adressen der Figur und der Bobmaske werden als Parameter
bergeben. Basierend auf den Parametern werden alle Werte berechnet, die in die
Blitter-Register geschrieben werden, wobei die zuvor gesehenen Formeln
verwendet werden. Folglich wurden auch die Rettungs- und
Wiederherstellungsroutinen des Hintergrunds gendert, um vernderliche
Rechtecke zu bearbeiten. Achten Sie darauf, dass der von Ihnen verwendete
Rettungspuffer der Routine gro genug ist, um das Rechteck aufzunehmen. Mit
diesen Routinen ist es mglich, einen animierten Bob in Kombination mit der
Animationsroutine aus dem Beispiel Listing10l1.s (Animation zyklisch) zu
realisieren. Beachten Sie, dass das Hintergrundbild den Bildschirm nur
teilweise einnimmt. Fr den Rest wird es zurckgesetzt.