
; Listing10g1.s		Blitt, in dem wir gestreifte Rechtecke auf dem Bildschirm zeichnen
; rechte Taste um den Blitt zu starten, links um zu beenden.

	SECTION	BLIT,CODE

;	include	"DaWorkBench.s"	; entferne das ; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup1.s"	; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001111000000	; Bitplane, Copper, Blitter DMA


Start:
	move.l	#Bitplane,d0		; Zeiger auf die "leere" Bitplane
	lea	Bplpointers,a1			; Bitplanepointer
	moveq	#1-1,d1				; Anzahl der Bitplanes (hier ist es 1)
PointBp:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	add.l	#40*256,d0			; + Bitplane Lnge (hier 256 Zeilen hoch)
	addq.w	#8,a1
	dbra	d1,PointBp

	lea	$dff000,a5				; Custom Register Base in a5
	move.w	#DMASET,$96(a5)		; DMACON - einschalten Bitplane, Copper, Blitter
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"


; Parameter fr das Zeichnen von Routinen

	move.w	#16,d0				; X obere linke Ecke
	move.w	#10,d1				; Y obere linke Ecke
	move.w	#48,d2				; Breite
	move.w	#20,d3				; Hhe
	move.w	#$aaaa,d4			; "Muster" zu zeichnen
	bsr.s	BlittRect			; die Zeichenroutine ausfhren

Mouse1:
	btst	#2,$dff016			; rechte Maustaste gedrckt?
	bne.s	Mouse1

;  Parameter fr das Zeichnen von Routinen

	move.w	#64,d0				; X obere linke Ecke
	move.w	#70,d1				; Y obere linke Ecke
	move.w	#32,d2				; Breite
	move.w	#40,d3				; Hhe 
	move.w	#$8ff1,d4			; "Muster" zu zeichnen
	bsr.s	BlittRect			; die Zeichenroutine ausfhren

Mouse2:
	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse2				; wenn nicht, gehe zurck zu Mouse2:

	rts

;****************************************************************************
; Diese Routine zeichnet ein Rechteck auf dem Bildschirm.
;
; d0 - X Koordinate des oberen linken Eckpunkts
; d1 - Y-Koordinate des oberen linken Eckpunkts
; d2 - Rechteckbreite in Pixel
; d3 - Rechteckhhe
; d4 - "Muster", mit dem ein Rechteck gezeichnet werden soll
;****************************************************************************

;	             |\__/,|   (`\
;	             |o o  |__ _) )
;	           _.( T   )  `  /
;	 n n._    ((_ `^--' /_<  \
;	 <" _ }=- `` `-'(((/  (((/
;	  `" "

BlittRect:
	btst	#6,2(a5)			; DMACONR
WaitBlit1:
	btst	#6,2(a5)			; DMACONR - warte auf das Ende des Blitters
	bne.s	WaitBlit1

; Berechnung der Startadresse des Blitters

	lea	Bitplane,a1				; Adresse Bitplane
	mulu.w	#40,d1				; offset Y
	add.l	d1,a1				; zur Adresse hinzufgen
	lsr.w	#3,d0				; teile das X durch 8
	and.w	#$fffe,d0			; mach es gerade
	add.w	d0,a1				; addieren zur Adresse der Bitebene, 
								; um die richtige Zieladresse zu finden

; Berechnung Modulo Blitter

	lsr.w	#3,d2				; dividiere die Breite durch 8
	and.w	#$fffe,d2			; Ich nulle Bit 0 (ich bin gerade)
	move.w	#40,d5				; Bildschirmbreite in Bytes
	sub.w	d2,d5				; Modulo=Breite Bildschirm - Breite Rechteck

; Berechnung Dimension Blitt

	lsl.w	#6,d3				; Hhe mal 64 (wegen Position im BLTSIZE)
	lsr.w	#1,d2				; Pixelbreite geteilt durch 16
								; das heit, Breite in Worten
	or	d2,d3					; lege die Dimensionen zusammen

; Lade die Register

	move.l	#$01f00000,$40(a5)	; BLTCON0 und BLTCON1
								; NUR Kanal D verwenden
								; LF = $f0 (Kopie von A nach D)
								; aufsteigender Weg

	move.w	d4,$74(a5)			; BLTADAT
	move.w	d5,$66(a5)			; BLTDMOD
	move.l	a1,$54(a5)			; BLTDPT Zeiger Ziel
	move.w	d3,$58(a5)			; BLTSIZE (Blitter starten !)

	rts

;****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP
	dc.w	$92,$38				; DDFSTRT
	dc.w	$94,$d0				; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2
	dc.w	$108,0				; BPL1MOD
	dc.w	$10a,0				; BPL2MOD

	dc.w	$100,$1200			; BPLCON0 - 1 Bitplane lowres

Bplpointers:
	dc.w	$e0,$0000,$e2,$0000	; erste Bitplane

	dc.w	$0180,$000			; COLOR00
	dc.w	$0182,$aaa			; COLOR01

	dc.w	$ffff,$fffe			; Ende Copperlist

;****************************************************************************

	SECTION	LEEREPLANE,BSS_C

Bitplane:
	ds.b	40*256

;****************************************************************************

	end

In diesem Beispiel verwenden wir den Blitter, um Rechtecke mit einem "Muster"
zu zeichnen. Das heit mit einem sich wiederholenden grafischen Muster. Wir
benutzen eine Routine mit Parameterbergabe, die ein Rechteck zeichnet, mit den
Koordinaten des oberen linken Eckpunkts und den Abmessungen (Breite und Hhe)
des Rechtecks. Zur Vereinfachung der Routine werden die Breite und die Position 
von X (die Hhe) einem Vielfachen von 16 angenhert. 
Das "Muster" wird auch als Parameter in einem Register bergeben. Auf diese
Weise knnen wir alle "Muster", die wir wollen mit nur einer Routine zeichnen.
Die Zeichnung wird durch einen Blitt gemacht, bei dem nur Kanal D aktiviert
wird, aber der Inhalt des BLTADAT-Registers zum Ausgang kopiert wird.
Sie mssen den gleichen LF-Wert verwenden, der auch bei der normalen Kopie von
A nach D verwendet wird, aber Sie mssen Kanal A nicht aktivieren. Daher ist
der Wert, der in BLTCON0 geschrieben werden muss $01f0 oder LF = $f0
(Kopie von A nach D) und nur der Kanal D ist aktiv. Der Wert des "Musters", das
in die Ausgabe kopiert wird, wird in das Register BLTADAT geschrieben.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ,2(a5)
