
; Listing10e4.s		Kopieren von B nach D mit Coppermonitor
; linke Taste zum Beenden.

	SECTION	BLIT,CODE

;	include	"DaWorkBench.s"	; entferne das ; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup1.s"	; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001111000000	; Bitplane, Copper, Blitter DMA


Start:
	move.l	#Bitplane,d0		; Zeiger auf die "leere" Bitplane
	lea	Bplpointers,a1			; Bitplanepointer
	moveq	#3-1,d1				; Anzahl der Bitplanes (hier sind es 3)
PointBp:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	add.l	#40*256,d0			; + LNGE EINER PLANE !!!!!
	addq.w	#8,a1
	dbra	d1,PointBp

	lea	$dff000,a5				; Custom Register Base in a5
	move.w	#DMASET,$96(a5)		; DMACON - einschalten Bitplane, Copper, Blitter
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

	move.w	#0,ObjX
	move.w	#0,ObjY

Mouse:

	addq.w	#1,ObjY
	cmp.w	#130,ObjY
	beq.s	Ende

	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$0d000,d2			; Warte auf Zeile $d0
WarteY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; Whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; Warte auf Zeile $d0
	bne.s	WarteY1

;             __            
;           >(. )
;            |  (     /)
;            |   \___/ )
;            (   ----- )  >@)_//   >@)_//  >@)_//  >@)_//
;             \_______/    (__)     (__)    (__)    (__)
;           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	bsr.s	ClearObject			; lsche den Bob

	move	#$0b0,$180(a5)		; dunkelgrner Bildschirm, wenn der
								; Prozessor die Lschung abgeschlossen hat

	bsr.s	DesignObject		; zeichne den Bob

	move	#$b00,$180(a5)		; dunkelroter Bildschirm, wenn der
								; Prozessor die Lschung abgeschlossen hat

	btst	#6,2(a5)
WaitBlit:
	btst	#6,2(a5)			; warte auf das Ende des Blitters
	bne.s	WaitBlit

	move.w	#$000,$180(a5)

	bra.s	Mouse

Ende:
	rts


;*****************************************************************************
; Diese Routine lscht den BOB unter Verwendung des Blitters. Die
; Lschung wird auf dem Rechteck gemacht, das den Bob umgibt.
;****************************************************************************

ClearObject:
	lea	Bitplane,a0				; Ziel in a0
	move.w	ObjY(pc),d0			; Koordinate Y
	mulu.w	#40,d0				; Adresse berechnen: Jede Zeile besteht aus
								; 40 Bytes
	add.w	d0,a0				; zur Anfangsadresse hinzufgen

	move.w	ObjX(pc),d1			; Koordinate X
	lsr.w	#3,d1				; (entspricht einer Division durch 8)
								; Runden auf ein Vielfaches von 8 fr den Zeiger
								; auf den Bildschirm, also auch auf ungerade Adressen
								; (also zu Bytes)
								; zB: eine 16 als Koordinate wird zu Byte 2
	and.w	#$fffe,d1			; Ich schliee Bit 0 aus
	add.w	d1,a0				; addieren zur Adresse der Bitebene, 
								; um die richtige Zieladresse zu finden

	moveq	#3-1,d7				; wiederhole es fr jede Ebene
PlaneLoop2:
	btst	#6,2(a5)
WaitBlit3:
	btst	#6,2(a5)			; warte auf das Ende des Blitters
	bne.s	WaitBlit3

	move.w	#$0f0,$180(a5)		; Coppermonitor! grner Bildschirm whrend
								; Lschung

	move.l	#$01000000,$40(a5)	; BLTCON0 und BLTCON1: Lschung
	move.w	#$0004,$66(a5)		; BLTDMOD=40-36=4
	move.l	a0,$54(a5)			; BLTDPT
	move.w	#(64*45)+18,$58(a5)	; BLTSIZE (Blitter starten!)
								; Lsche das umschlieende Rechteck
								; des BOBs

	lea	40*256(a0),a0			; zeigt auf die nchste Zielebene
	dbra	d7,PlaneLoop2

	rts				

;****************************************************************************
; Diese Routine zeichnet den BOB an die in den Variablen ObjX und ObjY
; angegebenen Koordinaten
;****************************************************************************

DesignObject:
	lea	Bitplane,a0				; Ziel in a0
	move.w	ObjY(pc),d0			; Koordinate Y
	mulu.w	#40,d0				; Adresse berechnen: Jede Zeile besteht aus
								; 40 Bytes
	add.w	d0,a0				; zur Anfangsadresse hinzufgen

	move.w	ObjX(pc),d0			; Koordinate X
	move.w	d0,d1				; Kopie
	lsr.w	#3,d1				; (entspricht einer Division durch 8)
								; Runden auf ein Vielfaches von 8 fr den Zeiger
								; auf den Bildschirm, also auch auf ungerade Adressen
								; (also zu Bytes)
								; zB: eine 16 als Koordinate wird zu Byte 2
	and.w	#$fffe,d1			; Ich schliee Bit 0 aus
	add.w	d1,a0				; addieren zur Adresse der Bitebene, 
								; um die richtige Zieladresse zu finden

	lea	Figur,a1				; Zeiger Quelle
	moveq	#3-1,d7				; wiederhole es fr jede Ebene
PlaneLoop:
	btst	#6,2(a5)
WaitBlit2:
	btst	#6,2(a5)			; warte auf das Ende des Blitters
	bne.s	WaitBlit2

	move.w	#$f00,$180(a5)		; Coppermonitor! roter Bildschirm whrend
								; des Zeichnens

	move.l	#$ffffffff,$44(a5)	; BLTAFWM = $ffff es passiert alles
								; BLTALWM = $ffff es passiert alles
								
	move.w	#$05cc,$40(a5)		; BLTCON0 (B+D)
	move.w	#$0000,$42(a5)		; BLTCON1 (ohne Spezialmodi)
	move.w	#$0000,$62(a5)		; BLTBMOD=0
	move.w	#$0004,$66(a5)		; BLTDMOD=40-36=4 wie immer

	move.l	a1,$4c(a5)			; BLTBPT (an der Quellfigur fixiert)
	move.l	a0,$54(a5)			; BLTDPT (Bildschirm)
	move.w	#(64*45)+18,$58(a5)	; BLTSIZE (Blitter starten !)

	lea	40*256(a0),a0			; zeigt auf die nchste Zielebene
	lea	2*18*45(a1),a1			; zeigt auf die nchste Quellebene
								; Jede Bitplane ist 18 Wrter breit und 
								; 45 Zeilen hoch
	dbra	d7,PlaneLoop

	rts

ObjY:		dc.w	0			; hier wird das Y des Objektes gespeichert
ObjX:		dc.w	0			; hier wird das X des Objektes gespeichert
;MouseY:	dc.b	0			; hier wird das Y der Maus gespeichert
;MouseX:	dc.b	0			; hier wird das X der Maus gespeichert

;****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP
	dc.w	$92,$38				; DDFSTRT
	dc.w	$94,$d0				; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2
	dc.w	$108,0				; WERT MODULO 0
	dc.w	$10a,0				; BEIDE MODULO MIT GLEICHEN WERT.

	dc.w	$100,$3200			; BPLCON0 - 3 Bitplanes lowres

Bplpointers:
	dc.w	$e0,$0000,$e2,$0000	; erste Bitplane
	dc.w	$e4,$0000,$e6,$0000
	dc.w	$e8,$0000,$ea,$0000

	dc.w	$0180,$000			; COLOR00
	dc.w	$0182,$475			; COLOR01
	dc.w	$0184,$fff			; COLOR02
	dc.w	$0186,$ccc			; COLOR03
	dc.w	$0188,$999			; COLOR04
	dc.w	$018a,$232			; COLOR05
	dc.w	$018c,$777			; COLOR06
	dc.w	$018e,$444			; COLOR07

	dc.w	$ffff,$fffe			; Ende Copperlist

;****************************************************************************

; Dies sind die Daten, aus denen die Figur des Bobs besteht.
; Der Bob ist im normalen Format, 288 Pixel breit (18 Wrter)
; 45 Zeilen hoch, 3 Bitebenen

Figur:
	incbin	"/Sources/copmon.raw"

;****************************************************************************

	SECTION	LEEREPLANE,BSS_C

Bitplane:
		ds.b	40*256			; 3 Bitplanes
		ds.b	40*256
		ds.b	40*256

	end

;****************************************************************************

In diesem Programm fhren wir die Zeichnung durch eine Kopie von B nach D
durch. In diesem Fall, anders als in dem Fall, in dem die Kopie zwischen
A nach D war, ist die Zeichnungsroutine langsamer, als die zum Lschen.
