
; Listing10c2.s		Blitt, in dem wir die Maske einer Zeichnung aufbauen
; rechte Taste um den Blitt zu starten, links um zu beenden.

	SECTION	BLIT,CODE

;	include	"DaWorkBench.s"	; entferne das ; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup1.s"	; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001111000000	; Bitplane, Copper, Blitter DMA


Start:
	move.l	#Bitplane1,d0		; Zeiger auf die "leere" Bitplane
	lea	Bplpointers,a1			; Bitplanepointer
	moveq	#3-1,d1				; Anzahl der Bitplanes
PointBp:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	add.l	#40*256,d0			; + Bitplane Lnge (hier 256 Zeilen hoch)
	addq.w	#8,a1
	dbra	d1,PointBp

	lea	$dff000,a5				; Custom Register Base in a5
	move.w	#DMASET,$96(a5)		; DMACON - einschalten Bitplane, Copper, Blitter
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

; kopiere das Bild normal

	lea	FigurPlane1,a0			; Kopiere die erste Bitplane
	lea	Bitplane1,a1
	bsr.s	Copy

	lea	FigurPlane2,a0			; Kopiere die zweite Bitplane
	lea	Bitplane2,a1
	bsr.s	Copy

	lea	FigurPlane3,a0			; Kopiere die dritte Bitplane
	lea	Bitplane3,a1
	bsr.s	Copy

Mouse1:
	btst	#2,$dff016			; rechte Maustaste gedrckt?
	bne.s	Mouse1				; wenn nicht, gehe zurck zu Mouse1:

; ODER aller Bitebenen

	lea	FigurPlane1,a0
	lea	FigurPlane2,a1
	lea	FigurPlane3,a2
	lea	Bitplane1+14,a3
	bsr.s	BlitOr				; fhrt ein ODER zwischen den Ebenen der Figur durch
								; und kopiert das Ergebnis

Mouse2:
	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse2				; wenn nicht, gehe zurck zu Mouse2:
	rts

;****************************************************************************
; Diese Routine kopiert die Figur auf dem Bildschirm.
;
; a0 - Quelladresse
; a1 - Zieladresse
;****************************************************************************

Copy:
	btst	#6,2(a5)			; DMACONR
WaitBlit1:
	btst	#6,2(a5)			; DMACONR - warte auf das Ende des Blitters
	bne.s	WaitBlit1

	move.l	#$ffffffff,$44(a5)	; Maske
	move.l	#$09f00000,$40(a5)	; BLTCON0 und BLTCON1 (A+D)
								; normale Kopie
	move.w	#0,$64(a5)			; BLTAMOD (=0)
	move.w	#34,$66(a5)			; BLTDMOD (40-6=34)
	move.l	a0,$50(a5)			; BLTAPT Zeiger Quelle
	move.l	a1,$54(a5)			; BLTDPT Zeiger Ziel
	move.w	#(64*42)+3,$58(a5)	; BLTSIZE (Blitter starten !)
								; Breite 3 Word, Hhe 42 Zeilen
	rts	

;****************************************************************************
; Diese Routine fhrt ein ODER zwischen den 3 Kanlen A, B und C durch.
;
; a0 - Adresse Kanal A
; a1 - Adresse Kanal B
; a2 - Adresse Kanal C
; a3 - Adresse Ziel
;****************************************************************************

;	                 _____
;	                (_____)
;	                  ,,,
;	 __n____________.|o o|.____________n__
;	== _o_|         |  -  |         |_o_ ==
;	  . |   ____  |\ O /|  ____   |   
;	      |__/    \ ||`*'|| /    \_#| :
;	    :         | ||   || |      `:
;	    .         |#._______|         .
;	              ! |  o  |
;	                (     )
;	                |  U  |
;	                :  !  :

BlitOr:
	btst	#6,2(a5)			; DMACONR
WaitBlit2:
	btst	#6,2(a5)			; DMACONR - warte auf das Ende des Blitters
	bne.s	WaitBlit2

	move.l	#$ffffffff,$44(a5)	; BLTFWM und BLTLWM
	move.l	#$0ffe0000,$40(a5)	; BLTCON0 und BLTCON1
								; Aktiviere alle Kanle
								; fhrt ein OR zwischen A, B und C aus
								; D=A OR B OR C
	move.w	#0,$60(a5)			; BLTCMOD (=0)
	move.w	#0,$62(a5)			; BLTBMOD (=0)
	move.w	#0,$64(a5)			; BLTAMOD (=0)
	move.w	#34,$66(a5)			; BLTDMOD (40-6=34)
	move.l	a0,$48(a5)			; BLTCPT Zeiger Quelle
	move.l	a1,$4c(a5)			; BLTBPT Zeiger Quelle
	move.l	a2,$50(a5)			; BLTAPT Zeiger Quelle
	move.l	a3,$54(a5)			; BLTDPT Zeiger Ziel
	move.w	#(64*42)+3,$58(a5)	; BLTSIZE (Blitter starten!)
								; Breite 3 Word, Hhe 42 Zeilen
	rts

;****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP
	dc.w	$92,$38				; DDFSTRT
	dc.w	$94,$d0				; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2
	dc.w	$108,0				; BPL1MOD
	dc.w	$10a,0				; BPL2MOD

	dc.w	$100,$3200			; BPLCON0

Bplpointers:
	dc.w	$e0,$0000,$e2,$0000	; erste Bitplane
	dc.w	$e4,$0000,$e6,$0000
	dc.w	$e8,$0000,$ea,$0000

	dc.w	$180,$000			; COLOR00
	dc.w	$182,$aaa			; COLOR01
	dc.w	$184,$b00			; COLOR02
	dc.w	$186,$080			; COLOR03
	dc.w	$188,$24c
	dc.w	$18a,$eb0
	dc.w	$18c,$b52
	dc.w	$18e,$0cc

	dc.w	$ffff,$fffe			; Ende Copperlist

;****************************************************************************

; Das ist die Figur

FigurPlane1:
	dc.l	$ffffc000,$ffff,$c0000000,$ffffc000,$ffff,$c0000000
	dc.l	$ffffc000,$ffff,$c0000000,$ffffc000,$ffff,$c0000000
	dc.l	$ffffc000,$ffff,$c0000000,$ffffc000,$ffff,$c0000000
	dc.l	$ffffc000,$ffff,$c0000000,$ffffc000,$ffff,$c0000000
	dc.l	0,0,0,0,0,0
	dc.l	0,0,0,0,0,$3fffff80
	dc.l	$3fff,$ff800000,$3fffff80,$3fff,$ff800000,$3fffff80
	dc.l	$3fff,$ff800000,$3fffff80,$3fff,$ff800000,$3fffff80
	dc.l	$3fff,$ff800000,$3fffff80,$3fff,$ff800000,$3fffff80
	dc.l	$3fff,$ff800000,$3fffff80,$3fff,$ff800000,$3fffff80
	dc.l	$3fff,$ff800000,0

FigurPlane2:
	dc.l	$3fff,$ff800000,$3fffff80,$3fff,$ff800000,$3fffff80
	dc.l	$3fff,$ff800000,$3fffff80,$3fff,$ff800000,$3fffff80
	dc.l	$3fff,$ff800000,$3fffff80,$3fff,$ff800000,$3fffff80
	dc.l	$3fff,$ff800000,$3fffff80,$3fff,$ff800000,$3fffff80
	dc.l	$3fff,$ff800000,$3fffff80,$3fff,$ff800000,$3fffff80
	dc.l	$3fff,$ff800000,$3fffff80,$3fff,$ff800000,0
	dc.l	0,0,0,0,0,0
	dc.l	0,0,0,0,0,0
	dc.l	0,0,0,0,0,0
	dc.l	0,0,0,0,0,0
	dc.l	0,0,0

FigurPlane3:
	dc.l	0,0,0,0,0,0
	dc.l	0,0,0,0,0,0
	dc.l	0,0,0,0,0,0
	dc.l	0,0,0,0,0,0
	dc.l	$ffffc000,$ffff,$c0000000,$ffffc000,$ffff,$c0000000
	dc.l	$ffffc000,$ffff,$c0000000,$ffffc000,$ffff,$ffffff80
	dc.l	$ffffffff,$ff80ffff,$ffffff80,$ffffffff,$ff80ffff,$ffffff80
	dc.l	$f000ffff,$ff80f000,$ffffff80,$f000ffff,$ff80f000,$ffffff80
	dc.l	$f000ffff,$ff80f000,$ffffff80,$f000ffff,$ff80f000,$ffffff80
	dc.l	$f000ffff,$ff80f000,$ffffff80,$f000ffff,$ff80f000,$ffffff80
	dc.l	$ffffffff,$ff800000,0

;****************************************************************************

	SECTION	LEEREPLANE,BSS_C

Bitplane1:
	ds.b	40*256
Bitplane2:
	ds.b	40*256
Bitplane3:
	ds.b	40*256

;****************************************************************************

	end

In diesem Beispiel erstellen wir die Maske einer Figur mit dem Blitter. Wir 
verwenden dabei eine andere Technik, als die im Listing10c1.s. Dieses Mal
fhren wir tatschlich nur einen Blitt aus, indem wir alle Kanle benutzen. Da
unsere Figur 3 Bitebenen hat, knnen wir sie gleichzeitig durch die Kanle
A, B und C ber das OR lesen und durch Kanal D schreiben.
Dies ist das erste Beispiel, in welchem wir alle Blitter-Kanle gleichzeitig
aktivieren. Beachten Sie, dass die Bits 8 bis 11 von BLTCON0 tatschlich alle
auf 1 gesetzt sind. Der Wert von LF wird auf die bliche Weise berechnet. Die
Einstellung wird vorgenommen fr alle Minterme, die den Eingangskombinationen 
A = 1 oder B = 1 oder C = 1 entsprechen. Natrlich sind dies 7 Kombinationen.
Die einzige, die nicht enthalten ist, ist diejenige mit A = 0, B = 0 und C = 0.
Beachten Sie, dass diese Technik, anders als im Listing10c1.s nur angewendet 
werden kann, wenn die Figur 3 Bitebenen hat.      