
; Listing10c1.s		Blitt, in dem wir die Maske einer Zeichnung aufbauen
; abwechselnd die Maustasten drcken, um die Blitts zu sehen

	SECTION	BLIT,CODE

;	include	"DaWorkBench.s"	; entferne das ; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup1.s"	; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001111000000	; Bitplane, Copper, Blitter DMA


Start:
	move.l	#Bitplane1,d0		; Zeiger auf die "leere" Bitplane
	lea	Bplpointers,a1			; Bitplanepointer
	moveq	#3-1,d1				; Anzahl der Bitplanes
PointBp:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	add.l	#40*256,d0			; + Bitplane Lnge (hier 256 Zeilen hoch)
	addq.w	#8,a1
	dbra	d1,PointBp

	lea	$dff000,a5				; Custom Register Base in a5
	move.w	#DMASET,$96(a5)		; DMACON - einschalten Bitplane, Copper, Blitter
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

; kopiere das Bild normal

	lea	FigurPlane1,a0			; Kopiere die erste Bitplane
	lea	Bitplane1,a1
	bsr.s	Copy

	lea	FigurPlane2,a0			; Kopiere die zweite Bitplane
	lea	Bitplane2,a1
	bsr.s	Copy

	lea	FigurPlane3,a0			; Kopiere die dritte Bitplane
	lea	Bitplane3,a1
	bsr.s	Copy

Mouse1:
	btst	#2,$dff016			; rechte Maustaste gedrckt?
	bne.s	Mouse1				; wenn nicht, gehe zurck zu Mouse1:

; Kopie erste Bitebene 

	lea	FigurPlane1,a0
	lea	Bitplane1+14,a1
	bsr.s	BlitOr				; fhrt ein ODER zwischen der Ebene 1 der Figur
								; und dem Ziel (leer) durch

Mouse2:
	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse2				; wenn nicht, gehe zurck zu Mouse2:

	lea	FigurPlane2,a0
	lea	Bitplane1+14,a1
	bsr.s	BlitOr				; fhrt ein ODER zwischen der Ebene 2 der Figur 
								; und dem Ziel (Ebene 1 der Figur) durch
Mouse3:
	btst	#2,$dff016			; rechte Maustaste gedrckt?
	bne.s	Mouse3				; wenn nicht, gehe zurck zu Mouse3:

	lea	FigurPlane3,a0
	lea	Bitplane1+14,a1
	bsr.s	BlitOr				; fhrt ein ODER zwischen der Ebene 3 der Figur 
								; und dem Ziel (Ebene 1 ODER 2 der Figur) durch
Mouse4:
	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse4				; wenn nicht, gehe zurck zu Mouse4:
	rts

;****************************************************************************
; Diese Routine kopiert die Figur auf dem Bildschirm.
;
; a0 - Quelladresse
; a1 - Zieladresse
;****************************************************************************

Copy:
	btst	#6,2(a5)			; DMACONR
WaitBlit1:
	btst	#6,2(a5)			; DMACONR - warte auf das Ende des Blitters
	bne.s	WaitBlit1

	move.l	#$ffffffff,$44(a5)	; Maske
	move.l	#$09f00000,$40(a5)	; BLTCON0 und BLTCON1 (A+D)
								; normale Kopie
	move.w	#0,$64(a5)			; BLTAMOD (=0)
	move.w	#34,$66(a5)			; BLTDMOD (40-6=34)
	move.l	a0,$50(a5)			; BLTAPT Zeiger Quelle
	move.l	a1,$54(a5)			; BLTDPT Zeiger Ziel
	move.w	#(64*42)+3,$58(a5)	; BLTSIZE (Blitter starten !)
								; Breite 3 Word, Hhe 42 Zeilen
	rts	

;****************************************************************************
; Diese Routine fhrt ein ODER zwischen der Quelle und dem Ziel durch. Wir
; verwenden die Kanle B, C und D. Die Quelle wird ber den Kanal C gelesen.
; Stattdessen wird das Ziel von Kanal B gelesen und dann von D neu geschrieben.
; Folglich haben die Kanle B und D beim Start das gleiche Modulo und die 
; gleichen Adressen.
;
; Parameter:
;
; a0 - Adresse Quelle
; a1 - Adresse Ziel
;****************************************************************************

;	                 _____
;	                (_____)
;	                  ,,,
;	 __n____________.|o o|.____________n__
;	== _o_|         |  -  |         |_o_ ==
;	  . |   ____  |\ O /|  ____   |   
;	      |__/    \ ||`*'|| /    \_#| :
;	    :         | ||   || |      `:
;	    .         |#._______|         .
;	              ! |  o  |
;	                (     )
;	                |  U  |
;	                :  !  :


BlitOr:
	btst	#6,2(a5)			; DMACONR
WaitBlit2:
	btst	#6,2(a5)			; DMACONR - warte auf das Ende des Blitters
	bne.s	WaitBlit2

	move.l	#$07ee0000,$40(a5)	; BLTCON0 und BLTCON1
								; fhrt ein OR zwischen B und C aus
								; D=B OR C
	move.w	#0,$60(a5)			; BLTCMOD (=0)
	move.w	#34,$66(a5)			; BLTDMOD (40-6=34)
	move.w	#34,$62(a5)			; BLTBMOD (40-6=34)
	move.l	a0,$48(a5)			; BLTCPT Zeiger Quelle
	move.l	a1,$4c(a5)			; BLTBPT Zeiger Quelle
	move.l	a1,$54(a5)			; BLTDPT Zeiger Ziel
	move.w	#(64*42)+3,$58(a5)	; BLTSIZE (Blitter starten !)
								; Breite 3 Word, Hhe 42 Zeilen
	rts	

;****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP
	dc.w	$92,$38				; DDFSTRT
	dc.w	$94,$d0				; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2
	dc.w	$108,0				; BPL1MOD
	dc.w	$10a,0				; BPL2MOD

	dc.w	$100,$3200			; BPLCON0

Bplpointers:
	dc.w	$e0,$0000,$e2,$0000	; erste Bitplane
	dc.w	$e4,$0000,$e6,$0000
	dc.w	$e8,$0000,$ea,$0000

	dc.w	$180,$000			; COLOR00
	dc.w	$182,$aaa			; COLOR01
	dc.w	$184,$b00			; COLOR02
	dc.w	$186,$080			; COLOR03
	dc.w	$188,$24c
	dc.w	$18a,$eb0
	dc.w	$18c,$b52
	dc.w	$18e,$0cc

	dc.w	$ffff,$fffe			; Ende Copperlist

;****************************************************************************

; Das ist die Figur

FigurPlane1:
	dc.l	$ffffc000,$ffff,$c0000000,$ffffc000,$ffff,$c0000000
	dc.l	$ffffc000,$ffff,$c0000000,$ffffc000,$ffff,$c0000000
	dc.l	$ffffc000,$ffff,$c0000000,$ffffc000,$ffff,$c0000000
	dc.l	$ffffc000,$ffff,$c0000000,$ffffc000,$ffff,$c0000000
	dc.l	0,0,0,0,0,0
	dc.l	0,0,0,0,0,$3fffff80
	dc.l	$3fff,$ff800000,$3fffff80,$3fff,$ff800000,$3fffff80
	dc.l	$3fff,$ff800000,$3fffff80,$3fff,$ff800000,$3fffff80
	dc.l	$3fff,$ff800000,$3fffff80,$3fff,$ff800000,$3fffff80
	dc.l	$3fff,$ff800000,$3fffff80,$3fff,$ff800000,$3fffff80
	dc.l	$3fff,$ff800000,0

FigurPlane2:
	dc.l	$3fff,$ff800000,$3fffff80,$3fff,$ff800000,$3fffff80
	dc.l	$3fff,$ff800000,$3fffff80,$3fff,$ff800000,$3fffff80
	dc.l	$3fff,$ff800000,$3fffff80,$3fff,$ff800000,$3fffff80
	dc.l	$3fff,$ff800000,$3fffff80,$3fff,$ff800000,$3fffff80
	dc.l	$3fff,$ff800000,$3fffff80,$3fff,$ff800000,$3fffff80
	dc.l	$3fff,$ff800000,$3fffff80,$3fff,$ff800000,0
	dc.l	0,0,0,0,0,0
	dc.l	0,0,0,0,0,0
	dc.l	0,0,0,0,0,0
	dc.l	0,0,0,0,0,0
	dc.l	0,0,0

FigurPlane3:
	dc.l	0,0,0,0,0,0
	dc.l	0,0,0,0,0,0
	dc.l	0,0,0,0,0,0
	dc.l	0,0,0,0,0,0
	dc.l	$ffffc000,$ffff,$c0000000,$ffffc000,$ffff,$c0000000
	dc.l	$ffffc000,$ffff,$c0000000,$ffffc000,$ffff,$ffffff80
	dc.l	$ffffffff,$ff80ffff,$ffffff80,$ffffffff,$ff80ffff,$ffffff80
	dc.l	$f000ffff,$ff80f000,$ffffff80,$f000ffff,$ff80f000,$ffffff80
	dc.l	$f000ffff,$ff80f000,$ffffff80,$f000ffff,$ff80f000,$ffffff80
	dc.l	$f000ffff,$ff80f000,$ffffff80,$f000ffff,$ff80f000,$ffffff80
	dc.l	$ffffffff,$ff800000,0

;****************************************************************************

	SECTION	LEEREPLANE,BSS_C

Bitplane1:
	ds.b	40*256
Bitplane2:
	ds.b	40*256
Bitplane3:
	ds.b	40*256

	end

;****************************************************************************

In diesem Beispiel erstellen wir die Maske einer Figur mit dem Blitter, das ist 
sein "Schatten". Um dies zu tun, ist es notwendig, ein ODER zwischen den Bits 
der Ebenen der Figur durchzufhren. In diesem Beispiel fhren wir diese
Operation ein Schritt nach dem anderen aus. Zuerst machen wir das ODER zwischen
der ersten Bitebene der Figur und dem Ziel, in dem wir die Maske zeichnen
werden. Da das Ziel zu Beginn leer ist, entspricht dieser Schritt einer
einfachen Kopie der ersten Ebene der Figur. Als zweiten Schritt fhren wir das
ODER zwischen der zweiten Ebene und dem Ziel durch. Das Ziel enthlt die erste
Ebene. In der Praxis fhren wir ein OR zwischen der Ebene 1 und der Ebene 2
aus. Als dritten Schritt fhren wir das ODER zwischen der Ebene 3 und dem Ziel
durch. Das Ziel enthlt das OR von Ebene 1 und Ebene 2. Als Ergebnis erhalten
wir das OR aller 3 Ebenen. Wenn wir eine Figur mit mehr als 3 Ebenen htten,
htten wir das gleiche Verfahren auch fr die anderen Bitebenen wiederholen
mssen. Der Blitt wird mit 3 Kanlen gemacht. Die Ebenen der Figur werden durch
den Kanal C gelesen, stattdessen wird das Ziel durch den Kanal B gelesen und
dann ber den Kanal D neu geschrieben. Der LF-Wert wird berechnet fr das ODER
der Kanle B und C.                                                                                                                                                                                               
                      