
; Listing10a2.s		Blitt, in dem wir ein Bild kopieren,
; indem wir eine Bitebene invertieren
; rechte Taste um den Blitt zu starten, links um zu beenden.

	SECTION	BLIT,CODE

;	include	"DaWorkBench.s"	; entferne das ; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup1.s"	; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001111000000	; Bitplane, Copper, Blitter DMA


Start:
	move.l	#Bitplane1,d0		; Zeiger auf die "leere" Bitplane
	lea	Bplpointers,a1			; Bitplanepointer
	moveq	#2-1,d1				; Anzahl der Bitplanes
PointBp:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	add.l	#40*256,d0			; + Bitplane Lnge (hier 256 Zeilen hoch)
	addq.w	#8,a1
	dbra	d1,PointBp

	lea	$dff000,a5				; Custom Register Base in a5
	move.w	#DMASET,$96(a5)		; DMACON - einschalten Bitplane, Copper, Blitter
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

; kopiere das Bild normal

	lea	FigurPlane1,a0			; kopiere die erste Bitplane
	lea	Bitplane1,a1
	bsr.s	Copy

	lea	FigurPlane2,a0			; kopiere die zweite Bitplane
	lea	Bitplane2,a1
	bsr.s	Copy

Mouse1:
	btst	#2,$dff016			; rechte Maustaste gedrckt?
	bne.s	Mouse1				; wenn nicht, gehe zurck zu Mouse1:

; wir kopieren das Bild, indem wir die erste Bitebene invertieren

	lea	FigurPlane1,a0
	lea	Bitplane1+14,a1
	bsr.s	CopyInvers			; kopiere die erste Bitplane, indem wir invertieren

	lea	FigurPlane2,a0
	lea	Bitplane2+14,a1
	bsr.s	Copy				; kopiere die zweite Bitplane, normal

Mouse2:
	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse2				; wenn nicht, gehe zurck zu Mouse2:
	rts

;****************************************************************************
; Diese Routine kopiert die Figur auf dem Bildschirm.
; Es braucht als Parameter
; a0 - Quelladresse
; a1 - Zieladresse
;****************************************************************************

Copy:
	btst	#6,2(a5)			; DMACONR
WaitBlit1:
	btst	#6,2(a5)			; DMACONR - warte auf das Ende des Blitters
	bne.s	WaitBlit1

	move.l	#$ffffffff,$44(a5)	; Maske
	move.l	#$09f00000,$40(a5)	; BLTCON0 und BLTCON1 (A+D)
								; normale Kopie
	move.w	#0,$64(a5)			; BLTAMOD (=0)
	move.w	#34,$66(a5)			; BLTDMOD (40-6=34)
	move.l	a0,$50(a5)			; BLTAPT Zeiger Quelle
	move.l	a1,$54(a5)			; BLTDPT Zeiger Ziel
	move.w	#(64*25)+3,$58(a5)	; BLTSIZE (Blitter starten !)
								; Breite 3 Word
	rts							; Hhe 25 Zeilen

;****************************************************************************
; Diese Routine kopiert die Figur auf dem Bildschirm, indem sie sie invertiert
; Das heit, aus 1 wird 0 und aus 0 wird 1.
;
; a0 - Quelladresse
; a1 - Zieladresse
;****************************************************************************

;	               _   _
;	            __/ \_/ \
;	           /  \_ oo_/
;	          /        \/_
;	     ____/_ ___ ____o
;	 ___/      \\  \\ UU

CopyInvers:
	btst	#6,2(a5)			; DMACONR
WaitBlit2:
	btst	#6,2(a5)			; DMACONR - warte auf das Ende des Blitters
	bne.s	WaitBlit2

	move.l	#$ffffffff,$44(a5)	; Maske
	move.l	#$090f0000,$40(a5)	; BLTCON0 und BLTCON1
								; kopieren Sie, indem Sie die Bits umkehren
								; D=NOT A
	move.w	#0,$64(a5)			; BLTAMOD (=0)
	move.w	#34,$66(a5)			; BLTDMOD (40-6=34)
	move.l	a0,$50(a5)			; BLTAPT Zeiger Quelle
	move.l	a1,$54(a5)			; BLTDPT Zeiger Ziel
	move.w	#(64*25)+3,$58(a5)	; BLTSIZE (Blitter starten !)
								; Breite 3 Word
	rts							; Hhe 25 Zeilen

;****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP
	dc.w	$92,$38				; DDFSTRT
	dc.w	$94,$d0				; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2
	dc.w	$108,0				; BPL1MOD
	dc.w	$10a,0				; BPL2MOD

	dc.w	$100,$2200			; BPLCON0 - 1 Bitplane lowres

Bplpointers:
	dc.w	$e0,$0000,$e2,$0000	; erste Bitplane
	dc.w	$e4,$0000,$e6,$0000

	dc.w	$0180,$000			; COLOR00
	dc.w	$0182,$aaa			; COLOR01
	dc.w	$0184,$55f			; COLOR02
	dc.w	$0186,$f80			; COLOR03

	dc.w	$ffff,$fffe			; Ende Copperlist

;****************************************************************************

FigurPlane1:
	dc.w	$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$c000,$0000,$0003,$c000
	dc.w	$0000,$0003,$c000,$0000,$0003,$c000,$0000,$0003,$c000,$0000
	dc.w	$0003,$c000,$0000,$0003,$c000,$0000,$0003,$c000,$0000,$0003
	dc.w	$c25c,$3bbb,$bb83,$c354,$22aa,$a283,$c2d4,$22bb,$b303,$c254
	dc.w	$22a2,$2283,$c25c,$3ba2,$3a83,$c000,$0000,$0003,$c000,$0000
	dc.w	$0003,$c000,$0000,$0003,$c000,$0000,$0003,$c000,$0000,$0003
	dc.w	$c000,$0000,$0003,$c000,$0000,$0003,$c000,$0000,$0003,$ffff
	dc.w	$ffff,$ffff,$ffff,$ffff,$ffff

FigurPlane2:
	dc.w	$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff
	dc.w	$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff
	dc.w	$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff
	dc.w	$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff
	dc.w	$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff
	dc.w	$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff
	dc.w	$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff
	dc.w	$ffff,$ffff,$ffff,$ffff,$ffff

;****************************************************************************

	SECTION	LEEREPLANE,BSS_C

Bitplane1:
	ds.b	40*256
Bitplane2:
	ds.b	40*256

	end

;****************************************************************************

In diesem Beispiel sehen wir eine Anwendung der logischen NOT-Operation.
Wir haben eine Zeichnung auf dem Bildschirm, das eine Schaltflche (Button)
darstellen knnte. Nehmen wir nun an, dass wir denselben Button zeichnen, aber
die Farbe invertieren wollen, um den Druck (Klick) zu simulieren. Eine Methode
besteht darin, die Farben in der Copperliste auszutauschen. Auf diese Weise
werden jedoch die Farben ber den gesamten Bildschirm vertauscht, so dass,
wenn wir 2 Schaltflchen gleichzeitig haben wollen, eine mit der normalen Farbe
und die andere mit der invertierten Farbe, diese Technik nicht funktionieren
wird.
Wir mssen also nur die Bitebene ndern, die das Bild bildet. Die Schaltflche
wird mit COLOR02 und COLOR03 gezeichnet. Um die Farben zu wechseln, mssen wir
COLOR02 in COLOR03 und umgekehrt umwandeln.
Ein Pixel mit COLOR02 tritt auf, wenn Ebene 1 auf 0 und Ebene 2 auf 1 gesetzt
ist und COLOR03 tritt auf, wenn die Ebene 1 auf 1 und die Ebene 2 auf 1 gesetzt
ist. Da bei beiden Farben die Ebene 2 auf 1 gesetzt ist, mssen wir nur die
Ebene 1 ndern. Wenn wir in der Ebene 1 sind, invertieren wir alle Bits (d.h.
wir invertieren alle 0 in 1 und alle 1 in 0). Dann werden wir COLOR02 und COLOR03
austauschen.
Die Umkehrung der Bits ist die logische NOT-Operation, die wir mit dem Blitter
durch einen geeigneten Minterm erreichen. Wenn wir Kanal A zum Lesen verwenden,
mssen wir den Ausgang D immer dann auf 1 setzen, wenn der Eingang 0 ist und
umgekehrt. Dies wird erreicht, indem alle Minterme, die den Kombinationen mit
A = 0 entsprechen, auf 1 gesetzt werden. Das wird (wie Sie aus der Tabelle in
der Lektion sehen knnen) mit LF = $0F erreicht.

		Ebene 2		Ebene 1
COLOR00	 0			0
COLOR01  0			1
COLOR02  1			0  
COLOR03  1			1                   