
; Listing9m2.s		Verschwinden eines Bildes, indem es nach links scrollt
; rechte Taste um den Blitt zu starten, links um zu beenden.

	SECTION	BLIT,CODE

;	include	"DaWorkBench.s"		; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup1.s"	; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	EQU	%1000001111000000	; Bitplane, Copper, Blitter DMA


Start:
	move.l	#Bitplane,d0		; Zeiger auf das Bild
	lea	Bplpointers,a1			; Bitplanepointer
	moveq	#3-1,d1				; Anzahl der Bitebenen (hier sind 3)
PointBp:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0				
								; HIER IST DER ERSTE UNTERSCHIED
								; ZU DEN NORMALEN BILDERN !!!!!!
	add.l	#40,d0				; + LNGE einer Zeile !!!!!
	addq.w	#8,a1
	dbra	d1,PointBp

	lea	$dff000,a5				; Custom Register Base in a5
	move.w	#DMASET,$96(a5)		; DMACON - einschalten Bitplane, Copper, Blitter
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse1:
	btst	#2,$dff016			; rechte Maustaste gedrckt?
	bne.s	Mouse1				; wenn nicht, gehe zurck zu Mouse1:

	bsr.s	Scroll				; Scroll-Routine ausfhren

Mouse2:
	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse2				; wenn nicht, gehe zurck zu Mouse2:

	rts


;****************************************************************************
; Diese Routine lscht ein Bild durch 
; verschieben nach links
;****************************************************************************

;	      ___________ ))
;	  (( /          \
;	    /   ___ ---   \
;	    \\____ ____/ /
;	    /   ( T. )  / ))
;	(( /     !  /
;	  /   _  (_ _) /
;	  \ (    `-'_/ ))
;	(( \        /
;	    \______/ xCz

Scroll:
	move.w	#160-1,d7	; Die Schleife muss fr jedes Pixel einmal ausgefhrt werden
						; das Bild ist 160 Pixel breit (10 Wrter)

; In diesem Beispiel kopieren wir ein Bild auf sich selbst, aber verschieben es
; dabei kontinuierlich um ein Pixel, um es flieen zu lassen.
; Daher sind die Quell- und Zieladressen identisch.
; Um nach links zu verschieben, benutzen wir den absteigenden Weg und daher
; zeigen wir auf das letzte Wort des Bildes:

	move.l	#Bitplane+((3*20*(50+20))+(64+160)/16-1)*2,d0	; Adresse Quelle und
															; Ziel

ScrollLoop:

; Warten, bis der Vblank das Bild um eine Pixelanzeige scrollt

WaitWblank:
	cmp.b	#$ff,$dff006		; warte auf die Zeile 255
	bne.s	WaitWblank
WarteY:
	cmp.b	#$ff,$dff006		; noch Zeile 255 ?
	beq.s	WarteY

	btst	#6,2(a5)			; warte auf das Ende des Blitters
WaitBlit:
	btst	#6,2(a5)
	bne.s	WaitBlit

	move.l	#$19f00002,$40(a5)	; BLTCON0 und BLTCON1 - Kopie von A nach D
								; absteigend und mit Shift
								; (nach links) um ein Pixel
	
	move.l	#$fffff7fff,$44(a5)	; BLTAFWM und BLTALWM
								; BLTAFWM = $ffff - alles passiert
								; BLTALWM = $7fff = %0111111111111111
								; lsche das linke Bit

								; Lade die Zeiger
	move.l	d0,$50(a5)			; BLTAPT - Quelle
	move.l	d0,$54(a5)			; BLTDPT - Ziel

; Die Modulo werden wie blich berechnet

	move.l #$00140014,$64(a5)	; BLTAMOD und BLTDMOD 
	move.w	#(3*20*64)+160/16,$58(a5)	; BLTSIZE
								; Hhe 20 Zeilen und 3 Ebenen
								; 160 Pixel breit (= 10 Wrter)

	dbra	d7,ScrollLoop		; Wiederholen fr jedes Pixel
						
	btst	#6,$02(a5)			; warte auf das Ende des Blitters
WaitBlit2:
	btst	#6,$02(a5)
	bne.s	WaitBlit2
	rts

;****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP
	dc.w	$92,$38				; DDFSTRT
	dc.w	$94,$d0				; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2

								; HIER IST DER ZWEITE UNTERSCHIED
								; ZU DEN NORMALEN BILDERN !!!!!!
	dc.w	$108,80				; WERT Modulo = 2*20*(3-1)= 80
	dc.w	$10a,80				; BEIDE MODULO MIT GLEICHEM WERT.

	dc.w	$100,$3200			; BPLCON0 - 3 Bitplanes lowres

Bplpointers:
	dc.w	$e0,$0000,$e2,$0000	; erste Bitplane
	dc.w	$e4,$0000,$e6,$0000
	dc.w	$e8,$0000,$ea,$0000

	dc.w	$0180,$000			; COLOR00
	dc.w	$0182,$475			; COLOR01
	dc.w	$0184,$fff			; COLOR02
	dc.w	$0186,$ccc			; COLOR03
	dc.w	$0188,$999			; COLOR04
	dc.w	$018a,$232			; COLOR05
	dc.w	$018c,$777			; COLOR06
	dc.w	$018e,$444			; COLOR07

	dc.w	$ffff,$fffe			; Ende Copperlist


Bitplane:
	incbin	"/Sources/amiga.rawblit"					
								; Hier laden wir die Figur ein
								; RAWBLIT-Format (oder interleaved),
								; mit KEFCON konvertiert.
	end

;****************************************************************************

In diesem Beispiel reproduzieren wir den Effekt, der in Listing9h4.s zu sehen
ist. Wir scrollen nach links. Um nach links zu verschieben, mssen wir den
Blitter absteigend benutzen. Jeder Blitt ist immer eine Kopie eines Bildes auf
sich selbst (gleiche Quell- und Zieladresse) aber die Verschiebung tritt nach
links auf. Wir mssen das Wort auf der linken Seite maskieren um die
Pixelspalte ganz links zu lschen. 
Absteigend wird das Wort auf der linken Seite von BLTALWM maskiert. Um die 
Spalte zu lschen (Pixel ganz links) mssen wir in den BLTALWM den Wert
%0111111111111111 eingeben. Das lscht das linke Bit und lsst die anderen
passieren. Beachten Sie den Unterschied zu Listing9h4.s, wo wir 
stattdessen das Bit rechts maskierten.
