
; Listing9h4.s		durch Scrollen nach rechts verschwindet ein Bild
; durch Shift + BLTALWM Maske.
; rechte Taste um den Blitt zu starten, links um zu beenden.

	SECTION	BLIT,CODE

;	include	"DaWorkBench.s"		; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup1.s"	; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	EQU	%1000001111000000	; Bitplane, Copper, Blitter DMA ; $83C0


Start:
	move.l	#Bitplane,d0		; Zeiger auf das Bild
	lea	Bplpointers,a1			; Bitplanepointer
	moveq	#3-1,d1				; Anzahl Bitplanes (hier sind es 3)
PointBp:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	add.l	#40*256,d0			; + Lnge einer Bitplane !!!!!
	addq.w	#8,a1
	dbra	d1,PointBp

	lea	$dff000,a5				; Custom Register Base in a5
	move.w	#DMASET,$96(a5)		; DMACON - einschalten Bitplane, Copper, Blitter
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse1:
	btst	#2,$dff016			; rechte Maustaste gedrckt?
	bne.s	Mouse1				; Wenn nicht, gehe zurck zu Mouse1:

	bsr.s	Scroll				; Scroll-Routine ausfhren

Mouse2:
	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse2				; Wenn nicht, gehe zurck zu Mouse2:

	rts


;******************************************************************************
; Diese Routine lsst ein Bild nach und nach verschwinden
; durch Verschieben nach rechts
;******************************************************************************

;	     .----------.
;	               
;	     |          |
;	     |          |
;	     |   --- |
;	    _l___    ___|_
;	   /   _\  / _  \
;	 _/   ( /--\ )   \_
;	/\_____/\_____/\
;	\ ____(_,____,_)____ /
;	 \_\ `----------' /_/
;	   \\___      ___//
;	    \__`------'__/
;	      |    | xCz
;	      `--------'

Scroll:
	move.w	#160-1,d7			; Die Schleife muss fr jedes Pixel einmal ausgefhrt 
								; werden, da das Bild 160 Pixel breit ist (10 Wrter)

; In diesem Beispiel kopieren wir ein Bild auf sich selbst, aber verschieben 
; es kontinuierlich um ein Pixel, um es flieen zu lassen.
; Daher sind die Quell- und Zieladressen identisch

ScrollLoop:

; Warten, bis das vblank das Bild um jeweils ein Pixel verschoben hat

WaitWblank:
	cmp.b	#$ff,$dff006		; VHPOSR - warte auf die Zeile 255
	bne.s	WaitWblank
WarteY:
	cmp.b	#$ff,$dff006		; VHPOSR - noch Zeile 255?
	beq.s	WarteY

	move.l	#Bitplane+((20*50)+64/16)*2,d0		; Adresse Quelle und Ziel
							
	moveq	#3-1,d5				; wiederhole es fr jede Ebene
PlaneLoop:
	btst	#6,2(a5)			; DMACONR - warte auf das Ende des Blitters
WaitBlit:
	btst	#6,2(a5)
	bne.s	WaitBlit

	move.l	#$19f00000,$40(a5)	; BLTCON0 und BLTCON1 - Kopie von A nach D
								; mit einer Ein-Pixel-Verschiebung

	move.l	#$ffffffffe,$44(a5)	; BLTAFWM und BLTALWM
								; BLTAFWM = $ffff - alles
								; BLTALWM = $fffe = %1111111111111110
								; lsche das letzte Bit

								; Lade die Zeiger
	move.l	d0,$50(a5)			; BLTAPT - Quelle
	move.l	d0,$54(a5)			; BLTDPT - Ziel

; Die Werte werden wie blich berechnet

	move.l	#$00140014,$64(a5)		; BLTAMOD und BLTDMOD 
	move.w	#(20*64)+160/16,$58(a5)	; BLTSIZE
								; Hhe 20 Zeilen
								; 160 Pixel breit (= 10 Wrter)

	add.l	#40*256,d0			; auf die nchste Ebene zeigen
	dbra	d5,PlaneLoop

	dbra	d7,ScrollLoop		; fr alle Pixel wiederholen
						
	btst	#6,$02(a5)			; DMACONR - warte auf das Ende des Blitters
WaitBlit2:
	btst	#6,$02(a5)
	bne.s	WaitBlit2
	rts

;****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP
	dc.w	$92,$38				; DDFSTRT
	dc.w	$94,$d0				; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2
	dc.w	$108,0				; WERT Modulo = 0
	dc.w	$10a,0				; BEIDE MODULO MIT GLEICHEM WERT.

	dc.w	$100,$3200			; BPLCON0 - 3 Bitplanes lowres

Bplpointers:
	dc.w	$e0,$0000,$e2,$0000	; erste Bitplane
	dc.w	$e4,$0000,$e6,$0000
	dc.w	$e8,$0000,$ea,$0000

	dc.w	$0180,$000			; COLOR00
	dc.w	$0182,$475			; COLOR01
	dc.w	$0184,$fff			; COLOR02
	dc.w	$0186,$ccc			; COLOR03
	dc.w	$0188,$999			; COLOR04
	dc.w	$018a,$232			; COLOR05
	dc.w	$018c,$777			; COLOR06
	dc.w	$018e,$444			; COLOR07

	dc.w	$ffff,$fffe			; Ende Copperlist

;****************************************************************************

Bitplane:
	incbin	"/Sources/amiga.raw"					
								; Hier laden wir die Figur ein					
								; mit KEFCON konvertiert.
	end

;****************************************************************************


In diesem Beispiel sehen wir einen neuen Effekt. Wir werden ein Bild vom 
Bildschirm verschwinden lassen, indem wir es nach rechts schieben und die
Pixel lschen, die in einer bestimmten horizontalen Position ankommen. Dieser
Effekt wird mit Hilfe des Blitters durch Kombination von Verschieben nach
rechts und Maskieren zusammen erreicht. 
Es wird natrlich durch die Verschiebung erreicht. Das Bild wird vom
Bildschirm ber Kanal A (es ist nicht in einem anderen Puffer gespeichert) 
gelesen. Es wird um ein Pixel verschoben und an der gleichen Stelle auf dem 
Bildschirm neu gezeichnet.
Die Quelle und das Ziel stimmen genau berein. Die Maske des ersten Wortes
bergibt alle Bits. Die Maske des letzten Wortes stattdessen hat den Wert
%11111111.11111110 und lscht damit das rechte Bit.
Wenn wir diesen Trick nicht benutzen, kommen die Pixel aus dem Wort rechts
heraus und wrden eine Zeile tiefer im linken Wort enthalten sein. (Wir haben
darber whrend der Erklrung zum Shiften gesprochen). Weil wir einen 
verschachtelten Bildschirm benutzen, die untere Zeile gehrt zu einer anderen
Ebene und wenn Pixel von einer Ebene zur nchsten verschoben werden, entsteht
Chaos. Versuchen Sie dies zu realisieren, indem Sie BLTALWM auf $ffff setzen.
Dank der Maske passiert das nicht, weil die Maske auf das letzte gelesene Wort
angewendet wird, bevor die Verschiebung erfolgt.
Dann wird das Bit, das rechts ausgehen wrde, von der Maske zurckgesetzt.
Ein verschwommener Effekt der auf diese Weise bewirkt, dass die Figur nach
rechts mit einem Pixel scrollt.
Wiederhole den Blitt so oft wie die Anzahl der Pixel, aus denen er besteht.
Da das Bild in der Breite (in unserem Fall 160 ist) erhalten wir ein
vollstndiges Verschwinden.
Es ist mglich, das Bild schneller mit einem Shift-Wert grer als 1 zu
scrollen. In diesem Fall mssen Sie jedoch auch die Maske ndern, so dass alle
Pixel gelscht werden, die die Verschiebung hinterlassen wrde.
Wenn Sie beispielsweise eine 4-Pixel-Verschiebung verwenden, muss die Maske
die 4 Pixel rechts lschen, denn sonst wrden sie herauskommen. Da das Bild
schneller scrollt, ist es auerdem notwendig, die Routine einige Male zu
wiederholen um es vollstndig verschwinden zu lassen.
Im Falle einer 4-Pixel-Verschiebung werden 160/4 = 40 Iterationen der Routine
bentigt.
Versuchen Sie, die Geschwindigkeit zu ndern, und probieren sie andere
Verschiebewerte aus, zum Beispiel 2,8 oder 3.
