
; Listing9h3r.s		Wir lassen ein Bild erscheinen
; immer eine Pixelspalte gleichzeitig 
; rechte Taste um den Blitt zu starten, links um zu beenden.	
; Hinweis: Bild in RAWBLIT (oder interleaved, wenn Sie es bevorzugen).

	SECTION	BLIT,CODE

;	include	"DaWorkBench.s"		; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup1.s"	; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	EQU	%1000001111000000	; Bitplane, Copper, Blitter DMA ; $83C0


Start:
	move.l	#Bitplane,d0		; Zeiger auf das Bild
	lea	Bplpointers,a1			; Bitplanepointer
	moveq	#3-1,d1				; Anzahl Bitplanes (hier sind es 3)
PointBp:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0				
								; HIER IST DER ERSTE UNTERSCHIED
								; ZU DEN NORMALEN BILDERN !!!!!!
	add.l	#40,d0				; + Lnge einer Zeile !!!!!
	addq.w	#8,a1
	dbra	d1,PointBp

	lea	$dff000,a5				; Custom Register Base in a5
	move.w	#DMASET,$96(a5)		; DMACON - einschalten Bitplane, Copper, Blitter
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse1:
	btst	#2,$dff016			; rechte Maustaste gedrckt?
	bne.s	Mouse1				; Wenn nicht, gehe zurck zu Mouse1:

	bsr.s	Show				; Routine ausfhren

Mouse2:
	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse2				; Wenn nicht, gehe zurck zu Mouse2:

	rts


; ************************ DIE ROUTINE, DIE DIE FIGUR ZEIGT *******************

;	     ..
;	     |_ _|
;	    _|___ ___|_
;	   (_| (T.) l_)
;	    /  (_)  \
;	   /____ _ ____\
;	  //    Y Y    \\
;	 //__/\_____/\__\\ xCz
;	(_________________)

Show:

; Anfangswerte von Zeigern

	lea	Picture,a0				; zeigt auf den Anfang der Figur
	lea	Bitplane,a1				; zeigt auf den Anfang der ersten Bitebene

	moveq	#20-1,d7			; alle Wort- "Spalten" ausfhren
								; Der Bildschirm ist 20 Wrter breit
								; Es gibt 20 Spalten.

MakeAllWords:
	moveq	#16-1,d6			; 16 Pixel fr jedes Wort.
	move.w	#%1000000000000000,d0	; Wert der Maske am Anfang der
								; internen Schleife. Wir bergeben nur das
								; Pixel ganz links vom Wort.
DoOneWord:

; warte auf Vblank, um jeweils eine Pixelspalte pro Frame zu zeichnen

WaitWblank:
	cmp.b	#$ff,$dff006		; VHPOSR - warte auf die Zeile 255
	bne.s	WaitWblank
WarteY:
	cmp.b	#$ff,$dff006		; VHPOSR - noch Zeile 255 ?
	beq.s	WarteY

	btst	#6,2(a5)			; DMACONR - warte auf das Ende des Blitters
WaitBlit:
	btst	#6,2(a5)
	bne.s	WaitBlit

	move.l	#$09f00000,$40(a5)	; BLTCON0 und BLTCON1 - Kopie von A nach D
	move.w	#$ffff,$44(a5)		; BLTAFWM - alle Bits bergeben
	move.w	d0,$46(a5)			; Wert der Maske in das BLTALWM Register laden

								; Lade die Zeiger
	move.l	a0,$50(a5)			; BLTAPT
	move.l	a1,$54(a5)			; BLTDPT

; Sowohl fr die Quelle als auch fr das Ziel blitten wir ein Wort auf einen 
; 20 Wrter breiten Bildschirm. Also hat das Modulo den Wert 2 * (20-1) = 38 = $26.
; Da die 2 Register aufeinanderfolgende Adressen haben, braucht man nur eine
; Anweisung anstatt 2 zu verwenden:

	move.l #$00260026,$64(a5)	; BLTAMOD und BLTDMOD 

; wir blitten ein 256 Zeilen hohes Wort "Spalte" (den ganzen Bildschirm)

	move.w	#(3*256*64)+1,$58(a5)	; BLTSIZE
								; Hhe 256 Zeilen von 3 Ebenen
								; Breite 1 Word
						
	asr.w	#1,d0				; die Maske fr den nchsten Blitt vorbereiten

	dbra	d6,DoOneWord		; fr alle Pixel wiederholen
	
	addq.w	#2,a0				; auf das nchste Wort zeigen
	addq.w	#2,a1				; auf das nchste Wort zeigen

	dbra	d7,MakeAllWords		; fr alle Wrter wiederholen 

	btst	#6,$02(a5)			; DMACONR - warte auf das Ende des Blitters
WaitBlit2:
	btst	#6,$02(a5)
	bne.s	WaitBlit2

	rts

;****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP
	dc.w	$92,$38				; DDFSTRT
	dc.w	$94,$d0				; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2

								; HIER IST DER ZWEITE UNTERSCHIED
								; ZU DEN NORMALEN BILDERN !!!!!!
	dc.w	$108,80				; WERT Modulo = 2*20*(3-1)= 80
	dc.w	$10a,80				; BEIDE MODULO MIT GLEICHEM WERT.

	dc.w	$100,$3200			; BPLCON0 - 3 Bitplanes lowres

Bplpointers:
	dc.w	$e0,$0000,$e2,$0000	; erste Bitplane
	dc.w	$e4,$0000,$e6,$0000
	dc.w	$e8,$0000,$ea,$0000

	dc.w	$0180,$000			; COLOR00
	dc.w	$0182,$475			; COLOR01
	dc.w	$0184,$fff			; COLOR02
	dc.w	$0186,$ccc			; COLOR03
	dc.w	$0188,$999			; COLOR04
	dc.w	$018a,$232			; COLOR05
	dc.w	$018c,$777			; COLOR06
	dc.w	$018e,$444			; COLOR07

	dc.w	$ffff,$fffe			; Ende Copperlist

;****************************************************************************

Picture:
	incbin	"/Sources/amiga.rawblit"			
								; Hier laden wir die Figur ein
								; RAWBLIT-Format (oder interleaved),
								; mit KEFCON konvertiert.

;****************************************************************************

	SECTION	LEEREPLANE,BSS_C

Bitplane:
		ds.b	40*256			; 3 Bitplanes
		ds.b	40*256
		ds.b	40*256
	end

;****************************************************************************

Dieses Beispiel ist die RawBlit-version von Listing9h3.s. Vergleichen Sie 
die Unterschiede in den Formeln zur Berechnung der zu schreibenden Werte
in die Blitter-Register.
