
; Listing9h2.s		Blitt, in dem wir ein Rechteck (in einem normalen Bild)
; mit Masken kopieren. 
; Drcken der rechten Taste fhrt den "kompletten" Blitt aus.
; Durch Drcken der linken Taste wird der Blitt mit ausgewhlten  
; Maskenbits ausgefhrt und schlielich rechte Taste fr Ende.

	SECTION	BLIT,CODE

;	include	"DaWorkBench.s"		; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup1.s"	; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	EQU	%1000001111000000	; Bitplane, Copper, Blitter DMA ; $83C0


Start:
	move.l	#Bitplane,d0		; Zeiger auf das Bild
	lea	Bplpointers,a1			; Bitplanepointer
	moveq	#3-1,d1				; Anzahl Bitplanes (hier sind es 3)
PointBp:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	add.l	#40*256,d0			; + Gre einer Bitplane !!!!!
	addq.w	#8,a1
	dbra	d1,PointBp

	lea	$dff000,a5				; Custom Register Base in a5
	move.w	#DMASET,$96(a5)		; DMACON - einschalten Bitplane, Copper, Blitter
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse1:
	btst	#2,$dff016			; rechte Maustaste gedrckt?
	bne.s	Mouse1				; Wenn nicht, gehe zurck zu Mouse1:

; Erster Blitt, mit den Masken, die alle Daten passieren lsst

	lea	Bitplane+((20*170)+80/16)*2,a0		; Adresse Ziel
	move.w	#$ffff,d0			; alles
	move.w	#$ffff,d1			; alles
	bsr.s	Kopie

Mouse2:
	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse2				; Wenn nicht, gehe zurck zu Mouse2:

; Zweiter Blitt, dank der Masken wird nur der Buchstabe "I" kopiert

	lea	Bitplane+((20*170)+160/16)*2,a0		; Adresse Ziel
	move.w	#%0000000000001111,d0	; nur die 4 Bits ganz rechts bergeben
	move.w	#%1111000000000000,d1	; nur die 4 Bits ganz links bergeben
	bsr.s	Kopie

Mouse3:
	btst	#2,$dff016			; rechte Maustaste gedrckt?
	bne.s	Mouse3				; Wenn nicht, gehe zurck zu Mouse3:

	rts

;****************************************************************************
; Diese Routine kopiert die Figur auf dem Bildschirm.
;
; a0 - Zieladresse
; d0.w - erste Wortmaske
; d1.w - letzte Wortmaske
;****************************************************************************

;	  ___________   
;	 (_____ _____)  
;	 /(_o(___)O_)\  
;	/ ___________ \
;	\ \____l____/ /|
;	|\_`---'---'_/ |
;	| `---------'  |
;	|  T  xCz   T  |
;	l__|        l__|
;	(__)---^----(__)
;	  T    T     |  
;	 _l____l_____|_ 
;	(______X_______)

Kopie:

	lea	Bitplane+((20*78)+128/16)*2,a1	; feste Quelladresse

	moveq	#3-1,d7				; wiederhole es fr jede Ebene
PlaneLoop:
	btst	#6,2(a5)			; warte auf das Ende des Blitters
WaitBlit:
	btst	#6,2(a5)
	bne.s	WaitBlit

	move.l	#$09f00000,$40(a5)	; BLTCON0 und BLTCON1 - Kopie von A nach D

								; ldt die Parameter in die Register
	move.w	d0,$44(a5)			; BLTAFWM Maske auf der linken Seite
	move.w	d1,$46(a5)			; BLTALWM Maske auf der rechten Seite
	
; Lade die Zeiger

	move.l	a1,$50(a5)			; BLTAPT - Quelle 
	move.l	a0,$54(a5)			; BLTDPT - Ziel

	move.l #$00240024,$64(a5)	; BLTAMOD und BLTDMOD 

	move.w	#(60*64)+2,$58(a5)	; BLTSIZE
								; Hhe 60 Zeilen
								; Breite 2 Wrter

	lea	40*256(a1),a1			; zeigt auf die nchste Quellebene
	lea	40*256(a0),a0			; zeigt auf die nchste Zielebene

	dbra	d7,PlaneLoop

	btst	#6,$02(a5)			; warte auf das Ende des Blitters
WaitBlit2:
	btst	#6,$02(a5)
	bne.s	WaitBlit2
	rts

;****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP
	dc.w	$92,$38				; DDFSTRT
	dc.w	$94,$d0				; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2

								; normale Bilder!!!!!!
	dc.w	$108,0				; Wert Modulo = 0
	dc.w	$10a,0				; BEIDE MODULO MIT GLEICHEM WERT.

	dc.w	$100,$3200			; BPLCON0 - 3 Bitplanes lowres

Bplpointers:
	dc.w	$e0,$0000,$e2,$0000	; erste Bitplane
	dc.w	$e4,$0000,$e6,$0000
	dc.w	$e8,$0000,$ea,$0000

	dc.w	$0180,$000			; COLOR00
	dc.w	$0182,$475			; COLOR01
	dc.w	$0184,$fff			; COLOR02
	dc.w	$0186,$ccc			; COLOR03
	dc.w	$0188,$999			; COLOR04
	dc.w	$018a,$232			; COLOR05
	dc.w	$018c,$777			; COLOR06
	dc.w	$018e,$444			; COLOR07

	dc.w	$ffff,$fffe			; Ende Copperlist

;****************************************************************************

Bitplane:
	incbin	"/Sources/amiga.raw"	
								; Hier laden wir die Figur ein
								; RAW-Format konvertiert mit KEFCON.
	end

;****************************************************************************

In diesem Beispiel zeigen wir, wie die Masken verwendet werden.
Es ist mglich, "Teile" von Bildern durch Lschen von Teilen die Sie nicht
mchten zu extrahieren. In diesem Fall wollen wir nur den Buchstaben "I" des
geschriebenen Amiga. Dieser Buchstabe ist in einem 2 Wrter breiten Rechteck
enthalten. Im Rechteck befinden sich jedoch auch Teile anderer Buchstaben. Die
erste Maske wird mit dem Wert $ffff ausgefhrt, sodass alle Pixel bergeben
werden. Wie Sie sehen knnen, werden die Teile der anderen Buchstaben ebenfalls
kopiert. Beim zweiten Blitt werden stattdessen die Masken auf geeignete Werte
gesetzt, so dass nur die Pixel passieren, die den Buchstaben "I" bilden.