
; Listing9g2.s		Blitt, in dem wir ein Rechteck von einem Punkt zu einem 
; anderen Punkt desselben Bildschirms im INTERLEAVED-Format kopieren
; Linke Taste um den Blitt auszufhren, rechts um zu beenden.

	SECTION	BLIT,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup1.s"	; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	EQU	%1000001111000000	; Bitplane, Copper, Blitter DMA ; $83C0


Start:
	move.l	#Bitplane,d0		; Zeiger auf das Bild
	lea	Bplpointers,a1			; Bitplanepointer
	moveq	#3-1,d1				; Anzahl der Bitebenen (hier sind 3)
PointBp:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0					; HIER IST DER ERSTE UNTERSCHIED ZU
								; DEN NORMALEN BILDERN !!!!!!
	add.l	#40,d0				; + LNGE einer ZEILE !!!!!
	addq.w	#8,a1
	dbra	d1,PointBp

	lea	$dff000,a5				; Custom Register Base in a5
	move.w	#DMASET,$96(a5)		; DMACON - einschalten Bitplane, Copper, Blitter
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse1:
	btst	#2,$dff016			; rechte Maustaste gedrckt?
	bne.s	Mouse1				; Wenn nicht, warte

	bsr.s	Kopie				; Kopierroutine ausfhren

Mouse2:
	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse2				; Wenn nicht, gehe zurck zu Mouse2:

	rts


; ************************ KOPIERROUTINE ****************************

; Ein Rechteck mit der Breite = 160 und der Hhe = 20 wird kopiert
; von den Koordinaten X1 = 64, Y1 = 50 (Quelle)
; zu den Koordinaten X2 = 80, Y2 = 190 (Ziel)

;	           _
;	          /\
;	         /   \
;	    __  /__ __\  __
;	 .--\/-/ `u' \-\/--.
;	 |    /  T   \    |
;	 |   /   `       \   |
;	 |  /_____________\  |
;	 |    _         _    |
;	 |    |         |    |
;	 l____|         l____|
;	 (____)----^----(____)
;	    T      T      T   xCz
;	 ___l______|______|___
;	`----------^----------'

Kopie:

; wir laden die Quell- und Zieladressen in 2 Register
; ANMERKUNG DER UNTERSCHIED IM HINBLICK AUF DEN NORMALEN FALL: 
; IST BEI DER BERECHNUNG DES OFFSETS
; DIE Y-ZEILE WIRD MULTIPLIZIERT MIT DER ANZAHL DER BITEBENEN (d.h. 3)
; Die Formel lautet 
; OFFSET = (Y * (Anzahl der Wrter pro Zeile) * (Anzahl der Ebenen)) * 2

	move.l	#Bitplane+((3*20*50)+64/16)*2,d0	; Adresse Quelle
												; Bemerke den * 3-Faktor!
	move.l	#Bitplane+((3*20*190)+80/16)*2,d2	; Adresse Ziel
												; Bemerke den * 3-Faktor!

	btst	#6,2(a5)			; warte auf das Ende des Blitters
WaitBlit:
	btst	#6,2(a5)
	bne.s	WaitBlit

	move.l	#$09f00000,$40(a5)	; BLTCON0 und BLTCON1 - Kopie A nach D
	move.l	#$ffffffff,$44(a5)	; BLTAFWM und BLTALWM wir erklren es spter

; Lade die Zeiger
	move.l	d0,$50(a5)			; BLTAPT
	move.l	d2,$54(a5)			; BLTDPT

; Diese 2 Anweisungen legen die Quell- und Zielmodulo fest
; ES GIBT KEINE UNTERSCHIEDE ZUM NORMALEN FALL:
; der Wert berechnet sich nach der Formel (H-L) * 2 (H ist die Breite der
; Bitebene in Worten und L ist die Breite des Bildes, immer in Worten)
; das haben wir in der Lektion gesehen, (20-160/16) * 2 = 20

	move.w	#(20-160/16)*2,$64(a5)	; BLTAMOD
	move.w	#(20-160/16)*2,$66(a5)	; BLTDMOD

; Beachten Sie auch, weil die 2 Register aufeinanderfolgende Adressen haben, 
; knnen wir eine einzige Anweisung anstelle von 2 verwenden 
; (denken Sie daran, 20 = $14):
; move.l #$00140014,$64(a5)		; BLTAMOD und BLTDMOD

; ANMERKUNG: DER UNTERSCHIED IM HINBLICK AUF DEN NORMALEN FALL: 
; LIEGT IN DER DIMENSION DES BLITTS
; ES IST DIE HHE DES BILDES - DIE ZAHL VERVIELFACHT SICH
; MIT DER ANZAHL DER BITEBENEN

	move.w	#(3*20*64)+160/16,$58(a5)	; BLTSIZE						
								; Hhe 20 Zeilen und 3 Ebenen
								; 160 Pixel breit (= 10 Wrter)
						
	btst	#6,$02(a5)			; warte auf das Ende des Blitters
WaitBlit2:
	btst	#6,$02(a5)
	bne.s	WaitBlit2
	rts

;****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP
	dc.w	$92,$38				; DDFSTRT
	dc.w	$94,$d0				; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2
					
								; HIER IST DER ZWEITE UNTERSCHIED 
								; ZU DEN NORMALEN BILDERN !!!!!!
	dc.w	$108,80				; Wert Modulo = 2*20*(3-1)= 80
	dc.w	$10a,80				; BEIDE MODULO MIT GLEICHEM WERT.

	dc.w	$100,$3200			; BPLCON0 - 3 Bitplanes lowres

Bplpointers:
	dc.w	$e0,$0000,$e2,$0000	; erste Bitplane
	dc.w	$e4,$0000,$e6,$0000
	dc.w	$e8,$0000,$ea,$0000

	dc.w	$0180,$000			; COLOR00
	dc.w	$0182,$475			; COLOR01
	dc.w	$0184,$fff			; COLOR02
	dc.w	$0186,$ccc			; COLOR03
	dc.w	$0188,$999			; COLOR04
	dc.w	$018a,$232			; COLOR05
	dc.w	$018c,$777			; COLOR06
	dc.w	$018e,$444			; COLOR07

	dc.w	$ffff,$fffe			; Ende Copperlist

;****************************************************************************

Bitplane:
	incbin	"/Sources/amiga.rawblit"
								; Hier laden wir die Figur ein
								; RAWBLIT-Format (oder interleaved),
								; mit KEFCON konvertiert.
	end

;****************************************************************************

In diesem Beispiel zeigen wir ein Bild im Interleaved-Format an und kopieren
ein Bild von einem Punkt des Bildschirms zu einem anderen Punkt auf dem
Bildschirm. Dies ist das gleiche Programm wie Beispiel Listing9f1.s, aber im
interleaved Format. Ich empfehle Ihnen, dieses Beispiel zu untersuchen, indem
Sie es mit Listing9f1.s vergleichen.
Wie wir in der Lektion gesehen haben, erlaubt uns das Interleaved-Format
die Kopie mit nur einem Blitt zu machen. Deshalb arbeitet die Routine 
"Kopieren" (das ist die Routine, die die Kopie macht) im Gegensatz zur
gleichnamigen Routine in Listing9f1.s ohne Schleifen.
Einige Werte, die in die Blitter-Register geladen werden, sind unterschiedlich:

1) In der Adressberechnung, um den Offset zwischen dem ersten Wort der Zeile Y
   und dem Anfang der Bitebene zu erhalten, mssen wir Y mit der Anzahl der
   Bitebenen multiplizieren, sowie der Anzahl der Wrter pro Zeile.   
   Bezglich X, gibt es jedoch keine Unterschiede.
   ; OFFSET = (Y * (Anzahl der Wrter pro Zeile) * (Anzahl der Ebenen)) * 2

2) Die Hhe des Blitts ist gleich der Hhe des Bildes multipliziert mit der
   Anzahl der Bitebenen. Fr die Breite gibt es jedoch keine Unterschiede.

Auch in Bezug auf die anderen Register, auch fr das Modulo, gibt es keine
Unterschiede.