
; Listing9e1.s		* SHIFTING * mit dem Blitter.

	SECTION	BLIT,CODE

;	include	"DaWorkBench.s"		; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup1.s"		; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	EQU	%1000001111000000	; Bitplane, Copper, Blitter DMA ; $83C0


Start:
	move.l	#Bitplane,d0		; Zeiger auf die "leere" Bitplane
	lea	Bplpointers,a1			; Bitplanepointer
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

	lea	$dff000,a5				; Custom Register Base in a5
	move.w	#DMASET,$96(a5)		; DMACON - einschalten Bitplane, Copper, Blitter
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

	moveq	#0,d4				; horizontale Koordinate startet mit 0
Loop:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$10800,d2			; Warte auf Zeile $108
WarteY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; Whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; Warte auf Zeile $108
	bne.s	WarteY1
WarteY2:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; Whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; Warte auf Zeile $108
	beq.s	WarteY2

;	  ...........
;	. ...  ...  :
;	|. _  _ .|
;	l_ _  _  |
;	 | (),.()  T
;	 | _________ |
;	 |  \_l_l_/  |
;	 l___`---'___|xCz
;	    `------'

	move.w	d4,d5				; aktuelle horizontale Koordinate in d5

	and.w	#$000f,d5			; wir whlen die ersten 4 Bits aus, weil sie
								; in den Shifter von Kanal A eingefgt werden
	lsl.w	#8,d5				; die 4 Bits werden zum High-Nibble bewegt
	lsl.w	#4,d5				; des Wortes ... (8 + 4 = 12-Bit-Verschiebung!)
	or.w	#$09f0,d5			; ... nur um in das BLTCON0-Register zu kommen
								; Hier setzen wir $f0 in den Minterm fr die Kopie von
								; Quelle A nach Ziel D und aktivieren
								; natrlich die A + D Kanle mit $0900 (Bit 8
								; fr D und Bit 11 fr A). Das ist $09f0 + Verschiebung.

	addq.w	#1,d4				; addiere 1 zur horizontalen Koordinate
								; gehe beim nchsten Mal 1 Pixel nach rechts

	btst	#6,2(a5)			; DMACONR
WaitBlit1:
	btst	#6,2(a5)			; DMACONR - warte auf das Ende des Blitters
	bne.s	WaitBlit1

	move.w	#$ffff,$44(a5)		; BLTAFWM wir erklren es spter
	move.w	#$ffff,$46(a5)		; BLTALWM wir erklren es spter
	move.w	d5,$40(a5)			; BLTCON0 (A+D) - im Register
								; setzen wir die Shiftbits! (Bits 12,13
								; 14 und 15, d.h. High Nibble!)
	move.w	#$0000,$42(a5)		; BLTCON1 wir erklren es spter
	move.w	#0,$64(a5)			; BLTAMOD (=0)
	move.w	#38,$66(a5)			; BLTDMOD (40-2=38)
	move.l	#Figur,$50(a5)		; BLTAPT  (an der Quellfigur fixiert)
	move.l	#Bitplane,$54(a5)	; BLTDPT  (Bildschirm)
	move.w	#(64*6)+1,$58(a5)	; BLTSIZE (Blitter starten !)					
								; Die Figur ist 1 Wort breit und 6 Zeilen hoch
							
	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	loop

	btst	#6,2(a5)			; DMACONR
WaitBlit2:
	btst	#6,2(a5)			; DMACONR - warte auf das Ende des Blitters
	bne.s	WaitBlit2

	rts

;****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP
	dc.w	$92,$38				; DDFSTRT
	dc.w	$94,$d0				; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2
	dc.w	$108,0				; BPL1MOD
	dc.w	$10a,0				; BPL2MOD

	dc.w	$100,$1200

Bplpointers:
	dc.w	$e0,$0000,$e2,$0000	; erste Bitplane

	dc.w	$0180,$000			; COLOR00
	dc.w	$0182,$eee			; COLOR01

	dc.w	$ffff,$fffe			; Ende Copperlist

;****************************************************************************

; Hier ist der Fisch ... 16 Pixel breit (1 Word) und 6 Zeilen hoch.

Figur:
	dc.w	%1000001111100000
	dc.w	%1100111111111000
	dc.w	%1111111111101100
	dc.w	%1111111111111110
	dc.w	%1100111111111000
	dc.w	%1000001111100000

;****************************************************************************

	SECTION	LEEREPLANE,BSS_C	

Bitplane:
	ds.b	40*256			; Bitplane lowres

	end

;****************************************************************************

In diesem Beispiel knnen Sie sehen, wie die Verschiebung funktioniert. Wir 
haben eine 1 Word breite und 6 Zeilen hohe Figur. Diese Figur wird immer an 
der gleichen Zieladresse geshiftet, d.h. die gleiche Adresse wird immer in 
BLTDPT ($dff054) gesetzt. Jedes Mal wird jedoch der Verschiebungswert im 
BLTCON0 um 1 erhht. Auf diese Weise bewegt sich die Figur jeweils um 
1 Pixel nach rechts.
Beachten Sie auch das in der Lektion beschriebene Phnomen: die Bits, die aus
dem Wort verschoben werden sind im nchsten Wort dann links. In unserem Fall
ist das nicht gut, weil die Nase des Fisches nach rechts herauskommt und dann
links, hinter den Schwanz fllt.
Im nchsten Beispiel werden wir sehen, wie wir das Problem lsen knnen.
