
; Listing9a1.s		Lschen von $10 Wrter mit dem Blitter
; Bevor Sie dieses Beispiel sich ansehen, schauen Sie sich Listing2f.s an, wo es herkommt
; gelschter Speicher mit dem 68000

	SECTION BLIT,CODE

Start:
	move.l	4.w,a6				; Execbase in a6
	jsr	-$78(a6)				; Disable - verhindert Interrupts
	lea	GfxName,a1				; Adresse des Namens der zu ffnenden Bibliothek in a1
	jsr	-$198(a6)				; OldOpenLibrary
	move.l	d0,a6				; benutze eine Routine von graphics library:

	jsr	-$1c8(a6)				; OwnBlitter, 
								; das gibt uns den exklusiven Zugang auf den Blitter
								; verhindert, das er vom Betriebssystem verwendet wird.
								; Wir mssen warten, bevor wir den Blitter benutzen
								; das es einen laufenden Blittervorgang beendet hat.
								; Die folgenden Anweisungen erledigen das

	btst	#6,$dff002			; warte auf das Ende des Blitters (leerer Test)
								; fr den BUG von Agnus
WaitBlit:
	btst	#6,$dff002			; freier Blitter?
	bne.s	WaitBlit

; Hier ist, wie man einen Blitt macht !!! 
; Nur 5 Anweisungen zum Zurcksetzen !!!
;	     __
;	__  /_/\   __
;	\/  \_\/  /\_\
;	 __   __  \/_/   __
;	/\_\ /\_\  __   /\_\
;	\/_/ \/_/ /_/\  \/_/
;	     __   \_\/
;	    /\_\  __
;	    \/_/  \/

	move.w	#$0100,$dff040		; BLTCON0: nur Ziel D ist aktiviert				
								; die MINTERMS (dh die Bits 0-7) sind alle
								; zurckgesetzt. Auf diese Weise ist die 
								; Lschoperation definiert					

	move.w	#$0000,$dff042		; BLTCON1: Wir werden dieses Register spter erklren
	move.l	#Start,$dff054		; BLTDPT: Adresse des Zielkanals
	move.w	#$0000,$dff066		; BLTDMOD: Wir werden dieses Register spter erklren
	move.w	#(1*64)+$10,$dff058 ; BLTSIZE: definiert die Dimension des
								; Rechtecks. In diesem Fall haben wir
								; $10 Wrter Breite und eine Hhe von 1 Zeile.
								; Weil die Gre des Rechtecks in die Bits 6-15 von 
								; BLTSIZE geschrieben wird
								; mssen wir es 6 Bits nach links verschieben.
								; Dies entspricht der Multiplikation seines Wertes
								; mit 64. Die Breite wird in die niedrigen
								; 6 Bits geschrieben und werden daher nicht
								; gendert.
								; Auerdem startet diese Anweisung den Blitt					 

	btst	#6,$dff002			; warte auf das Ende des Blitters (leerer Test)
WaitBlit2:
	btst	#6,$dff002			; freier Blitter?
	bne.s	WaitBlit2

	jsr	-$1ce(a6)				; DisOwnBlitter, das Betriebssystem
								; kann den Blitter jetzt wieder benutzen
	move.l	a6,a1				; Basis der Grafikbibliothek zum Schlieen
	move.l	4.w,a6
	jsr	-$19e(a6)				; CloseLibrary - schliee die Grafikbibliothek
	jsr	-$7e(a6)				; Enable - erlaubt Interrupts
	rts

******************************************************************************

	SECTION THE_DATA,DATA_C

; Beachten Sie, dass die gelschten Daten im CHIP-Speicher liegen mssen
; Tatschlich funktioniert der Blitter nur im CHIP-Speicher

Quelle:
	dcb.b	$20,$fe
TheEnd:
	dc.b	'Hier loeschen wir nicht'

	even

GfxName:
	dc.b	"graphics.library",0,0

	end

Dieses Beispiel ist die Blitter-Version von Listing2f.s, in der die Bytes durch
eine Schleife von "clr.l (a0)+" zurckgesetzt werden.

In diesem Fall, assemblieren sie, ohne zu starten, und berprfen erst mit
einem "M QUELLE" das unter dem Label $20 Bytes "$fe" vorhanden sind. An diesem
Punkt fhren wir das Listing aus und aktivieren zum ersten Mal im Kurs den
Blitter. Danach wiederholen Sie "M QUELLE" und Sie werden besttigen, dass 
diese Bytes bis zum Label TheEnd gelscht wurden. In der Tat mit einem 
"M THEEND" finden Sie immer seinen Platz. Die Lschoperation erfordert nur die
Verwendung des Kanals D. Auerdem mssen alle MINTERMS zurckgesetzt werden. 
Daher ist der Wert, der im BLTCON0-Register geladen werden muss $0100.

Beachten Sie den Wert, der in dem BLTSIZE-Register geschrieben wird. Wir wollen
ein Rechteck, das $10 Wrter breit und eine Zeile hoch ist lschen. Wir mssen
die Breite immer in die Bits 0-5 von BLTSIZE und die Hhe in die Bits 6-15 von
BLTSIZE schreiben. Um die Hhe in die Bits 6-15 zu schreiben, knnen wir sie
6 Bits nach links verschieben, was einer Multiplikation mit 64 entspricht. Die
Gre des Rechtecks, das durch das BLTSIZE-Register anzugeben ist, verwendet
die folgende Formel:

In BLTSIZE = (Hhe * 64) + Breite ist der zu einzugebene Wert.

Ich erinnere Sie daran, dass die BREITE in Worten ausgedrckt wird.

HINWEIS: Es wurde eine Betriebssystemfunktion verwendet, die wir noch nie
benutzt haben. Das ist diejenige, die den Gebrauch des Blitters vom System
verhindert, um zu vermeiden, das der Blitter auch vom Betriebssystem
(Workbench) verwendet wird. Um die Verwendung des Blitters durch das
Betriebssystem zu deaktivieren und zu reaktivieren ist es ausreichend, die
entsprechenden bereits fertig im Kickstart vorhandenen Routinen zu verwenden.
Wie in der graphics.library: Wenn man das GFXBASE in a6 hat, reicht es aus.

	jsr	-$1c8(a6)	; OwnBlitter, das gibt uns den exklusiven Zugang auf dem Blitter
	
Um sicherzustellen, dass wir die einzigen sind, die den Blitter verwenden.

	jsr	-$1ce(a6)	; DisOwnBlitter, das Betriebssystem
					; kann den Blitter jetzt wieder verwenden

Vor dem Beenden des Programms ist es erforderlich, die Workbench zu
reaktivieren.

Erinneren sie sich also daran, dass wenn wir den Blitter in unseren
Meisterwerken verwenden, mssen sie OwnBlitter am Anfang und DisOwnBlitter am
Ende hinzufgen, zustzlich zum bekannten Deaktivieren und Aktivieren des
Multitasking.
