
; Listing8p9b.s		Fragen und Ratschlge zu CC-Anwendungen

	SECTION	CONDCODES,CODE

Mouse:
	move.b	$bfe001,d2
	and.b	#$40,d2				; $40 = %01000000, d.h. Bit 6
	bne.s	Mouse
	rts

	end

Wie kommt es, dass diese Routine richtig darauf wartet, dass die Maustaste
gedrckt wird, ohne irgendwelche BTST? Ich hoffe der Kommentar auf der Seite
und Ihre Kenntnis der CCs lsst Sie die Antwort vermuten.
Kommen wir nun zu einigen Anwendungen von "CC". Gehen Sie zurck zu Listing7n.s,
das ein Sprite abprallen lie. Hier ist diese Routine ohne das "btst", das
(unntigerweise) das hohe Bit getestet hat, um festzustellen, ob die Zahl 
negativ geworden war:

; Diese Routine ndert die Koordinaten des Sprites durch Hinzufgen einer 
; konstanten Geschwindigkeit sowohl vertikal als auch horizontal. Auch wenn das 
; Sprite eine der Rnder berhrt sieht die Routine vor, die Richtung umzukehren.

; Um diese Routine zu verstehen, muss bekannt sein, dass der Befehl "NEG" 
; bentigt wird um eine positive Zahl in eine negative Zahl umzuwandeln und 
; umgekehrt. Sie werden auch das das BPL nach einem ADD und nicht nach einem
; TST oder einem CMP bemerken. Jetzt wissen Sie warum:

BewegeSprite:
	move.w	SpriteY(pc),d0		; alte Position lesen
	add.w	SpeedY(pc),d0		; Geschwindigkeit addieren
	bpl.s	NichtAngehenOben	; wenn > 0 ist es in Ordnung
	neg.w	SpeedY				; Wenn < 0, haben wir den oberen Rand berhrt
								; dann umgekehrte Richtung
	bra.s	BewegeSprite		; berechnet die neue Position neu

NichtAngehenOben:
	cmp.w	#243,d0				; wenn die Position 256-13 = 243 ist,
								; berhrt das Sprite den unteren Rand
	blo.s	NichtAngehenUnten
	neg.w	speed_y				; Wenn das Sprite den unteren Rand berhrt,
								; Geschwindigkeit umkehren
	bra.s	BewegeSprite		; berechnet die neue Position neu

NichtAngehenUnten:
	move	d0,SpriteY			; aktualisieren der Position
PosX:
	move.w	SpriteX(pc),d1		; alte Position lesen
	add.w	SpeedX(pc),d1		; Geschwindigkeit addieren
	bpl.s	NichtAngehenLinks
	neg.w	SpeedX				; Wenn < 0 links berhrt: Richtung umkehren
	bra.s	PosX				; Neuberechnung der neuen Position horizontal

NichtAngehenLinks:
	cmp.w	#304,d1				; Wenn die Position 320-16 = 304 ist,
								; berhret das Sprite den rechten Rand
	blo.s	NichtAngehenRechts
	neg.w	SpeedX				; Wenn es rechts berhrt, Richtung umkehren
	bra.s	PosX				; Neuberechnung der neuen Position horizonzal

NichtAngehenRechts:
	move.w	d1,SpriteX			; aktualisieren der Position

	lea	MeinSprite,a1			; Adresse Sprite
	moveq	#13,d2				; Hhe Sprite
    bsr.s	UniBewegeSprite		; fhrt die universelle Routine aus, die 
					; das Sprite positioniert
	rts

-	-	-	-	-	-	-	-	-	-

Jetzt sehen wir eine weitere mgliche Verwendung der CCs. Angenommen, wir
mchten einen vertikalen Bildlauf zu einer Bitebene, unter Verwendung einer
anderen Routine, die die Adresse aus den Bplpointers "holt" und 40 addiert
und sie wieder einsetzt.
Angenommen, diese Routine muss nur 40 zu bpl0ptl hinzufgen, d.h. zum
niedrigen Wort der Adresse. Das Problem entsteht, wenn wir uns zum Beispiel 
an der Adresse $2ffe2 befinden, so dass die Addition von 40 $??3000a ergeben
wrde und auch das hohe Wort ndern wrde.:

Copperlist:
	...
	dc.w	$e0					; BPL0PTH
PlaneH:
	dc.w	$0002
	dc.w	$e2					; BPL0PTL
PlaneL:
	dc.w	$ffe2

Wie Sie sehen knnen, erhalten wir $000a, wenn wir 40 zu PlaneL addieren, aber 
PlaneH bleibt $0002! Aus diesem Grund nehmen wir jedes Mal die Adresse, addieren
sie hinzu und fgen sie wieder in die 2 Wrter zurck! 
Andernfalls, wenn das hohe Wort "zu schnappt", was wrden wir tun?
Mit CC kann jedoch etwas getan werden. Wir sagten, dass $ffe2 + 40 uns die
genaue Lsung $000a gibt, aber es wird auch der Carry gesetzt, fr den
bertrag, da wir $ffff berschritten haben. Allo knnten wir schreiben:

Scroll:
	add.w	#40,PlaneL			; eine Zeile nach unten gehen, indem wir 40
								; zum unteren Wort der Adresse hinzufgen, auf
								; die der bpl0pt zeigt 
	bcc.s	NotShown			; haben wir den enthaltenen Wert im Wort
								; berschritten? dann mssen wir auch das hohe
								; Wort ndern. Wenn nicht, spring ...
	addq.w	#1,PlaneH			; Ansonsten, addiere 1 in das hohe Wort, dh
								; den bertrag der Addition auf die PlaneL
								; "ausfhren"!
NotShown:
	rts

Dies sind einige Beispiele dafr, wie Sie bereits bekannte Routinen
"berprfen" knnen.
