
; Listing8p1c.s		Verhalten der Condition Codes bei divu/divs

	SECTION	CONDCODES,CODE

Start:
	moveq	#$0010,d0
	moveq	#$0003,d1
	divs.w	d1,d0

	move.l	#$200000,d0
	moveq	#$0002,d1
	divs.w	d1,d0
Stop:
	rts

	end

;	[oO]
;	  C
;	 \__/
;	   U

Sehen wir uns nun ein Beispiel fr die Verwendung von Divisionsanweisungen an.
Auch fr die Division liefert der 68000 uns 2 verschiedene Befehle:
divs teilt zwei Zahlen und betrachtet sie als Zweierkomplementzahlen, whrend
divu die Zahlen immer als positive Zahlen ansieht.

Die Unterschiede sind daher denen von muls und mulu hnlich. Wir werden sie in
unseren Experimenten veranschaulichen. Die Beispiele, die wir machen werden,
betreffen divs.

Die Divisionsbefehle teilen einen 32-Bit-Operanden in ein Datenregister. Bei
einem 16-Bit-Teiler wird der 16-Bit-Quotient in das Low-Word des Zielregisters
und der Rest im oberen Wort geschrieben.

Bei einer Division durch 0 fhrt der 68000 eine Ausnahmeroutine durch und in
den meisten Fllen haben Sie eine schne GURU MEDITATION.
Die Division kann die Bedingungscodes folgendermaen beeinflussen:

1) Carry (C) es wird immer auf 0 gesetzt
2) Overflow (V) wird gesetzt, wenn das Ergebnis nicht in 16 Bit enthalten sein
   kann, zB:
	move.l	#$ffffffff,d0
	divu.w	#2,d0

3) Zero (Z) wird auf 1 gesetzt, wenn das Ergebnis der Operation 0 ist
4) Negativ (N) wird auf 1 gesetzt, wenn das Ergebnis der Operation negativ ist
5) Extend (X) bleibt unverndert.
----------------------------------------------------------------------------

Zunchst sehen wir uns ein normales Beispiel an: Wir teilen die Zahl $10 (=16)
in Register d0 mit der in d1 enthaltenen Zahl 3.

D0: 00000010 00000003 00000000 00000000 00000000 00000000 00000000 00000000 
A0: 00000000 00000000 00000000 00000000 00000000 00000000 00000000 07D32154 
SSP=07D33287 USP=07D32154 SR=8000 T1 -- PL=0 ----- PC=07D34CE8
PC=07D34CE8 81C1		 DIVS.W  D1,D0
>

Das Ergebnis ist unten dargestellt. Beachten Sie, dass sowohl der Quotient 
berechnet wird (wird in das niedrige Wort d0 gesetzt), und dass der Rest 
(in das hohe Wort von d0 gesetzt wird).
Es ist in der Tat eine Teilung zwischen ganzen Zahlen.

D0: 00010005 00000003 00000000 00000000 00000000 00000000 00000000 00000000
A0: 00000000 00000000 00000000 00000000 00000000 00000000 00000000 07D32154
SSP=07D33287 USP=07D32154 SR=8000 T1 -- PL=0 ----- PC=07D34CEA
PC=07D34CEA 203C00200000	 MOVE.L  #$00200000,D0
>

Schauen wir uns ein anderes Beispiel an.
Wir teilen die Zahl $200000 (in d0 enthalten) durch $2 (in d1).

D0: 00200000 00000002 00000000 00000000 00000000 00000000 00000000 00000000 
A0: 00000000 00000000 00000000 00000000 00000000 00000000 00000000 07D32154 
SSP=07D33287 USP=07D32154 SR=8000 T1 -- PL=0 ----- PC=07D34CF6
PC=07D34CF6 81C1		 DIVS.W  D1,D0
>

Das genaue Ergebnis ist $100000, wie Sie mit dem "?" von Asmone sehen. Diese
Zahl ist jedoch zu gro, um in ein Wort zu passen. Daher fhrt der divs die
Berechnung nicht korrekt aus und meldet dies durch das Setzen des Flags V
auf 1:

D0: 00200000 00000002 00000000 00000000 00000000 00000000 00000000 00000000
A0: 00000000 00000000 00000000 00000000 00000000 00000000 00000000 07D32154
SSP=07D33287 USP=07D32154 SR=8002 T1 -- PL=0 ---V- PC=07D34CF8
PC=07D34CF8 4E75		 RTS
>

In solchen Fllen muss die Division mit Hilfe spezieller Algorithmen
durchgefhrt werden.
